/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.Ai;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.Fontx;
import com.extentech.formats.XLS.charts.Frame;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.ObjectLink;
import com.extentech.formats.XLS.charts.Pos;
import com.extentech.formats.XLS.charts.SeriesText;
import com.extentech.toolkit.ByteTools;
import java.awt.Color;
import java.util.HashMap;

public class TextDisp
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -7862828186455339066L;
    private short grbit = 0;
    private short grbit2 = 0;
    private short at = (short)2;
    private short vat = 1;
    private short wBkgMode = 1;
    private short icvText = 0;
    private short trot = 0;
    private short dlp;
    private int x = 0;
    private int y = 0;
    private int dx = 0;
    private int dy = 0;
    private Color rgbText = null;
    private boolean fAutoColor;
    private boolean fShowKey;
    private boolean fShowValue;
    private boolean fVert;
    private boolean fAutoText;
    private boolean fGenerated;
    private boolean fDeleted;
    private boolean fAutoMode;
    private boolean fShowLblPct;
    private boolean fShowPct;
    private boolean fShowBubbleSizes;
    private boolean fShowCatLabel;
    private byte[] PROTOTYPE_BYTES;

    public TextDisp() {
        byte[] byArray = new byte[32];
        byArray[0] = 2;
        byArray[1] = 2;
        byArray[2] = 1;
        byArray[8] = -33;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -74;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[24] = -79;
        byArray[26] = 77;
        byArray[28] = -96;
        byArray[29] = 9;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.at = data[0];
        this.vat = data[1];
        this.wBkgMode = ByteTools.readShort(data[2], data[3]);
        this.rgbText = new Color(data[4] < 0 ? 255 + data[4] : data[4], data[5] < 0 ? 255 + data[5] : data[5], data[6] < 0 ? 255 + data[6] : data[6]);
        this.x = ByteTools.readInt(this.getBytesAt(8, 4));
        this.y = ByteTools.readInt(this.getBytesAt(12, 4));
        this.dx = ByteTools.readInt(this.getBytesAt(16, 4));
        this.dy = ByteTools.readInt(this.getBytesAt(20, 4));
        this.grbit = ByteTools.readShort(data[24], data[25]);
        this.fAutoColor = (this.grbit & 1) == 1;
        this.fShowKey = (this.grbit & 2) == 2;
        this.fShowValue = (this.grbit & 4) == 4;
        this.fVert = (this.grbit & 8) == 8;
        this.fAutoText = (this.grbit & 0x10) == 16;
        this.fGenerated = (this.grbit & 0x20) == 32;
        this.fDeleted = (this.grbit & 0x40) == 64;
        this.fAutoMode = (this.grbit & 0x80) == 128;
        this.fShowLblPct = (this.grbit & 0x800) == 2048;
        this.fShowPct = (this.grbit & 0x1000) == 4096;
        this.fShowBubbleSizes = (this.grbit & 0x2000) == 8192;
        this.fShowCatLabel = (this.grbit & 0x4000) == 16384;
        this.icvText = ByteTools.readShort(data[26], data[27]);
        this.dlp = (short)(data[28] & 0xF);
        this.grbit2 = ByteTools.readShort(data[28], data[29]);
        this.trot = ByteTools.readShort(data[30], data[31]);
    }

    public int getType() {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4135) {
                return ((ObjectLink)b).getType();
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Label=\"" + this.toString() + "\"");
        sb.append(" TextRotation=\"" + this.trot + "\"");
        if (this.fShowLblPct) {
            sb.append(" ShowLabelPct=\"true\"");
        }
        if (this.fShowPct) {
            sb.append(" ShowPct=\"true\"");
        }
        if (this.fShowCatLabel) {
            sb.append(" ShowCatLabel=\"true\"");
        }
        if (this.fShowBubbleSizes) {
            sb.append(" ShowBubbleSizes=\"true\"");
        }
        sb.append(" Font=\"" + this.getFontId() + "\"");
        return sb.toString();
    }

    public int getFontId() {
        int ret = 0;
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4134) {
                ret = ((Fontx)b).getIfnt();
                break;
            }
            ++i;
        }
        return ret;
    }

    public void setFontId(int id) {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4134) {
                ((Fontx)b).setIfnt(id);
                break;
            }
            ++i;
        }
    }

    public Font getFont(WorkBook wb) {
        return wb.getFont(this.getFontId());
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("Label")) {
            this.setText(val);
            bHandled = true;
        } else if (op.equalsIgnoreCase("ShowKey")) {
            this.fShowKey = val.equals("true") || val.equals("1");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fShowKey, 1);
            bHandled = true;
        } else if (op.equalsIgnoreCase("ShowValue")) {
            this.fShowValue = val.equals("true") || val.equals("1");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fShowValue, 2);
            bHandled = true;
        } else if (op.equalsIgnoreCase("ShowLabelPct")) {
            this.fShowLblPct = val.equals("true") || val.equals("1");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fShowLblPct, 11);
            bHandled = true;
        } else if (op.equalsIgnoreCase("ShowPct")) {
            this.fShowPct = val.equals("true") || val.equals("1");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fShowPct, 12);
            bHandled = true;
        } else if (op.equalsIgnoreCase("ShowCatLabel")) {
            this.fShowCatLabel = val.equals("true") || val.equals("1");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fShowCatLabel, 14);
            bHandled = true;
        } else if (op.equalsIgnoreCase("ShowBubbleSizes")) {
            this.fShowBubbleSizes = val.equals("true") || val.equals("1");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fShowBubbleSizes, 13);
            bHandled = true;
        } else if (op.equalsIgnoreCase("TextRotation")) {
            this.trot = Short.parseShort(val);
            bHandled = true;
        } else if (op.equalsIgnoreCase("Font")) {
            this.setFontId(Short.parseShort(val));
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }

    @Override
    public String getChartOption(String op) {
        if (op.equalsIgnoreCase("Label")) {
            int i = 0;
            while (i < this.chartArr.size()) {
                BiffRec b = (BiffRec)this.chartArr.get(i);
                if (b.getOpcode() == 4109) {
                    SeriesText st = (SeriesText)b;
                    return st.toString();
                }
                ++i;
            }
        } else {
            if (op.equalsIgnoreCase("ShowKey")) {
                return this.fShowKey ? "1" : "0";
            }
            if (op.equalsIgnoreCase("ShowValue")) {
                return this.fShowValue ? "1" : "0";
            }
            if (op.equalsIgnoreCase("ShowLabelPct")) {
                return this.fShowLblPct ? "1" : "0";
            }
            if (op.equalsIgnoreCase("ShowPct")) {
                return this.fShowPct ? "1" : "0";
            }
            if (op.equalsIgnoreCase("ShowCatLabel")) {
                return this.fShowCatLabel ? "1" : "0";
            }
            if (op.equalsIgnoreCase("ShowBubbleSizes")) {
                return this.fShowBubbleSizes ? "1" : "0";
            }
            if (op.equalsIgnoreCase("TextRotation")) {
                return String.valueOf(this.trot);
            }
        }
        return "";
    }

    protected boolean isChartTitle() {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4135) {
                ObjectLink ol = (ObjectLink)b;
                return ol.isChartTitle();
            }
            ++i;
        }
        return false;
    }

    protected boolean isXAxisLabel() {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4135) {
                ObjectLink ol = (ObjectLink)b;
                return ol.isXAxisLabel();
            }
            ++i;
        }
        return false;
    }

    protected boolean isYAxisLabel() {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4135) {
                ObjectLink ol = (ObjectLink)b;
                return ol.isYAxisLabel();
            }
            ++i;
        }
        return false;
    }

    protected boolean isZAxisLabel() {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4135) {
                ObjectLink ol = (ObjectLink)b;
                return ol.getType() == 7;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String toString() {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4109) {
                SeriesText st = (SeriesText)b;
                return st.toString();
            }
            ++i;
        }
        return "";
    }

    public void setText(String newText) {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4109) {
                SeriesText st = (SeriesText)b;
                st.setText(newText);
                break;
            }
            ++i;
        }
    }

    public static XLSRecord getPrototype(int type, String text, WorkBook book) {
        TextDisp td = new TextDisp();
        td.setOpcode((short)4133);
        td.setData(td.PROTOTYPE_BYTES);
        td.init();
        if (type != 4) {
            td.grbit = ByteTools.updateGrBit(td.grbit, false, 4);
            td.grbit = ByteTools.updateGrBit(td.grbit, false, 5);
            td.updateRecord();
            td.init();
        }
        td.setWorkBook(book);
        Pos p = (Pos)Pos.getPrototype(0);
        p.setWorkBook(book);
        if (type == 3) {
            p.setX(-4);
            p.setY(-3);
        }
        td.addChartRecord(p);
        if (type != 4) {
            Fontx f = (Fontx)Fontx.getPrototype();
            f.setWorkBook(book);
            td.addChartRecord(f);
        }
        Ai ai = null;
        ai = type == 1 ? (Ai)Ai.getPrototype(Ai.AI_TYPE_LEGEND) : (Ai)Ai.getPrototype(Ai.AI_TYPE_NULL_LEGEND);
        ai.setWorkBook(book);
        td.addChartRecord(ai);
        if (type != 4) {
            SeriesText st = SeriesText.getPrototype(text);
            td.addChartRecord(st);
        }
        ObjectLink o = (ObjectLink)ObjectLink.getPrototype(type);
        o.setWorkBook(book);
        td.addChartRecord(o);
        return td;
    }

    public static XLSRecord getPrototype() {
        TextDisp td = new TextDisp();
        td.setOpcode((short)4133);
        td.setData(td.PROTOTYPE_BYTES);
        td.init();
        return td;
    }

    private void updateRecord() {
        this.getData()[0] = (byte)this.at;
        this.getData()[1] = (byte)this.vat;
        byte[] b = ByteTools.shortToLEBytes(this.wBkgMode);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
        b = new byte[]{(byte)this.rgbText.getRed(), (byte)this.rgbText.getGreen(), (byte)this.rgbText.getBlue(), 0};
        System.arraycopy(b, 0, this.getData(), 0, 4);
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[24] = b[0];
        this.getData()[25] = b[1];
        b = ByteTools.shortToLEBytes(this.grbit2);
        this.getData()[28] = b[0];
        this.getData()[29] = b[1];
        b = ByteTools.shortToLEBytes(this.trot);
        this.getData()[30] = b[0];
        this.getData()[31] = b[1];
    }

    public static int convertType(int axis) {
        int t = axis;
        switch (axis) {
            case 0: {
                t = 3;
                break;
            }
            case 1: 
            case 3: {
                t = 2;
                break;
            }
            case 2: {
                t = 7;
            }
        }
        return t;
    }

    public float[] getCoords() {
        Pos p = (Pos)Chart.findRec(this.chartArr, Pos.class);
        if (p != null) {
            float[] coords = p.getCoords();
            return coords;
        }
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    public int getRotation() {
        return this.trot;
    }

    public void setRotation(int rot) {
        this.trot = (short)rot;
        byte[] b = ByteTools.shortToLEBytes(this.trot);
        this.getData()[30] = b[0];
        this.getData()[31] = b[1];
    }

    public String getTextColor() {
        return FormatHandle.colorToHexString(this.rgbText);
    }

    public StringBuffer getSVG(HashMap<String, Double> chartMetrics) {
        StringBuffer svg = new StringBuffer();
        float[] coords = this.getCoords();
        coords[0] = (int)Math.ceil(Pos.convertFromSPRC(coords[0], chartMetrics.get("canvasw").floatValue(), 0.0f)) - 3;
        coords[1] = (int)Math.ceil(Pos.convertFromSPRC(coords[1], 0.0f, chartMetrics.get("canvash").floatValue()));
        Font fx = this.getFont(this.wkbook);
        svg.append("<g>\r\n");
        float fh = 10.0f;
        if (fx != null) {
            fh = (float)fx.getFontHeightInPoints();
        }
        float x = (float)(chartMetrics.get("x") + chartMetrics.get("w") / 2.0);
        float y = (chartMetrics.get("TITLEOFFSET").floatValue() + fh) / 2.0f;
        Frame f = (Frame)Chart.findRec(this.chartArr, Frame.class);
        if (f != null) {
            coords[0] = coords[0] + x;
            coords[1] = y + coords[1] + fh;
            coords[3] = fh * 2.0f;
            svg.append(f.getSVG(coords));
        } else {
            coords[0] = x;
            coords[1] = y + fh / 2.0f;
        }
        svg.append("<text " + GenericChartObject.getScript("charttitle") + " x='" + coords[0] + "' y='" + coords[1] + "' style='text-anchor: middle;' alignment-baseline='text-after-edge' ");
        if (fx != null) {
            svg.append(" " + fx.getSVG() + ">");
        } else {
            svg.append(" font-family='Arial' font-size='14pt' font-weight='bold'>");
        }
        svg.append(String.valueOf(this.toString()) + "</text>\r\n");
        svg.append("</g>\r\n");
        return svg;
    }

    public void setFrame(int lw, int lclr, int bgcolor, float[] coords) {
        Frame f = (Frame)Chart.findRec(this.chartArr, Frame.class);
        if (f == null) {
            f = (Frame)Frame.getPrototype();
            f.addBox(lw, lclr, bgcolor);
            f.setParentChart(this.getParentChart());
            this.chartArr.add(f);
        }
    }
}

