/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.MarkerFormat;
import com.extentech.formats.XLS.charts.Radar;
import com.extentech.formats.XLS.charts.RadarArea;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;

public class RadarChart
extends ChartType {
    public RadarChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
    }

    public void setFilled(boolean isFilled) {
        this.chartobj = isFilled ? (RadarArea)RadarArea.getPrototype() : (Radar)Radar.getPrototype();
        this.chartobj.setParentChart(this.cf.parentChart);
        this.cf.chartArr.remove(0);
        this.cf.chartArr.add(this.chartobj);
    }

    public boolean getIsFilled() {
        return this.chartobj.chartType == 17;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        if (series.size() == 0) {
            Logger.logErr("Radar.getSVG: error in series");
            return "";
        }
        StringBuffer svg = new StringBuffer();
        int[] dls = this.getDataLabelInts();
        int[] markers = this.getMarkerFormats();
        int n = series.size();
        int nseries = categories.length;
        double centerx = w / 2.0 + x;
        double centery = h / 2.0 + y;
        double percentage = 1.0 / (double)nseries;
        double radius = Math.min(w, h) / 2.3;
        svg.append("<g>\r\n");
        svg.append(MarkerFormat.getMarkerSVGDefs());
        int i = 0;
        while (i < n) {
            String points = "";
            String labels = "";
            double angle = 90.0;
            double[] curseries = (double[])series.get(i);
            String[] curranges = (String[])s.getSeriesRanges().get(i);
            double x0 = 0.0;
            double y0 = 0.0;
            int j = 0;
            while (j < curseries.length) {
                double r2 = radius * (curseries[j] / (max - min));
                double x1 = centerx + r2 * Math.cos(Math.toRadians(angle));
                double y1 = centery - r2 * Math.sin(Math.toRadians(angle));
                if (j == 0) {
                    x0 = x1;
                    y0 = y1;
                }
                points = String.valueOf(points) + x1 + "," + y1 + " ";
                String l = this.getSVGDataLabels(dls, axisMetrics, curseries[j], percentage, j, legends, categories[j].toString());
                if (l != null) {
                    double labelx1 = centerx + (r2 + 5.0) * Math.cos(Math.toRadians(angle));
                    double labely1 = centery - (r2 + 5.0) * Math.sin(Math.toRadians(angle));
                    labels = String.valueOf(labels) + "<text x='" + labelx1 + "' y='" + labely1 + "' style='text-anchor: middle;' " + RadarChart.getDataLabelFontSVG() + ">" + l + "</text>\r\n";
                }
                angle -= percentage * 360.0;
                ++j;
            }
            points = String.valueOf(points) + x0 + "," + y0;
            svg.append("<polyline " + RadarChart.getScript("") + " fill-opacity='0' " + RadarChart.getStrokeSVG(4.0f, "black") + " points='" + points + "'" + "/>\r\n");
            svg.append("<polyline " + RadarChart.getScript("") + "   id='series_" + (i + 1) + "' fill='none' fill-opacity='0' " + RadarChart.getStrokeSVG(3.0f, seriescolors[i]) + " points='" + points + "'" + "/>\r\n");
            if (markers[i] > 0) {
                String[] markerpoints = points.split(" ");
                int j2 = 0;
                while (j2 < markerpoints.length) {
                    String markerpoint = markerpoints[j2];
                    String[] xy = markerpoint.split(",");
                    double xx = Double.valueOf(xy[0]);
                    double yy = Double.valueOf(xy[1]);
                    svg.append(String.valueOf(MarkerFormat.getMarkerSVG(xx, yy, seriescolors[i], markers[i])) + "\r\n");
                    ++j2;
                }
            }
            svg.append(labels);
            ++i;
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:radarChart>");
        cooxml.append("\r\n");
        String style = "standard";
        if (this.getIsFilled()) {
            style = "filled";
        } else {
            int[] markers;
            int[] nArray = markers = this.getMarkerFormats();
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                int m = nArray[n2];
                if (m != 0) {
                    style = "marker";
                    break;
                }
                ++n2;
            }
        }
        cooxml.append("<c:radarStyle val=\"" + style + "\"/>");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:radarChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

