/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartSeriesHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Pie;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PieChart
extends ChartType {
    Pie pie = null;

    public PieChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.pie = (Pie)charttype;
    }

    public JSONObject getJSON(ChartSeriesHandle[] series, WorkBookHandle wbh, Double[] minMax) throws JSONException {
        JSONObject chartObjectJSON = new JSONObject();
        chartObjectJSON.put("type", (Object)this.getTypeJSON());
        double yMax = 0.0;
        double yMin = 0.0;
        double len = 0.0;
        JSONArray pieSeries = new JSONArray();
        try {
            String range = series[0].getCategoryRange();
            JSONArray cats = CellRange.getValuesAsJSON(range, wbh);
            JSONArray seriesvals = CellRange.getValuesAsJSON(series[0].getSeriesRange(), wbh);
            double piesum = 0.0;
            int k = 0;
            while (k < seriesvals.length()) {
                piesum += seriesvals.getDouble(k);
                yMax = Math.max(yMax, seriesvals.getDouble(k));
                yMin = Math.min(yMin, seriesvals.getDouble(k));
                ++k;
            }
            double percent = 100.0 / piesum;
            int k2 = 0;
            while (k2 < seriesvals.length()) {
                JSONObject piepoint = new JSONObject();
                piepoint.put("y", seriesvals.getDouble(k2));
                piepoint.put("text", (Object)(String.valueOf(cats.getString(k2)) + "\n" + Math.round(percent * seriesvals.getDouble(k2)) + "%"));
                piepoint.put("color", (Object)FormatConstants.SVGCOLORSTRINGS[series[k2].getPieChartSliceColor(k2)]);
                piepoint.put("stroke", (Object)PieChart.getDarkColor());
                pieSeries.put((Object)piepoint);
                ++k2;
            }
            len = seriesvals.length();
        }
        catch (Exception exception) {
            // empty catch block
        }
        minMax[0] = new Double(yMin);
        minMax[1] = new Double(yMax);
        minMax[2] = new Double(len);
        chartObjectJSON.put("Series", (Object)pieSeries);
        chartObjectJSON.put("SeriesFills", (Object)"");
        return chartObjectJSON;
    }

    @Override
    public JSONObject getTypeJSON() throws JSONException {
        JSONObject typeJSON = new JSONObject();
        typeJSON.put("labelOffset", -25);
        typeJSON.put("precision", 0);
        typeJSON.put("type", (Object)"Pie");
        return typeJSON;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        StringBuffer svg = new StringBuffer();
        if (series.size() == 0) {
            Logger.logErr("Pie.getSVG: error in series");
            return "";
        }
        int[] dls = this.getDataLabelInts();
        int LABELOFFSET = 15;
        int n = series.size();
        double centerx = 0.0;
        double centery = 0.0;
        double radius = 0.0;
        double radiusy = 0.0;
        centerx = w / 2.0 + chartMetrics.get("x");
        centery = h / 2.0 + chartMetrics.get("y");
        svg.append("<g>\r\n");
        radiusy = radius = Math.min(w, h) / 2.0;
        if (n > 0) {
            double[] oneseries = (double[])series.get(0);
            String[] curranges = (String[])s.getSeriesRanges().get(0);
            double total = 0.0;
            int j = 0;
            while (j < oneseries.length) {
                total += oneseries[j];
                ++j;
            }
            if (dls.length == 1) {
                int dl = dls[0];
                dls = new int[oneseries.length];
                int i = 0;
                while (i < dls.length) {
                    dls[i] = dl;
                    ++i;
                }
            }
            String path = "";
            double x = centerx + radius;
            double y = centery;
            double percentage = 0.0;
            double lasta = 0.0;
            int largearcflag = 0;
            int sweepflag = 0;
            int j2 = 0;
            while (j2 < oneseries.length) {
                if (total > 0.0) {
                    percentage = oneseries[j2] / total;
                }
                double angle = percentage * 360.0 + lasta;
                double x1 = centerx + radius * Math.cos(Math.toRadians(angle));
                double y1 = centery - radiusy * Math.sin(Math.toRadians(angle));
                largearcflag = percentage * 360.0 > 180.0 ? 1 : 0;
                path = "M" + centerx + " " + centery + " L" + x + " " + y + " A" + radius + " " + radiusy + " 0 " + largearcflag + " " + sweepflag + " " + x1 + " " + y1 + " L" + centerx + " " + centery + "Z";
                svg.append("<path " + PieChart.getScript(curranges[j2]) + "   id='series_" + (j2 + 1) + "'  fill='" + seriescolors[j2] + "' fill-opacity='1' " + PieChart.getStrokeSVG() + " path='' d='" + path + "' fill-rule='evenodd'/>\r\n");
                String l = this.getSVGDataLabels(dls, axisMetrics, oneseries[j2], percentage, j2, legends, categories[j2].toString());
                if (l != null) {
                    double y2;
                    double x2;
                    double halfa = percentage / 2.0 * 360.0 + lasta;
                    if (percentage < 0.3) {
                        x2 = centerx + (radius + 15.0) * Math.cos(Math.toRadians(halfa));
                        y2 = centery - (radiusy + 15.0) * Math.sin(Math.toRadians(halfa));
                    } else {
                        x2 = centerx + radius / 2.0 * Math.cos(Math.toRadians(halfa));
                        y2 = centery - radiusy / 2.0 * Math.sin(Math.toRadians(halfa));
                    }
                    String style = "";
                    if (percentage >= 0.3) {
                        style = " style='text-anchor: middle;'";
                    } else if (lasta > 90.0 && lasta < 270.0) {
                        style = " style='text-anchor: end;'";
                    }
                    svg.append("<text x='" + x2 + "' y='" + y2 + "' vertical-align='bottom' " + PieChart.getDataLabelFontSVG() + " " + style + ">" + l + "</text>\r\n");
                    if (percentage < 0.3) {
                        double x0 = centerx + radius * Math.cos(Math.toRadians(halfa));
                        double y0 = centery - radiusy * Math.sin(Math.toRadians(halfa));
                        svg.append("<line " + PieChart.getScript(curranges[j2]) + " x1='" + x0 + "' y1 ='" + y0 + "' x2='" + (x2 - 3.0) + "' y2='" + (y2 - 3.0) + "'" + PieChart.getStrokeSVG() + "/>\r\n");
                    }
                }
                lasta = angle;
                x = x1;
                y = y1;
                ++j2;
            }
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:pieChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:varyColors val=\"1\"/>");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        cooxml.append("<c:firstSliceAng val=\"" + this.pie.getAnStart() + "\"/>");
        cooxml.append("</c:pieChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

