/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.PieChart;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;

public class Pie3dChart
extends PieChart {
    public Pie3dChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        StringBuffer svg = new StringBuffer();
        if (series.size() == 0) {
            Logger.logErr("Pie.getSVG: error in series");
            return "";
        }
        int[] dls = this.getDataLabelInts();
        int LABELOFFSET = 15;
        int n = series.size();
        double centerx = 0.0;
        double centery = 0.0;
        double radius = 0.0;
        double radiusy = 0.0;
        centerx = w / 2.0 + chartMetrics.get("x");
        centery = h / 2.0 + chartMetrics.get("y");
        svg.append("<defs>\r\n");
        svg.append("<filter id=\"multiply\">\r\n");
        svg.append("<feBlend mode=\"multiply\" in2=\"\"/>\r\n");
        svg.append("</filter>\r\n");
        svg.append("</defs>\r\n");
        svg.append("<g>\r\n");
        radius = Math.min(w, h) / 2.0;
        double depth3d = 0.0;
        radiusy = radius * 2.0 / 3.0;
        depth3d = radius / 5.5;
        if (n > 0) {
            double[] oneseries = (double[])series.get(0);
            String[] curranges = (String[])s.getSeriesRanges().get(0);
            double total = 0.0;
            int j = 0;
            while (j < oneseries.length) {
                total += oneseries[j];
                ++j;
            }
            if (dls.length == 1) {
                int dl = dls[0];
                dls = new int[oneseries.length];
                int i = 0;
                while (i < dls.length) {
                    dls[i] = dl;
                    ++i;
                }
            }
            String path = "";
            double x = centerx + radius;
            double y = centery;
            double percentage = 0.0;
            double lasta = 0.0;
            int largearcflag = 0;
            int sweepflag = 0;
            int j2 = 0;
            while (j2 < oneseries.length) {
                if (total > 0.0) {
                    percentage = oneseries[j2] / total;
                }
                double angle = percentage * 360.0 + lasta;
                double x1 = centerx + radius * Math.cos(Math.toRadians(angle));
                double y1 = centery - radiusy * Math.sin(Math.toRadians(angle));
                largearcflag = percentage * 360.0 > 180.0 ? 1 : 0;
                if (y1 >= centery) {
                    double x0 = x;
                    double y0 = y;
                    if (centery > y) {
                        y0 = centery;
                        x0 = centerx - radius;
                    }
                    path = "M" + x0 + "," + y0 + " A" + radius + " " + radiusy + " 0 " + largearcflag + " " + sweepflag + " " + x1 + " " + y1 + " L" + x1 + " " + (y1 + depth3d);
                    path = String.valueOf(path) + " A" + radius + " " + radiusy + " 0 " + largearcflag + " " + "1" + " " + x0 + " " + (y0 + depth3d) + " Z";
                    svg.append("<path " + Pie3dChart.getScript(curranges[j2]) + "  fill='" + seriescolors[j2] + "' fill-opacity='" + Pie3dChart.getFillOpacity() + "' style='filter:url(#multiply)' " + Pie3dChart.getStrokeSVG(2.0f, Pie3dChart.getMediumColor()) + " path='' d='" + path + "' fill-rule='evenodd'/>\r\n");
                }
                path = "M" + centerx + " " + centery + " L" + x + " " + y + " A" + radius + " " + radiusy + " 0 " + largearcflag + " " + sweepflag + " " + x1 + " " + y1 + " L" + centerx + " " + centery + "Z";
                svg.append("<path " + Pie3dChart.getScript(curranges[j2]) + "   id='series_" + (j2 + 1) + "'  fill='" + seriescolors[j2] + "' fill-opacity='1' " + Pie3dChart.getStrokeSVG() + " path='' d='" + path + "' fill-rule='evenodd'/>\r\n");
                String l = this.getSVGDataLabels(dls, axisMetrics, oneseries[j2], percentage, j2, legends, categories[j2].toString());
                if (l != null) {
                    double y2;
                    double x2;
                    double halfa = percentage / 2.0 * 360.0 + lasta;
                    if (percentage < 0.3) {
                        x2 = centerx + (radius + 15.0) * Math.cos(Math.toRadians(halfa));
                        y2 = centery - (radiusy + 15.0) * Math.sin(Math.toRadians(halfa));
                    } else {
                        x2 = centerx + radius / 2.0 * Math.cos(Math.toRadians(halfa));
                        y2 = centery - radiusy / 2.0 * Math.sin(Math.toRadians(halfa));
                    }
                    String style = "";
                    if (percentage >= 0.3) {
                        style = " style='text-anchor: middle;'";
                    } else if (lasta > 90.0 && lasta < 270.0) {
                        style = " style='text-anchor: end;'";
                    }
                    svg.append("<text x='" + x2 + "' y='" + y2 + "' vertical-align='bottom' " + Pie3dChart.getDataLabelFontSVG() + " " + style + ">" + l + "</text>\r\n");
                    if (percentage < 0.3) {
                        double x0 = centerx + radius * Math.cos(Math.toRadians(halfa));
                        double y0 = centery - radiusy * Math.sin(Math.toRadians(halfa));
                        svg.append("<line " + Pie3dChart.getScript(curranges[j2]) + " x1='" + x0 + "' y1 ='" + y0 + "' x2='" + (x2 - 3.0) + "' y2='" + (y2 - 3.0) + "'" + Pie3dChart.getStrokeSVG() + "/>\r\n");
                    }
                }
                lasta = angle;
                x = x1;
                y = y1;
                ++j2;
            }
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:pie3DChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:varyColors val=\"1\"/>");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        cooxml.append("</c:pie3DChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

