/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Pie
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -7851320124576950635L;
    private short grbit = 0;
    private boolean fHasShadow = false;
    private boolean fShowLdrLines = false;
    protected short pcDonut = 0;
    protected short anStart = 0;
    private byte[] PROTOTYPE_BYTES;

    public Pie() {
        byte[] byArray = new byte[6];
        byArray[4] = 2;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.anStart = ByteTools.readShort(data[0], data[1]);
        this.pcDonut = data[2];
        this.chartType = this.pcDonut == 0 ? 3 : 8;
        this.grbit = ByteTools.readShort(data[4], data[5]);
        this.fHasShadow = (this.grbit & 1) == 1;
        this.fShowLdrLines = (this.grbit & 2) == 2;
    }

    public static XLSRecord getPrototype() {
        Pie b = new Pie();
        b.setOpcode((short)4121);
        b.setData(b.PROTOTYPE_BYTES);
        b.init();
        return b;
    }

    private void updateRecord() {
        this.getData()[2] = (byte)this.pcDonut;
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public void setAsPieChart() {
        this.pcDonut = 0;
        this.chartType = 3;
        this.updateRecord();
    }

    public void setAsDoughnutChart() {
        this.pcDonut = (short)50;
        this.chartType = 8;
        this.updateRecord();
    }

    public int getDoughnutSize() {
        return this.pcDonut;
    }

    public void setDoughnutSize(int s) {
        this.pcDonut = (short)s;
        byte[] b = ByteTools.shortToLEBytes(this.pcDonut);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
    }

    public int getAnStart() {
        return this.anStart;
    }

    public void setAnStart(int a) {
        this.anStart = (short)a;
        byte[] b = ByteTools.shortToLEBytes(this.anStart);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.fHasShadow) {
            sb.append(" Shadow=\"true\"");
        }
        if (this.fShowLdrLines) {
            sb.append(" ShowLdrLines=\"true\"");
        }
        if (this.pcDonut > 0) {
            sb.append(" Donut=\"" + this.pcDonut + "\"");
        }
        return sb.toString();
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("Shadow")) {
            this.setHasShadow(true);
            bHandled = true;
        } else if (op.equalsIgnoreCase("ShowLdrLines")) {
            this.setShowLdrLines(true);
            bHandled = true;
        } else if (op.equalsIgnoreCase("Donut")) {
            this.setDonutPercentage(val);
            bHandled = true;
        } else if (op.equalsIgnoreCase("donutSize")) {
            this.setDonutPercentage(val);
            bHandled = true;
        }
        return bHandled;
    }

    @Override
    public String getChartOption(String op) {
        if (op.equals("ShowLdrLines")) {
            return String.valueOf(this.showLdrLines());
        }
        if (op.equals("donutSize")) {
            return String.valueOf(this.getDonutPercentage());
        }
        return super.getChartOption(op);
    }

    @Override
    public boolean hasShadow() {
        return this.fHasShadow;
    }

    public boolean showLdrLines() {
        return this.fShowLdrLines;
    }

    public void setHasShadow(boolean bHasShadow) {
        this.fHasShadow = bHasShadow;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fHasShadow, 0);
        this.updateRecord();
    }

    public void setShowLdrLines(boolean bShowLdrLines) {
        this.fShowLdrLines = bShowLdrLines;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fShowLdrLines, 1);
        this.updateRecord();
    }

    public void setDonutPercentage(String val) {
        try {
            this.pcDonut = Short.valueOf(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateRecord();
    }

    public short getDonutPercentage() {
        return this.pcDonut;
    }
}

