/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;
import java.awt.Color;

public class LineFormat
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 3051781109844837056L;
    private Color rgb;
    private short lnx = 0;
    private short we = 0;
    private short grbit = 0;
    private short icv = 0;
    private SpPr sppr = null;
    public static final int SOLID = 0;
    public static final int DASH = 1;
    public static final int DOT = 2;
    public static final int DASHDOT = 3;
    public static final int DASHDASHDOT = 4;
    public static final int NONE = 5;
    public static final int DKGRAY = 6;
    public static final int MEDGRAY = 7;
    public static final int LTGRAY = 8;
    private byte[] PROTOTYPE_BYTES;
    private byte[] PROTOTYPE_BYTES_1;

    public LineFormat() {
        byte[] byArray = new byte[12];
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = 9;
        byArray[10] = 77;
        this.PROTOTYPE_BYTES = byArray;
        byte[] byArray2 = new byte[12];
        byArray2[0] = -128;
        byArray2[1] = -128;
        byArray2[2] = -128;
        this.PROTOTYPE_BYTES_1 = byArray2;
    }

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.rgb = new Color(data[0] < 0 ? 255 + data[0] : data[0], data[1] < 0 ? 255 + data[1] : data[1], data[2] < 0 ? 255 + data[2] : data[2]);
        this.lnx = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.we = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.grbit = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.icv = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
    }

    public static XLSRecord getPrototype() {
        LineFormat lf = new LineFormat();
        lf.setOpcode((short)4103);
        lf.setData(lf.PROTOTYPE_BYTES);
        lf.init();
        return lf;
    }

    public static XLSRecord getPrototype(int style, int weight) {
        LineFormat lf = new LineFormat();
        lf.setOpcode((short)4103);
        lf.setData(lf.PROTOTYPE_BYTES_1);
        lf.init();
        lf.setLineStyle(style);
        lf.setLineWeight(weight);
        return lf;
    }

    public void setLineWeight(int weight) {
        this.we = (short)weight;
        this.updateRecord();
    }

    public void setLineStyle(int style) {
        this.lnx = (short)style;
        if (this.lnx == 5) {
            this.we = (short)-1;
            this.grbit = (short)8;
            this.setLineColor(77);
        }
        this.updateRecord();
    }

    public int getLineStyle() {
        return this.lnx;
    }

    public void setLineColor(int clr) {
        if (clr > -1 && clr < this.getColorTable().length) {
            this.icv = (short)clr;
            this.rgb = this.getColorTable()[clr];
            this.updateRecord();
        } else if (clr == 77) {
            this.icv = (short)clr;
            this.rgb = this.getColorTable()[0];
            this.updateRecord();
        }
    }

    public String getLineColor() {
        return FormatHandle.colorToHexString(this.rgb);
    }

    private void updateRecord() {
        byte[] b = new byte[]{(byte)this.rgb.getRed(), (byte)this.rgb.getGreen(), (byte)this.rgb.getBlue(), 0};
        System.arraycopy(b, 0, this.getData(), 0, 4);
        b = ByteTools.shortToLEBytes(this.lnx);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
        b = ByteTools.shortToLEBytes(this.we);
        this.getData()[6] = b[0];
        this.getData()[7] = b[1];
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[8] = b[0];
        this.getData()[9] = b[1];
        b = ByteTools.shortToLEBytes(this.icv);
        this.getData()[10] = b[0];
        this.getData()[11] = b[1];
    }

    @Override
    public String toString() {
        return "LineFormat: LinePattern=" + this.lnx + " Weight=" + this.we + " Draw Ticks=" + ((this.grbit & 4) == 4);
    }

    public String getSVG() {
        if (this.lnx == 5) {
            return "";
        }
        float sz = 1.0f;
        if (this.we == -1) {
            sz = 1.0f;
        } else if (this.we == 0) {
            sz = 2.0f;
        } else if (this.we == 1) {
            sz = 4.0f;
        } else if (this.we == 2) {
            sz = 6.0f;
        }
        String clr = ChartType.getMediumColor();
        if (this.lnx == 6) {
            clr = ChartType.getDarkColor();
        } else if (this.lnx == 7) {
            clr = ChartType.getMediumColor();
        } else if (this.lnx == 8) {
            clr = ChartType.getLightColor();
        }
        String style = "";
        if (this.lnx == 1) {
            style = " style='stroke-dasharray: 9, 5;' ";
        } else if (this.lnx == 2) {
            style = " style='stroke-dasharray:2, 2;' ";
        } else if (this.lnx == 3) {
            style = " style='stroke-dasharray: 3, 2, 9, 2;' ";
        } else if (this.lnx == 4) {
            style = " style='stroke-dasharray: 9, 5, 9, 5, 3, 2;' ";
        }
        return " stroke='" + clr + "'  stroke-opacity='1' stroke-width='" + sz + "' " + style + "stroke-linecap='butt' stroke-linejoin='miter' stroke-miterlimit='4'";
    }

    public String getOOXML() {
        if (this.sppr != null) {
            return this.sppr.getOOXML();
        }
        if (!this.parentChart.getWorkBook().getIsExcel2007()) {
            StringBuffer ooxml = new StringBuffer();
            ooxml.append("<c:spPr>");
            ooxml.append("<a:ln w=\"" + this.we + "\">");
            ooxml.append("<a:solidFill>");
            ooxml.append("<a:srgbClr val=\"" + FormatHandle.colorToHexString(this.rgb) + "\"/>");
            ooxml.append("</a:solidFill>");
            ooxml.append("</a:ln>");
            ooxml.append("</c:spPr>");
            return ooxml.toString();
        }
        return "";
    }

    public void setFromOOXML(SpPr sp) {
        this.sppr = sp;
        int lw = sp.getLineWidth();
        this.setLineWeight(lw);
        this.setLineColor(sp.getLineColor());
        this.setLineStyle(sp.getLineStyle());
    }
}

