/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartLine;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Line;
import com.extentech.formats.XLS.charts.LineChart;

public class Line3DChart
extends LineChart {
    public Line3DChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.line = (Line)charttype;
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        int gapdepth;
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:line3DChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:grouping val=\"");
        if (this.is100PercentStacked()) {
            cooxml.append("percentStacked");
        } else if (this.isStacked()) {
            cooxml.append("stacked");
        } else {
            cooxml.append("standard");
        }
        cooxml.append("\"/>");
        cooxml.append("\r\n");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        ChartLine cl = this.cf.getChartLinesRec(ChartLine.TYPE_DROPLINE);
        if (cl != null) {
            cooxml.append(cl.getOOXML());
        }
        if ((gapdepth = this.getGapDepth()) != 0) {
            cooxml.append("<c:gapDepth val=\"" + gapdepth + "\"/>");
        }
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + serAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:line3DChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

