/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.PtgRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class TrackedPtgs
extends TreeMap {
    private static final long serialVersionUID = 1L;
    static final long SECONDPTGFACTOR = 0x400004000L;

    public TrackedPtgs(Comparator c) {
        super(c);
    }

    private Object getKey(Object o) throws IllegalArgumentException {
        long loc = ((PtgRef)o).hashcode;
        if (loc == -1L) {
            throw new IllegalArgumentException();
        }
        long ploc = ((PtgRef)o).getParentRec().hashCode();
        return new long[]{loc, ploc};
    }

    private Object getKey(long loc, long ploc) {
        return new long[]{loc, ploc};
    }

    public boolean add(Object o) {
        try {
            super.put(this.getKey(o), o);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    public boolean contains(Object o) {
        return super.containsKey(this.getKey(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getParents(BiffRec cell) {
        ArrayList<XLSRecord> parents = new ArrayList<XLSRecord>();
        int[] rc = new int[]{cell.getRowNumber(), cell.getColNumber()};
        long loc = PtgRef.getHashCode(rc[0], rc[1]);
        Map m = Collections.synchronizedMap(this.subMap(this.getKey(loc, 0L), this.getKey(loc + 1L, 0L)));
        if (m != null && m.size() > 0) {
            for (Object key : m.keySet()) {
                long testkey = ((long[])key)[0];
                if (testkey != loc) break;
                parents.add(((PtgRef)this.get(key)).getParentRec());
            }
        }
        if ((m = Collections.synchronizedMap(this.tailMap(this.getKey(0x400004000L, 0L)))) != null) {
            Set<Object> set = m.keySet();
            synchronized (set) {
                for (Object key : m.keySet()) {
                    long testkey = ((long[])key)[0];
                    double firstkey = testkey / 0x400004000L;
                    double secondkey = testkey % 0x400004000L;
                    if ((long)firstkey <= loc && (long)secondkey >= loc) {
                        int rw0 = (int)(firstkey / 16384.0) - 1;
                        int col0 = (int)firstkey % 16384;
                        int rw1 = (int)(secondkey / 16384.0) - 1;
                        int col1 = (int)secondkey % 16384;
                        if (!this.isaffected(rc, new int[]{rw0, col0, rw1, col1})) continue;
                        parents.add(((PtgRef)this.get(key)).getParentRec());
                        continue;
                    }
                    if (firstkey > (double)loc) break;
                }
            }
        }
        return parents.iterator();
    }

    private boolean isaffected(int[] cellrc, int[] arearc) {
        if (cellrc[0] < arearc[0]) {
            return false;
        }
        if (cellrc[0] > arearc[2]) {
            return false;
        }
        if (cellrc[1] < arearc[1]) {
            return false;
        }
        return cellrc[1] <= arearc[3];
    }

    @Override
    public synchronized Object remove(Object o) {
        return super.remove(this.getKey(o));
    }

    public void update(Object o, XLSRecord parent) {
        try {
            this.remove(o);
            long newloc = parent.hashCode();
            this.put(this.getKey(((PtgRef)o).hashcode, newloc), o);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Object[] toArray() {
        return this.values().toArray();
    }
}

