/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class TableStyles
extends XLSRecord
implements XLSConstants {
    short cts;
    short cchDefTableStyle;
    short cchDefPivotStyle;
    String rgchDefTableStyle = null;
    String rgchDefPivotStyle = null;
    private static final long serialVersionUID = 2639291289806138985L;

    @Override
    public void init() {
        byte[] tmp;
        super.init();
        this.cts = (short)ByteTools.readInt(this.getByteAt(12), this.getByteAt(13), this.getByteAt(14), this.getByteAt(14));
        this.cchDefTableStyle = ByteTools.readShort(this.getByteAt(16), this.getByteAt(17));
        this.cchDefPivotStyle = ByteTools.readShort(this.getByteAt(18), this.getByteAt(19));
        int pos = 20;
        if (this.cchDefTableStyle > 0) {
            tmp = this.getBytesAt(pos, this.cchDefTableStyle * 2);
            try {
                this.rgchDefTableStyle = new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding Table Style name in TableStyles: " + e);
            }
            pos += this.cchDefTableStyle * 2;
        }
        if (this.cchDefPivotStyle > 0) {
            tmp = this.getBytesAt(pos, this.cchDefPivotStyle * 2);
            try {
                this.rgchDefPivotStyle = new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding Pivot Style name in TableStyles: " + e);
            }
        }
    }

    public static XLSRecord getPrototype() {
        TableStyles tx = new TableStyles();
        tx.setOpcode((short)2190);
        byte[] byArray = new byte[88];
        byArray[0] = -114;
        byArray[1] = 8;
        byArray[12] = -112;
        byArray[16] = 17;
        byArray[18] = 17;
        byArray[20] = 84;
        byArray[22] = 97;
        byArray[24] = 98;
        byArray[26] = 108;
        byArray[28] = 101;
        byArray[30] = 83;
        byArray[32] = 116;
        byArray[34] = 121;
        byArray[36] = 108;
        byArray[38] = 101;
        byArray[40] = 77;
        byArray[42] = 101;
        byArray[44] = 100;
        byArray[46] = 105;
        byArray[48] = 117;
        byArray[50] = 109;
        byArray[52] = 57;
        byArray[54] = 80;
        byArray[56] = 105;
        byArray[58] = 118;
        byArray[60] = 111;
        byArray[62] = 116;
        byArray[64] = 83;
        byArray[66] = 116;
        byArray[68] = 121;
        byArray[70] = 108;
        byArray[72] = 101;
        byArray[74] = 76;
        byArray[76] = 105;
        byArray[78] = 103;
        byArray[80] = 104;
        byArray[82] = 116;
        byArray[84] = 49;
        byArray[86] = 54;
        tx.setData(byArray);
        tx.init();
        return tx;
    }
}

