/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class SxAddl
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = 2639291289806138985L;
    private short sxc;
    private short sxd;

    @Override
    public void init() {
        super.init();
        this.sxc = this.getData()[4];
        this.sxd = this.getData()[5];
        int len = this.getData().length;
        block1 : switch (ADDL_CLASSES.get(this.sxc)) {
            case sxcView: {
                SxcView record = SxcView.lookup(this.sxd);
                switch (record) {
                    case sxdId: {
                        if (len > 6) {
                            short cch = ByteTools.readShort(this.getData()[6], this.getData()[7]);
                            if (cch > 0) {
                                cch = ByteTools.readShort(this.getData()[12], this.getData()[13]);
                                byte encoding = this.getData()[14];
                                byte[] tmp = this.getBytesAt(15, cch * (encoding + 1));
                                String name = null;
                                try {
                                    name = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
                                }
                                catch (UnsupportedEncodingException e) {
                                    Logger.logInfo("encoding PivotTable caption name in Sxvd: " + e);
                                }
                                if (this.DEBUGLEVEL <= 3) break;
                                Logger.logInfo("SXADDL_sxcView: record=" + (Object)((Object)record) + " name: " + name);
                                break;
                            }
                            if (this.DEBUGLEVEL <= 3) break;
                            Logger.logInfo("SXADDL_sxcView: record=" + (Object)((Object)record) + " name: MULTIPLESEGMENTS");
                            break;
                        }
                        if (this.DEBUGLEVEL <= 3) break;
                        Logger.logInfo("SXADDL_sxcView: record=" + (Object)((Object)record) + " name: null");
                        break;
                    }
                    case sxdVerUpdInv: 
                    case sxdVer10Info: 
                    case sxdTableStyleClient: {
                        if (this.DEBUGLEVEL <= 3) break;
                        Logger.logInfo("SXADDL_sxcView: record=" + (Object)((Object)record) + " data:" + Arrays.toString(this.getBytesAt(6, len - 6)));
                    }
                }
                break;
            }
            case sxcCache: {
                SxcCache crec = SxcCache.lookup(this.sxd);
                switch (crec) {
                    case SxdVer10Info: {
                        byte verLastRefresh = this.getByteAt(16);
                        byte verRefreshMin = this.getByteAt(17);
                        double lastdate = ByteTools.eightBytetoLEDouble(this.getBytesAt(18, 8));
                        Date ld = DateConverter.getDateFromNumber(lastdate);
                        if (this.DEBUGLEVEL <= 3) break block1;
                        DateFormat dateFormatter = DateFormat.getDateInstance(2, Locale.getDefault());
                        Logger.logInfo("SXADDL_sxcCache: record=" + (Object)((Object)crec) + " lastDate:" + dateFormatter.format(ld) + " verLast:" + verLastRefresh + " verMin:" + verRefreshMin);
                        break block1;
                    }
                }
                if (this.DEBUGLEVEL <= 3) break;
                Logger.logInfo("SXADDL_sxcCache: record=" + (Object)((Object)crec) + " data:" + Arrays.toString(this.getBytesAt(6, len - 6)));
                break;
            }
            case sxcField12: {
                SxcField12 srec = SxcField12.lookup(this.sxd);
                if (this.DEBUGLEVEL <= 3) break;
                Logger.logInfo("SXADDL_sxcField12: record=" + (Object)((Object)srec) + " data:" + Arrays.toString(this.getBytesAt(6, len - 6)));
                break;
            }
            case sxcField: 
            case sxcHierarchy: 
            case sxcCacheField: 
            case sxcQsi: 
            case sxcQuery: 
            case sxcGrpLevel: 
            case sxcGroup: 
            case sxcCacheItem: 
            case sxcSxrule: 
            case sxcSxfilt: 
            case sxcSxdh: 
            case sxcAutoSort: 
            case sxcSxmgs: 
            case sxcSxmg: 
            case sxcSxcondfmts: 
            case sxcSxcondfmt: 
            case sxcSxfilters12: 
            case sxcSxfilter12: {
                if (this.DEBUGLEVEL <= 3) break;
                Logger.logInfo("SXADDL: hdr:  sxc:" + this.sxc + " sxd:" + this.sxd + " data:" + Arrays.toString(this.getBytesAt(6, len - 6)));
            }
        }
    }

    public static SxAddl getDefaultAddlRecord(ADDL_CLASSES cls, int recordid, byte[] data) {
        SxAddl sxa = new SxAddl();
        sxa.setOpcode((short)2148);
        byte[] newData = new byte[6];
        newData[0] = 100;
        newData[1] = 8;
        newData[4] = (byte)cls.ordinal();
        newData[5] = (byte)recordid;
        if (data == null) {
            block0 : switch (cls) {
                case sxcView: {
                    SxcView record = SxcView.lookup(recordid);
                    switch (record) {
                        case sxdId: 
                        case sxdVerUpdInv: 
                        case sxdTableStyleClient: {
                            break;
                        }
                        case sxdVer10Info: {
                            byte[] byArray = new byte[6];
                            byArray[0] = 1;
                            byArray[1] = 65;
                            data = byArray;
                            break;
                        }
                        case sxdEnd: {
                            data = new byte[6];
                        }
                    }
                    break;
                }
                case sxcCache: {
                    SxcCache crec = SxcCache.lookup(recordid);
                    switch (crec) {
                        case SxdId: {
                            byte[] byArray = new byte[6];
                            byArray[0] = 1;
                            data = byArray;
                            break block0;
                        }
                        case SxdVer10Info: {
                            byte[] byArray = new byte[12];
                            byArray[6] = -1;
                            byArray[7] = -1;
                            byArray[8] = -1;
                            byArray[9] = -1;
                            byArray[10] = 3;
                            data = byArray;
                            double d = DateConverter.getXLSDateVal(new Date());
                            byte[] dates = ByteTools.doubleToLEByteArray(d);
                            data = ByteTools.append(dates, data);
                            data = ByteTools.append(new byte[2], data);
                            break block0;
                        }
                        case SxdVerSxMacro: {
                            byte[] byArray = new byte[6];
                            byArray[0] = 1;
                            data = byArray;
                            break block0;
                        }
                        case SxdEnd: {
                            data = new byte[6];
                        }
                    }
                }
            }
        }
        newData = ByteTools.append(data, newData);
        sxa.setData(newData);
        sxa.init();
        return sxa;
    }

    public void setViewName(String viewName) {
        if (this.sxc != 0 && this.sxd != 0) {
            Logger.logErr("Incorrect SXADDL_ record for view name");
        }
        byte[] data = new byte[14];
        System.arraycopy(this.getData(), 0, data, 0, 5);
        byte[] strbytes = null;
        try {
            strbytes = viewName.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("encoding pivot view name in SXADDL: " + e);
        }
        short cch = (short)strbytes.length;
        byte[] nm = ByteTools.shortToLEBytes(cch);
        data[6] = nm[0];
        data[7] = nm[1];
        data[12] = nm[0];
        data[13] = nm[1];
        byte[] newrgch = new byte[cch + 1];
        System.arraycopy(strbytes, 0, newrgch, 1, cch);
        data = ByteTools.append(newrgch, data);
        this.setData(data);
    }

    public ADDL_CLASSES getADDlClass() {
        return ADDL_CLASSES.get(this.sxc);
    }

    public Object getRecordId() {
        switch (ADDL_CLASSES.get(this.sxc)) {
            case sxcView: {
                return SxcView.lookup(this.sxd);
            }
            case sxcCache: {
                return SxcCache.lookup(this.sxd);
            }
            case sxcField12: {
                return SxcField12.lookup(this.sxd);
            }
        }
        return null;
    }

    static enum ADDL_CLASSES {
        sxcView(0),
        sxcField(1),
        sxcHierarchy(2),
        sxcCache(3),
        sxcCacheField(4),
        sxcQsi(5),
        sxcQuery(6),
        sxcGrpLevel(7),
        sxcGroup(8),
        sxcCacheItem(9),
        sxcSxrule(12),
        sxcSxfilt(13),
        sxcSxdh(16),
        sxcAutoSort(18),
        sxcSxmgs(19),
        sxcSxmg(20),
        sxcField12(23),
        sxcSxcondfmts(26),
        sxcSxcondfmt(27),
        sxcSxfilters12(28),
        sxcSxfilter12(29);

        private final short cls;

        private ADDL_CLASSES(int cls) {
            this.cls = (short)cls;
        }

        public short sxd() {
            return this.cls;
        }

        public static ADDL_CLASSES get(int cls) {
            ADDL_CLASSES[] aDDL_CLASSESArray = ADDL_CLASSES.values();
            int n = aDDL_CLASSESArray.length;
            int n2 = 0;
            while (n2 < n) {
                ADDL_CLASSES c = aDDL_CLASSESArray[n2];
                if (c.cls == cls) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
    }

    static enum SxcCache {
        SxdId(0),
        SxdVerUpdInv(1),
        SxdVer10Info(2),
        SxdVerSxMacro(24),
        SxdInvRefreshReal(52),
        SxdInfo12(65),
        SxdEnd(-1);

        private final short sxd;

        private SxcCache(int sxd) {
            this.sxd = (short)sxd;
        }

        public short sxd() {
            return this.sxd;
        }

        public static SxcCache lookup(int record) {
            SxcCache[] sxcCacheArray = SxcCache.values();
            int n = sxcCacheArray.length;
            int n2 = 0;
            while (n2 < n) {
                SxcCache c = sxcCacheArray[n2];
                if (c.sxd == record) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
    }

    static enum SxcField12 {
        sxdId(0),
        sxdVerUpdInv(1),
        sxdMemberCaption(17),
        sxdVer12Info(25),
        sxdIsxth(28),
        sxdAutoshow(55),
        sxdEnd(-1);

        private final short sxd;

        private SxcField12(int sxd) {
            this.sxd = (short)sxd;
        }

        public short sxd() {
            return this.sxd;
        }

        public static SxcField12 lookup(int record) {
            SxcField12[] sxcField12Array = SxcField12.values();
            int n = sxcField12Array.length;
            int n2 = 0;
            while (n2 < n) {
                SxcField12 c = sxcField12Array[n2];
                if (c.sxd == record) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
    }

    static enum SxcView {
        sxdId(0),
        sxdVerUpdInv(1),
        sxdVer10Info(2),
        sxdCalcMember(3),
        sxdCalcMemString(10),
        sxdVer12Info(25),
        sxdTableStyleClient(30),
        sxdCompactRwHdr(33),
        sxdCompactColHdr(34),
        sxdSxpiIvmb(38),
        sxdEnd(-1);

        private final short sxd;

        private SxcView(int sxd) {
            this.sxd = (short)sxd;
        }

        public short sxd() {
            return this.sxd;
        }

        public static SxcView lookup(int record) {
            SxcView[] sxcViewArray = SxcView.values();
            int n = sxcViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                SxcView c = sxcViewArray[n2];
                if (c.sxd == record) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
    }
}

