/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.CellAddressComparator;
import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgAreaN;
import com.extentech.formats.XLS.formulas.PtgExp;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRefN;
import com.extentech.toolkit.ByteTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public final class Shrfmla
extends XLSRecord {
    private static final long serialVersionUID = -6147947203791941819L;
    private int rwFirst;
    private int rwLast;
    private int colFirst;
    private int colLast;
    private Stack expression;
    private Ptg[] ptgcache;
    private Formula host;
    private SortedSet members = new TreeSet(new CellAddressComparator());
    boolean containsIndirectFunction = false;

    public int getFirstRow() {
        return this.rwFirst;
    }

    public int getLastRow() {
        return this.rwLast;
    }

    public int getFirstCol() {
        return this.colFirst;
    }

    public int getLastCol() {
        return this.colLast;
    }

    public void updateLocation(int shiftamount, PtgRef pr) {
        if (this.ptgcache.length > 1 && (this.ptgcache[0] instanceof PtgRefN ? pr.hashcode != ((PtgRefN)this.ptgcache[0]).getArea().hashcode : pr.hashcode != ((PtgAreaN)this.ptgcache[0]).getArea().hashcode)) {
            return;
        }
        int i = 0;
        while (i < this.ptgcache.length) {
            if (this.ptgcache[i] instanceof PtgRefN) {
                ((PtgRefN)this.ptgcache[i]).removeFromRefTracker();
            } else {
                ((PtgAreaN)this.ptgcache[i]).removeFromRefTracker();
            }
            ++i;
        }
        for (Formula f : this.members) {
            f.clearCachedValue();
            PtgExp pointer = (PtgExp)f.getExpression().get(0);
            pointer.setRowFirst(pointer.getRwFirst() + shiftamount);
        }
        this.setFirstRow(this.rwFirst + shiftamount);
        this.setLastRow(this.rwLast + shiftamount);
        int i2 = 0;
        while (i2 < this.ptgcache.length) {
            if (this.ptgcache[i2] instanceof PtgRefN) {
                ((PtgRefN)this.ptgcache[i2]).addToRefTracker();
            } else {
                ((PtgAreaN)this.ptgcache[i2]).addToRefTracker();
            }
            ++i2;
        }
    }

    public void setFirstRow(int row) {
        this.rw = this.rwFirst = row;
    }

    public void setLastRow(int row) {
        this.rwLast = row;
    }

    @Override
    public void init() {
        super.init();
        this.rwFirst = ByteTools.readUnsignedShort(this.getByteAt(0), this.getByteAt(1));
        this.rwLast = ByteTools.readUnsignedShort(this.getByteAt(2), this.getByteAt(3));
        this.colFirst = this.getByteAt(4);
        this.colLast = this.getByteAt(5);
        short cce = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        byte[] rgce = this.getBytesAt(10, cce);
        if (this.getSheet() == null) {
            this.setSheet(this.wkbook.getLastbound());
        }
        this.rw = this.rwFirst;
        try {
            this.wkbook.lastFormula.initSharedFormula(this);
            this.setHostCell(this.wkbook.lastFormula);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.expression = ExpressionParser.parseExpression(rgce, this);
        if (this.containsIndirectFunction && this.host != null) {
            this.host.registerIndirectFunction();
        }
        ArrayList<Ptg> ptgs = new ArrayList<Ptg>();
        int idx = 0;
        while (idx < this.expression.size()) {
            Ptg ptg = (Ptg)this.expression.get(idx);
            if (ptg instanceof PtgRefN) {
                ptgs.add(ptg);
            } else if (ptg instanceof PtgAreaN) {
                ptgs.add(ptg);
            }
            ++idx;
        }
        this.ptgcache = new Ptg[ptgs.size()];
        ptgs.toArray(this.ptgcache);
    }

    @Override
    public void preStream() {
        super.preStream();
        byte[] data = this.getData();
        System.arraycopy(ByteTools.shortToLEBytes((short)this.rwFirst), 0, data, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.rwLast), 0, data, 2, 2);
        data[4] = (byte)this.colFirst;
        data[5] = (byte)this.colLast;
        data[7] = (byte)this.members.size();
        this.setData(data);
    }

    boolean isInRange(String s) {
        return ExcelTools.isInRange(s, this.rwFirst, this.rwLast, this.colFirst, this.colLast);
    }

    public static Stack convertStack(Stack in, Formula f) {
        Stack<Ptg> out = new Stack<Ptg>();
        int idx = 0;
        while (idx < in.size()) {
            Ptg ptg = (Ptg)in.get(idx);
            if (ptg instanceof PtgRefN) {
                ptg = ((PtgRefN)ptg).convertToPtgRef(f);
            } else if (ptg instanceof PtgAreaN) {
                ptg = ((PtgAreaN)ptg).convertToPtgArea(f);
            } else {
                ptg = (Ptg)ptg.clone();
                ptg.setParentRec(f);
            }
            out.add(ptg);
            ++idx;
        }
        return out;
    }

    @Override
    public String toString() {
        return "Shared Formula [" + this.getCellRange() + "] " + FormulaParser.getExpressionString(this.expression);
    }

    public String getCellRange() {
        return ExcelTools.formatRange(new int[]{this.colFirst, this.rwFirst, this.colLast, this.rwLast});
    }

    public void setHostCell(Formula newHost) {
        if (this.host != null) {
            this.host.removeInternalRecord(this);
        }
        this.host = newHost;
        this.host.addInternalRecord(this);
        this.rw = this.host.getRowNumber();
        this.col = this.host.getColNumber();
    }

    public Formula getHostCell() {
        return this.host;
    }

    public PtgExp getPointer() {
        PtgExp pointer = new PtgExp();
        pointer.setParentRec(this.host);
        pointer.init(this.host.getRowNumber(), this.host.getColNumber());
        return pointer;
    }

    public void addMember(Formula member) {
        if (this.members.size() >= 255) {
            throw new IndexOutOfBoundsException("shared formula already has 255 members");
        }
        this.members.add(member);
        if (this.members.size() == 1) {
            this.setHostCell(member);
        }
        if (!this.getWorkBook().getFactory().iscompleted()) {
            return;
        }
        int row = member.getRowNumber();
        short col = member.getColNumber();
        if (row < this.rwFirst) {
            this.rwFirst = row;
        }
        if (row > this.rwLast) {
            this.rwLast = row;
        }
        if (col < this.colFirst) {
            this.colFirst = col;
        }
        if (col > this.colLast) {
            this.colLast = col;
        }
    }

    public void removeMember(Formula member) {
        this.members.remove(member);
        if (this.members.size() == 0) {
            return;
        }
        if (member.getRowNumber() == this.rwLast) {
            this.rwLast = (short)((Formula)this.members.last()).getRowNumber();
        }
        if (member == this.host) {
            this.setHostCell((Formula)this.members.first());
            this.rwFirst = this.host.getRowNumber();
        }
    }

    public SortedSet getMembers() {
        return this.members;
    }

    public Stack getStack() {
        return this.expression;
    }

    public Stack instantiate(Formula parent) {
        return Shrfmla.convertStack(this.expression, parent);
    }

    protected void setContainsIndirectFunction(boolean containsIndirectFunction) {
        this.containsIndirectFunction = containsIndirectFunction;
    }

    protected Formula getAffected(BiffRec br) {
        int[] rc = new int[]{br.getRowNumber(), br.getColNumber()};
        Iterator ii = this.members.iterator();
        boolean isExcel2007 = this.getWorkBook().getIsExcel2007();
        while (ii.hasNext()) {
            Formula f = (Formula)ii.next();
            int[] frc = new int[]{f.getRowNumber(), f.getColNumber()};
            int i = 0;
            while (i < this.ptgcache.length) {
                int[] refrc;
                if (this.ptgcache[i] instanceof PtgRefN) {
                    refrc = ((PtgRefN)this.ptgcache[i]).getRealRowCol();
                    if (refrc[0] + frc[0] == rc[0] && this.adjustCol(refrc[1] + frc[1], isExcel2007) == rc[1]) {
                        return f;
                    }
                } else {
                    refrc = ((PtgAreaN)this.ptgcache[i]).getRealRowCol();
                    refrc[0] = refrc[0] + frc[0];
                    refrc[2] = refrc[2] + frc[1];
                    refrc[1] = this.adjustCol(refrc[1] + frc[0], isExcel2007);
                    refrc[3] = this.adjustCol(refrc[3] + frc[0], isExcel2007);
                    if (refrc[0] <= rc[0] && refrc[1] <= rc[1] && refrc[2] >= rc[0] && refrc[3] >= rc[1]) {
                        return f;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private int adjustCol(int c, boolean isExcel2007) {
        if (c >= 256 && !isExcel2007) {
            c -= 256;
        }
        return c;
    }

    @Override
    public void close() {
        if (this.members != null) {
            this.members.clear();
        }
        this.members = null;
        if (this.expression != null) {
            while (!this.expression.isEmpty()) {
                GenericPtg p = (GenericPtg)this.expression.pop();
                if (p instanceof PtgRef) {
                    ((PtgRef)p).close();
                } else {
                    p.close();
                }
                Object var1_1 = null;
            }
        }
        this.ptgcache = null;
        this.host = null;
        super.close();
    }

    protected void finalize() {
        this.close();
    }
}

