/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class Scl
extends XLSRecord {
    private static final long serialVersionUID = -4595833226859365049L;
    int num = 1;
    int denum = 1;

    Scl() {
        byte[] bs = new byte[]{1, 0, 1, 0};
        this.setOpcode((short)160);
        this.setLength(4);
        if (this.DEBUGLEVEL > 50) {
            Logger.logInfo("Scl.init()" + String.valueOf(this.offset));
        }
        this.setData(bs);
        this.originalsize = 4;
    }

    public void setZoom(float b) {
        byte[] data = this.getData();
        int[] n = this.gcd((int)(b * 100.0f), 100);
        this.num = n[0];
        this.denum = n[1];
        byte[] nmbd = ByteTools.shortToLEBytes((short)this.num);
        System.arraycopy(nmbd, 0, data, 0, 2);
        nmbd = ByteTools.shortToLEBytes((short)this.denum);
        System.arraycopy(nmbd, 0, data, 2, 2);
        this.setData(data);
    }

    public float getZoom() {
        return (float)this.num / (float)this.denum;
    }

    @Override
    public void init() {
        super.init();
        this.num = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.denum = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        if (this.DEBUGLEVEL > 50) {
            Logger.logInfo("Scl.init() sheet zoom:" + this.getZoom());
        }
    }

    private int[] gcd(int numerator, int denominator) {
        int n = 1;
        int d = 1;
        int highest = denominator > numerator ? denominator : numerator;
        int x = highest;
        while (x > 0) {
            if (denominator % x == 0 && numerator % x == 0) {
                n = numerator / x;
                d = denominator / x;
                break;
            }
            --x;
        }
        return new int[]{n, d};
    }
}

