/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.toolkit.ByteTools;
import java.util.ArrayList;
import java.util.Arrays;

class SXLI_Item {
    short cSic;
    short itmType;
    short isxviMac;
    byte iData;
    boolean fMultiDataName;
    boolean fSbt;
    boolean fBlock;
    boolean fGrand;
    boolean fMultiDataOnAxis;
    byte[] rgisxvi;
    static int pos = 0;

    public static ArrayList<SXLI_Item> parse(byte[] data, int nItemsPerLine) {
        pos = 0;
        ArrayList<SXLI_Item> items = new ArrayList<SXLI_Item>();
        while (pos < data.length - 7) {
            items.add(new SXLI_Item(data, nItemsPerLine));
        }
        return items;
    }

    SXLI_Item(byte[] data, int nItemsPerLine) {
        try {
            this.cSic = ByteTools.readShort(data[pos + 0], data[pos + 1]);
            this.itmType = (short)(ByteTools.readShort(data[pos + 2], data[pos + 3]) & Short.MAX_VALUE);
            this.isxviMac = ByteTools.readShort(data[pos + 4], data[pos + 5]);
            short tmp = ByteTools.readShort(data[pos + 6], data[pos + 7]);
            this.fMultiDataName = (tmp & 0x8000) == 32768;
            this.iData = (byte)(tmp >> 7 & 0x80);
            tmp = (byte)(tmp >> 9);
            this.fSbt = (tmp & 1) == 1;
            this.fBlock = (tmp & 2) == 2;
            this.fGrand = (tmp & 4) == 4;
            this.fMultiDataOnAxis = (tmp & 8) == 8;
            this.rgisxvi = new byte[nItemsPerLine * 2];
            System.arraycopy(data, pos += 8, this.rgisxvi, 0, this.rgisxvi.length);
            pos += this.rgisxvi.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    SXLI_Item(int repeat, int nLines, int type, short[] indexes, int nItemsPerLine) {
        this.cSic = (short)repeat;
        this.isxviMac = (short)nLines;
        ITEMTYPE t = ITEMTYPE.get(type);
        this.itmType = (short)t.ordinal();
        switch (t) {
            case ITMTYPEDATA: 
            case ITMTYPEBLANK: {
                break;
            }
            case ITMTYPEGRAND: {
                this.fGrand = true;
            }
            default: {
                this.fSbt = true;
            }
        }
        this.rgisxvi = new byte[indexes.length * 2];
        int i = 0;
        while (i < indexes.length * 2) {
            byte[] b = ByteTools.shortToLEBytes(indexes[i / 2]);
            this.rgisxvi[i] = b[0];
            this.rgisxvi[i + 1] = b[1];
            i += 2;
        }
    }

    byte[] getData() {
        byte[] data = new byte[8];
        byte[] b = ByteTools.shortToLEBytes(this.cSic);
        data[0] = b[0];
        data[1] = b[1];
        b = ByteTools.shortToLEBytes(this.itmType);
        data[2] = b[0];
        data[3] = b[1];
        b = ByteTools.shortToLEBytes(this.isxviMac);
        data[4] = b[0];
        data[5] = b[1];
        short tmp = (short)(this.fMultiDataName ? 1 : 0);
        tmp = (short)(tmp | this.iData << 1);
        if (this.fSbt) {
            tmp = (short)(tmp | 0x200);
        }
        if (this.fBlock) {
            tmp = (short)(tmp | 0x400);
        }
        if (this.fGrand) {
            tmp = (short)(tmp | 0x800);
        }
        if (this.fMultiDataOnAxis) {
            tmp = (short)(tmp | 0x1000);
        }
        b = ByteTools.shortToLEBytes(tmp);
        data[6] = b[0];
        data[7] = b[1];
        data = ByteTools.append(this.rgisxvi, data);
        return data;
    }

    public String toString() {
        return String.format("[rep %d typ %d imax %d iData %d fSbt %b fBlock %b fGrand %b rgi: %s", this.cSic, this.itmType, this.isxviMac, this.iData, this.fSbt, this.fBlock, this.fGrand, Arrays.toString(this.rgisxvi));
    }

    public static enum ITEMTYPE {
        ITMTYPEDATA("data"),
        ITMTYPEDEFAULT("default"),
        ITMTYPESUM("sum"),
        ITMTYPECOUNTA("countA"),
        ITMTYPECOUNT("count"),
        ITMTYPEAVERAGE("avg"),
        ITMTYPEMAX("max"),
        ITMTYPEMIN("min"),
        ITMTYPEPRODUCT("product"),
        ITMTYPESTDEV("stdDev"),
        ITMTYPESTDEVP("stdDevP"),
        ITMTYPEVAR("var"),
        ITMTYPEVARP("varP"),
        ITMTYPEGRAND("grand"),
        ITMTYPEBLANK("blank");

        private final String itm;

        private ITEMTYPE(String s) {
            this.itm = s;
        }

        public static int get(String s) {
            ITEMTYPE[] iTEMTYPEArray = ITEMTYPE.values();
            int n = iTEMTYPEArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITEMTYPE c = iTEMTYPEArray[n2];
                if (c.itm.equals(s)) {
                    return c.ordinal();
                }
                ++n2;
            }
            return 0;
        }

        public static ITEMTYPE get(int id) {
            ITEMTYPE[] iTEMTYPEArray = ITEMTYPE.values();
            int n = iTEMTYPEArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITEMTYPE c = iTEMTYPEArray[n2];
                if (c.ordinal() == id) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
    }
}

