/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.formats.XLS.PivotCacheRecord;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class SXDBEx
extends XLSRecord
implements XLSConstants,
PivotCacheRecord {
    private static final long serialVersionUID = 9027599480633995587L;
    int nformulas;
    double lastdate;

    @Override
    public void init() {
        super.init();
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXDBEx -" + Arrays.toString(this.getData()));
        }
        this.lastdate = ByteTools.eightBytetoLEDouble(this.getBytesAt(0, 8));
        this.nformulas = ByteTools.readInt(this.getBytesAt(8, 4));
    }

    @Override
    public String toString() {
        Date ld = DateConverter.getDateFromNumber(this.lastdate);
        DateFormat dateFormatter = DateFormat.getDateInstance(2, Locale.getDefault());
        try {
            return "SXDBEx: nFormulas:" + this.nformulas + " last Date:" + dateFormatter.format(ld) + Arrays.toString(this.getRecord());
        }
        catch (Exception exception) {
            return "SXDBEx: nFormulas:" + this.nformulas + " last Date: undefined";
        }
    }

    public static XLSRecord getPrototype() {
        SXDBEx sxdbex = new SXDBEx();
        sxdbex.setOpcode((short)290);
        byte[] data = new byte[12];
        double d = DateConverter.getXLSDateVal(new Date());
        System.arraycopy(ByteTools.doubleToLEByteArray(d), 0, data, 0, 8);
        sxdbex.setData(data);
        sxdbex.init();
        return sxdbex;
    }

    public void setnFormulas(int n) {
        this.nformulas = n;
        byte[] b = ByteTools.cLongToLEBytes(n);
        System.arraycopy(b, 0, this.getData(), 8, 4);
    }

    public int getnFormulas() {
        return this.nformulas;
    }

    @Override
    public byte[] getRecord() {
        byte[] b = new byte[4];
        System.arraycopy(ByteTools.shortToLEBytes(this.getOpcode()), 0, b, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.getData().length), 0, b, 2, 2);
        return ByteTools.append(this.getData(), b);
    }
}

