/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.LocationComparer;
import com.extentech.formats.XLS.Mergedcells;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.Shrfmla;
import com.extentech.formats.XLS.TrackedPtgs;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.Ai;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.Series;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgAreaErr3d;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRefErr;
import com.extentech.formats.XLS.formulas.PtgRefErr3d;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ReferenceTracker {
    private Map sheetMap = new HashMap();
    private Map nameRefs = new HashMap();
    private Map criteriaDBs = new HashMap();
    private Map CollectionDBs = new HashMap();
    private Map vlookups = new HashMap();
    private Collection crs = new Vector();
    private Map lookupColsCache = new HashMap();

    public Map getLookupColCache() {
        return this.lookupColsCache;
    }

    public Map getVlookups() {
        return this.vlookups;
    }

    public Map getCriteriaDBs() {
        return this.criteriaDBs;
    }

    public Map getListDBs() {
        return this.CollectionDBs;
    }

    public void clearCaches() {
        this.criteriaDBs = new HashMap();
        this.CollectionDBs = new HashMap();
        this.vlookups = new HashMap();
    }

    public void clearLookupCaches() {
        this.lookupColsCache.clear();
        this.lookupColsCache = new HashMap();
        this.criteriaDBs.clear();
        this.criteriaDBs = new HashMap();
        this.CollectionDBs.clear();
        this.CollectionDBs = new HashMap();
        this.vlookups.clear();
        this.vlookups = new HashMap();
    }

    public synchronized Map clearAffectedFormulaCellsOnSheet(CellHandle cx, String sheetname) {
        HashMap hm = (HashMap)this.clearAffectedFormulaCells(cx);
        HashMap retmap = new HashMap();
        for (String s : hm.keySet()) {
            if (s.indexOf(sheetname) <= -1) continue;
            retmap.put(s, hm.get(s));
        }
        return retmap;
    }

    public synchronized Map clearAffectedFormulaCells(CellHandle cx) {
        return this.clearAffectedFormulaCells(cx.getCell(), new HashMap());
    }

    public synchronized Map clearAffectedFormulaCells(BiffRec cx) {
        return this.clearAffectedFormulaCells(cx, new HashMap());
    }

    private synchronized Map clearAffectedFormulaCells(BiffRec changedRec, Map affectedCellHandles) {
        String newRecSheetName;
        TrackedPtgs ptgRefs;
        if (affectedCellHandles == null) {
            affectedCellHandles = new HashMap();
        }
        if ((ptgRefs = (TrackedPtgs)this.sheetMap.get(GenericPtg.qualifySheetname(newRecSheetName = changedRec.getSheet().getSheetName()))) == null) {
            return affectedCellHandles;
        }
        Iterator parents = ptgRefs.getParents(changedRec);
        while (parents.hasNext()) {
            String adr;
            BiffRec br = (BiffRec)parents.next();
            short op = br.getOpcode();
            if (op == 24) {
                String theName = ((Name)br).getNameA();
                if (!this.nameRefs.containsKey(theName)) continue;
                ArrayList list = (ArrayList)this.nameRefs.get(theName);
                int i = 0;
                while (i < list.size()) {
                    String adr2;
                    XLSRecord ptgParent = ((Ptg)list.get(i)).getParentRec();
                    if (ptgParent.getOpcode() != 24 && affectedCellHandles.get(adr2 = String.valueOf(ptgParent.getSheet().getSheetName()) + "!" + ptgParent.getCellAddress()) == null) {
                        ReferenceTracker.addRec(ptgParent, affectedCellHandles);
                        affectedCellHandles = (HashMap)this.clearAffectedFormulaCells(ptgParent, affectedCellHandles);
                    }
                    ++i;
                }
                continue;
            }
            if (op == 432 || op == 4177) continue;
            if (op == 1212) {
                String adr3;
                Shrfmla sh = (Shrfmla)br;
                Formula f = sh.getAffected(changedRec);
                if (f == null || affectedCellHandles.containsKey(adr3 = String.valueOf(f.getSheet().getSheetName()) + "!" + f.getCellAddress())) continue;
                ReferenceTracker.addRec(f, affectedCellHandles);
                affectedCellHandles = (HashMap)this.clearAffectedFormulaCells(f, affectedCellHandles);
                continue;
            }
            if (br.getSheet() == null || affectedCellHandles.containsKey(adr = String.valueOf(br.getSheet().getSheetName()) + "!" + br.getCellAddress())) continue;
            ReferenceTracker.addRec(br, affectedCellHandles);
            affectedCellHandles = (HashMap)this.clearAffectedFormulaCells(br, affectedCellHandles);
        }
        return affectedCellHandles;
    }

    public List<Ai> getChartReferences(BiffRec newRec) {
        String newRecSheetName = newRec.getSheet().getSheetName();
        ArrayList<Ai> ret = new ArrayList<Ai>();
        TrackedPtgs ptgRefs = (TrackedPtgs)this.sheetMap.get(GenericPtg.qualifySheetname(newRecSheetName));
        if (ptgRefs == null) {
            return ret;
        }
        Iterator parents = ptgRefs.getParents(newRec);
        while (parents.hasNext()) {
            BiffRec br = (BiffRec)parents.next();
            short op = br.getOpcode();
            if (op != 4177) continue;
            ret.add((Ai)br);
        }
        return ret;
    }

    public void addPtgNameReference(PtgName p) {
        String name = p.getTextString().toUpperCase();
        Object refs = this.nameRefs.get(name);
        if (refs == null) {
            refs = new ArrayList();
            ((ArrayList)refs).add(p);
            this.nameRefs.put(name, refs);
        } else {
            ArrayList ptgNames = (ArrayList)refs;
            if (!ptgNames.contains(p)) {
                ptgNames.add(p);
            }
        }
    }

    private static void addRec(BiffRec celly, Map affectedCellHandles) {
        String address = String.valueOf(celly.getSheet().getSheetName()) + "!" + celly.getCellAddress();
        affectedCellHandles.put(address, celly);
        try {
            ((Formula)celly).clearCachedValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public Ptg addCellRange(Ptg ptgRef) {
        String trackprop = System.getProperty("com.extentech.extenxls.trackreferences");
        if (trackprop != null && trackprop.equals("false")) {
            return ptgRef;
        }
        if (!(ptgRef instanceof PtgRef)) {
            return ptgRef;
        }
        if (ptgRef instanceof PtgAreaErr3d || ptgRef instanceof PtgRefErr3d || ptgRef instanceof PtgRefErr) {
            return ptgRef;
        }
        String sheetname = "";
        try {
            try {
                sheetname = ((PtgRef)ptgRef).getSheetName();
                sheetname = GenericPtg.qualifySheetname(sheetname);
            }
            catch (Exception ex) {
                sheetname = "WorkBookRanges";
            }
            if (sheetname.equals("#REF!")) {
                return ptgRef;
            }
            TrackedPtgs ptgs = (TrackedPtgs)this.sheetMap.get(sheetname);
            if (ptgs == null) {
                ptgs = new TrackedPtgs((Comparator)new LocationComparer());
                this.sheetMap.put(sheetname, ptgs);
            }
            if (!ptgs.contains(ptgRef)) {
                ptgs.add(ptgRef);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ptgRef;
    }

    public void clearPtgLocationCaches(String targetSheet) {
        try {
            targetSheet = GenericPtg.qualifySheetname(targetSheet);
            Iterator ptgs = ((TrackedPtgs)this.sheetMap.get(targetSheet)).values().iterator();
            while (ptgs.hasNext()) {
                try {
                    PtgRef p = (PtgRef)ptgs.next();
                    p.clearLocationCache();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeCellRange(Ptg cr) {
        if (!(cr instanceof PtgRef)) {
            return;
        }
        try {
            String sheetname = "";
            try {
                sheetname = ((PtgRef)cr).getSheetName();
                sheetname = GenericPtg.qualifySheetname(sheetname);
            }
            catch (Exception ex) {
                sheetname = "WorkBookRanges";
            }
            TrackedPtgs ptgs = (TrackedPtgs)this.sheetMap.get(sheetname);
            if (ptgs != null) {
                ptgs.remove(cr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateInRefTracker(PtgRef pr, XLSRecord parent) {
        if (pr instanceof PtgRefErr || pr instanceof PtgRefErr3d) {
            return;
        }
        try {
            String sheetname = "";
            try {
                sheetname = pr.getSheetName();
                sheetname = GenericPtg.qualifySheetname(sheetname);
            }
            catch (Exception ex) {
                sheetname = "WorkBookRanges";
            }
            TrackedPtgs ptgs = (TrackedPtgs)this.sheetMap.get(sheetname);
            if (ptgs != null) {
                ptgs.update(pr, parent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CellRange[] getCellRanges() {
        CellRange[] ret = new CellRange[this.crs.size()];
        return this.crs.toArray(ret);
    }

    public static void updateReferences(int start, int shiftamount, Boundsheet thissheet, boolean shiftRow) {
        boolean shiftInclusive = thissheet.isShiftInclusive();
        boolean isExcel2008 = thissheet.getWorkBook().getIsExcel2007();
        if (shiftInclusive) {
            ++start;
        }
        HashSet<PtgRef> updated = new HashSet<PtgRef>();
        String sheetname = GenericPtg.qualifySheetname(thissheet.getSheetName());
        TrackedPtgs trackedptgs = (TrackedPtgs)thissheet.getWorkBook().getRefTracker().sheetMap.get(sheetname);
        if (trackedptgs == null || trackedptgs.size() == 0) {
            return;
        }
        Object[] ptgs = null;
        ptgs = trackedptgs.toArray();
        int i = shiftamount > 0 ? ptgs.length - 1 : 0;
        int end = shiftamount > 0 ? 0 : ptgs.length;
        int inc = shiftamount > 0 ? -1 : 1;
        boolean done = false;
        while (!done) {
            Ptg p = (Ptg)ptgs[i];
            if (p instanceof PtgRefErr || p instanceof PtgRefErr3d) continue;
            PtgRef pr = (PtgRef)p;
            if (!updated.contains(pr)) {
                String sht;
                try {
                    sht = pr.getSheetName();
                }
                catch (Exception e) {
                    Logger.logErr("ReferenceTracker.updateReferences:  Error in Formula Reference Location: " + e.toString());
                    continue;
                }
                sht = GenericPtg.qualifySheetname(sht);
                if (sheetname.equals(sht) && ReferenceTracker.shiftPtg(pr, sht, start, shiftamount, isExcel2008, shiftRow)) {
                    updated.add(pr);
                }
            }
            i += inc;
            if (shiftamount > 0) {
                done = i < 0;
                continue;
            }
            boolean bl = done = i == ptgs.length;
        }
        if (thissheet.hasMergedCells()) {
            for (Mergedcells mrg : thissheet.getMergedCellsRecs()) {
                CellRange[] rngs = mrg.getMergedRanges();
                int j = 0;
                while (j < rngs.length) {
                    try {
                        int[] rc = rngs[j].getRangeCoords();
                        rc[0] = rc[0] - 1;
                        rc[2] = rc[2] - 1;
                        boolean isRange = rc.length > 2;
                        boolean bUpdated = false;
                        if (shiftRow) {
                            if (rc[0] >= start) {
                                rc[0] = rc[0] + shiftamount;
                                if (isRange) {
                                    rc[2] = rc[2] + shiftamount;
                                }
                                bUpdated = true;
                            } else if (isRange && rc[2] >= start) {
                                rc[2] = rc[2] + shiftamount;
                                bUpdated = true;
                            }
                        }
                        if (bUpdated) {
                            String newrange = thissheet + "!" + ExcelTools.formatLocation(rc);
                            rngs[j].setRange(newrange);
                        }
                    }
                    catch (CellNotFoundException cellNotFoundException) {
                        // empty catch block
                    }
                    ++j;
                }
            }
        }
    }

    public static boolean shiftPtg(PtgRef ptgref, String sht, int start, int shiftamount, boolean isExcel2007, boolean shiftRow) {
        int[] rc;
        short iParent = ptgref.getParentRec().getOpcode();
        boolean isNamedRange = iParent == 24;
        boolean isAi = iParent == 4177;
        boolean isShared = iParent == 1212;
        try {
            rc = ptgref.getIntLocation();
        }
        catch (Exception e) {
            if (!(ptgref instanceof PtgAreaErr3d)) {
                Logger.logErr("ReferenceTracker.shiftPtg:  Error in Formula Reference Location: " + e.toString());
            }
            return false;
        }
        boolean isRange = rc.length > 2;
        boolean bUpdated = false;
        if (shiftRow) {
            if (!(isNamedRange || isAi || ptgref.isRowRel())) {
                return false;
            }
            if (rc[0] + 1 == start && isRange) {
                rc[2] = rc[2] + shiftamount;
                if (isAi && rc[1] != rc[3]) {
                    rc[0] = rc[0] + shiftamount;
                }
                bUpdated = true;
            } else if (rc[0] + 1 >= start) {
                rc[0] = rc[0] + shiftamount;
                if (isRange) {
                    rc[2] = rc[2] + shiftamount;
                }
                bUpdated = true;
            } else if (isRange && rc[2] + 1 >= start) {
                rc[2] = rc[2] + shiftamount;
                if (isAi && rc[1] != rc[3]) {
                    rc[0] = rc[0] + shiftamount;
                }
                bUpdated = true;
            }
            if (bUpdated && iParent == 6 && ptgref.getParentRec().getRowNumber() == start - 1) {
                bUpdated = false;
            }
        } else {
            if (!(isNamedRange || isAi || ptgref.isColRel())) {
                return false;
            }
            if (rc[1] + 1 >= start) {
                rc[1] = rc[1] + shiftamount;
                if (isRange) {
                    rc[3] = rc[3] + shiftamount;
                }
                bUpdated = true;
            } else if (isRange && rc[3] + 1 >= start) {
                rc[3] = rc[3] + shiftamount;
                bUpdated = true;
            }
        }
        if (bUpdated) {
            if (isExcel2007) {
                if (rc[0] >= 0x100000) {
                    rc[0] = 1048575;
                }
                if (isRange && rc[2] >= 0x100000) {
                    rc[2] = 1048575;
                }
            } else {
                if (rc[0] >= 65536) {
                    rc[0] = 65535;
                }
                if (isRange && rc[2] >= 65536) {
                    rc[2] = 65535;
                }
            }
            String newaddr = ExcelTools.formatLocation(rc, ptgref.isRowRel(), ptgref.isColRel());
            if (isRange && newaddr.indexOf(":") == -1) {
                newaddr = String.valueOf(newaddr) + ":" + newaddr;
            }
            newaddr = String.valueOf(sht) + "!" + newaddr;
            try {
                if (!isAi && !isShared) {
                    ptgref.setLocation(newaddr);
                    if (isNamedRange) {
                        ReferenceTracker rt = ptgref.getParentRec().getWorkBook().getRefTracker();
                        String theName = ((Name)ptgref.getParentRec()).getNameA();
                        if (rt.nameRefs.containsKey(theName)) {
                            ArrayList list = (ArrayList)rt.nameRefs.get(theName);
                            int i = 0;
                            while (i < list.size()) {
                                XLSRecord ptgParent = ((Ptg)list.get(i)).getParentRec();
                                if (ptgParent.getOpcode() != 24) {
                                    rt.clearAffectedFormulaCells(ptgParent);
                                }
                                ++i;
                            }
                        }
                    } else if (iParent == 432) {
                        ((Condfmt)ptgref.getParentRec()).setDirty();
                    }
                } else if (isShared) {
                    ((Shrfmla)ptgref.getParentRec()).updateLocation(shiftamount, ptgref);
                } else {
                    ((Ai)ptgref.getParentRec()).changeAiLocation(ptgref, newaddr);
                }
            }
            catch (Exception e) {
                Logger.logInfo("ReferenceTracker.shiftPtg:  Shifting Formula Reference failed: " + e.toString());
            }
        }
        return bUpdated;
    }

    public static void insertChartSeries(Chart c, String sht, int rownum) {
        PtgRef pr = null;
        boolean inserted = false;
        HashMap seriesmap = c.getSeriesPtgs();
        Iterator ii = seriesmap.keySet().iterator();
        while (ii.hasNext() && !inserted) {
            Series s = (Series)ii.next();
            Ptg[] ptgs = (Ptg[])seriesmap.get(s);
            int i = 0;
            while (i < ptgs.length) {
                block11: {
                    int[] rc;
                    String cursheet;
                    try {
                        pr = (PtgRef)ptgs[i];
                        cursheet = pr.getSheetName();
                        rc = pr.getIntLocation();
                    }
                    catch (Exception e) {
                        break block11;
                    }
                    if (sht.equalsIgnoreCase(cursheet) && rc[0] == rownum) {
                        boolean isRange = rc.length > 2;
                        rc[0] = rc[0] - 1;
                        if (isRange) {
                            rc[2] = rc[2] - 1;
                        }
                        String newseries = ExcelTools.formatLocation(rc, pr.isRowRel(), pr.isColRel());
                        if (isRange && newseries.indexOf(":") == -1) {
                            newseries = String.valueOf(newseries) + ":" + newseries;
                        }
                        newseries = String.valueOf(sht) + "!" + newseries;
                        Ai legend = s.getLegendAi();
                        rc = ExcelTools.getRowColFromString(legend.getDefinition());
                        if (rc[0] == rownum) {
                            rc[0] = rc[0] - 1;
                        }
                        String legendRange = ExcelTools.formatLocation(rc);
                        Ai bubble = s.getBubbleValueAi();
                        String bubbleRange = "";
                        if (bubble != null && !bubble.getDefinition().equals("")) {
                            rc = ExcelTools.getRowColFromString(bubble.getDefinition());
                            if (rc[0] == rownum) {
                                rc[0] = rc[0] - 1;
                            }
                            if (rc.length > 2) {
                                rc[2] = rc[2] - 1;
                            }
                            bubbleRange = ExcelTools.formatLocation(rc);
                        }
                        String categoryRange = s.getCategoryValueAi().getDefinition();
                        c.addSeries(newseries, categoryRange, bubbleRange, legendRange, "", 0);
                        c.setDimensionsRecord();
                        inserted = true;
                    }
                }
                ++i;
            }
        }
    }

    public static void updateAddressPerPolicy(Ptg thisptg, String newaddr) {
        int pl = thisptg.getLocationPolicy();
        switch (pl) {
            case 0: {
                if (newaddr.indexOf("#REF!") > -1) {
                    Formula formula = (Formula)thisptg.getParentRec();
                    formula.replacePtg(thisptg, new PtgErr(PtgErr.ERROR_REF));
                    break;
                }
                thisptg.setLocation(newaddr);
                break;
            }
            case 2: {
                thisptg.updateAddressFromTrackerCell();
                break;
            }
        }
    }

    public static void adjustFormulaRefs(CellHandle newcell, int newrownum, int offset, boolean shiftRow) throws Exception {
        try {
            String sheet = newcell.getWorkSheetName();
            boolean isExcel2007 = newcell.getWorkBook().getWorkBook().getIsExcel2007();
            Ptg[] locptgs = newcell.getFormulaHandle().getFormulaRec().getCellRangePtgs();
            int t = 0;
            while (t < locptgs.length) {
                if (locptgs[t] instanceof PtgRef) {
                    PtgRef pr = (PtgRef)locptgs[t];
                    ReferenceTracker.shiftPtg(pr, sheet, newrownum, offset, isExcel2007, shiftRow);
                }
                ++t;
            }
        }
        catch (FormulaNotFoundException formulaNotFoundException) {
            // empty catch block
        }
    }

    public void close() {
        this.sheetMap.clear();
        this.nameRefs.clear();
        this.criteriaDBs.clear();
        this.CollectionDBs.clear();
        this.vlookups.clear();
        this.crs.clear();
        this.lookupColsCache.clear();
        this.sheetMap = new HashMap();
        this.nameRefs = new HashMap();
        this.criteriaDBs = new HashMap();
        this.CollectionDBs = new HashMap();
        this.vlookups = new HashMap();
        this.crs = new Vector();
        this.lookupColsCache = new HashMap();
    }
}

