/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Mulblank;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.util.Iterator;
import java.util.List;

public final class Mergedcells
extends XLSRecord {
    private static final long serialVersionUID = 6638569392267433468L;
    public static int MAXRANGES = 1024;
    private int nummerges = 0;
    private CompatibleVector ranges = new CompatibleVector();

    @Override
    public void init() {
        super.init();
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("Mergedcells record.");
        }
    }

    public static XLSRecord getPrototype() {
        Mergedcells newrec = new Mergedcells();
        newrec.setOpcode((short)229);
        newrec.setData(new byte[4]);
        return newrec;
    }

    public void removeCellRange(CellRange rng) {
        this.ranges.remove(rng);
        this.update();
    }

    public void addCellRange(CellRange rng) {
        this.ranges.add(rng);
    }

    public CellRange[] getMergedRanges() {
        if (this.ranges.size() < 1) {
            return null;
        }
        Object[] ret = new CellRange[this.ranges.size()];
        this.ranges.toArray(ret);
        return ret;
    }

    public void update() {
        if (this.ranges.size() > MAXRANGES) {
            this.handleMultiRec();
        }
        this.nummerges = this.ranges.size();
        int datasz = this.nummerges * 8;
        this.data = new byte[datasz += 2];
        byte[] szbt = ByteTools.shortToLEBytes((short)this.ranges.size());
        this.data[0] = szbt[0];
        this.data[1] = szbt[1];
        int pos = 2;
        if (this.DEBUGLEVEL > 50) {
            Logger.logInfo("updating Mergedcell with " + this.nummerges + " merges.");
        }
        int t = 0;
        while (t < this.ranges.size()) {
            CellRange thisrng = (CellRange)this.ranges.get(t);
            int[] rints = thisrng.getRowInts();
            int[] cints = thisrng.getColInts();
            byte[] rowmin = ByteTools.shortToLEBytes((short)(rints[0] - 1));
            this.data[pos++] = rowmin[0];
            this.data[pos++] = rowmin[1];
            byte[] rowmax = ByteTools.shortToLEBytes((short)(rints[rints.length - 1] - 1));
            this.data[pos++] = rowmax[0];
            this.data[pos++] = rowmax[1];
            byte[] colmin = ByteTools.shortToLEBytes((short)cints[0]);
            this.data[pos++] = colmin[0];
            this.data[pos++] = colmin[1];
            byte[] colmax = ByteTools.shortToLEBytes((short)cints[cints.length - 1]);
            this.data[pos++] = colmax[0];
            this.data[pos++] = colmax[1];
            ++t;
        }
        this.setData(this.data);
    }

    void handleMultiRec() {
        if (this.ranges.size() < MAXRANGES) {
            return;
        }
        this.nummerges = MAXRANGES;
        Mergedcells mcfresh = (Mergedcells)Mergedcells.getPrototype();
        List substa = this.ranges.subList(MAXRANGES, this.ranges.size());
        Iterator ita = substa.iterator();
        while (ita.hasNext()) {
            mcfresh.addCellRange((CellRange)ita.next());
        }
        Iterator removes = mcfresh.ranges.iterator();
        while (removes.hasNext()) {
            this.ranges.remove(removes.next());
        }
        this.getWorkBook().addRecord(mcfresh, false);
        int idx = this.getRecordIndex() + 1;
        mcfresh.setSheet(this.getSheet());
        this.getSheet().addMergedCellsRec(mcfresh);
        this.getStreamer().addRecordAt(mcfresh, idx);
        mcfresh.init();
        mcfresh.update();
    }

    public void initCells(WorkBookHandle wbook) {
        this.nummerges = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.ranges = new CompatibleVector();
        int pos = 2;
        int x = 0;
        while (x < this.nummerges) {
            int[] cellcoords = new int[4];
            cellcoords[0] = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            cellcoords[2] = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            cellcoords[1] = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            cellcoords[3] = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
            try {
                WorkSheetHandle shtr = wbook.getWorkSheet(this.getSheet().getSheetName());
                CellRange cr = new CellRange(shtr, cellcoords, false);
                cr.setWorkBook(wbook);
                this.ranges.add(cr);
                BiffRec[] ch = cr.getCellRecs();
                Mulblank aMul = null;
                int t = 0;
                while (t < ch.length) {
                    block6: {
                        block7: {
                            if (ch[t] == null) break block6;
                            if (ch[t].getOpcode() != 190) break block7;
                            if (aMul == (Mulblank)ch[t]) break block6;
                            aMul = (Mulblank)ch[t];
                        }
                        ch[t].setMergeRange(cr);
                    }
                    ++t;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++x;
        }
    }
}

