/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.RowHandle;
import com.extentech.formats.XLS.Colinfo;
import com.extentech.formats.XLS.Phonetic;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.escher.MsofbtClientAnchor;
import com.extentech.formats.escher.MsofbtClientData;
import com.extentech.formats.escher.MsofbtDg;
import com.extentech.formats.escher.MsofbtDgContainer;
import com.extentech.formats.escher.MsofbtOPT;
import com.extentech.formats.escher.MsofbtSp;
import com.extentech.formats.escher.MsofbtSpContainer;
import com.extentech.formats.escher.MsofbtSpgr;
import com.extentech.formats.escher.MsofbtSpgrContainer;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Random;

public final class MSODrawing
extends XLSRecord {
    private static final long serialVersionUID = 8275831369787287975L;
    public byte[] PROTOTYPE_BYTES;
    int imageIndex;
    boolean bActive;
    String imageName;
    String shapeName;
    short clientAnchorFlag;
    short[] bounds;
    short origHeight;
    short origWidth;
    private MsofbtOPT optrec;
    private MsofbtOPT secondaryoptrec;
    private MsofbtOPT tertiaryoptrec;
    short shapeType;
    private int SPIDSEED;
    boolean bIsHeader;
    int SPID;
    int SPCONTAINERLENGTH;
    boolean isShape;
    int numShapes;
    int lastSPID;
    static final int HEADERRECLENGTH = 24;
    int otherSPCONTAINERLENGTH;
    int SOLVERCONTAINERLENGTH;
    int drawingId;
    public static final int COL = 0;
    public static final int COLOFFSET = 1;
    public static final int ROW = 2;
    public static final int ROWOFFSET = 3;
    public static final int COL1 = 4;
    public static final int COLOFFSET1 = 5;
    public static final int ROW1 = 6;
    public static final int ROWOFFSET1 = 7;
    public static final int OFFSETMAX = 1023;
    public static final double XCONVERSION = 10.0;
    public static final double WCONVERSION = 8.8;
    public static final double PIXELCONVERSION = 1.333;
    private Phonetic phonetic;

    public MSODrawing() {
        byte[] byArray = new byte[100];
        byArray[0] = 15;
        byArray[2] = 4;
        byArray[3] = -16;
        byArray[4] = 92;
        byArray[8] = -78;
        byArray[9] = 4;
        byArray[10] = 10;
        byArray[11] = -16;
        byArray[12] = 8;
        byArray[16] = 2;
        byArray[17] = 4;
        byArray[21] = 10;
        byArray[24] = 35;
        byArray[26] = 11;
        byArray[27] = -16;
        byArray[28] = 34;
        byArray[32] = 4;
        byArray[33] = 65;
        byArray[34] = 2;
        byArray[38] = 5;
        byArray[39] = -63;
        byArray[40] = 22;
        byArray[44] = 66;
        byArray[46] = 108;
        byArray[48] = 117;
        byArray[50] = 101;
        byArray[52] = 32;
        byArray[54] = 104;
        byArray[56] = 105;
        byArray[58] = 108;
        byArray[60] = 108;
        byArray[62] = 115;
        byArray[68] = 16;
        byArray[69] = -16;
        byArray[70] = 18;
        byArray[74] = 2;
        byArray[76] = 2;
        byArray[80] = 11;
        byArray[84] = 6;
        byArray[88] = 22;
        byArray[90] = 75;
        byArray[94] = 17;
        byArray[95] = -16;
        this.PROTOTYPE_BYTES = byArray;
        this.imageIndex = -1;
        this.bActive = false;
        this.imageName = "";
        this.shapeName = "";
        this.bounds = new short[8];
        this.optrec = null;
        this.secondaryoptrec = null;
        this.tertiaryoptrec = null;
        this.shapeType = 0;
        this.SPIDSEED = 1024;
        this.bIsHeader = false;
        this.SPID = 0;
        this.SPCONTAINERLENGTH = 0;
        this.isShape = true;
        this.numShapes = 1;
        this.lastSPID = this.SPIDSEED;
        this.otherSPCONTAINERLENGTH = 0;
        this.SOLVERCONTAINERLENGTH = 0;
        this.drawingId = 0;
        this.phonetic = null;
    }

    public byte[] createRecord(int spid, String imageName, String shapeName, int imageIndex) {
        this.imageName = imageName;
        this.shapeName = shapeName;
        this.imageIndex = imageIndex;
        this.SPID = spid;
        MsofbtSp msofbtSp1 = new MsofbtSp(61450, this.shapeType, 2);
        msofbtSp1.setId(this.SPID);
        msofbtSp1.setGrfPersistence(2560);
        byte[] msofbtSp1Bytes = msofbtSp1.toByteArray();
        this.optrec = new MsofbtOPT(61451, 0, 3);
        if (imageIndex != -1) {
            this.optrec.setImageIndex(imageIndex);
        }
        if (imageName != null && !imageName.equals("")) {
            this.optrec.setImageName(imageName);
        }
        if (shapeName != null && !shapeName.equals("")) {
            this.optrec.setShapeName(shapeName);
        }
        byte[] msofbtOPT1Bytes = this.optrec.toByteArray();
        MsofbtClientAnchor msofbtClientAnchor1 = new MsofbtClientAnchor(61456, 0, 0);
        msofbtClientAnchor1.setBounds(this.bounds);
        byte[] msofbtClientAnchor1Bytes = msofbtClientAnchor1.toByteArray();
        MsofbtClientData msofbtClientData1 = new MsofbtClientData(61457, 0, 0);
        byte[] msofbtClientData1Bytes = msofbtClientData1.toByteArray();
        this.SPCONTAINERLENGTH = msofbtSp1Bytes.length + msofbtOPT1Bytes.length + msofbtClientAnchor1Bytes.length + msofbtClientData1Bytes.length;
        if (this.shapeType == 202) {
            this.SPCONTAINERLENGTH += 8;
        }
        MsofbtSpContainer msofbtSpContainer1 = new MsofbtSpContainer(61444, 0, 15);
        msofbtSpContainer1.setLength(this.SPCONTAINERLENGTH);
        byte[] msofbtSpContainer1Bytes = msofbtSpContainer1.toByteArray();
        this.SPCONTAINERLENGTH += msofbtSpContainer1Bytes.length;
        byte[] retData = new byte[this.SPCONTAINERLENGTH];
        int pos = 0;
        System.arraycopy(msofbtSpContainer1Bytes, 0, retData, pos, msofbtSpContainer1Bytes.length);
        System.arraycopy(msofbtSp1Bytes, 0, retData, pos += msofbtSpContainer1Bytes.length, msofbtSp1Bytes.length);
        System.arraycopy(msofbtOPT1Bytes, 0, retData, pos += msofbtSp1Bytes.length, msofbtOPT1Bytes.length);
        System.arraycopy(msofbtClientAnchor1Bytes, 0, retData, pos += msofbtOPT1Bytes.length, msofbtClientAnchor1Bytes.length);
        System.arraycopy(msofbtClientData1Bytes, 0, retData, pos += msofbtClientAnchor1Bytes.length, msofbtClientData1Bytes.length);
        pos += msofbtClientData1Bytes.length;
        if (this.bIsHeader) {
            if (this.lastSPID < this.SPID) {
                this.lastSPID = this.SPID;
            }
            int totalSPRECORDS = 0;
            MsofbtSp msofbtSp = new MsofbtSp(61450, 0, 2);
            msofbtSp.setId(this.SPIDSEED);
            msofbtSp.setGrfPersistence(5);
            byte[] msofbtSpBytes = msofbtSp.toByteArray();
            MsofbtSpgr msofbtSpgr = new MsofbtSpgr(61449, 0, 1);
            msofbtSpgr.setRect(0, 0, 0, 0);
            byte[] msofbtSpgrBytes = msofbtSpgr.toByteArray();
            totalSPRECORDS = msofbtSpgrBytes.length + msofbtSpBytes.length;
            MsofbtSpContainer msofbtSpContainer = new MsofbtSpContainer(61444, 0, 15);
            msofbtSpContainer.setLength(totalSPRECORDS);
            byte[] msofbtSpContainerBytes = msofbtSpContainer.toByteArray();
            this.SPCONTAINERLENGTH += (totalSPRECORDS += msofbtSpContainerBytes.length);
            MsofbtSpgrContainer msofbtSpgrContainer = new MsofbtSpgrContainer(61443, 0, 15);
            msofbtSpgrContainer.setLength(this.SPCONTAINERLENGTH + this.otherSPCONTAINERLENGTH);
            byte[] msofbtSpgrContainerBytes = msofbtSpgrContainer.toByteArray();
            MsofbtDg msofbtDg = new MsofbtDg(61448, this.drawingId, 0);
            msofbtDg.setNumShapes(this.numShapes);
            msofbtDg.setLastSPID(this.lastSPID);
            byte[] msofbtDgBytes = msofbtDg.toByteArray();
            MsofbtDgContainer msofbtDgContainer = new MsofbtDgContainer(61442, 0, 15);
            msofbtDgContainer.setLength(24 + this.SPCONTAINERLENGTH + this.otherSPCONTAINERLENGTH);
            byte[] msofbtDgContainerBytes = msofbtDgContainer.toByteArray();
            byte[] headerRec = new byte[80 + retData.length];
            pos = 0;
            System.arraycopy(msofbtDgContainerBytes, 0, headerRec, pos, msofbtDgContainerBytes.length);
            System.arraycopy(msofbtDgBytes, 0, headerRec, pos += msofbtDgContainerBytes.length, msofbtDgBytes.length);
            System.arraycopy(msofbtSpgrContainerBytes, 0, headerRec, pos += msofbtDgBytes.length, msofbtSpgrContainerBytes.length);
            System.arraycopy(msofbtSpContainerBytes, 0, headerRec, pos += msofbtSpgrContainerBytes.length, msofbtSpContainerBytes.length);
            System.arraycopy(msofbtSpgrBytes, 0, headerRec, pos += msofbtSpContainerBytes.length, msofbtSpgrBytes.length);
            System.arraycopy(msofbtSpBytes, 0, headerRec, pos += msofbtSpgrBytes.length, msofbtSpBytes.length);
            System.arraycopy(retData, 0, headerRec, pos += msofbtSpBytes.length, retData.length);
            retData = headerRec;
        }
        this.setData(retData);
        this.setLength(this.data.length);
        return retData;
    }

    @Override
    public void init() {
        super.init();
        ByteArrayInputStream bis = new ByteArrayInputStream(super.getData());
        this.SPCONTAINERLENGTH = 0;
        this.otherSPCONTAINERLENGTH = 0;
        int SPGRCONTAINERLENGTH = 0;
        int SPCONTAINERATOMS = 0;
        int DGCONTAINERLENGTH = 0;
        int DGCONTAINERATOMS = 0;
        int SOLVERCONTAINERATOMS = 0;
        boolean hasUndoInfo = false;
        while (bis.available() > 0) {
            byte[] dat = new byte[8];
            bis.read(dat, 0, 8);
            int version = 0xF & dat[0];
            int inst = (0xFF & dat[1]) << 4 | (0xF0 & dat[0]) >> 4;
            int fbt = (0xFF & dat[3]) << 8 | 0xFF & dat[2];
            int len = ByteTools.readInt(dat[4], dat[5], dat[6], dat[7]);
            if (version == 15) {
                if (fbt == 61442) {
                    this.bIsHeader = true;
                    this.otherSPCONTAINERLENGTH = len;
                    DGCONTAINERLENGTH = len;
                    continue;
                }
                if (fbt == 61443) {
                    if (SPGRCONTAINERLENGTH == 0) {
                        SPGRCONTAINERLENGTH = len;
                    }
                    if (this.bIsHeader) continue;
                    hasUndoInfo = true;
                    continue;
                }
                if (fbt == 61444) {
                    this.SPCONTAINERLENGTH += len + 8;
                    if (this.bIsHeader) {
                        this.otherSPCONTAINERLENGTH -= len + 8;
                    }
                    this.isShape = true;
                    continue;
                }
                if (fbt == 61445) {
                    this.isShape = false;
                    this.SOLVERCONTAINERLENGTH = len + 8;
                    continue;
                }
                Logger.logInfo("MSODrawing.init: unknown container encountered: " + fbt);
                continue;
            }
            dat = new byte[len];
            bis.read(dat, 0, len);
            switch (fbt) {
                case 61450: {
                    this.SPID = ByteTools.readInt(dat[0], dat[1], dat[2], dat[3]);
                    int flag = ByteTools.readInt(dat[4], dat[5], dat[6], dat[7]);
                    boolean fGroup = (flag & 1) == 1;
                    boolean fChild = (flag & 2) == 2;
                    boolean fPatriarch = (flag & 4) == 4;
                    boolean fDeleted = (flag & 8) == 8;
                    boolean fOleShape = (flag & 0x10) == 16;
                    boolean fHaveMaster = (flag & 0x20) == 32;
                    boolean fFlipH = (flag & 0x40) == 64;
                    boolean fFlipV = (flag & 0x80) == 128;
                    boolean fConnector = (flag & 0x100) == 256;
                    boolean fHaveAnchor = (flag & 0x200) == 512;
                    boolean fBackground = (flag & 0x400) == 1024;
                    boolean fHaveSpt = (flag & 0x800) == 2048;
                    boolean bl = this.bActive = this.bActive || fPatriarch;
                    if (fHaveSpt) {
                        this.shapeType = (short)inst;
                    }
                    if (inst == 0) {
                        this.SPIDSEED = this.SPID;
                    }
                    SPCONTAINERATOMS += len + 8;
                    break;
                }
                case 61456: {
                    this.clientAnchorFlag = ByteTools.readShort(dat[0], dat[1]);
                    this.bounds[0] = ByteTools.readShort(dat[2], dat[3]);
                    this.bounds[1] = ByteTools.readShort(dat[4], dat[5]);
                    this.bounds[2] = ByteTools.readShort(dat[6], dat[7]);
                    this.bounds[3] = ByteTools.readShort(dat[8], dat[9]);
                    this.bounds[4] = ByteTools.readShort(dat[10], dat[11]);
                    this.bounds[5] = ByteTools.readShort(dat[12], dat[13]);
                    this.bounds[6] = ByteTools.readShort(dat[14], dat[15]);
                    this.bounds[7] = ByteTools.readShort(dat[16], dat[17]);
                    SPCONTAINERATOMS += len + 8;
                    break;
                }
                case 61451: {
                    this.optrec = new MsofbtOPT(fbt, inst, version);
                    this.optrec.setData(dat);
                    this.imageName = this.optrec.getImageName();
                    this.shapeName = this.optrec.getShapeName();
                    this.imageIndex = this.optrec.getImageIndex();
                    SPCONTAINERATOMS += len + 8;
                    break;
                }
                case 61729: {
                    this.secondaryoptrec = new MsofbtOPT(fbt, inst, version);
                    this.secondaryoptrec.setData(dat);
                    SPCONTAINERATOMS += len + 8;
                    break;
                }
                case 61730: {
                    this.tertiaryoptrec = new MsofbtOPT(fbt, inst, version);
                    this.tertiaryoptrec.setData(dat);
                    SPCONTAINERATOMS += len + 8;
                    break;
                }
                case 61448: {
                    this.drawingId = inst;
                    this.numShapes = ByteTools.readInt(dat[0], dat[1], dat[2], dat[3]);
                    this.lastSPID = ByteTools.readInt(dat[4], dat[5], dat[6], dat[7]);
                }
                case 61720: 
                case 61728: {
                    DGCONTAINERATOMS += len + 8;
                    this.otherSPCONTAINERLENGTH -= len + 8;
                    break;
                }
                case 61452: 
                case 61453: {
                    this.isShape = false;
                    break;
                }
                case 61449: 
                case 61454: 
                case 61455: 
                case 61457: 
                case 61725: {
                    SPCONTAINERATOMS += len + 8;
                    break;
                }
                case 61458: 
                case 61459: 
                case 61460: 
                case 61461: 
                case 61463: {
                    SOLVERCONTAINERATOMS += len + 8;
                    break;
                }
                default: {
                    Logger.logInfo("MSODrawing.init:  unknown subrecord encountered: " + fbt);
                }
            }
        }
        if (hasUndoInfo) {
            this.SPCONTAINERLENGTH += 8;
        }
    }

    public void updateRecord(int spid, String imageName, String shapeName, int imageIndex, short[] bounds) {
        this.SPID = spid;
        this.imageName = imageName;
        this.shapeName = shapeName;
        this.imageIndex = imageIndex;
        this.bounds = bounds;
        this.updateRecord();
    }

    public void updateRecord() {
        byte[] spcontainer1atoms = new byte[]{};
        byte[] spcontainer2atoms = new byte[]{};
        byte[] dgcontaineratoms = new byte[]{};
        boolean hasUndoInfo = false;
        this.SPCONTAINERLENGTH = 0;
        super.getData();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
        while (bis.available() > 0) {
            byte[] header = new byte[8];
            bis.read(header, 0, 8);
            int fbt = (0xFF & header[3]) << 8 | 0xFF & header[2];
            int len = ByteTools.readInt(header[4], header[5], header[6], header[7]);
            if ((0xF & header[0]) == 15) {
                if (fbt == 61443) {
                    if (this.bIsHeader) continue;
                    hasUndoInfo = true;
                    continue;
                }
                if (fbt == 61444) {
                    this.isShape = true;
                    continue;
                }
                if (fbt == 61445) {
                    this.SOLVERCONTAINERLENGTH = len + 8;
                    this.isShape = false;
                    continue;
                }
                if (fbt != 61442) continue;
                continue;
            }
            byte[] data = new byte[len];
            bis.read(data, 0, len);
            switch (fbt) {
                case 61448: {
                    System.arraycopy(ByteTools.cLongToLEBytes(this.numShapes), 0, data, 0, 4);
                    System.arraycopy(ByteTools.cLongToLEBytes(this.lastSPID), 0, data, 4, 4);
                    len = data.length;
                    data = ByteTools.append(data, header);
                    dgcontaineratoms = ByteTools.append(data, dgcontaineratoms);
                    break;
                }
                case 61450: {
                    boolean fHaveSpt;
                    int flag = ByteTools.readInt(data[4], data[5], data[6], data[7]);
                    boolean bl = fHaveSpt = (flag & 0x800) == 2048;
                    if (flag != 5) {
                        System.arraycopy(ByteTools.cLongToLEBytes(this.SPID), 0, data, 0, 4);
                    }
                    if (fHaveSpt) {
                        header[0] = (byte)(2 | 0xF0 & this.shapeType << 4);
                        header[1] = (byte)((0xFF0 & this.shapeType) >> 4);
                    }
                    data = ByteTools.append(data, header);
                    if (flag != 5) {
                        spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                        break;
                    }
                    spcontainer2atoms = ByteTools.append(data, spcontainer2atoms);
                    break;
                }
                case 61456: {
                    System.arraycopy(ByteTools.shortToLEBytes(this.clientAnchorFlag), 0, data, 0, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[0]), 0, data, 2, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[1]), 0, data, 4, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[2]), 0, data, 6, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[3]), 0, data, 8, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[4]), 0, data, 10, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[5]), 0, data, 12, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[6]), 0, data, 14, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[7]), 0, data, 16, 2);
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61451: {
                    if (this.optrec == null) {
                        this.optrec = new MsofbtOPT(61451, 0, 3);
                    }
                    if (this.imageIndex != this.optrec.getImageIndex()) {
                        this.optrec.setImageIndex(this.imageIndex);
                    }
                    if (this.imageName == null || !this.imageName.equals(this.optrec.getImageName())) {
                        this.optrec.setImageName(this.imageName);
                    }
                    if (this.shapeName == null || !this.shapeName.equals(this.optrec.getShapeName())) {
                        this.optrec.setShapeName(this.shapeName);
                    }
                    data = this.optrec.toByteArray();
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61729: 
                case 61730: {
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61720: 
                case 61728: {
                    data = ByteTools.append(data, header);
                    dgcontaineratoms = ByteTools.append(data, dgcontaineratoms);
                    break;
                }
                case 61452: 
                case 61453: {
                    this.isShape = false;
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61449: {
                    data = ByteTools.append(data, header);
                    spcontainer2atoms = ByteTools.append(data, spcontainer2atoms);
                    break;
                }
                case 61454: 
                case 61455: 
                case 61457: 
                case 61725: {
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61458: 
                case 61459: 
                case 61460: 
                case 61461: 
                case 61463: {
                    break;
                }
                default: {
                    Logger.logInfo("MSODrawing.updateRecord:  unknown subrecord encountered: " + fbt);
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                }
            }
        }
        this.SPCONTAINERLENGTH = spcontainer1atoms.length;
        int additionalSP = 0;
        if (hasUndoInfo) {
            additionalSP = 8;
        }
        if (this.shapeType == 202) {
            additionalSP = 8;
        }
        MsofbtSpContainer spcontainer1 = new MsofbtSpContainer(61444, 0, 15);
        spcontainer1.setLength(this.SPCONTAINERLENGTH + additionalSP);
        byte[] container = spcontainer1.toByteArray();
        this.SPCONTAINERLENGTH += container.length;
        byte[] retData = new byte[this.SPCONTAINERLENGTH];
        System.arraycopy(container, 0, retData, 0, container.length);
        System.arraycopy(spcontainer1atoms, 0, retData, container.length, spcontainer1atoms.length);
        this.SPCONTAINERLENGTH += additionalSP;
        if (this.bIsHeader) {
            MsofbtSpContainer spcontainer2 = new MsofbtSpContainer(61444, 0, 15);
            spcontainer2.setLength(spcontainer2atoms.length);
            byte[] container2 = spcontainer2.toByteArray();
            this.SPCONTAINERLENGTH += spcontainer2atoms.length + container2.length;
            int spgrcontainerlen = this.SPCONTAINERLENGTH + this.otherSPCONTAINERLENGTH - 8;
            MsofbtSpgrContainer msofbtSpgrContainer = new MsofbtSpgrContainer(61443, 0, 15);
            msofbtSpgrContainer.setLength(spgrcontainerlen);
            byte[] spgrcontainer = msofbtSpgrContainer.toByteArray();
            int dgcontainerlen = dgcontaineratoms.length + spgrcontainerlen + this.SOLVERCONTAINERLENGTH + 8;
            MsofbtDgContainer msofbtDgContainer = new MsofbtDgContainer(61442, 0, 15);
            msofbtDgContainer.setLength(dgcontainerlen);
            byte[] dgcontainer = msofbtDgContainer.toByteArray();
            byte[] header = new byte[24 + this.SPCONTAINERLENGTH - additionalSP + dgcontainer.length];
            int pos = 0;
            System.arraycopy(dgcontainer, 0, header, pos, dgcontainer.length);
            System.arraycopy(dgcontaineratoms, 0, header, pos += dgcontainer.length, dgcontaineratoms.length);
            System.arraycopy(spgrcontainer, 0, header, pos += dgcontaineratoms.length, spgrcontainer.length);
            System.arraycopy(container2, 0, header, pos += spgrcontainer.length, container2.length);
            System.arraycopy(spcontainer2atoms, 0, header, pos += container2.length, spcontainer2atoms.length);
            System.arraycopy(retData, 0, header, pos += spcontainer2atoms.length, retData.length);
            retData = header;
        }
        this.setData(retData);
        this.setLength(this.data.length);
    }

    public void addHeader() {
        this.bIsHeader = true;
        if (this.lastSPID < this.SPID) {
            this.lastSPID = this.SPID;
        }
        MsofbtSp msofbtSp = new MsofbtSp(61450, 0, 2);
        msofbtSp.setId(this.SPIDSEED);
        msofbtSp.setGrfPersistence(5);
        byte[] msofbtSpBytes = msofbtSp.toByteArray();
        this.SPCONTAINERLENGTH += msofbtSpBytes.length;
        MsofbtSpgr msofbtSpgr = new MsofbtSpgr(61449, 0, 1);
        msofbtSpgr.setRect(0, 0, 0, 0);
        byte[] msofbtSpgrBytes = msofbtSpgr.toByteArray();
        this.SPCONTAINERLENGTH += msofbtSpgrBytes.length;
        MsofbtSpContainer msofbtSpContainer = new MsofbtSpContainer(61444, 0, 15);
        msofbtSpContainer.setLength(msofbtSpgrBytes.length + msofbtSpBytes.length);
        byte[] msofbtSpContainerBytes = msofbtSpContainer.toByteArray();
        this.SPCONTAINERLENGTH += 8;
        MsofbtSpgrContainer msofbtSpgrContainer = new MsofbtSpgrContainer(61443, 0, 15);
        msofbtSpgrContainer.setLength(this.SPCONTAINERLENGTH + this.otherSPCONTAINERLENGTH);
        byte[] msofbtSpgrContainerBytes = msofbtSpgrContainer.toByteArray();
        MsofbtDg msofbtDg = new MsofbtDg(61448, this.drawingId, 0);
        msofbtDg.setNumShapes(this.numShapes);
        msofbtDg.setLastSPID(this.lastSPID);
        byte[] msofbtDgBytes = msofbtDg.toByteArray();
        MsofbtDgContainer msofbtDgContainer = new MsofbtDgContainer(61442, 0, 15);
        msofbtDgContainer.setLength(24 + this.SPCONTAINERLENGTH + this.otherSPCONTAINERLENGTH);
        byte[] msofbtDgContainerBytes = msofbtDgContainer.toByteArray();
        byte[] headerRec = new byte[this.getData().length + 80];
        int pos = 0;
        System.arraycopy(msofbtDgContainerBytes, 0, headerRec, pos, msofbtDgContainerBytes.length);
        System.arraycopy(msofbtDgBytes, 0, headerRec, pos += msofbtDgContainerBytes.length, msofbtDgBytes.length);
        System.arraycopy(msofbtSpgrContainerBytes, 0, headerRec, pos += msofbtDgBytes.length, msofbtSpgrContainerBytes.length);
        System.arraycopy(msofbtSpContainerBytes, 0, headerRec, pos += msofbtSpgrContainerBytes.length, msofbtSpContainerBytes.length);
        System.arraycopy(msofbtSpgrBytes, 0, headerRec, pos += msofbtSpContainerBytes.length, msofbtSpgrBytes.length);
        System.arraycopy(msofbtSpBytes, 0, headerRec, pos += msofbtSpgrBytes.length, msofbtSpBytes.length);
        System.arraycopy(this.getData(), 0, headerRec, pos += msofbtSpBytes.length, this.getData().length);
        this.setData(headerRec);
    }

    public void removeHeader() {
        byte[] spcontainer1atoms = new byte[]{};
        this.SPCONTAINERLENGTH = 0;
        super.getData();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
        block12: while (bis.available() > 0) {
            byte[] header = new byte[8];
            bis.read(header, 0, 8);
            int fbt = (0xFF & header[3]) << 8 | 0xFF & header[2];
            int len = ByteTools.readInt(header[4], header[5], header[6], header[7]);
            if ((0xF & header[0]) == 15) continue;
            byte[] data = new byte[len];
            bis.read(data, 0, len);
            switch (fbt) {
                case 61448: {
                    break;
                }
                case 61450: {
                    int flag = ByteTools.readInt(data[4], data[5], data[6], data[7]);
                    if (flag != 5) {
                        System.arraycopy(ByteTools.cLongToLEBytes(this.SPID), 0, data, 0, 4);
                    }
                    data = ByteTools.append(data, header);
                    if (flag == 5) continue block12;
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61456: {
                    System.arraycopy(ByteTools.shortToLEBytes(this.clientAnchorFlag), 0, data, 0, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[0]), 0, data, 2, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[1]), 0, data, 4, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[2]), 0, data, 6, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[3]), 0, data, 8, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[4]), 0, data, 10, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[5]), 0, data, 12, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[6]), 0, data, 14, 2);
                    System.arraycopy(ByteTools.shortToLEBytes(this.bounds[7]), 0, data, 16, 2);
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61451: {
                    if (this.optrec == null) {
                        this.optrec = new MsofbtOPT(61451, 0, 3);
                    }
                    if (this.imageIndex != -1 && this.imageIndex != this.optrec.getImageIndex()) {
                        this.optrec.setImageIndex(this.imageIndex);
                    }
                    if (this.imageName != null && !this.imageName.equals("") && !this.imageName.equals(this.optrec.getImageName())) {
                        this.optrec.setImageName(this.imageName);
                    }
                    if (this.shapeName != null && !this.shapeName.equals("") && !this.shapeName.equals(this.optrec.getShapeName())) {
                        this.optrec.setShapeName(this.shapeName);
                    }
                    data = this.optrec.toByteArray();
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61729: 
                case 61730: {
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61720: 
                case 61728: {
                    break;
                }
                case 61452: 
                case 61453: {
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61449: {
                    break;
                }
                case 61454: 
                case 61455: 
                case 61457: 
                case 61725: {
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                    break;
                }
                case 61458: 
                case 61459: 
                case 61460: 
                case 61461: 
                case 61463: {
                    break;
                }
                default: {
                    Logger.logInfo("MSODrawing.removeHeader:  unknown subrecord encountered: " + fbt);
                    data = ByteTools.append(data, header);
                    spcontainer1atoms = ByteTools.append(data, spcontainer1atoms);
                }
            }
        }
        this.SPCONTAINERLENGTH = spcontainer1atoms.length;
        MsofbtSpContainer spcontainer1 = new MsofbtSpContainer(61444, 0, 15);
        spcontainer1.setLength(this.SPCONTAINERLENGTH);
        byte[] container = spcontainer1.toByteArray();
        this.SPCONTAINERLENGTH += container.length;
        byte[] retData = new byte[this.SPCONTAINERLENGTH];
        System.arraycopy(container, 0, retData, 0, container.length);
        System.arraycopy(spcontainer1atoms, 0, retData, container.length, spcontainer1atoms.length);
        this.setData(retData);
    }

    public void updateHeader(int otherSPContainers, int otherContainers, int numShapes, int lastSPID) {
        int len;
        int fbt;
        byte[] buf;
        if (!this.isHeader()) {
            Logger.logErr("Msodrawing.updateHeader is only applicable for the header drawing object");
            return;
        }
        this.numShapes = numShapes;
        this.lastSPID = lastSPID;
        this.otherSPCONTAINERLENGTH = otherSPContainers;
        int spgrcontainerlength = this.SPCONTAINERLENGTH + this.otherSPCONTAINERLENGTH;
        int dgcontainerlength = otherContainers + spgrcontainerlength;
        int DGATOMS = 0;
        boolean hasSPGRCONTAINER = false;
        super.getData();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
        while (bis.available() > 0) {
            buf = new byte[8];
            bis.read(buf, 0, 8);
            fbt = (0xFF & buf[3]) << 8 | 0xFF & buf[2];
            len = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
            if (fbt == 61442 || fbt == 61444) continue;
            if (fbt == 61443) {
                if (hasSPGRCONTAINER) {
                    spgrcontainerlength += 8;
                }
                DGATOMS += 8;
                hasSPGRCONTAINER = true;
                continue;
            }
            if (fbt == 61451) break;
            if (fbt == 61720 || fbt == 61448 || fbt == 61728) {
                DGATOMS += len + 8;
            }
            buf = new byte[len];
            bis.read(buf, 0, len);
        }
        dgcontainerlength += DGATOMS;
        super.getData();
        bis = new ByteArrayInputStream(this.data);
        while (bis.available() > 0) {
            buf = new byte[8];
            bis.read(buf, 0, 8);
            fbt = (0xFF & buf[3]) << 8 | 0xFF & buf[2];
            len = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
            if (fbt == 61442) {
                System.arraycopy(ByteTools.cLongToLEBytes(dgcontainerlength), 0, this.data, this.data.length - bis.available() - 4, 4);
                continue;
            }
            if (fbt == 61448) {
                buf = new byte[len];
                bis.read(buf, 0, len);
                byte[] newrec = new byte[8];
                System.arraycopy(ByteTools.cLongToLEBytes(this.numShapes), 0, newrec, 0, 4);
                System.arraycopy(ByteTools.cLongToLEBytes(this.lastSPID), 0, newrec, 4, 4);
                if (len == newrec.length) {
                    System.arraycopy(newrec, 0, this.data, this.data.length - bis.available() - newrec.length, newrec.length);
                    continue;
                }
                Logger.logErr("UpdateClientAnchorRecord: New Array Size=" + newrec.length);
                continue;
            }
            if (fbt == 61443) {
                System.arraycopy(ByteTools.cLongToLEBytes(spgrcontainerlength), 0, this.data, this.data.length - bis.available() - 4, 4);
                return;
            }
            buf = new byte[len];
            bis.read(buf, 0, len);
        }
    }

    public void updateImageIndex(int idx) {
        super.getData();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
        while (bis.available() > 0) {
            byte[] buf = new byte[8];
            bis.read(buf, 0, 8);
            int inst = (0xFF & buf[1]) << 4 | (0xF0 & buf[0]) >> 4;
            int fbt = (0xFF & buf[3]) << 8 | 0xFF & buf[2];
            int len = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
            if (fbt < 61445) continue;
            buf = new byte[len];
            bis.read(buf, 0, len);
            if (fbt != 61451) continue;
            int n = inst;
            int pos = 0;
            int i = 0;
            while (i < n) {
                int propertyId = (0x3F & buf[pos + 1]) << 8 | 0xFF & buf[pos];
                if (propertyId == 260) {
                    int insertPosition = this.data.length - bis.available() - len + pos + 2;
                    System.arraycopy(ByteTools.cLongToLEBytes(idx), 0, this.data, insertPosition, 4);
                    this.imageIndex = idx;
                    return;
                }
                pos += 6;
                ++i;
            }
        }
    }

    public void makeNonHeader() {
        if (!this.bIsHeader) {
            return;
        }
        this.bIsHeader = false;
        this.removeHeader();
    }

    public void setIsHeader() {
        if (!this.bIsHeader) {
            this.addHeader();
        }
    }

    public MsofbtOPT getOPTRec() {
        return this.optrec;
    }

    public boolean isHeader() {
        return this.bIsHeader;
    }

    public String getName() {
        return this.imageName;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public boolean hasBorder() {
        if (this.optrec != null) {
            return this.optrec.hasBorder();
        }
        return false;
    }

    public int borderLineWidth() {
        if (this.optrec != null) {
            return this.optrec.getBorderLineWidth();
        }
        return -1;
    }

    public void setImageIndex(int value) {
        this.imageIndex = value;
        this.updateRecord();
    }

    public void setImageName(String name) {
        if (!name.equals(this.imageName)) {
            this.imageName = name;
            this.updateRecord();
        }
    }

    public void setDrawingId(int id) {
        this.drawingId = id;
        this.updateDGRecord();
    }

    public int getDrawingId() {
        return this.drawingId;
    }

    public void setShapeName(String name) {
        if (!name.equals(this.shapeName)) {
            this.shapeName = name;
            this.updateRecord();
        }
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public void setBounds(short[] b) {
        this.bounds = (short[])b.clone();
        this.origHeight = this.calcHeight();
        this.updateClientAnchorRecord(this.bounds);
    }

    public void setBoundsInPixels(short[] coords) {
        short x = (short)Math.round(coords[0]);
        short y = (short)Math.round(coords[1]);
        short w = (short)Math.round(coords[2]);
        short h = (short)Math.round(coords[3]);
        this.setX(x);
        this.setY(y);
        this.setWidth(w);
        this.setHeight(h);
    }

    public short[] getCoords() {
        short x = (short)Math.round(this.getX() * 256 / 36);
        short y = (short)Math.round(this.getY() * 20 / (RowHandle.ROW_HEIGHT_DIVISOR - 4));
        short w = (short)Math.round(this.getWidth() * 256 / 36);
        short h = (short)Math.round(this.calcHeight() * 20 / (RowHandle.ROW_HEIGHT_DIVISOR - 2));
        return new short[]{x, y, w, h};
    }

    public void setCoords(short[] coords) {
        short x = (short)Math.round(coords[0] * 36 / 256);
        short y = (short)Math.round(coords[1] * (RowHandle.ROW_HEIGHT_DIVISOR - 4) / 20);
        short w = (short)Math.round(coords[2] * 36 / 256);
        short h = (short)Math.round(coords[3] * (RowHandle.ROW_HEIGHT_DIVISOR - 2) / 20);
        this.setX(x);
        this.setY(y);
        this.setWidth(w);
        this.setHeight(h);
    }

    public short[] getBounds() {
        return this.bounds;
    }

    public int getCol() {
        return this.bounds[0];
    }

    public int getCol1() {
        return this.bounds[4];
    }

    public int getRow0() {
        return this.bounds[2];
    }

    public int getRow1() {
        return this.bounds[6];
    }

    public void setRow(int row) {
        this.bounds[2] = (short)row;
        this.updateClientAnchorRecord(this.bounds);
    }

    public void setRow1(int row) {
        this.bounds[6] = (short)row;
        this.updateClientAnchorRecord(this.bounds);
    }

    public short getX() {
        int col = this.bounds[0];
        double colOff = (double)this.bounds[1] / 1024.0;
        double x = 0.0;
        int i = 0;
        while (i < col) {
            x += (double)this.getColWidth(i);
            ++i;
        }
        return (short)Math.round(x += colOff * (double)this.getColWidth(col));
    }

    public short getColOffset() {
        double colOff = (double)this.bounds[1] / 1024.0;
        short col = this.bounds[0];
        double x = colOff * (double)this.getColWidth(col);
        return (short)((double)Math.round(x) * 10.0);
    }

    public void setX(int x) {
        int z = 0;
        int col = 0;
        short colOffset = 0;
        int i = 0;
        while (i < 16384 && z < x) {
            int w = this.getColWidth(i);
            if (z + w < x) {
                z += w;
            } else {
                col = i;
                colOffset = (short)Math.round(1024.0 * ((double)(x - z) / (double)w));
                z = x;
            }
            i = (short)(i + 1);
        }
        this.bounds[0] = col;
        this.bounds[1] = colOffset;
        this.updateClientAnchorRecord(this.bounds);
    }

    public short getY() {
        int row = this.bounds[2];
        double y = 0.0;
        int i = 0;
        while (i < row) {
            y += this.getRowHeight(i);
            ++i;
        }
        double rowOff = (double)this.bounds[3] / 256.0;
        return (short)Math.round(y += this.getRowHeight(row) * rowOff);
    }

    public void setY(int y) {
        double z = 0.0;
        int row = 0;
        short rowOffset = 0;
        int i = 0;
        while (z < (double)y) {
            double h = this.getRowHeight(i);
            if (z + h < (double)y) {
                z += h;
            } else {
                row = i;
                rowOffset = (short)Math.round(256.0 * (((double)y - z) / this.getRowHeight(i)));
                z = y;
            }
            i = (short)(i + 1);
        }
        this.bounds[2] = row;
        this.bounds[3] = rowOffset;
        this.updateClientAnchorRecord(this.bounds);
    }

    public short getOriginalWidth() {
        return this.origWidth;
    }

    public short getWidth() {
        short col = this.bounds[0];
        double colOff = (double)this.bounds[1] / 1024.0;
        short col1 = this.bounds[4];
        double colOff1 = (double)this.bounds[5] / 1024.0;
        double w = (double)this.getColWidth(col) - (double)this.getColWidth(col) * colOff;
        int i = col + 1;
        while (i < col1) {
            w += (double)this.getColWidth(i);
            ++i;
        }
        w = col1 > col ? (w += (double)this.getColWidth(col1) * colOff1) : (double)this.getColWidth(col1) * (colOff1 - colOff);
        return (short)Math.round(w);
    }

    public short getHeight() {
        return this.origHeight;
    }

    private short calcHeight() {
        short row = this.bounds[2];
        short row1 = this.bounds[6];
        double rowOff = (double)this.bounds[3] / 256.0;
        double rowOff1 = (double)this.bounds[7] / 256.0;
        double y = this.getRowHeight(row) - this.getRowHeight(row) * rowOff;
        int i = row + 1;
        while (i < row1) {
            y += this.getRowHeight(i);
            ++i;
        }
        y = row1 > row ? (y += this.getRowHeight(row1) * rowOff1) : this.getRowHeight(row1) * (rowOff1 - rowOff);
        return (short)Math.round(y);
    }

    public void setWidth(int w) {
        int col = this.bounds[0];
        double colOff = (double)this.bounds[1] / 1024.0;
        int col1 = col;
        int colOff1 = 0;
        int z = this.getColWidth(col) - (int)((double)this.getColWidth(col) * colOff);
        if (z >= w) {
            col1 = col;
            colOff1 = (short)Math.round(1024.0 * ((double)w / (double)this.getColWidth(col))) + this.bounds[1];
        }
        int i = col + 1;
        while (i < 16384 && z < w) {
            int cw = this.getColWidth(i);
            if (z + cw < w) {
                z += cw;
            } else {
                col1 = i;
                colOff1 = (short)(1024.0 * ((double)(w - z) / (double)cw));
                z = w;
            }
            ++i;
        }
        this.bounds[4] = (short)col1;
        this.bounds[5] = (short)colOff1;
        this.updateClientAnchorRecord(this.bounds);
        this.origWidth = this.getOriginalWidth();
    }

    public void setHeight(int h) {
        int row = this.bounds[2];
        double rowOff = (double)this.bounds[3] / 256.0;
        int row1 = row;
        int rowOff1 = 0;
        double rh = this.getRowHeight(row);
        double y = rh - rh * rowOff;
        if (y > (double)h) {
            rowOff1 = (short)(256.0 * ((double)h / rh)) + this.bounds[3];
        }
        int i = row + 1;
        while (y < (double)h) {
            rh = this.getRowHeight(i);
            if (y + rh < (double)h) {
                y += rh;
            } else {
                row1 = i;
                rowOff1 = (short)Math.round(256.0 * (((double)h - y) / rh));
                y = h;
            }
            ++i;
        }
        this.bounds[6] = (short)row1;
        this.bounds[7] = (short)rowOff1;
        this.updateClientAnchorRecord(this.bounds);
        this.origHeight = this.calcHeight();
    }

    public short[] getColAndOffset() {
        return new short[]{this.bounds[0], this.bounds[1]};
    }

    public void setColAndOffset(short[] b) {
        this.bounds[0] = b[0];
        this.bounds[1] = b[1];
        this.updateClientAnchorRecord(this.bounds);
    }

    public short[] getRowAndOffset() {
        return new short[]{this.bounds[2], this.bounds[3]};
    }

    public void setRowAndOffset(short[] b) {
        this.bounds[2] = b[0];
        this.bounds[3] = b[1];
        this.updateClientAnchorRecord(this.bounds);
    }

    private int getColWidth(int col) {
        double w = 2340.0;
        try {
            Colinfo co = this.getSheet().getColInfo(col);
            if (co != null) {
                w = co.getColWidth();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (int)Math.round(w / 256.0);
    }

    private double getRowHeight(int row) {
        int h = 255;
        try {
            Row r2 = this.getSheet().getRowByNumber(row);
            if (r2 == null) {
                return this.getSheet().getDefaultRowHeight();
            }
            h = r2.getRowHeight();
        }
        catch (Exception e) {
            return this.getSheet().getDefaultRowHeight();
        }
        return (double)h / 20.0;
    }

    public Phonetic getMystery() {
        return this.phonetic;
    }

    public void setMystery(Phonetic p) {
        this.phonetic = p;
    }

    public int getNumShapes() {
        return this.numShapes;
    }

    public void setNumShapes(int n) {
        this.numShapes = n;
        this.updateDGRecord();
    }

    public int getlastSPID() {
        return this.lastSPID;
    }

    public int getSPContainerLength() {
        return this.SPCONTAINERLENGTH;
    }

    public int getSOLVERContainerLength() {
        return this.SOLVERCONTAINERLENGTH;
    }

    protected static XLSRecord getPrototype() {
        MSODrawing mso = new MSODrawing();
        mso.setOpcode((short)236);
        mso.setData(mso.PROTOTYPE_BYTES);
        mso.init();
        return mso;
    }

    protected static XLSRecord getTextBoxPrototype() {
        MSODrawing mso = new MSODrawing();
        mso.setOpcode((short)236);
        byte[] byArray = new byte[8];
        byArray[2] = 13;
        byArray[3] = -16;
        mso.setData(byArray);
        mso.init();
        return mso;
    }

    private void updateDGRecord() {
        super.getData();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
        while (bis.available() > 0) {
            byte[] buf = new byte[8];
            bis.read(buf, 0, 8);
            int fbt = (0xFF & buf[3]) << 8 | 0xFF & buf[2];
            int len = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
            if (fbt < 61445) continue;
            buf = new byte[len];
            bis.read(buf, 0, len);
            if (fbt != 61448) continue;
            this.data[8] = (byte)(this.drawingId * 16);
            byte[] newrec = new byte[8];
            System.arraycopy(ByteTools.cLongToLEBytes(this.numShapes), 0, newrec, 0, 4);
            System.arraycopy(ByteTools.cLongToLEBytes(this.lastSPID), 0, newrec, 4, 4);
            if (len == newrec.length) {
                System.arraycopy(newrec, 0, this.data, this.data.length - bis.available() - newrec.length, newrec.length);
            } else {
                Logger.logErr("UpdateClientAnchorRecord: New Array Size=" + newrec.length);
            }
            return;
        }
    }

    private void updateClientAnchorRecord(short[] bounds) {
        super.getData();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
        while (bis.available() > 0) {
            byte[] buf = new byte[8];
            bis.read(buf, 0, 8);
            int fbt = (0xFF & buf[3]) << 8 | 0xFF & buf[2];
            int len = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
            if (fbt < 61445) continue;
            buf = new byte[len];
            bis.read(buf, 0, len);
            if (fbt != 61456) continue;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                bos.write(ByteTools.shortToLEBytes(this.clientAnchorFlag));
                bos.write(ByteTools.shortToLEBytes(bounds[0]));
                bos.write(ByteTools.shortToLEBytes(bounds[1]));
                bos.write(ByteTools.shortToLEBytes(bounds[2]));
                bos.write(ByteTools.shortToLEBytes(bounds[3]));
                bos.write(ByteTools.shortToLEBytes(bounds[4]));
                bos.write(ByteTools.shortToLEBytes(bounds[5]));
                bos.write(ByteTools.shortToLEBytes(bounds[6]));
                bos.write(ByteTools.shortToLEBytes(bounds[7]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] newrec = bos.toByteArray();
            if (buf.length == newrec.length) {
                System.arraycopy(newrec, 0, this.data, this.data.length - bis.available() - newrec.length, newrec.length);
            } else {
                Logger.logErr("UpdateClientAnchorRecord: New Array Size=" + newrec.length);
            }
            return;
        }
    }

    public void setOPTSubRecord(int propertyId, boolean isBid, boolean isComplex, int dtx, byte[] complexBytes) {
        MsofbtOPT optrec = this.getOPTRec();
        int origlen = optrec.toByteArray().length;
        optrec.setProperty(959, isBid, isComplex, dtx, complexBytes);
        this.updateRecord();
        if (origlen != optrec.toByteArray().length) {
            this.getWorkBook().updateMsodrawingHeaderRec(this.getSheet());
        }
    }

    public void setLastSPID(int spid) {
        this.lastSPID = spid;
        this.updateDGRecord();
    }

    public void setSPID(int spid) {
        this.SPID = spid;
        this.updateSPID();
    }

    public int getSPID() {
        return this.SPID;
    }

    public void setShapeType(int shapeType) {
        this.shapeType = (short)shapeType;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    private void updateSPID() {
        super.getData();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
        while (bis.available() > 0) {
            byte[] buf = new byte[8];
            bis.read(buf, 0, 8);
            int inst = (0xFF & buf[1]) << 4 | (0xF0 & buf[0]) >> 4;
            int fbt = (0xFF & buf[3]) << 8 | 0xFF & buf[2];
            int len = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
            if (fbt < 61445) continue;
            buf = new byte[len];
            bis.read(buf, 0, len);
            if (fbt != 61450) continue;
            int flag = ByteTools.readInt(buf[4], buf[5], buf[6], buf[7]);
            System.arraycopy(ByteTools.cLongToLEBytes(this.SPID), 0, this.data, this.data.length - bis.available() - len, 4);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Msodrawing: image=" + this.imageName + ".\t" + this.shapeName + "\timageIndex=" + this.imageIndex + " sheet=" + (this.getSheet() != null ? this.getSheet().getSheetName() : "none"));
        sb.append(" ID= " + this.drawingId + " SPID=" + this.SPID);
        sb.append("\tShapeType= " + this.shapeType);
        if (this.isHeader()) {
            sb.append("\tNumber of Shapes=" + this.numShapes + " Last SPID=" + this.lastSPID + " SPCL=" + this.SPCONTAINERLENGTH + " otherLen=" + this.otherSPCONTAINERLENGTH);
        } else {
            sb.append(" SPCL=" + this.SPCONTAINERLENGTH);
        }
        if (!this.isShape) {
            sb.append(" NOT A SHAPE");
        }
        return sb.toString();
    }

    @Override
    public void setSheet(Sheet bs) {
        super.setSheet(bs);
        this.origHeight = this.calcHeight();
        this.origWidth = this.getOriginalWidth();
    }

    public boolean isActive() {
        return this.bActive;
    }

    public void createDropDownListStyle(int col) {
        MsofbtOPT optrec = this.getOPTRec();
        optrec.setInst(0);
        optrec.setData(new byte[0]);
        optrec.setProperty(127, false, false, 0x1040104, null);
        optrec.setProperty(191, false, false, 524296, null);
        optrec.setProperty(511, false, false, 524288, null);
        optrec.setProperty(959, false, false, 131072, null);
        this.setShapeType(201);
        short[] sArray = new short[8];
        sArray[0] = (short)col;
        sArray[4] = (short)(col + 1);
        sArray[6] = 1;
        this.updateRecord(++this.wkbook.lastSPID, null, null, -1, sArray);
    }

    public void createCommentBox(int row, int col) {
        MsofbtOPT optrec = this.getOPTRec();
        optrec.setInst(0);
        optrec.setData(new byte[0]);
        int id = new Random().nextInt();
        optrec.setProperty(128, false, false, id, null);
        optrec.setProperty(139, false, false, 2, null);
        optrec.setProperty(191, false, false, 524296, null);
        optrec.setProperty(344, false, false, 0, null);
        optrec.setProperty(385, false, false, 0x8000050, null);
        optrec.setProperty(387, false, false, 0x8000050, null);
        optrec.setProperty(447, false, false, 0x100010, null);
        optrec.setProperty(513, false, false, 0, null);
        optrec.setProperty(575, false, false, 196611, null);
        optrec.setProperty(959, false, false, 131074, null);
        this.setShapeType(202);
        this.updateRecord(++this.wkbook.lastSPID, null, null, -1, new short[]{(short)(col + 1), 240, (short)row, 30, (short)(col + 3), 496, (short)(row + 4), 196});
    }

    public String debugOutput() {
        ByteArrayInputStream bis = new ByteArrayInputStream(super.getData());
        StringBuffer log = new StringBuffer();
        try {
            while (bis.available() > 0) {
                byte[] dat = new byte[8];
                bis.read(dat, 0, 8);
                int version = 0xF & dat[0];
                int inst = (0xFF & dat[1]) << 4 | (0xF0 & dat[0]) >> 4;
                int fbt = (0xFF & dat[3]) << 8 | 0xFF & dat[2];
                int len = ByteTools.readInt(dat[4], dat[5], dat[6], dat[7]);
                log.append(String.valueOf(fbt) + " " + version + "/" + inst + "/" + len);
                if (version == 15) {
                    if (fbt == 61442) {
                        log.append("\tMSOFBTDGCONTAINER");
                    } else if (fbt == 61443) {
                        log.append("\tMSOFBTSPGRCONTAINER");
                    } else if (fbt == 61444) {
                        log.append("\tMSOFBTSPCONTAINER");
                    } else if (fbt == 61445) {
                        log.append("\tMSOFBTSOLVERCONTAINER");
                    } else {
                        log.append("\tUNKNOWN CONTAINER");
                    }
                    log.append("\r\n");
                    continue;
                }
                dat = new byte[len];
                bis.read(dat, 0, len);
                switch (fbt) {
                    case 61463: {
                        log.append("\tMSOFBTCALLOUTRULE");
                        break;
                    }
                    case 61725: {
                        log.append("\tMSOFBTDELETEDPSPL");
                        break;
                    }
                    case 61720: {
                        log.append("\tMSOFBTREGROUPITEMS");
                        break;
                    }
                    case 61450: {
                        log.append("\tMSOFBTSP");
                        int flag = ByteTools.readInt(dat[4], dat[5], dat[6], dat[7]);
                        if ((flag & 0x800) == 2048) {
                            log.append("\tshapeType=" + inst);
                        }
                        if (inst == 0) {
                            log.append("\tSPIDSEED=" + ByteTools.readInt(dat[0], dat[1], dat[2], dat[3]));
                        } else {
                            log.append("\tSPID=" + ByteTools.readInt(dat[0], dat[1], dat[2], dat[3]));
                        }
                        log.append("\tflag=" + flag);
                        break;
                    }
                    case 61456: {
                        log.append("\tMSOFBTCLIENTANCHOR");
                        log.append("\t[");
                        log.append(String.valueOf(ByteTools.readShort(dat[2], dat[3])) + ",");
                        log.append(String.valueOf(ByteTools.readShort(dat[4], dat[5])) + ",");
                        log.append(String.valueOf(ByteTools.readShort(dat[6], dat[7])) + ",");
                        log.append(String.valueOf(ByteTools.readShort(dat[8], dat[9])) + ",");
                        log.append(String.valueOf(ByteTools.readShort(dat[10], dat[11])) + ",");
                        log.append(String.valueOf(ByteTools.readShort(dat[12], dat[13])) + ",");
                        log.append(String.valueOf(ByteTools.readShort(dat[14], dat[15])) + ",");
                        log.append(ByteTools.readShort(dat[16], dat[17]));
                        log.append("]");
                        break;
                    }
                    case 61451: {
                        log.append("\tMSOFBTOPT");
                        log.append(this.optrec.debugOutput());
                        break;
                    }
                    case 61729: {
                        log.append("\tMSOFBTSECONDARYOPT");
                        MsofbtOPT secondaryoptrec = new MsofbtOPT(fbt, inst, version);
                        secondaryoptrec.setData(dat);
                        log.append(secondaryoptrec.debugOutput());
                        break;
                    }
                    case 61730: {
                        log.append("\tMSOFBTTERTIARYOPT");
                        MsofbtOPT tertiaryoptrec = new MsofbtOPT(fbt, inst, version);
                        tertiaryoptrec.setData(dat);
                        log.append(tertiaryoptrec.debugOutput());
                        break;
                    }
                    case 61448: {
                        log.append("\tMSOFBTDG");
                        log.append("\tID=" + inst);
                        log.append("\tns=" + ByteTools.readInt(dat[0], dat[1], dat[2], dat[3]));
                        log.append("\tllastSPID=" + ByteTools.readInt(dat[4], dat[5], dat[6], dat[7]));
                        break;
                    }
                    case 61453: {
                        log.append("\tMSOFBTCLIENTTEXTBOX");
                        break;
                    }
                    case 61449: {
                        log.append("\tMSOFBTSPGR");
                        break;
                    }
                    case 61457: {
                        log.append("\tMSOFBTCLIENTDATA");
                        break;
                    }
                    case 61445: {
                        log.append("\tMSOFBTSOLVERCONTAINER");
                        break;
                    }
                    case 61455: {
                        log.append("\tMSOFBTCHILDANCHOR");
                        break;
                    }
                    case 61458: {
                        log.append("\tMSOFBTCONNECTORRULE");
                        break;
                    }
                    default: {
                        log.append("\tUNKNOWN ATOM");
                    }
                }
                log.append("\r\n");
            }
        }
        catch (Exception e) {
            log.append("\r\nEXCEPTION: " + e.toString());
        }
        log.append("**");
        return log.toString();
    }

    @Override
    public void close() {
        super.close();
        this.bounds = null;
        this.optrec = null;
        this.secondaryoptrec = null;
        this.tertiaryoptrec = null;
    }
}

