/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Dv;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

public class Dval
extends XLSRecord {
    private static final long serialVersionUID = 3954586766300169606L;
    private short grbit;
    private int xLeft;
    private int yTop;
    private int inObj;
    private int idvMac;
    private static final short BITMASK_F_WN_CLOSED = 1;
    private static final short BITMASK_F_WN_PINNED = 2;
    private static final short BITMASK_F_CACHED = 4;
    private byte[] PROTOTYPE_BYTES;
    private ArrayList dvRecs;

    public Dval() {
        byte[] byArray = new byte[18];
        byArray[0] = 4;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        int offset = 0;
        this.dvRecs = new ArrayList();
        this.grbit = ByteTools.readShort(this.getByteAt(offset++), this.getByteAt(offset++));
        this.xLeft = ByteTools.readInt(this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++));
        this.yTop = ByteTools.readInt(this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++));
        this.inObj = ByteTools.readInt(this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++));
        this.idvMac = ByteTools.readInt(this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++), this.getByteAt(offset++));
    }

    protected static XLSRecord getPrototype() {
        Dval dval = new Dval();
        dval.setOpcode((short)434);
        dval.setData(dval.PROTOTYPE_BYTES);
        dval.init();
        return dval;
    }

    public void setGrbit() {
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        System.arraycopy(b, 0, data, 0, 2);
        this.setData(data);
    }

    public boolean isValidityCached() {
        return (this.grbit & 4) == 4;
    }

    public void setValidityCached(boolean cached) {
        this.grbit = cached ? (short)(this.grbit | 4) : (short)(this.grbit ^ 4);
        this.setGrbit();
    }

    public boolean isPromptBoxAtCell() {
        return (this.grbit & 2) == 2;
    }

    public void setPromptBoxAtCell(boolean location) {
        this.grbit = location ? (short)(this.grbit | 2) : (short)(this.grbit ^ 2);
        this.setGrbit();
    }

    public boolean isPromptBoxVisible() {
        return (this.grbit & 1) == 1;
    }

    public void setPromptBoxVisible(boolean location) {
        this.grbit = location ? (short)(this.grbit | 1) : (short)(this.grbit ^ 1);
        this.setGrbit();
    }

    public int getFollowingDvCount() {
        return this.idvMac;
    }

    public void setFollowingDvCount(int cnt) {
        this.idvMac = cnt;
        byte[] data = this.getData();
        byte[] b = ByteTools.cLongToLEBytes(this.idvMac);
        System.arraycopy(b, 0, data, 14, 4);
        this.setData(data);
    }

    public int getObjectIdentifier() {
        return this.inObj;
    }

    public void setObjectIdentifier(int cnt) {
        this.inObj = cnt;
        byte[] data = this.getData();
        byte[] b = ByteTools.cLongToLEBytes(this.inObj);
        System.arraycopy(b, 0, data, 10, 4);
        this.setData(data);
    }

    public int getHorizontalPosition() {
        return this.xLeft;
    }

    public void setHorizontalPosition(int cnt) {
        this.xLeft = cnt;
        byte[] data = this.getData();
        byte[] b = ByteTools.cLongToLEBytes(this.xLeft);
        System.arraycopy(b, 0, data, 2, 4);
        this.setData(data);
    }

    public int getVerticalPosition() {
        return this.yTop;
    }

    public void setVerticalPosition(int cnt) {
        this.yTop = cnt;
        byte[] data = this.getData();
        byte[] b = ByteTools.cLongToLEBytes(this.yTop);
        System.arraycopy(b, 0, data, 2, 4);
        this.setData(data);
    }

    public void addDvRec(Dv dv) {
        this.dvRecs.add(dv);
    }

    public Dv createDvRec(String location) {
        Dv d = (Dv)Dv.getPrototype(this.getWorkBook());
        d.setSheet(this.getSheet());
        d.setRange(location);
        this.addDvRec(d);
        this.setFollowingDvCount(this.dvRecs.size());
        return d;
    }

    public List getDvs() {
        return this.dvRecs;
    }

    public void removeDvRec(Dv dv) {
        this.dvRecs.remove(dv);
    }

    public Dv getDv(String cellAddress) {
        if (cellAddress.indexOf("!") != -1) {
            cellAddress = cellAddress.substring(cellAddress.indexOf("!"));
        }
        int i = 0;
        while (i < this.dvRecs.size()) {
            Dv d = (Dv)this.dvRecs.get(i);
            if (d.isInRange(cellAddress)) {
                return d;
            }
            ++i;
        }
        return null;
    }

    public static Dval parseOOXML(XmlPullParser xpp, Boundsheet bs) {
        Dval dval = bs.insertDvalRec();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("dataValidations")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (!n.equals("count")) {
                                if (n.equals("disablePrompts")) {
                                    dval.setPromptBoxVisible(false);
                                } else if (n.equals("xWindow")) {
                                    dval.setHorizontalPosition(Integer.valueOf(v));
                                } else if (n.equals("yWindow")) {
                                    dval.setVerticalPosition(Integer.valueOf(v));
                                }
                            }
                            ++i;
                        }
                    } else if (tnm.equals("dataValidation")) {
                        Dv.parseOOXML(xpp, bs);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("dataValidations")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLELEMENT.parseOOXML: " + e.toString());
        }
        return dval;
    }

    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.dvRecs.size() > 0) {
            ooxml.append("<dataValidations count=\"" + this.dvRecs.size() + "\"");
            if (!this.isPromptBoxVisible()) {
                ooxml.append(" disablePrompts=\"1\"");
            }
            if (this.getHorizontalPosition() != 0) {
                ooxml.append(" xWindow=\"" + this.getHorizontalPosition() + "\"");
            }
            if (this.getVerticalPosition() != 0) {
                ooxml.append(" yWindow=\"" + this.getVerticalPosition() + "\"");
            }
            ooxml.append(">");
            int i = 0;
            while (i < this.dvRecs.size()) {
                ooxml.append(((Dv)this.dvRecs.get(i)).getOOXML());
                ++i;
            }
            ooxml.append("</dataValidations>");
        }
        return ooxml.toString();
    }
}

