/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class DConRef
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = 2639291289806138985L;
    private short rwFirst;
    private short rwLast;
    private short colFirst;
    private short colLast;
    private short cchFile;
    private String fileName = null;
    private byte refType = 0;

    @Override
    public void init() {
        super.init();
        this.rwFirst = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.rwLast = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.colFirst = this.getByteAt(4);
        this.colLast = this.getByteAt(5);
        this.cchFile = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        if (this.cchFile > 0) {
            byte encoding = this.getByteAt(8);
            this.refType = this.getByteAt(9);
            if (this.refType != 2) {
                Logger.logWarn("PivotTable: External Data Sources are not supported");
            }
            byte[] tmp = this.getBytesAt(10, (this.cchFile - 1) * (encoding + 1));
            try {
                this.fileName = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding PivotTable name in DCONREF: " + e);
            }
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("DCONREF: rwFirst:" + this.rwFirst + " rwLast:" + this.rwLast + " colFirst:" + this.colFirst + " colLast:" + this.colLast + " cchFile:" + this.cchFile + " fileName:" + this.fileName);
        }
    }

    public int[] getRange() {
        return new int[]{this.rwFirst, this.colFirst, this.rwLast, this.colLast};
    }

    public String getSourceSheet() {
        if (this.refType != 2) {
            Logger.logWarn("External Data Sources are not supported");
        }
        return this.fileName;
    }

    public void setRange(int[] rc, String sheetName) {
        this.rwFirst = (short)rc[0];
        this.colFirst = (short)rc[1];
        this.rwLast = (short)rc[2];
        this.colLast = (short)rc[3];
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.rwFirst);
        data[0] = b[0];
        data[1] = b[1];
        b = ByteTools.shortToLEBytes(this.rwLast);
        data[2] = b[0];
        data[3] = b[1];
        data[4] = (byte)this.colFirst;
        data[5] = (byte)this.colLast;
        this.setSourceSheet(sheetName);
    }

    public void setSourceSheet(String sheetName) {
        this.cchFile = (short)((short)sheetName.length() + 1);
        this.fileName = sheetName;
        byte[] data = new byte[10];
        System.arraycopy(this.getData(), 0, data, 0, 6);
        byte[] b = ByteTools.shortToLEBytes(this.cchFile);
        data[6] = b[0];
        data[7] = b[1];
        data[8] = 0;
        data[9] = 2;
        try {
            data = ByteTools.append(sheetName.getBytes("ISO-8859-1"), data);
            data = ByteTools.append(new byte[1], data);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setData(data);
    }

    public static XLSRecord getPrototype() {
        DConRef dr = new DConRef();
        dr.setOpcode((short)81);
        dr.setData(new byte[8]);
        dr.init();
        return dr;
    }

    public CellRange getCellRange() {
        String range = String.valueOf(this.fileName) + "!" + ExcelTools.formatLocation(new int[]{this.rwFirst, this.colFirst, this.rwLast, this.colLast});
        try {
            return new CellRange(range, null);
        }
        catch (CellNotFoundException cellNotFoundException) {
            return null;
        }
    }

    public void setCellRange(CellRange cr) {
        try {
            int[] rc = cr.getRangeCoords();
            this.setRange(rc, cr.getSheet().getSheetName());
        }
        catch (CellNotFoundException cellNotFoundException) {
            // empty catch block
        }
    }

    public void setCellRange(String cr) {
        String sheetname = cr.indexOf("!") != -1 ? cr.split("!")[0] : this.fileName;
        int[] rc = ExcelTools.getRangeCoords(cr);
        this.setRange(rc, sheetname);
    }
}

