/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.CfRule;
import com.extentech.formats.OOXML.Dxf;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Cf;
import com.extentech.formats.XLS.DiscontiguousRefStruct;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;

public final class Condfmt
extends XLSRecord {
    private FormatHandle formatHandle = null;
    private static final long serialVersionUID = -7923448634000437926L;
    short grbit = 0;
    private int ccf;
    DiscontiguousRefStruct refs = null;
    private ArrayList cfRules = new ArrayList();
    private int cfxe = -1;
    boolean isdirty = false;
    private byte[] PROTOTYPE_BYTES = new byte[14];

    public void setDirty() {
        this.isdirty = true;
    }

    @Override
    public void init() {
        super.init();
        this.rw = 0;
        this.ccf = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.grbit = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
    }

    public void initializeReferences() {
        this.data = this.getData();
        short sqrefCount = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        byte[] sqrefdata = new byte[sqrefCount * 8];
        System.arraycopy(this.data, 14, sqrefdata, 0, sqrefdata.length);
        this.refs = new DiscontiguousRefStruct(sqrefdata, (XLSRecord)this);
    }

    public FormatHandle getFormatHandle() {
        return this.formatHandle;
    }

    public void setFormatHandle(FormatHandle formatHandle) {
        this.formatHandle = formatHandle;
    }

    public int getCfxe() {
        int[] rc = this.refs.getRowColBounds();
        this.cfxe = 50000 + this.getSheet().getSheetNum() * 10000 + ByteTools.readShort(rc[0], rc[1]);
        return this.cfxe;
    }

    public void setCfxe(int c) {
        this.cfxe = c;
    }

    public ArrayList getRules() {
        return this.cfRules;
    }

    public void addRule(Cf c) {
        if (this.cfRules.indexOf(c) == -1) {
            this.cfRules.add(c);
        }
        c.setCondfmt(this);
    }

    public String[] getAllRanges() {
        return this.refs.getRefs();
    }

    public int[] getEncompassingRange() {
        return this.refs.getRowColBounds();
    }

    private void updateRecord() {
        if (!this.isdirty) {
            return;
        }
        byte[] outdata = new byte[this.refs.getNumRefs() * 8 + 14];
        byte[] tmp = ByteTools.shortToLEBytes((short)this.getRules().size());
        int offset = 0;
        outdata[offset++] = tmp[0];
        outdata[offset++] = tmp[1];
        tmp = ByteTools.shortToLEBytes(this.grbit);
        outdata[offset++] = tmp[0];
        outdata[offset++] = tmp[1];
        int[] rowcols = this.refs.getRowColBounds();
        tmp = ByteTools.shortToLEBytes((short)rowcols[0]);
        outdata[offset++] = tmp[0];
        outdata[offset++] = tmp[1];
        tmp = ByteTools.shortToLEBytes((short)rowcols[2]);
        outdata[offset++] = tmp[0];
        outdata[offset++] = tmp[1];
        tmp = ByteTools.shortToLEBytes((short)rowcols[1]);
        outdata[offset++] = tmp[0];
        outdata[offset++] = tmp[1];
        tmp = ByteTools.shortToLEBytes((short)rowcols[3]);
        outdata[offset++] = tmp[0];
        outdata[offset++] = tmp[1];
        tmp = ByteTools.shortToLEBytes((short)this.refs.getNumRefs());
        outdata[offset++] = tmp[0];
        outdata[offset++] = tmp[1];
        byte[] sqrefbytes = this.refs.getRecordData();
        System.arraycopy(sqrefbytes, 0, outdata, offset, sqrefbytes.length);
        this.setData(outdata);
    }

    public void addLocation(String location) {
        this.refs.addRef(location);
        this.isdirty = true;
    }

    public String getBoundingRange() {
        int[] rowcols = this.refs.getRowColBounds();
        return ExcelTools.formatRangeRowCol(rowcols);
    }

    public void resetRange(String range) {
        this.refs = new DiscontiguousRefStruct(range, (XLSRecord)this);
        this.isdirty = true;
    }

    protected static XLSRecord getPrototype() {
        Condfmt cf = new Condfmt();
        cf.setOpcode((short)432);
        cf.setData(cf.PROTOTYPE_BYTES);
        cf.init();
        return cf;
    }

    @Override
    public void preStream() {
        this.updateRecord();
    }

    public static Condfmt parseOOXML(XmlPullParser xpp, WorkBookHandle wb, Boundsheet bs) {
        Condfmt condfmt = null;
        ArrayList dxfs = wb.getWorkBook().getDxfs();
        if (dxfs == null) {
            dxfs = new ArrayList();
        }
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("conditionalFormatting")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (n.equals("sqref")) {
                                condfmt = bs.createCondfmt("", wb);
                                condfmt.initializeReferences();
                                String[] ranges = StringTool.splitString(v, " ");
                                int z = 0;
                                while (z < ranges.length) {
                                    condfmt.addCellRange(String.valueOf(bs.getSheetName()) + "!" + ranges[z]);
                                    ++z;
                                }
                            } else {
                                n.equals("pivot");
                            }
                            ++i;
                        }
                    } else if (tnm.equals("cfRule")) {
                        int dxfId;
                        CfRule cfRule = (CfRule)CfRule.parseOOXML(xpp).cloneElement();
                        Cf cf = bs.createCf(condfmt);
                        cf.setOperator(Cf.translateOperator(cfRule.getOperator()));
                        cf.setType(Cf.translateOOXMLType(cfRule.getType()));
                        if (cf.getType() == 3) {
                            cf.setContainsText(cfRule.getContainsText());
                        }
                        if (cfRule.getFormula1() != null) {
                            cf.setCondition1(cfRule.getFormula1());
                        }
                        if (cfRule.getFormula2() != null) {
                            cf.setCondition2(cfRule.getFormula2());
                        }
                        if ((dxfId = cfRule.getDxfId()) > -1) {
                            Dxf dxf = (Dxf)dxfs.get(dxfId);
                            Cf.setStylePropsFromDxf(dxf, cf);
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("conditionalFormatting")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("Condfmt.parseOOXML: " + e.toString());
        }
        if (condfmt != null) {
            bs.addConditionalFormat(condfmt);
        }
        return condfmt;
    }

    private void addCellRange(String range) {
        this.refs.addRef(range);
        this.isdirty = true;
        this.updateRecord();
    }

    public String getXML() {
        return this.getXML(false);
    }

    public String getXMLSS() {
        return this.getXML(true);
    }

    public String getXML(boolean useXMLSSNameSpace) {
        String ns = "";
        if (useXMLSSNameSpace) {
            ns = "xmlns=\"urn:schemas-microsoft-com:office:excel\"";
        }
        StringBuffer xml = new StringBuffer("<ConditionalFormatting" + ns + ">");
        for (Cf c : this.getRules()) {
            xml.append(c.getXML());
        }
        xml.append("</ConditionalFormatting>");
        return xml.toString();
    }

    public String getOOXML(WorkBookHandle bk, int[] priority) {
        int i;
        this.updateRecord();
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<conditionalFormatting");
        if (this.refs != null) {
            ooxml.append(" sqref=\"");
            String[] refStrs = this.refs.getRefs();
            i = 0;
            while (i < refStrs.length) {
                if (i > 0) {
                    ooxml.append(" ");
                }
                ooxml.append(refStrs[i]);
                ++i;
            }
            ooxml.append("\"");
        }
        ooxml.append(">");
        ArrayList dxfs = this.getWorkBook().getDxfs();
        if (dxfs == null) {
            dxfs = new ArrayList();
            this.getWorkBook().setDxfs(dxfs);
        }
        if (this.cfRules != null) {
            i = 0;
            while (i < this.cfRules.size()) {
                int n = priority[0];
                priority[0] = n + 1;
                ooxml.append(((Cf)this.cfRules.get(i)).getOOXML(bk, n, dxfs));
                ++i;
            }
        }
        ooxml.append("</conditionalFormatting>");
        return ooxml.toString();
    }

    public boolean contains(int[] rowColFromString) {
        return this.refs.containsReference(rowColFromString);
    }

    @Override
    public void close() {
        super.close();
        this.refs = null;
        if (this.cfRules != null) {
            int i = 0;
            while (i < this.cfRules.size()) {
                Cf cf = (Cf)this.cfRules.get(i);
                cf.close();
                Object var2_2 = null;
                ++i;
            }
        }
    }
}

