/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class Theme
implements OOXMLElement {
    private static final long serialVersionUID = -9201334460078323287L;
    public String[] genericThemeClrs = new String[]{"FFFFFF", "000000", "EEECE1", "1F497D", "4F81BD", "C0504D", "9BBB59", "8064A2", "4BACC6", "F79646", "0000FF", "800080"};

    public static Theme parseThemeOOXML(WorkBookHandle bk, InputStream ii) {
        Theme t = new Theme();
        t.parseOOXML(bk, ii);
        return t;
    }

    public void parseOOXML(WorkBookHandle bk, InputStream ii) {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    int idx = 0;
                    String tnm = xpp.getName();
                    if (tnm.equals("clrScheme")) {
                        eventType = xpp.next();
                        while (eventType != 1) {
                            if (eventType == 2) {
                                tnm = xpp.getName();
                                if (tnm.equals("dk1")) {
                                    idx = 1;
                                } else if (tnm.equals("lt1")) {
                                    idx = 0;
                                } else if (tnm.equals("dk2")) {
                                    idx = 3;
                                } else if (tnm.equals("lt2")) {
                                    idx = 2;
                                } else if (tnm.equals("accent1")) {
                                    idx = 4;
                                } else if (tnm.equals("accent2")) {
                                    idx = 5;
                                } else if (tnm.equals("accent3")) {
                                    idx = 6;
                                } else if (tnm.equals("accent4")) {
                                    idx = 7;
                                } else if (tnm.equals("accent5")) {
                                    idx = 8;
                                } else if (tnm.equals("accent6")) {
                                    idx = 9;
                                } else if (tnm.equals("hlink")) {
                                    idx = 10;
                                } else if (tnm.equals("folHlink")) {
                                    idx = 11;
                                } else if (tnm.equals("sysClr")) {
                                    this.genericThemeClrs[idx] = xpp.getAttributeValue("", "lastClr");
                                } else if (tnm.equals("srgbClr")) {
                                    this.genericThemeClrs[idx] = xpp.getAttributeValue(0);
                                }
                            } else if (eventType == 3 && xpp.getName().equals("clrScheme")) break;
                            eventType = xpp.next();
                        }
                    } else if (!(tnm.equals("fmtScheme") || tnm.equals("fontScheme") || tnm.equals("objectDefaults"))) {
                        tnm.equals("extraClrSchemeList");
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("Theme.parseOOXML: " + e.toString());
        }
    }

    @Override
    public OOXMLElement cloneElement() {
        return null;
    }

    @Override
    public String getOOXML() {
        return null;
    }
}

