/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.PivotTableHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.SxStreamID;
import com.extentech.formats.XLS.Sxvd;
import com.extentech.formats.XLS.Sxview;
import com.extentech.toolkit.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PivotTableDefinition
implements OOXMLElement {
    private static final long serialVersionUID = -5070227633357072878L;
    Sxview ptview = null;

    public static PivotTableHandle parseOOXML(WorkBookHandle bk, Boundsheet sheet, InputStream ii) {
        Sxview ptview = null;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("pivotTableDefinition")) {
                        String cacheId = "";
                        String tablename = "";
                        int z = 0;
                        while (z < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(z);
                            String v = xpp.getAttributeValue(z);
                            if (nm.equals("name")) {
                                tablename = v;
                            } else if (nm.equals("cacheId")) {
                                cacheId = v;
                            }
                            ++z;
                        }
                        cacheId = "0";
                        short cid = Integer.valueOf(cacheId).shortValue();
                        SxStreamID ptstream = bk.getWorkBook().getPivotStream(cid + 1);
                        ptview = sheet.addPivotTable(ptstream.getCellRange().toString(), bk, cid + 1, tablename);
                        ptview.setDataName("Values");
                        ptview.setICache(cid);
                    } else if (tnm.equals("location")) {
                        PivotTableDefinition.parseLocationOOXML(xpp, ptview, bk);
                    } else if (tnm.equals("pivotFields")) {
                        PivotTableDefinition.parsePivotFields(xpp, ptview);
                    } else if (!tnm.equals("pageFields")) {
                        if (tnm.equals("pageField")) {
                            PivotTableDefinition.parsePageFieldOOXML(xpp, ptview);
                        } else if (!tnm.equals("dataFields")) {
                            if (tnm.equals("dataField")) {
                                PivotTableDefinition.parseDataFieldOOXML(xpp, ptview);
                            } else if (tnm.equals("colFields") || tnm.equals("rowFields")) {
                                PivotTableDefinition.parseFieldOOXML(xpp, ptview);
                            } else if (tnm.equals("rowItems") || tnm.equals("colItems")) {
                                PivotTableDefinition.parseLineItemOOXML(xpp, ptview);
                            } else if (tnm.equals("formats")) {
                                PivotTableDefinition.parseFormatsOOXML(xpp, ptview);
                            } else if (tnm.equals("chartFormats")) {
                                PivotTableDefinition.parseFormatsOOXML(xpp, ptview);
                            } else if (tnm.equals("pivotTableStyleInfo")) {
                                // empty if block
                            }
                        }
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("PivotTableDefinition.parseOOXML: " + e.toString());
        }
        PivotTableHandle pth = new PivotTableHandle(ptview, bk);
        return pth;
    }

    private static void parseLocationOOXML(XmlPullParser xpp, Sxview ptview, WorkBookHandle bk) throws XmlPullParserException {
        try {
            int i = 0;
            while (i < xpp.getAttributeCount()) {
                String nm = xpp.getAttributeName(i);
                String v = xpp.getAttributeValue(i);
                if (nm.equalsIgnoreCase("ref")) {
                    ptview.setLocation(v);
                } else if (nm.equalsIgnoreCase("firstDataCol")) {
                    ptview.setColFirstData(Integer.valueOf(v).shortValue());
                } else if (nm.equalsIgnoreCase("firstDataRow")) {
                    ptview.setRwFirstData(Integer.valueOf(v).shortValue());
                } else if (nm.equalsIgnoreCase("firstHeaderRow")) {
                    ptview.setRwFirstHead(Integer.valueOf(v).shortValue());
                } else if (nm.equalsIgnoreCase("rowPageCount") || nm.equalsIgnoreCase("colPageCount")) {
                    // empty if block
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("PivotTableHandle.parseLocation:");
        }
    }

    private static void parsePivotFields(XmlPullParser xpp, Sxview ptview) throws XmlPullParserException {
        try {
            int eventType = xpp.getEventType();
            String elname = xpp.getName();
            int fcount = 0;
            Sxvd curAxis = null;
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("pivotField")) {
                        curAxis = null;
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (nm.equalsIgnoreCase("axis")) {
                                curAxis = ptview.addPivotFieldToAxis(PivotTableDefinition.axisLookup(v), fcount++);
                            } else if (!(nm.equalsIgnoreCase("showAll") || nm.equalsIgnoreCase("defaultSubtotal") || nm.equalsIgnoreCase("numFmtId"))) {
                                if (nm.equalsIgnoreCase("dataField")) {
                                    if (v.equals("1") && curAxis == null) {
                                        curAxis = ptview.addPivotFieldToAxis(PivotTableDefinition.axisLookup("axisValues"), fcount++);
                                    }
                                } else if (nm.equalsIgnoreCase("multipleItemSelectionAllowed") || nm.equalsIgnoreCase("sortType")) {
                                    // empty if block
                                }
                            }
                            ++i;
                        }
                    } else if (tnm.equals("items")) {
                        PivotTableDefinition.parsePivotItemOOXML(xpp, ptview, curAxis);
                    } else if (tnm.equals("pivotArea")) {
                        PivotTableDefinition.parsePivotAreaOOXML(xpp);
                    }
                } else if (eventType == 3 && xpp.getName().equals(elname)) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("parsePivotFields:" + e.toString());
        }
    }

    private static void parsePivotItemOOXML(XmlPullParser xpp, Sxview ptview, Sxvd axis) throws XmlPullParserException {
        try {
            int eventType = xpp.getEventType();
            String elname = xpp.getName();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("item")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (!(nm.equals("c") || nm.equals("d") || nm.equals("e") || nm.equals("f") || nm.equals("h") || nm.equals("m") || nm.equals("n") || nm.equals("s") || nm.equals("sd"))) {
                                if (nm.equals("t")) {
                                    if (v.equals("default")) {
                                        ptview.addPivotItem(axis, 1, -1);
                                    } else {
                                        Logger.logWarn("PivitItem: Unknown type");
                                    }
                                } else if (nm.equals("x")) {
                                    ptview.addPivotItem(axis, 0, Integer.valueOf(v));
                                }
                            }
                            ++i;
                        }
                    }
                } else if (eventType == 3 && xpp.getName().equals(elname)) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("parsePivotItemOOXML:" + e.toString());
        }
    }

    private static void parseFormatsOOXML(XmlPullParser xpp, Sxview ptview) throws XmlPullParserException {
        try {
            int eventType = xpp.getEventType();
            String elname = xpp.getName();
            while (eventType != 1) {
                if (eventType == 2) {
                    String nm;
                    int i;
                    String tnm = xpp.getName();
                    if (tnm.equals("format")) {
                        i = 0;
                        while (i < xpp.getAttributeCount()) {
                            nm = xpp.getAttributeName(i);
                            if (!nm.equals("dxfId")) {
                                nm.equals("action");
                            }
                            ++i;
                        }
                    } else if (tnm.equals("chartFormat")) {
                        i = 0;
                        while (i < xpp.getAttributeCount()) {
                            nm = xpp.getAttributeName(i);
                            if (!nm.equals("chart") && !nm.equals("format")) {
                                nm.equals("series");
                            }
                            ++i;
                        }
                    } else if (tnm.equals("pivotArea")) {
                        PivotTableDefinition.parsePivotAreaOOXML(xpp);
                    }
                } else if (eventType == 3 && xpp.getName().equals(elname)) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("parsePivotAreaOOXML:" + e.toString());
        }
    }

    private static void parsePivotAreaOOXML(XmlPullParser xpp) throws XmlPullParserException {
        try {
            int eventType = xpp.getEventType();
            String elname = xpp.getName();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("pivotArea")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            if (nm.equals("field") || nm.equals("type") || nm.equals("dataOnly") || nm.equals("labelOnly") || nm.equals("outline") || nm.equals("axis") || nm.equals("fieldPosition")) {
                                // empty if block
                            }
                            ++i;
                        }
                    } else if (!tnm.equals("references") && !tnm.equals("reference")) {
                        tnm.equals("x");
                    }
                } else if (eventType == 3 && xpp.getName().equals(elname)) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("parsePivotAreaOOXML:");
        }
    }

    private static void parseLineItemOOXML(XmlPullParser xpp, Sxview ptview) throws XmlPullParserException {
        try {
            int eventType = xpp.getEventType();
            String elname = xpp.getName();
            boolean isRowItems = elname.equals("rowItems");
            Class<ITEMTYPES> enumType = ITEMTYPES.class;
            int type = 0;
            int repeat = 0;
            short[] indexes = null;
            int nIndexes = isRowItems ? ptview.getCDimRw() : ptview.getCDimCol();
            int index = 0;
            int nLines = 0;
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("i")) {
                        indexes = new short[nIndexes];
                        nLines = nIndexes;
                        index = 0;
                        repeat = 0;
                        type = 0;
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (!nm.equals("i")) {
                                if (nm.equals("r")) {
                                    repeat = Integer.valueOf(v);
                                    index += repeat;
                                    nLines -= repeat;
                                } else if (nm.equals("t") && ((type = Enum.valueOf(enumType, "_" + v).ordinal()) != 0 || type != 14)) {
                                    --nLines;
                                }
                            }
                            ++i;
                        }
                    } else if (tnm.equals("x")) {
                        indexes[index++] = (short)PivotTableDefinition.parseItemIndexOOXML(xpp);
                    }
                } else if (eventType == 3) {
                    String endname = xpp.getName();
                    if (endname.equals(elname)) break;
                    if (endname.equals("i")) {
                        if (isRowItems) {
                            ptview.addPivotLineToROWAxis(repeat, nLines, type, indexes);
                        } else {
                            ptview.addPivotLineToCOLAxis(repeat, nLines, type, indexes);
                        }
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("parseItemOOXML:" + e.toString());
        }
    }

    private static void parseFieldOOXML(XmlPullParser xpp, Sxview ptview) throws XmlPullParserException {
        try {
            int eventType = xpp.getEventType();
            String elname = xpp.getName();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("field")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            if (nm.equals("x")) {
                                String v = xpp.getAttributeValue(i);
                                if (elname.equals("rowFields")) {
                                    ptview.addRowField(Integer.valueOf(v));
                                } else {
                                    ptview.addColField(Integer.valueOf(v));
                                }
                            }
                            ++i;
                        }
                    }
                } else if (eventType == 3 && xpp.getName().equals(elname)) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("parseFieldOOXML:" + e.toString());
        }
    }

    private static int parseItemIndexOOXML(XmlPullParser xpp) {
        int v = 0;
        try {
            if (xpp.getAttributeCount() > 0) {
                v = Integer.valueOf(xpp.getAttributeValue(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    private static void parseDataFieldOOXML(XmlPullParser xpp, Sxview ptview) {
        int fieldIndex = 0;
        String aggregateFunction = null;
        String name = null;
        int z = 0;
        while (z < xpp.getAttributeCount()) {
            String nm = xpp.getAttributeName(z);
            String v = xpp.getAttributeValue(z);
            if (nm.equals("name")) {
                name = v;
            } else if (nm.equals("fld")) {
                fieldIndex = Integer.valueOf(xpp.getAttributeValue(z));
            } else if (nm.equals("subtotal")) {
                aggregateFunction = v;
            }
            ++z;
        }
        ptview.addDataField(fieldIndex, aggregateFunction, name);
    }

    private static void parsePageFieldOOXML(XmlPullParser xpp, Sxview ptview) {
        int fieldIndex = 0;
        int itemIndex = 32765;
        int i = 0;
        while (i < xpp.getAttributeCount()) {
            String nm = xpp.getAttributeName(i);
            if (nm.equals("fld")) {
                fieldIndex = Integer.valueOf(xpp.getAttributeValue(i));
            } else if (nm.equals("item")) {
                itemIndex = Integer.valueOf(xpp.getAttributeValue(i));
            }
            ++i;
        }
        ptview.addPageField(fieldIndex, itemIndex);
    }

    @Override
    public OOXMLElement cloneElement() {
        return null;
    }

    @Override
    public String getOOXML() {
        return null;
    }

    private static int axisLookup(String axis) {
        if (axis.equals("axisRow")) {
            return 1;
        }
        if (axis.equals("axisCol")) {
            return 2;
        }
        if (axis.equals("axisPage")) {
            return 4;
        }
        if (axis.equals("axisValues")) {
            return 8;
        }
        return 0;
    }

    static enum ITEMTYPES {
        _data,
        _default,
        _sum,
        _countA,
        _count,
        _avg,
        _max,
        _min,
        _product,
        _stdDev,
        _stdDevP,
        _var,
        _varP,
        _grand,
        _blank;

    }
}

