/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.BgColor;
import com.extentech.formats.OOXML.FgColor;
import com.extentech.formats.OOXML.Fill;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Theme;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

class PatternFill
implements OOXMLElement {
    private static final long serialVersionUID = -4399355217499895956L;
    private String patternType = null;
    private FgColor fgColor = null;
    private BgColor bgColor = null;
    private Theme theme = null;

    public PatternFill(String patternType, FgColor fg, BgColor bg, Theme t) {
        this.patternType = patternType;
        this.fgColor = fg;
        this.bgColor = bg;
        this.theme = t;
    }

    public PatternFill(PatternFill p) {
        this.patternType = p.patternType;
        if (p.fgColor != null) {
            this.fgColor = (FgColor)p.fgColor.cloneElement();
        }
        if (p.bgColor != null) {
            this.bgColor = (BgColor)p.bgColor.cloneElement();
        }
        this.theme = p.theme;
    }

    public PatternFill(String patternType, int fg, int bg) {
        HashMap<String, String> attrs;
        this.patternType = patternType;
        if (fg > -1 && fg != 64) {
            attrs = new HashMap<String, String>();
            attrs.put("rgb", "FF" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[fg]).substring(1));
            this.fgColor = new FgColor(attrs);
        }
        if (bg > -1 && bg != 65) {
            attrs = new HashMap();
            attrs.put("rgb", "FF" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[bg]).substring(1));
            this.bgColor = new BgColor(attrs);
        }
    }

    public PatternFill(String patternType, int fg, String fgCustom, int bg, String bgCustom) {
        HashMap<String, String> attrs;
        this.patternType = patternType;
        if (fg > 0 || fgCustom != null) {
            attrs = new HashMap<String, String>();
            if (fgCustom == null) {
                attrs.put("indexed", String.valueOf(fg));
            } else {
                attrs.put("rgb", Fill.transformToOOXMLRGBColor(fgCustom));
            }
            this.fgColor = new FgColor(attrs);
        }
        if (bg > -1 || bgCustom != null) {
            attrs = new HashMap();
            if (bgCustom == null) {
                attrs.put("indexed", String.valueOf(bg));
            } else {
                attrs.put("rgb", Fill.transformToOOXMLRGBColor(bgCustom));
            }
            this.bgColor = new BgColor(attrs);
        }
    }

    public static PatternFill parseOOXML(XmlPullParser xpp, boolean isDxf, WorkBookHandle bk) {
        String patternType = null;
        FgColor fg = null;
        BgColor bg = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("patternFill")) {
                        if (xpp.getAttributeCount() > 0) {
                            patternType = xpp.getAttributeValue(0);
                        }
                    } else if (tnm.equals("fgColor")) {
                        fg = FgColor.parseOOXML(xpp);
                    } else if (tnm.equals("bgColor")) {
                        bg = BgColor.parseOOXML(xpp);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("patternFill")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("patternFill.parseOOXML: " + e.toString());
        }
        if (isDxf) {
            if (patternType == null) {
                patternType = "solid";
            }
            if (patternType.equals("solid")) {
                if (bg != null) {
                    fg = new FgColor(bg.getAttrs());
                }
                bg = new BgColor(64);
            }
        }
        PatternFill p = new PatternFill(patternType, fg, bg, bk.getWorkBook().getTheme());
        return p;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<patternFill");
        ooxml.append(" patternType=\"" + this.patternType + "\">");
        if (this.fgColor != null) {
            ooxml.append(this.fgColor.getOOXML());
        }
        if (this.bgColor != null) {
            ooxml.append(this.bgColor.getOOXML());
        }
        ooxml.append("</patternFill>");
        return ooxml.toString();
    }

    public String getOOXML(boolean isDxf) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<patternFill");
        if (!isDxf) {
            ooxml.append(" patternType=\"" + this.patternType + "\">");
            if (this.fgColor != null) {
                ooxml.append(this.fgColor.getOOXML());
            }
            if (this.bgColor != null) {
                ooxml.append(this.bgColor.getOOXML());
            }
        } else if (this.patternType.equals("solid")) {
            ooxml.append(">");
            if (this.fgColor != null) {
                BgColor tempbg = new BgColor(this.fgColor.getAttrs());
                ooxml.append(tempbg.getOOXML());
            }
        } else {
            ooxml.append(" patternType=\"" + this.patternType + "\">");
            if (this.fgColor != null) {
                ooxml.append(this.fgColor.getOOXML());
            }
            if (this.bgColor != null) {
                ooxml.append(this.bgColor.getOOXML());
            }
        }
        ooxml.append("</patternFill>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new PatternFill(this);
    }

    public String toString() {
        return String.valueOf(this.patternType != null ? this.patternType : "<none>") + " fg:" + (this.fgColor != null ? this.fgColor.toString() : "<none>") + " bg:" + (this.bgColor != null ? this.bgColor.toString() : "<none>");
    }

    public String getFillPattern() {
        return this.patternType;
    }

    public int getFillPatternInt() {
        if (this.patternType == null) {
            return OOXMLConstants.patternFill.length + 1;
        }
        int i = 0;
        while (i < OOXMLConstants.patternFill.length) {
            if (OOXMLConstants.patternFill[i].equals(this.patternType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setFillPattern(String s) {
        this.patternType = s;
    }

    public void setFillPattern(int t) {
        this.patternType = PatternFill.translateIndexedFillPattern(t);
    }

    public static String translateIndexedFillPattern(int pattern) {
        String newPattern = null;
        if (pattern == OOXMLConstants.patternFill.length + 1) {
            newPattern = null;
        } else if (pattern >= 0 && pattern < OOXMLConstants.patternFill.length) {
            newPattern = OOXMLConstants.patternFill[pattern];
        }
        return newPattern;
    }

    public String getFgColorAsRGB(Theme t) {
        if (this.fgColor != null) {
            return Fill.transformToWebRGBColor(this.fgColor.getColorAsRGB(t));
        }
        return null;
    }

    public int getFgColorAsInt(Theme t) {
        if (this.fgColor != null) {
            return this.fgColor.getColorAsInt(t);
        }
        if ("solid".equals(this.patternType)) {
            return 0;
        }
        return -1;
    }

    public void setFgColor(int t) {
        if (this.fgColor != null) {
            this.fgColor.setColor(t);
        }
    }

    public void setFgColor(int t, String colorString) {
        if (t > 0 || colorString != null) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (colorString == null) {
                attrs.put("indexed", String.valueOf(t));
            } else {
                attrs.put("rgb", colorString);
            }
            this.fgColor = new FgColor(attrs);
        }
    }

    public String getBgColorAsRGB(Theme t) {
        if (this.bgColor != null) {
            return Fill.transformToWebRGBColor(this.bgColor.getColorAsRGB(t));
        }
        return null;
    }

    public int getBgColorAsInt(Theme t) {
        if (this.bgColor != null) {
            return this.bgColor.getColorAsInt(t);
        }
        return -1;
    }

    public void setBgColor(int t) {
        if (this.bgColor != null) {
            this.bgColor.setColor(t);
        }
    }

    public void setBgColor(int t, String colorString) {
        if (t > 0 || colorString != null) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (colorString == null) {
                attrs.put("indexed", String.valueOf(t));
            } else {
                attrs.put("rgb", Fill.transformToOOXMLRGBColor(colorString));
            }
            this.bgColor = new BgColor(attrs);
        }
    }
}

