/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import org.xmlpull.v1.XmlPullParser;

class PageSetupPr
implements OOXMLElement {
    private static final long serialVersionUID = 3030511803286369045L;
    private boolean autoPageBreaks = true;
    private boolean fitToPage = false;

    public PageSetupPr(boolean autoPageBreaks, boolean fitToPage) {
        this.autoPageBreaks = autoPageBreaks;
        this.fitToPage = fitToPage;
    }

    public PageSetupPr(PageSetupPr pr) {
        this.autoPageBreaks = pr.autoPageBreaks;
        this.fitToPage = pr.fitToPage;
    }

    public static PageSetupPr parseOOXML(XmlPullParser xpp) {
        boolean autoPageBreaks = true;
        boolean fitToPage = false;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("pageSetUpPr")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            if (nm.equals("fitToPage")) {
                                fitToPage = xpp.getAttributeValue(i).equals("1");
                            } else if (nm.equals("autoPageBreaks")) {
                                autoPageBreaks = xpp.getAttributeValue(i).equals("1");
                            }
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("pageSetUpPr")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("PageSetupPr: " + e.toString());
        }
        PageSetupPr pr = new PageSetupPr(autoPageBreaks, fitToPage);
        return pr;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<pageSetUpPr");
        if (!this.autoPageBreaks) {
            ooxml.append(" autoPageBreaks=\"0\"");
        }
        if (this.fitToPage) {
            ooxml.append(" fitToPage=\"1\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new PageSetupPr(this);
    }
}

