/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Gs;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class GsLst
implements OOXMLElement {
    private static final long serialVersionUID = 6576320251327916221L;
    private ArrayList<Gs> gs;

    public GsLst(ArrayList<Gs> g) {
        this.gs = g;
    }

    public GsLst(GsLst gl) {
        this.gs = gl.gs;
    }

    public static GsLst parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        ArrayList<Gs> g = new ArrayList<Gs>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("gs")) {
                        lastTag.push(tnm);
                        g.add(Gs.parseOOXML(xpp, lastTag, bk));
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("gsLst")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("gsLst.parseOOXML: " + e.toString());
        }
        GsLst gl = new GsLst(g);
        return gl;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:gsLst");
        if (!this.gs.isEmpty()) {
            ooxml.append(">");
            int i = 0;
            while (i < this.gs.size()) {
                ooxml.append(this.gs.get(i).getOOXML());
                ++i;
            }
            ooxml.append("</a:gsLst>");
        } else {
            ooxml.append("/>");
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new GsLst(this);
    }
}

