/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.BlipFill;
import com.extentech.formats.OOXML.GradFill;
import com.extentech.formats.OOXML.GrpFill;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.PattFill;
import com.extentech.formats.OOXML.SolidFill;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class FillGroup
implements OOXMLElement {
    private static final long serialVersionUID = 8320871291479597945L;
    private BlipFill bf;
    private GradFill gpf;
    private GrpFill grpf;
    private PattFill pf;
    private SolidFill sf;

    public FillGroup(BlipFill bf, GradFill gpf, GrpFill grpf, PattFill pf, SolidFill sf) {
        this.bf = bf;
        this.gpf = gpf;
        this.grpf = grpf;
        this.pf = pf;
        this.sf = sf;
    }

    public FillGroup(FillGroup f) {
        this.bf = f.bf;
        this.gpf = f.gpf;
        this.grpf = f.grpf;
        this.pf = f.pf;
        this.sf = f.sf;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        BlipFill bf = null;
        GradFill gpf = null;
        GrpFill grpf = null;
        PattFill pf = null;
        SolidFill sf = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("solidFill")) {
                        lastTag.push(tnm);
                        sf = SolidFill.parseOOXML(xpp, lastTag, bk);
                        lastTag.pop();
                        break;
                    }
                    if (!tnm.equals("noFill")) {
                        if (tnm.equals("gradFill")) {
                            lastTag.push(tnm);
                            gpf = GradFill.parseOOXML(xpp, lastTag, bk);
                            lastTag.pop();
                            break;
                        }
                        if (tnm.equals("grpFill")) {
                            lastTag.push(tnm);
                            grpf = GrpFill.parseOOXML(xpp, lastTag);
                            lastTag.pop();
                            break;
                        }
                        if (tnm.equals("pattFill")) {
                            lastTag.push(tnm);
                            pf = PattFill.parseOOXML(xpp, lastTag, bk);
                            lastTag.pop();
                            break;
                        }
                        if (tnm.equals("blipFill")) {
                            lastTag.push(tnm);
                            bf = BlipFill.parseOOXML(xpp, lastTag);
                            lastTag.pop();
                            break;
                        }
                    }
                } else if (eventType == 3) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("FillGroup.parseOOXML: " + e.toString());
        }
        FillGroup f = new FillGroup(bf, gpf, grpf, pf, sf);
        return f;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.sf != null) {
            ooxml.append(this.sf.getOOXML());
        } else if (this.gpf != null) {
            ooxml.append(this.gpf.getOOXML());
        } else if (this.grpf != null) {
            ooxml.append(this.grpf.getOOXML());
        } else if (this.bf != null) {
            ooxml.append(this.bf.getOOXML());
        } else if (this.pf != null) {
            ooxml.append(this.pf.getOOXML());
        } else {
            ooxml.append("<a:noFill/>");
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new FillGroup(this);
    }

    public String getEmbed() {
        if (this.bf != null) {
            return this.bf.getEmbed();
        }
        return null;
    }

    public String getLink() {
        if (this.bf != null) {
            return this.bf.getLink();
        }
        return null;
    }

    public void setEmbed(String embed) {
        if (this.bf == null) {
            this.bf = new BlipFill();
        }
        this.bf.setEmbed(embed);
    }

    public void setLink(String link) {
        if (this.bf == null) {
            this.bf = new BlipFill();
        }
        this.bf.setLink(link);
    }

    public void setColor(String clr) {
        if (this.bf != null) {
            return;
        }
        this.gpf = null;
        this.grpf = null;
        this.pf = null;
        this.sf = new SolidFill();
        this.sf.setColor(clr);
    }

    public int getColor() {
        if (this.sf != null) {
            return this.sf.getColor();
        }
        return -1;
    }
}

