/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.Cxn;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class CxnLst
implements OOXMLElement {
    private static final long serialVersionUID = -562847539163221621L;
    private ArrayList<Cxn> cxns;

    public CxnLst(ArrayList<Cxn> cxns) {
        this.cxns = cxns;
    }

    public CxnLst(CxnLst c) {
        this.cxns = c.cxns;
    }

    public static CxnLst parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        ArrayList<Cxn> cxns = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("cxn")) {
                        lastTag.push(tnm);
                        if (cxns == null) {
                            cxns = new ArrayList<Cxn>();
                        }
                        cxns.add(Cxn.parseOOXML(xpp, lastTag));
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("cxnLst")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("cxnLst.parseOOXML: " + e.toString());
        }
        CxnLst c = new CxnLst(cxns);
        return c;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:cxnLst>");
        if (this.cxns != null) {
            int i = 0;
            while (i < this.cxns.size()) {
                ooxml.append(this.cxns.get(i).getOOXML());
                ++i;
            }
        }
        ooxml.append("</a:cxnLst>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new CxnLst(this);
    }
}

