/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class CNvPr
implements OOXMLElement {
    private static final long serialVersionUID = -3382139449400844949L;
    private String descr = null;
    private String name = null;
    private boolean hidden = false;
    private int id = -1;

    public CNvPr() {
    }

    public CNvPr(int id, String name, String descr, boolean hidden) {
        this.id = id;
        this.name = name;
        this.descr = descr;
        this.hidden = hidden;
    }

    public CNvPr(CNvPr cnv) {
        this.id = cnv.id;
        this.name = cnv.name;
        this.descr = cnv.descr;
        this.hidden = cnv.hidden;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        String descr = null;
        String name = null;
        boolean hidden = false;
        int id = -1;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block15: {
                    String endTag;
                    block13: {
                        String tnm;
                        block14: {
                            if (eventType != 2) break block13;
                            tnm = xpp.getName();
                            if (!tnm.equals("cNvPr")) break block14;
                            int i = 0;
                            while (i < xpp.getAttributeCount()) {
                                String nm = xpp.getAttributeName(i);
                                String val = xpp.getAttributeValue(i);
                                if (nm.equals("id")) {
                                    id = Integer.valueOf(val);
                                } else if (nm.equals("name")) {
                                    name = val;
                                } else if (nm.equals("descr")) {
                                    descr = val;
                                } else if (nm.equals("hidden")) {
                                    hidden = val.equals("1");
                                }
                                ++i;
                            }
                            break block15;
                        }
                        if (tnm.equals("hlinkClick")) break block15;
                        tnm.equals("hlinkHover");
                        break block15;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("cNvPr")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("cNvPr.parseOOXML: " + e.toString());
        }
        CNvPr cnv = new CNvPr(id, name, descr, hidden);
        return cnv;
    }

    @Override
    public String getOOXML() {
        StringBuffer tooxml = new StringBuffer();
        tooxml.append("<xdr:cNvPr id=\"" + this.id + "\" name=\"" + OOXMLAdapter.stripNonAscii(this.name) + "\"");
        if (this.descr != null) {
            tooxml.append(" descr=\"" + this.descr + "\"");
        }
        if (this.hidden) {
            tooxml.append(" hidden=\"" + (this.hidden ? "1" : "0") + "\"");
        }
        tooxml.append(">");
        tooxml.append("</xdr:cNvPr>");
        return tooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new CNvPr(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescr() {
        return this.descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }
}

