/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.Blip;
import com.extentech.formats.OOXML.FillMode;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.SrcRect;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class BlipFill
implements OOXMLElement {
    private static final long serialVersionUID = -2030570462677450734L;
    private HashMap<String, String> attrs = null;
    private Blip blip = null;
    private SrcRect srcRect;
    private FillMode fillMode;
    private String ns = "xdr";

    public BlipFill() {
        this.srcRect = new SrcRect();
        this.fillMode = new FillMode(null, false);
    }

    public BlipFill(String ns, HashMap<String, String> attrs, Blip b, SrcRect s, FillMode f) {
        this.ns = ns;
        this.attrs = attrs;
        this.blip = b;
        this.srcRect = s;
        this.fillMode = f;
    }

    public BlipFill(BlipFill bf) {
        this.ns = bf.ns;
        this.attrs = bf.attrs;
        this.blip = bf.blip;
        this.srcRect = bf.srcRect;
        this.fillMode = bf.fillMode;
    }

    public static BlipFill parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Blip b = null;
        SrcRect s = null;
        FillMode f = null;
        String ns = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block10: {
                            block9: {
                                block7: {
                                    if (eventType != 2) break block6;
                                    tnm = xpp.getName();
                                    if (!tnm.equals("blipFill")) break block7;
                                    ns = xpp.getPrefix();
                                    int i = 0;
                                    while (i < xpp.getAttributeCount()) {
                                        attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                        ++i;
                                    }
                                    break block8;
                                }
                                if (!tnm.equals("blip")) break block9;
                                lastTag.push(tnm);
                                b = Blip.parseOOXML(xpp, lastTag);
                                break block8;
                            }
                            if (!tnm.equals("srcRect")) break block10;
                            lastTag.push(tnm);
                            s = SrcRect.parseOOXML(xpp, lastTag);
                            break block8;
                        }
                        if (!tnm.equals("stretch") && !tnm.equals("tile")) break block8;
                        lastTag.push(tnm);
                        f = FillMode.parseOOXML(xpp, lastTag);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("blipFill")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("blipFill.parseOOXML: " + e.toString());
        }
        BlipFill bf = new BlipFill(ns, attrs, b, s, f);
        return bf;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.ns == null) {
            Logger.logErr("Error: BlipFill Namespace is null");
        }
        ooxml.append("<" + this.ns + ":blipFill");
        if (this.attrs != null) {
            for (String key : this.attrs.keySet()) {
                String val = this.attrs.get(key);
                ooxml.append(" " + key + "=\"" + val + "\"");
            }
        }
        ooxml.append(">");
        if (this.blip != null) {
            ooxml.append(this.blip.getOOXML());
        }
        if (this.srcRect != null) {
            ooxml.append(this.srcRect.getOOXML());
        }
        if (this.fillMode != null) {
            ooxml.append(this.fillMode.getOOXML());
        }
        ooxml.append("</" + this.ns + ":blipFill>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new BlipFill(this);
    }

    public String getEmbed() {
        if (this.blip != null) {
            return this.blip.getEmbed();
        }
        return null;
    }

    public String getLink() {
        if (this.blip != null) {
            return this.blip.getLink();
        }
        return null;
    }

    public void setEmbed(String embed) {
        if (this.blip == null) {
            this.blip = new Blip();
        }
        this.blip.setEmbed(embed);
    }

    public void setLink(String link) {
        if (this.blip == null) {
            this.blip = new Blip();
        }
        this.blip.setLink(link);
    }
}

