/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.LEO;

import com.extentech.formats.LEO.BIGBLOCK;
import com.extentech.formats.LEO.Block;
import com.extentech.formats.LEO.BlockByteReader;
import com.extentech.formats.LEO.BlockFactory;
import com.extentech.formats.LEO.BlockImpl;
import com.extentech.formats.LEO.FileBuffer;
import com.extentech.formats.LEO.InvalidFileException;
import com.extentech.formats.LEO.LEOHeader;
import com.extentech.formats.LEO.RootStorage;
import com.extentech.formats.LEO.Storage;
import com.extentech.formats.LEO.StorageNotFoundException;
import com.extentech.formats.LEO.StorageTable;
import com.extentech.formats.XLS.WorkBookException;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.JFileWriter;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.ResourceLoader;
import com.extentech.toolkit.TempFileManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LEOFile
implements Serializable {
    private static final long serialVersionUID = 2760792940329331096L;
    public static final int MAXDIFATLEN = 109;
    public static final int IDXBLOCKSIZE = 128;
    public static final boolean DEBUG = false;
    public int DEBUGLEVEL = 0;
    public static int actualOutput = 0;
    private List bigBlocks;
    private boolean readok = false;
    private LEOHeader header = null;
    private StorageTable directories;
    private FileBuffer fb = null;
    String fileName = "New Spreadsheet";
    byte[] encryptionStorageOverage = null;
    boolean encryptedXLSX = false;

    public LEOHeader getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        if (this.fb != null) {
            this.fb.close();
        }
        this.fb = null;
        this.header = null;
        if (this.directories != null) {
            this.directories.close();
            this.directories = null;
        }
        if (this.bigBlocks != null) {
            int i = 0;
            while (i < this.bigBlocks.size()) {
                BlockImpl b = (BlockImpl)this.bigBlocks.get(i);
                b.close();
                ++i;
            }
            this.bigBlocks.clear();
        }
        this.bigBlocks = null;
    }

    public void closefb() throws IOException {
        if (this.fb != null) {
            this.fb.close();
        }
        this.fb = null;
    }

    public void shutdown() {
        block2: {
            try {
                this.close();
            }
            catch (Exception e) {
                if (this.DEBUGLEVEL <= 0) break block2;
                Logger.logWarn("could not close workbook cleanly." + e);
            }
        }
    }

    public LEOFile(String fname) {
        if (fname.indexOf(".ser") > -1) {
            this.initFromPrototype(fname);
            return;
        }
        this.fileName = fname;
        this.fb = LEOFile.readFile(fname);
        this.initWrapper(this.fb.getBuffer());
    }

    private void initFromPrototype(String fname) {
        try {
            byte[] b = ResourceLoader.getBytesFromJar(fname);
            if (b == null) {
                throw new WorkBookException("Required Class files not on the CLASSPATH.  Check location of .jar file and/or jarloc System property.", 2);
            }
            ByteBuffer bbf = ByteBuffer.wrap(b);
            bbf.order(ByteOrder.LITTLE_ENDIAN);
            this.initWrapper(bbf);
        }
        catch (Exception e) {
            throw new InvalidFileException("WorkBook could not be instantiated: " + e.toString());
        }
    }

    public LEOFile(File fpath, boolean usetempfile, boolean encryptedXLSX) {
        this.encryptedXLSX = encryptedXLSX;
        this.fileName = fpath.getAbsolutePath();
        this.fb = LEOFile.readFile(fpath, usetempfile);
        this.initWrapper(this.fb.getBuffer());
    }

    public static boolean checkIsLEO(byte[] data, int count) {
        if (count < LEOHeader.majick.length) {
            return false;
        }
        int idx = 0;
        while (idx < LEOHeader.majick.length) {
            if (data[idx] != LEOHeader.majick[idx]) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public LEOFile(File fpath, boolean usetempfile) {
        this.fileName = fpath.getAbsolutePath();
        this.fb = LEOFile.readFile(fpath, usetempfile);
        this.initWrapper(this.fb.getBuffer());
    }

    public LEOFile(File fpath, int DEBUGLEVEL) {
        this.fileName = fpath.getAbsolutePath();
        this.DEBUGLEVEL = DEBUGLEVEL;
        this.fb = LEOFile.readFile(fpath);
        this.initWrapper(this.fb.getBuffer());
    }

    public LEOFile(ByteBuffer bytebuff) {
        this.initWrapper(bytebuff);
    }

    public void initWrapper(ByteBuffer bytebuff) {
        int[] FAT = this.init(bytebuff);
        if (FAT != null) {
            this.directories.initDirectories(this.bigBlocks, FAT);
            if (this.DEBUGLEVEL > 200) {
                this.directories.DEBUG();
            }
            FAT = null;
            this.readok = true;
        } else {
            this.readok = false;
        }
    }

    public void clearAfterInit() {
        this.bigBlocks.clear();
    }

    public void readEncryptedFile(File encryptedFile) {
        this.fb = LEOFile.readFile(encryptedFile);
        this.initWrapper(this.fb.getBuffer());
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean hasWorkBook() {
        try {
            Storage book = this.directories.getDirectoryByName("Workbook");
        }
        catch (StorageNotFoundException e) {
            try {
                Storage book = this.directories.getDirectoryByName("Book");
            }
            catch (StorageNotFoundException e1) {
                return false;
            }
        }
        return true;
    }

    public boolean hasDoc() {
        if (this.readok) {
            try {
                Storage storage = this.directories.getDirectoryByName("WordDocument");
            }
            catch (StorageNotFoundException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasPivotCache() {
        if (this.readok) {
            try {
                Storage storage = this.directories.getDirectoryByName("_SX_DB_CUR");
            }
            catch (StorageNotFoundException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public LEOFile() {
    }

    public LEOFile(InputStream stream) throws IOException {
        File target = TempFileManager.createTempFile("ExtenXLS_temp", ".leo");
        JFileWriter.writeToFile(stream, target);
        this.fileName = target.getAbsolutePath();
        this.fb = LEOFile.readFile(target);
        this.initWrapper(this.fb.getBuffer());
        target.deleteOnExit();
        target.delete();
    }

    static final int getNumFATSectors(int storageTotal) {
        int nFAT = storageTotal * 4;
        float realnum = (float)(storageTotal * 4) / 512.0f;
        if (realnum - (float)(nFAT /= 512) > 0.0f || nFAT > 109) {
            ++nFAT;
        }
        return nFAT;
    }

    public synchronized List writeBytes(OutputStream out, int workbook_byte_size) {
        Vector<Storage> storages = new Vector<Storage>();
        int numFATSectors = 0;
        int rootstart = 0;
        int numExtraDIFATSectors = 0;
        int extraDIFATStart = -2;
        int numMiniFATSectors = 0;
        int miniFATStart = -2;
        int sbidxpos = -2;
        int sbsz = 0;
        int numblocks = 1;
        Storage book = null;
        boolean isEncrypted = false;
        try {
            book = this.directories.getDirectoryByName("Workbook");
        }
        catch (StorageNotFoundException e3) {
            try {
                book = this.directories.getDirectoryByName("EncryptedPackage");
                isEncrypted = false;
            }
            catch (StorageNotFoundException e1) {
                throw new InvalidFileException("Input LEO file not valid for output");
            }
        }
        RootStorage rootStore = null;
        try {
            rootStore = this.directories.getRootStorage();
        }
        catch (StorageNotFoundException e2) {
            throw new InvalidFileException("Input LEO file not valid for output");
        }
        Enumeration e = this.directories.getAllDirectories().elements();
        while (e.hasMoreElements()) {
            Storage thisStore = (Storage)e.nextElement();
            if (thisStore == book || thisStore == rootStore) continue;
            ((AbstractList)storages).add(thisStore);
            if (thisStore.getBlockType() != 0) continue;
            thisStore.miniStreamStorage = true;
            numMiniFATSectors += thisStore.getBlockVect().size();
        }
        if (numMiniFATSectors > 0) {
            Storage[] sbs = this.buildMiniFAT(storages, numMiniFATSectors);
            ((AbstractList)storages).add(sbs[0]);
            numMiniFATSectors = sbs[1].getBlockVect().size();
            ((AbstractList)storages).add(sbs[1]);
        }
        numblocks = (int)((double)numblocks + Math.ceil(this.directories.directoryVector.size() / 4));
        int t = 0;
        while (t < ((AbstractCollection)storages).size()) {
            Storage nstr = (Storage)((AbstractList)storages).get(t);
            if (!nstr.miniStreamStorage) {
                numblocks += nstr.getSizeInBlocks();
            }
            ++t;
        }
        book.miniStreamStorage = false;
        int workbook_idx_block_size = LEOFile.getSizeInBlocks(workbook_byte_size, 512);
        workbook_idx_block_size = Math.max(workbook_idx_block_size, this.getMinBlocks() - 1);
        numblocks += workbook_idx_block_size + 1;
        if (isEncrypted) {
            --numblocks;
            --workbook_idx_block_size;
        }
        numFATSectors = LEOFile.getNumFATSectors(numblocks);
        numFATSectors = LEOFile.getNumFATSectors(numFATSectors + numblocks);
        int[] FAT = new int[128 * numFATSectors];
        int i = 0;
        while (i < FAT.length) {
            FAT[i] = -1;
            ++i;
        }
        int[] DIFAT = new int[Math.min(numFATSectors, 109)];
        int[] extraDIFAT = new int[Math.max(numFATSectors - 109, 0)];
        int blockpos = 0;
        book.setStartBlock(blockpos);
        int t2 = 0;
        while (t2 < workbook_idx_block_size) {
            FAT[blockpos++] = blockpos;
            ++t2;
        }
        FAT[blockpos++] = -2;
        if (!isEncrypted) {
            book.setActualFileSize((workbook_idx_block_size + 1) * 512);
        }
        t2 = 0;
        while (t2 < ((AbstractCollection)storages).size()) {
            Storage nstr = (Storage)((AbstractList)storages).get(t2);
            if (!nstr.miniStreamStorage) {
                if (nstr.getName().equals("miniStream")) {
                    miniFATStart = blockpos;
                    sbsz = nstr.getActualFileSize();
                } else if (nstr.getName().equals("miniFAT")) {
                    sbidxpos = blockpos;
                }
                nstr.setStartBlock(-2);
                Block[] blks = nstr.getBlocks();
                if (blks != null) {
                    nstr.setStartBlock(blockpos);
                    int i2 = 0;
                    while (i2 < blks.length - 1) {
                        FAT[blockpos++] = blockpos;
                        ++i2;
                    }
                    FAT[blockpos++] = -2;
                }
            }
            ++t2;
        }
        rootStore.setStartBlock(miniFATStart);
        rootStore.setActualFileSize(sbsz);
        rootStore.setBytes(this.directories.rebuildRootStore());
        rootstart = blockpos;
        int i3 = 0;
        while (i3 < rootStore.getBlockVect().size() - 1) {
            FAT[blockpos++] = blockpos;
            ++i3;
        }
        FAT[blockpos++] = -2;
        ((AbstractList)storages).add(rootStore);
        i3 = 0;
        while (i3 < DIFAT.length) {
            DIFAT[i3] = blockpos + 1;
            FAT[blockpos++] = -3;
            ++i3;
        }
        if (numFATSectors > 109) {
            int n = 109;
            while (n < numFATSectors) {
                extraDIFAT[n - 109] = blockpos + 1;
                FAT[blockpos++] = -3;
                ++n;
            }
            i3 = 0;
            while (i3 < (int)Math.ceil((double)(numFATSectors - 109) / 128.0)) {
                FAT[blockpos++] = -4;
                ++i3;
            }
        }
        Storage idxstore = new Storage();
        idxstore.setName("IDXStorage");
        Block[] FATSectors = LEOFile.getIDXBlocks(FAT);
        idxstore.setBlocks(FATSectors);
        ((AbstractList)storages).add(idxstore);
        if (numFATSectors > 109) {
            extraDIFATStart = blockpos - (int)Math.ceil((double)(numFATSectors - 109) / 128.0);
            Storage xbbstore = this.buildExtraDIFAT(extraDIFAT, extraDIFATStart);
            numExtraDIFATSectors = xbbstore.getBlockVect().size();
            ((AbstractList)storages).add(xbbstore);
        }
        this.header = LEOHeader.getPrototype(DIFAT);
        this.header.setMiniFATStart(sbidxpos);
        this.header.setRootStorageStart(rootstart);
        this.header.setNumFATSectors(numFATSectors);
        this.header.setNumMiniFATSectors(numMiniFATSectors);
        this.header.setNumExtraDIFATSectors(numExtraDIFATSectors);
        this.header.setExtraDIFATStart(extraDIFATStart);
        if (!this.header.init()) {
            throw new RuntimeException("LEO File Header Not Initialized");
        }
        return storages;
    }

    private Storage buildExtraDIFAT(int[] difatidx, int xbbpos) {
        if (difatidx != null) {
            ArrayList<BIGBLOCK> outblocks = new ArrayList<BIGBLOCK>();
            byte[] xbytes = new byte[difatidx.length * 4];
            int i = 0;
            while (i < difatidx.length) {
                byte[] idx = ByteTools.cLongToLEBytes(difatidx[i] - 1);
                System.arraycopy(idx, 0, xbytes, i * 4, 4);
                ++i;
            }
            int counter = 0;
            int i2 = 0;
            while (i2 < xbytes.length) {
                ByteBuffer bl = BlockFactory.getPrototypeBlock(1).getByteBuffer();
                int len = xbytes.length - i2;
                if (len > 508) {
                    len = 508;
                }
                bl.position(0);
                bl.put(xbytes, i2, len);
                ++counter;
                if (len == 508) {
                    bl.putInt(xbbpos + counter);
                }
                BIGBLOCK xbbBlock = new BIGBLOCK();
                xbbBlock.init(bl, 0, 0);
                outblocks.add(xbbBlock);
                i2 += 508;
            }
            Storage xbbstore = new Storage();
            xbbstore.setName("XBBStore");
            Block[] xblx = new Block[outblocks.size()];
            outblocks.toArray(xblx);
            xbbstore.setBlocks(xblx);
            return xbbstore;
        }
        return null;
    }

    private Storage[] buildMiniFAT(List storages, int numsbs) {
        int[] sbidx = new int[(int)Math.ceil((double)numsbs / 128.0) * 128];
        byte[] smallblocks = new byte[]{};
        int i = 0;
        while (i < sbidx.length) {
            sbidx[i] = -1;
            ++i;
        }
        int z = 0;
        int i2 = 0;
        while (i2 < storages.size()) {
            Storage thisStore = (Storage)storages.get(i2);
            if (thisStore.getBlockType() == 0) {
                thisStore.setStartBlock(z);
                int j = 0;
                while (j < thisStore.getBlockVect().size() - 1) {
                    sbidx[z++] = z;
                    ++j;
                }
                sbidx[z++] = -2;
                smallblocks = ByteTools.append(thisStore.getBytes(), smallblocks);
            }
            ++i2;
        }
        Block[] smallBlocksToBig = BlockFactory.getBlocksFromByteArray(smallblocks, 1);
        Storage miniFATContainer = new Storage();
        miniFATContainer.setName("miniStream");
        miniFATContainer.setBlocks(smallBlocksToBig);
        miniFATContainer.setActualFileSize(smallblocks.length);
        smallblocks = null;
        Storage miniFAT = new Storage();
        miniFAT.setName("miniFAT");
        Block[] sbIDX = LEOFile.getIDXBlocks(sbidx);
        miniFAT.setBlocks(sbIDX);
        return new Storage[]{miniFATContainer, miniFAT};
    }

    static final void initSmallBlockIndex(int[] newidx, Block b) {
        while (b.hasNext() && b != (Block)b.next()) {
            int origps = b.getBlockIndex();
            if (origps < 0) {
                Logger.logWarn("WARNING: LEOFile Block Not In MINIFAT vector: " + String.valueOf(b.getOriginalIdx()));
            } else {
                int newp;
                newidx[origps] = newp = ((Block)b.next()).getBlockIndex();
            }
            b = (Block)b.next();
        }
        if (b.getBlockIndex() >= 0) {
            newidx[b.getBlockIndex()] = -2;
        }
    }

    static final int[] getEmptyDIFAT(int totblocks, int numFATSectors) {
        int[] bbdi = new int[numFATSectors + totblocks + 1];
        int x = 0;
        while (x < bbdi.length) {
            bbdi[x] = -1;
            ++x;
        }
        return bbdi;
    }

    static final Block[] getIDXBlocks(int[] bbdidx) {
        byte[] b = new byte[bbdidx.length * 4];
        int bv = 0;
        int t = 0;
        while (t < b.length) {
            byte[] bs = ByteTools.cLongToLEBytes(bbdidx[bv++]);
            b[t++] = bs[0];
            b[t++] = bs[1];
            b[t++] = bs[2];
            b[t++] = bs[3];
        }
        return BlockFactory.getBlocksFromByteArray(b, 1);
    }

    public Storage getStorageByName(String s) throws StorageNotFoundException {
        return this.directories.getDirectoryByName(s);
    }

    public Storage[] getAllDirectories() {
        CompatibleVector v = this.directories.getAllDirectories();
        Object[] s = new Storage[v.size()];
        s = (Storage[])v.toArray(s);
        return s;
    }

    public StorageTable getDirectoryArray() {
        return this.directories;
    }

    public BlockByteReader getDocBlockBytes() {
        Storage doc;
        try {
            doc = this.directories.getDirectoryByName("WordDocument");
        }
        catch (StorageNotFoundException e) {
            throw new InvalidFileException("InvalidFileException: Not Word '97 or later version.  Unsupported file format.");
        }
        return doc.getBlockReader();
    }

    public BlockByteReader getXLSBlockBytes() {
        Storage book;
        try {
            book = this.directories.getDirectoryByName("Workbook");
        }
        catch (StorageNotFoundException e) {
            try {
                book = this.directories.getDirectoryByName("Book");
            }
            catch (StorageNotFoundException e1) {
                Logger.logInfo("Not Excel '97 (BIFF8) or later version.  Unsupported file format.");
                throw new InvalidFileException("InvalidFileException: Not Excel '97 (BIFF8) or later version.  Unsupported file format.");
            }
        }
        return book.getBlockReader();
    }

    public synchronized int[] init(ByteBuffer bbuf) {
        int pos = 0;
        CompatibleVector FATSectors = new CompatibleVector();
        this.bigBlocks = new ArrayList();
        int len = bbuf.limit() / 512;
        int i = 0;
        while (i < len) {
            BIGBLOCK bbd = new BIGBLOCK();
            bbd.init(bbuf, i, pos);
            pos += 512;
            this.bigBlocks.add(bbd);
            ++i;
        }
        int encryptionStorageOverageLen = bbuf.limit() % 512;
        if (encryptionStorageOverageLen > 0) {
            int filepos = len * 512;
            if (this.encryptedXLSX) {
                bbuf.position(filepos);
                this.encryptionStorageOverage = new byte[encryptionStorageOverageLen];
                bbuf.get(this.encryptionStorageOverage, 0, this.encryptionStorageOverage.length);
            } else {
                BIGBLOCK bbd = new BIGBLOCK();
                bbd.init(bbuf, len, pos);
                pos += encryptionStorageOverageLen;
                this.bigBlocks.add(bbd);
            }
        }
        this.header = new LEOHeader();
        if (!this.header.init(bbuf)) {
            throw new InvalidFileException(String.valueOf(this.getFileName()) + " is not a valid OLE File.");
        }
        BIGBLOCK headerblock = (BIGBLOCK)this.bigBlocks.get(0);
        headerblock.setInitialized(true);
        FATSectors = this.getFATSectors();
        byte[] blx = LEOFile.getBytes(FATSectors);
        int[] FAT = null;
        FAT = LEOFile.readFAT(blx);
        blx = null;
        this.directories = new StorageTable();
        this.directories.init(bbuf, this.header, this.bigBlocks, FAT);
        return FAT;
    }

    public static final FileBuffer readFile(File fpath) {
        boolean usetempfile = false;
        String tmpfu = (String)System.getProperties().get("com.extentech.formats.LEO.usetempfile");
        if (tmpfu != null) {
            usetempfile = tmpfu.equalsIgnoreCase("true");
        }
        return LEOFile.readFile(fpath, usetempfile);
    }

    public static final FileBuffer readFile(File fpath, boolean usetempfile) {
        if (usetempfile) {
            return FileBuffer.readFileUsingTemp(fpath);
        }
        return FileBuffer.readFile(fpath);
    }

    public static final FileBuffer readFile(String fpath) {
        return LEOFile.readFile(new File(fpath));
    }

    public static final int[] readFAT(List vect) {
        byte[] data = LEOFile.getBytes(vect);
        return LEOFile.readFAT(data);
    }

    private static final int[] readFAT(byte[] data) {
        int[] bbs = new int[data.length / 4];
        int pos = 0;
        int i = 0;
        while (i < data.length) {
            bbs[pos++] = ByteTools.readInt(data[i++], data[i++], data[i++], data[i++]);
        }
        data = null;
        return bbs;
    }

    public static final byte[] getBytes(Block[] outblocks) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LEOFile.getBytes(outblocks, (OutputStream)out);
        return out.toByteArray();
    }

    public static final OutputStream getByteStream(Block[] outblocks) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LEOFile.getBytes(outblocks, (OutputStream)out);
        return out;
    }

    public static final void getBytes(Block[] outblocks, OutputStream out) {
        ArrayList<Block> blxt = new ArrayList<Block>();
        int tx = 0;
        while (tx < outblocks.length) {
            blxt.add(outblocks[tx]);
            ++tx;
        }
        LEOFile.getBytes(blxt, out);
    }

    public static final void getBytes(List outblocks, OutputStream out) {
        Iterator it = outblocks.iterator();
        int i = 0;
        while (it.hasNext()) {
            Block boc = (Block)it.next();
            try {
                if (boc == null) continue;
                out.write(boc.getBytes());
                ++i;
            }
            catch (IOException a) {
                Logger.logWarn("ERROR: gettting bytes from blocks failed: " + a);
            }
        }
    }

    public static final byte[] getBytes(List bbvect) {
        if (bbvect == null) {
            return new byte[0];
        }
        Block[] b = new Block[bbvect.size()];
        b = bbvect.toArray(b);
        return LEOFile.getBytes(b);
    }

    public static final OutputStream getByteStream(List bbvect) {
        if (bbvect == null) {
            return new ByteArrayOutputStream();
        }
        Block[] b = new Block[bbvect.size()];
        b = bbvect.toArray(b);
        return LEOFile.getByteStream(b);
    }

    public static final int getSizeInBlocks(int sz, int blocksize) {
        float realnum = (float)sz / (float)blocksize;
        int size = sz / blocksize;
        if (realnum - (float)size > 0.0f) {
            ++size;
        }
        return size;
    }

    public int getMinBlocks() {
        return this.header.getMinStreamSize() / 512;
    }

    public byte[] getEncryptionStorageOverage() {
        if (this.encryptionStorageOverage == null) {
            this.encryptionStorageOverage = new byte[0];
        }
        return this.encryptionStorageOverage;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CompatibleVector getFATSectors() {
        int extraDIFATStart;
        CompatibleVector FATSectors = new CompatibleVector();
        int[] DIFAT = this.header.getDIFAT();
        int FATidx = 0;
        int blockidx = 0;
        int bsz = this.bigBlocks.size() - 1;
        while (blockidx < Math.min(DIFAT.length, 109)) {
            FATidx = DIFAT[blockidx];
            if (FATidx > bsz) {
                Logger.logErr("LEOFile.init failed. FAT Index Attempting to fetch Block past end of blocks.");
                throw new InvalidFileException("Input file truncated. LEOFile.init failed. FAT Index Attempting to fetch Block past end of blocks.");
            }
            BIGBLOCK bbd = (BIGBLOCK)this.bigBlocks.get(FATidx);
            bbd.setIsDepotBlock(true);
            FATSectors.add(bbd);
            ++blockidx;
        }
        int numExtraDIFATSectors = this.header.getNumExtraDIFATSectors();
        int chainIndex = extraDIFATStart = this.header.getExtraDIFATStart() + 1;
        int x = 0;
        while (x < numExtraDIFATSectors) {
            BIGBLOCK xind = (BIGBLOCK)this.bigBlocks.get(chainIndex);
            ByteBuffer extraSectorBytes = ByteBuffer.wrap(xind.getBytes());
            extraSectorBytes.position(0);
            extraSectorBytes.order(ByteOrder.LITTLE_ENDIAN);
            int numExtraSectorElements = Math.min(this.header.getNumFATSectors() - blockidx, 128);
            int i = 0;
            while (i < numExtraSectorElements) {
                if (i < 127) {
                    int bbloc = extraSectorBytes.getInt() + 1;
                    if (bbloc > bsz) {
                        Logger.logErr("LEOFile.init failed. Attempting to fetch Invalid Extra Sector Block.");
                        throw new InvalidFileException("LEOFile.init failed. Attempting to fetch Invalid Extra Sector Block.");
                    }
                    BIGBLOCK bbd = (BIGBLOCK)this.bigBlocks.get(bbloc);
                    bbd.setIsDepotBlock(true);
                    bbd.setIsExtraSector(true);
                    FATSectors.add(bbd);
                    ++blockidx;
                } else {
                    chainIndex = extraSectorBytes.getInt() + 1;
                }
                ++i;
            }
            ++x;
        }
        return FATSectors;
    }
}

