/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ColHandle;
import com.extentech.ExtenXLS.Handle;
import com.extentech.ExtenXLS.RowHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Fill;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Cf;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.Xf;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class FormatHandle
implements Handle,
FormatConstants {
    private CompatibleVector mycells = new CompatibleVector();
    private Xf myxf;
    private int xfe;
    private ColHandle mycol = null;
    private RowHandle myrow = null;
    private boolean writeImmediate = false;
    boolean underlined = false;
    private com.extentech.formats.XLS.WorkBook wkbook;
    private WorkBook wbh;
    public static final Map<String, String> numericFormatMap;
    public static final Map<String, String> currencyFormatMap;
    public static final Map<String, String> dateFormatMap;
    public static short colorFONT;
    public static short colorBACKGROUND;
    public static short colorFOREGROUND;
    public static short colorBORDER;

    static {
        String[] formatArr;
        HashMap<String, String> formats = new HashMap<String, String>();
        String[][] stringArray = FormatConstants.NUMERIC_FORMATS;
        int n = FormatConstants.NUMERIC_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            formatArr = stringArray[n2];
            if (formatArr.length == 3) {
                formats.put(formatArr[0].toLowerCase(), formatArr[2]);
            }
            ++n2;
        }
        numericFormatMap = Collections.unmodifiableMap(formats);
        formats = new HashMap();
        stringArray = FormatConstants.CURRENCY_FORMATS;
        n = FormatConstants.CURRENCY_FORMATS.length;
        n2 = 0;
        while (n2 < n) {
            formatArr = stringArray[n2];
            if (formatArr.length == 3) {
                formats.put(formatArr[0].toLowerCase(), formatArr[2]);
            }
            ++n2;
        }
        currencyFormatMap = Collections.unmodifiableMap(formats);
        formats = new HashMap();
        stringArray = FormatConstants.DATE_FORMATS;
        n = FormatConstants.DATE_FORMATS.length;
        n2 = 0;
        while (n2 < n) {
            formatArr = stringArray[n2];
            if (formatArr.length == 3) {
                formats.put(formatArr[0].toLowerCase(), formatArr[2]);
            } else {
                formats.put(formatArr[0].toLowerCase(), formatArr[0]);
            }
            ++n2;
        }
        dateFormatMap = Collections.unmodifiableMap(formats);
        colorFONT = 0;
        colorBACKGROUND = 1;
        colorFOREGROUND = (short)2;
        colorBORDER = (short)3;
    }

    public FormatHandle() {
    }

    public FormatHandle(WorkBook book, Xf xfr) {
        this.myxf = xfr;
        this.xfe = this.myxf.getIdx();
        this.wbh = book;
        if (book != null) {
            this.wkbook = book.getWorkBook();
        } else if (xfr.getWorkBook() != null) {
            this.wkbook = xfr.getWorkBook();
        } else {
            Logger.logErr("FormatHandle constructed with null WorkBook.");
        }
    }

    public FormatHandle(WorkBook book) {
        this(book, book.getWorkBook().getDefaultIxfe());
    }

    public FormatHandle(com.extentech.formats.XLS.WorkBook book, int xfnum) {
        this.wkbook = book;
        if (xfnum > -1 && xfnum < this.wkbook.getNumXfs()) {
            this.myxf = this.wkbook.getXf(xfnum);
            this.xfe = this.myxf.getIdx();
        }
        if (this.myxf == null) {
            this.myxf = this.duplicateXf(null);
        }
        this.myxf.getFont();
    }

    protected FormatHandle(WorkBook book, int xfnum, boolean dedupe) {
        this(book, xfnum);
        this.writeImmediate = dedupe;
    }

    protected FormatHandle(Condfmt cx, WorkBook book, int xfnum, CellHandle c) {
        cx.setFormatHandle(this);
        this.xfe = xfnum;
        this.wbh = book;
        this.wkbook = book.getWorkBook();
        if (c == null) {
            try {
                int[] rc = cx.getEncompassingRange();
                c = new CellHandle(cx.getSheet().getCell(rc[0], rc[1]), (WorkBookHandle)book);
            }
            catch (Exception rc) {
                // empty catch block
            }
        }
        this.myxf = this.duplicateXf(book.getWorkBook().getXf(c.getFormatId()));
        ArrayList lx = cx.getRules();
        for (Cf format : lx) {
            this.updateFromCF(format, book);
        }
    }

    protected void updateFromCF(Cf cf, WorkBook book) {
        int us;
        int fsup;
        Font f;
        int[] xs;
        Color[] clr = cf.getBorderColors();
        if (clr != null) {
            this.setBorderColors(clr);
        }
        if ((xs = cf.getBorderStyles()) != null) {
            this.setBorderLineStyle(xs);
        }
        if ((f = cf.getFont()) != null) {
            this.setFont(f);
        } else {
            this.setFontHeight(180);
        }
        if (cf.getFontItalic()) {
            this.setItalic(true);
        }
        if (cf.getFontStriken()) {
            this.setStricken(true);
        }
        if ((fsup = cf.getFontEscapement()) > -1) {
            this.setScript(fsup);
        }
        if ((us = cf.getFontUnderlineStyle()) > -1) {
            this.setUnderlineStyle(us);
            this.setUnderlined(true);
        }
        if (cf.getFormatPattern() != null) {
            this.setFormatPattern(cf.getFormatPattern());
        }
        if (cf.getFill() != null) {
            this.setFill(cf.getFill());
        } else {
            int fill = cf.getPatternFillStyle();
            if (fill > -1) {
                int bg = cf.getPatternFillColorBack();
                int fg = cf.getPatternFillColor();
                this.setFill(fill, fg, bg);
            } else {
                int fg = cf.getForegroundColor();
                if (fg > -1) {
                    this.setForegroundColor(fg);
                }
            }
        }
    }

    public FormatHandle(CellHandle c) {
        this.wkbook = c.getCell().getWorkBook();
        if (c.getCell().getXfRec() != null) {
            this.myxf = c.getCell().getXfRec();
            this.xfe = this.myxf.getIdx();
        } else {
            this.myxf = this.wkbook.getXf(c.getCell().getIxfe());
            this.xfe = this.myxf.getIdx();
        }
    }

    public boolean equals(Object another) {
        return another.toString().equals(this.toString());
    }

    public void setLocked(boolean locked) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setLocked(locked);
        this.updateXf(xf);
    }

    public void setFormulaHidden(boolean b) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setFormulaHidden(b);
        this.updateXf(xf);
    }

    public boolean isFormulaHidden() {
        return this.myxf.isFormulaHidden();
    }

    public boolean isLocked() {
        return this.myxf.isLocked();
    }

    public String getJavaFormatString() {
        String pat = this.getFormatPattern();
        if (pat == null) {
            return null;
        }
        String patty = FormatHandle.convertFormatString(pat.toLowerCase());
        if (patty != null) {
            patty = StringTool.qualifyPatternString(patty.toString());
        }
        if (this.myxf.isDatePattern()) {
            if (patty != null) {
                return patty;
            }
            return "M/d/yy h:mm";
        }
        if (patty != null) {
            return patty;
        }
        int firstParens = (pat = StringTool.qualifyPatternString(pat.toString())).indexOf(";");
        if (firstParens != -1) {
            int secondParens = pat.indexOf(";", firstParens + 1);
            pat = secondParens != -1 ? pat.substring(0, secondParens) : pat.substring(firstParens + 2, pat.length() - 1);
        }
        return pat;
    }

    public static String convertFormatString(String pattern) {
        String ret = numericFormatMap.get(pattern);
        if (ret != null) {
            return ret;
        }
        ret = currencyFormatMap.get(pattern);
        if (ret != null) {
            return ret;
        }
        ret = dateFormatMap.get(pattern);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public void setBorderColors(Color[] bordercolors) {
        Xf xf = this.cloneXf(this.myxf);
        if (bordercolors[0] != null) {
            xf.setTopBorderColor(FormatHandle.getColorInt(bordercolors[0]));
        }
        if (bordercolors[1] != null) {
            xf.setLeftBorderColor(FormatHandle.getColorInt(bordercolors[1]));
        }
        if (bordercolors[2] != null) {
            xf.setBottomBorderColor(FormatHandle.getColorInt(bordercolors[2]));
        }
        if (bordercolors[3] != null) {
            xf.setRightBorderColor(FormatHandle.getColorInt(bordercolors[3]));
        }
        this.updateXf(xf);
    }

    public void removeBorders() {
        Xf xf = this.cloneXf(this.myxf);
        xf.removeBorders();
        this.updateXf(xf);
    }

    public void setBorderColors(int[] bordercolors) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setTopBorderColor(bordercolors[0]);
        xf.setLeftBorderColor(bordercolors[1]);
        xf.setBottomBorderColor(bordercolors[2]);
        xf.setRightBorderColor(bordercolors[3]);
        this.updateXf(xf);
    }

    public void setBorderColor(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setRightBorderColor((short)x);
        xf.setLeftBorderColor((short)x);
        xf.setTopBorderColor((short)x);
        xf.setBottomBorderColor((short)x);
        this.updateXf(xf);
    }

    public void setBorderColor(Color col) {
        Xf xf = this.cloneXf(this.myxf);
        short x = (short)FormatHandle.getColorInt(col);
        xf.setRightBorderColor(x);
        xf.setLeftBorderColor(x);
        xf.setTopBorderColor(x);
        xf.setBottomBorderColor(x);
        this.updateXf(xf);
    }

    public void setBorderRightColor(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setRightBorderColor((short)x);
        this.updateXf(xf);
    }

    public void setBorderRightColor(Color x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setRightBorderColor((short)FormatHandle.getColorInt(x));
        this.updateXf(xf);
    }

    public Color getBorderRightColor() {
        if (this.myxf.getRightBorderLineStyle() == 0) {
            return null;
        }
        short x = this.myxf.getRightBorderColor();
        if (x < this.getWorkBook().colorTable.length) {
            return this.getWorkBook().getColorTable()[x];
        }
        return this.getWorkBook().getColorTable()[0];
    }

    public void setBorderLeftColor(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setLeftBorderColor((short)x);
        this.updateXf(xf);
    }

    public void setBorderLeftColor(Color x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setLeftBorderColor((short)FormatHandle.getColorInt(x));
        this.updateXf(xf);
    }

    public Color[] getBorderColors() {
        Color[] colors = new Color[]{this.getBorderTopColor(), this.getBorderLeftColor(), this.getBorderBottomColor(), this.getBorderRightColor()};
        return colors;
    }

    public Color getBorderLeftColor() {
        if (this.myxf.getLeftBorderLineStyle() == 0) {
            return null;
        }
        return this.getWorkBook().getColorTable()[this.myxf.getLeftBorderColor()];
    }

    public void setBorderTopColor(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setTopBorderColor(x);
        this.updateXf(xf);
    }

    public Color getBorderTopColor() {
        if (this.myxf.getTopBorderLineStyle() == 0) {
            return null;
        }
        int xt = this.myxf.getTopBorderColor();
        if (xt > this.getWorkBook().getColorTable().length) {
            xt = 0;
        }
        return this.getWorkBook().getColorTable()[xt];
    }

    public void setBorderTopColor(Color x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setTopBorderColor(FormatHandle.getColorInt(x));
        this.updateXf(xf);
    }

    public void setBorderBottomColor(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setBottomBorderColor(x);
        this.updateXf(xf);
    }

    public void setBorderBottomColor(Color x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setBottomBorderColor(FormatHandle.getColorInt(x));
        this.updateXf(xf);
    }

    public boolean isRedWhenNegative() {
        String pattern = this.myxf.getFormatPattern();
        return pattern.indexOf("Red") > -1;
    }

    public Color getBorderBottomColor() {
        if (this.myxf.getBottomBorderLineStyle() == 0) {
            return null;
        }
        int x = this.myxf.getBottomBorderColor();
        if (x < this.getWorkBook().getColorTable().length) {
            return this.getWorkBook().getColorTable()[x];
        }
        return this.getWorkBook().getColorTable()[0];
    }

    public void setTopBorderLineStyle(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setTopBorderLineStyle((short)x);
        this.updateXf(xf);
    }

    public int getTopBorderLineStyle() {
        return this.myxf.getTopBorderLineStyle();
    }

    public void setBottomBorderLineStyle(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setBottomBorderLineStyle((short)x);
        this.updateXf(xf);
    }

    public int getBottomBorderLineStyle() {
        return this.myxf.getBottomBorderLineStyle();
    }

    public void setLeftBorderLineStyle(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setLeftBorderLineStyle((short)x);
        this.updateXf(xf);
    }

    public int getLeftBorderLineStyle() {
        return this.myxf.getLeftBorderLineStyle();
    }

    public void setRightBorderLineStyle(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setRightBorderLineStyle((short)x);
        this.updateXf(xf);
    }

    public int getRightBorderLineStyle() {
        return this.myxf.getRightBorderLineStyle();
    }

    public void setBorderLineStyle(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setBorderLineStyle((short)x);
        this.updateXf(xf);
    }

    public void setBorderLineStyle(int[] b) {
        this.myxf.setAllBorderLineStyles(b);
    }

    public void setBorderLineStyle(short x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setBorderLineStyle(x);
        this.updateXf(xf);
    }

    public int[] getAllBorderLineStyles() {
        int[] ret = new int[]{this.myxf.getLeftBorderLineStyle(), this.myxf.getRightBorderLineStyle(), this.myxf.getTopBorderLineStyle(), this.myxf.getBottomBorderLineStyle(), this.myxf.getDiagBorderLineStyle()};
        return ret;
    }

    public int[] getAllBorderColors() {
        int[] ret = new int[]{this.myxf.getLeftBorderColor(), this.myxf.getRightBorderColor(), this.myxf.getTopBorderColor(), this.myxf.getBottomBorderColor(), this.myxf.getDiagBorderColor()};
        return ret;
    }

    public void setBorderDiagonal(int x) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setBorderDiag(x);
        this.updateXf(xf);
    }

    public void setColHandle(ColHandle c) {
        this.mycol = c;
    }

    public void setRowHandle(RowHandle c) {
        this.myrow = c;
    }

    public Object clone() {
        FormatHandle ret = null;
        if (this.wbh == null) {
            this.wkbook = this.myxf.getWorkBook();
            ret = new FormatHandle();
            ret.myxf = this.myxf;
            ret.xfe = this.myxf.getIdx();
            ret.wkbook = this.wkbook;
        } else {
            ret = new FormatHandle(this.wbh, this.myxf);
        }
        return ret;
    }

    public String toString() {
        return this.myxf.toString();
    }

    public FormatHandle(WorkBook book, String fontname, int fontstyle, int fontsize) {
        this(book);
        this.setFont(fontname, fontstyle, fontsize);
    }

    public FormatHandle(WorkBook workBook, int i) {
        this(workBook.getWorkBook(), i);
        this.wbh = workBook;
    }

    public void setFontWeight(int wt) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setFontWeight(wt);
        this.updateFont(f);
    }

    public int getFontWeight() {
        return this.myxf.getFont().getFontWeight();
    }

    public void setFont(Font f) {
        this.setXFToFont(f);
    }

    private void setXFToFont(Font f) {
        int fti = this.addFontIfNecessary(f);
        if (this.myxf == null) {
            this.myxf = this.duplicateXf(null);
            this.myxf.setFont(fti);
        } else if (this.myxf.getIfnt() != fti) {
            Xf xf = this.cloneXf(this.myxf);
            xf.setFont(fti);
            this.updateXf(xf);
        }
    }

    public void setFont(String fn, int stl, double sz) {
        sz *= 20.0;
        if (stl == 0) {
            stl = 200;
        }
        if (stl == 1) {
            stl = 700;
        }
        Font f = new Font(fn, stl, (int)sz);
        this.setXFToFont(f);
    }

    private int addFontIfNecessary(Font f) {
        if (this.wkbook == null) {
            Logger.logErr("AddFontIfNecessary: workbook is null");
            return -1;
        }
        int fti = this.wkbook.getFontIdx(f);
        if (fti == 3) {
            fti = 0;
        }
        if (fti == -1) {
            f.setIdx(-1);
            fti = this.wkbook.insertFont(f) + 1;
        } else {
            f.setIdx(fti);
        }
        return fti;
    }

    public static int addFont(Font f, WorkBookHandle bk) {
        int fti;
        if (bk == null) {
            Logger.logErr("addFont: workbook is null");
        }
        if ((fti = bk.getWorkBook().getFontIdx(f)) == 3) {
            fti = 0;
        }
        if (fti == -1) {
            f.setIdx(-1);
            fti = bk.getWorkBook().insertFont(f) + 1;
        } else {
            f.setIdx(fti);
        }
        return fti;
    }

    public void addCellRange(CellRange cr) {
        CellHandle[] crcells = cr.getCells();
        int t = 0;
        while (t < crcells.length) {
            this.addCell(crcells[t]);
            ++t;
        }
    }

    public void addCellArray(CellHandle[] crcells) {
        int t = 0;
        while (t < crcells.length) {
            this.addCell(crcells[t]);
            ++t;
        }
    }

    public void addCell(CellHandle c) {
        c.setFormatHandle(this);
    }

    public void addCells(List cx) {
        Iterator itx = cx.iterator();
        while (itx.hasNext()) {
            this.addCell((BiffRec)itx.next());
            this.mycells.add((BiffRec)itx.next());
        }
    }

    void addCell(BiffRec c) {
        if (this.myxf != null) {
            c.setXFRecord(this.myxf.getIdx());
        } else {
            Logger.logWarn("FormatHandle.addCell() - You MUST call setFont() to initialize the FormatHandle's font before adding Cells.");
        }
        this.mycells.add(c);
    }

    public void stamp(CellHandle cell) {
        cell.setFormatId(this.xfe);
    }

    public void stamp(CellRange range) {
        try {
            range.setFormatID(this.xfe);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBackgroundPattern(int t) {
        Xf xf = this.cloneXf(this.myxf);
        if (t != 1) {
            xf.setPattern(t);
        } else {
            short bg = xf.getBackgroundColor();
            xf.setBackgroundSolid();
            xf.setForeColor(bg, null);
        }
        this.updateXf(xf);
    }

    public boolean isDate() {
        if (this.myxf == null) {
            return false;
        }
        return this.myxf.isDatePattern();
    }

    public boolean isCurrency() {
        if (this.myxf == null) {
            return false;
        }
        return this.myxf.isCurrencyPattern();
    }

    public void setUnderlineStyle(int u) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setUnderlineStyle((byte)u);
        this.updateFont(f);
    }

    public void setScript(int ss) {
        if (ss > 2) {
            ss = 2;
        }
        if (ss < 0) {
            ss = 0;
        }
        this.myxf.getFont().setScript(ss);
    }

    public void setFontColor(int t) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setColor(t);
        this.updateFont(f);
    }

    public void setFontColor(Color colr) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setColor(colr);
        this.updateFont(f);
    }

    public void setFontColor(String clr) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setColor(clr);
        this.updateFont(f);
    }

    public Color getFontColor() {
        return this.myxf.getFont().getColorAsColor();
    }

    public String getFontColorAsHex() {
        return this.myxf.getFont().getColorAsHex();
    }

    public void setForegroundColor(int t) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setForeColor(t, null);
        this.updateXf(xf);
    }

    public void setForegroundColor(Color colr) {
        Xf xf = this.cloneXf(this.myxf);
        int clrz = FormatHandle.getColorInt(colr);
        xf.setForeColor(clrz, colr);
        this.updateXf(xf);
    }

    public void setBackgroundColor(int t) {
        Xf xf = this.cloneXf(this.myxf);
        if (xf.getFillPattern() == 1) {
            xf.setForeColor(t, null);
        } else {
            xf.setBackColor(t, null);
        }
        this.updateXf(xf);
    }

    public void setCellBackgroundColor(Color colr) {
        int clrz = FormatHandle.getColorInt(colr);
        this.setCellBackgroundColor(clrz);
    }

    public void setCellBackgroundColor(int t) {
        Xf xf = this.cloneXf(this.myxf);
        if (xf.getFillPattern() == 0) {
            xf.setBackgroundSolid();
        }
        if (xf.getFillPattern() == 1) {
            xf.setForeColor(t, null);
        } else {
            xf.setBackColor(t, null);
        }
        this.updateXf(xf);
    }

    protected void setFill(Fill f) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setFill(f);
        this.updateXf(xf);
    }

    public void setFill(int fillpattern, int fg, int bg) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setPattern(fillpattern);
        if (xf.getFillPattern() == 1) {
            xf.setForeColor(bg, null);
            xf.setBackColor(64, null);
        } else {
            xf.setForeColor(fg, null);
            xf.setBackColor(bg, null);
        }
        this.updateXf(xf);
    }

    public int getBackgroundColor() {
        return this.myxf.getBackgroundColor();
    }

    public String getBackgroundColorAsHex() {
        return this.myxf.getBackgroundColorHEX();
    }

    public Color getBackgroundColorAsColor() {
        return FormatHandle.HexStringToColor(this.getBackgroundColorAsHex());
    }

    public int getTrueForegroundColor() {
        return this.myxf.getForegroundColor();
    }

    public int getCellBackgroundColor() {
        int fp = this.getFillPattern();
        if (fp == 1) {
            return this.myxf.getForegroundColor();
        }
        return this.myxf.getBackgroundColor();
    }

    public String getCellBackgroundColorAsHex() {
        int fp = this.getFillPattern();
        if (fp == 1) {
            return this.myxf.getForegroundColorHEX();
        }
        return this.myxf.getBackgroundColorHEX();
    }

    public Color getCellBackgroundColorAsColor() {
        return FormatHandle.HexStringToColor(this.getCellBackgroundColorAsHex());
    }

    public int getForegroundColor() {
        if (this.getFillPattern() == 1) {
            return this.myxf.getBackgroundColor();
        }
        return this.myxf.getForegroundColor();
    }

    public String getForegroundColorAsHex() {
        if (this.getFillPattern() == 1) {
            return this.myxf.getBackgroundColorHEX();
        }
        return this.myxf.getForegroundColorHEX();
    }

    public Color getForegroundColorAsColor() {
        return FormatHandle.HexStringToColor(this.getForegroundColorAsHex());
    }

    public void setBackgroundColor(Color colr) {
        Xf xf = this.cloneXf(this.myxf);
        int clrz = FormatHandle.getColorInt(colr);
        xf.setBackColor(clrz, colr);
        this.updateXf(xf);
    }

    public void setBold(boolean isBold) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setBold(isBold);
        this.updateFont(f);
    }

    public boolean getIsBold() {
        return this.myxf.getFont().getIsBold();
    }

    public int getUnderlineStyle() {
        return this.myxf.getFont().getUnderlineStyle();
    }

    public double getFontHeightInPoints() {
        return this.getFont().getFontHeightInPoints();
    }

    public int getFontHeight() {
        return this.getFont().getFontHeight();
    }

    public void setFontHeight(int fontHeight) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setFontHeight(fontHeight);
        this.updateFont(f);
    }

    public String getFontName() {
        return this.getFont().getFontName();
    }

    public void setFontName(String fontName) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setFontName(fontName);
        this.updateFont(f);
    }

    public boolean getStricken() {
        if (this.myxf.getFont() == null) {
            return false;
        }
        return this.myxf.getFont().getStricken();
    }

    public void setStricken(boolean isStricken) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setStricken(isStricken);
        this.updateFont(f);
    }

    public boolean getItalic() {
        if (this.myxf.getFont() == null) {
            return false;
        }
        return this.myxf.getFont().getItalic();
    }

    public void setItalic(boolean isItalic) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setItalic(isItalic);
        this.updateFont(f);
    }

    public boolean getUnderlined() {
        if (this.myxf.getFont() == null) {
            return this.underlined;
        }
        return this.myxf.getFont().getUnderlined();
    }

    public void setUnderlined(boolean isUnderlined) {
        Font f = this.cloneFont(this.myxf.getFont());
        f.setUnderlined(isUnderlined);
        this.updateFont(f);
    }

    public boolean getBold() {
        return this.myxf.getFont().getBold();
    }

    public Font getFont() {
        if (this.myxf != null) {
            return this.myxf.getFont();
        }
        return null;
    }

    public void setFormatPattern(String pat) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setFormatPattern(pat);
        this.updateXf(xf);
    }

    public void setPattern(int pat) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setPattern(pat);
        this.updateXf(xf);
    }

    public int getFormatId() {
        return this.xfe;
    }

    public String getFormatPattern() {
        return this.myxf.getFormatPattern();
    }

    public int getFillPattern() {
        return this.myxf.getFillPattern();
    }

    public static Color getColor(int col) {
        if (col > -1 && col < COLORTABLE.length) {
            return COLORTABLE[col];
        }
        return COLORTABLE[0];
    }

    public static int getColorInt(Color col) {
        int i = 0;
        while (i < COLORTABLE.length) {
            if (col.equals(COLORTABLE[i])) {
                return i;
            }
            ++i;
        }
        int R2 = col.getRed();
        int G = col.getGreen();
        int B = col.getBlue();
        int colorMatch = -1;
        double colorDiff = 2.147483647E9;
        int i2 = 0;
        while (i2 < COLORTABLE.length) {
            double curDif = Math.pow(R2 - COLORTABLE[i2].getRed(), 2.0) + Math.pow(G - COLORTABLE[i2].getGreen(), 2.0) + Math.pow(B - COLORTABLE[i2].getBlue(), 2.0);
            if (curDif < colorDiff) {
                colorDiff = curDif;
                colorMatch = i2;
            }
            ++i2;
        }
        return colorMatch;
    }

    public void setXf(Xf xrec) {
        this.myxf = xrec;
    }

    public void setHorizontalAlignment(int align) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setHorizontalAlignment(align);
        this.updateXf(xf);
    }

    public int getHorizontalAlignment() {
        return this.myxf.getHorizontalAlignment();
    }

    public void setIndent(int indent) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setIndent(indent);
        this.updateXf(xf);
    }

    public void adjustPrecision(boolean increase) {
        String pat = this.getFormatPattern();
        if (pat.equals("General") && increase) {
            pat = "0.0";
            this.setFormatPattern(pat);
            return;
        }
        try {
            String[] pats = pat.split(";");
            String newPat = "";
            int i = 0;
            while (i < pats.length) {
                char c;
                if (i > 0) {
                    newPat = String.valueOf(newPat) + ';';
                }
                int z = pats[i].indexOf(46);
                boolean foundit = false;
                if (z != -1) {
                    ++z;
                    while (z < pats[i].length()) {
                        c = pats[i].charAt(z);
                        if (c == '0' || c == '#' || c == '?') {
                            foundit = true;
                        } else if (foundit && c != '0' && c != '#' && c != '?') break;
                        ++z;
                    }
                    newPat = increase ? String.valueOf(newPat) + new StringBuffer(pats[i]).insert(z, "0").toString() : (pats[i].charAt(z - 2) != '.' ? String.valueOf(newPat) + new StringBuffer(pats[i]).deleteCharAt(z - 1).toString() : String.valueOf(newPat) + new StringBuffer(pats[i]).delete(z - 2, z).toString());
                } else if (increase) {
                    z = pats[i].length() - 1;
                    while (z >= 0) {
                        c = pats[i].charAt(z);
                        if (c == '0' || c == '#' || c == '?') {
                            foundit = true;
                            break;
                        }
                        --z;
                    }
                    newPat = foundit ? String.valueOf(newPat) + new StringBuffer(pats[i]).insert(z + 1, ".0").toString() : String.valueOf(newPat) + pats[i];
                } else {
                    newPat = String.valueOf(newPat) + pats[i];
                }
                ++i;
            }
            this.setFormatPattern(newPat);
        }
        catch (Exception e) {
            Logger.logErr("Error setting style");
        }
    }

    public int getIndent() {
        return this.myxf.getIndent();
    }

    public void setRightToLeftReadingOrder(int rtl) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setRightToLeftReadingOrder(rtl);
        this.updateXf(xf);
    }

    public int getRightToLetReadingOrder() {
        return this.myxf.getRightToLeftReadingOrder();
    }

    public void setVerticalAlignment(int align) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setVerticalAlignment(align);
        this.updateXf(xf);
    }

    public int getVerticalAlignment() {
        return this.myxf.getVerticalAlignment();
    }

    public FormatHandle pack() {
        return this;
    }

    public void setWorkBook(com.extentech.formats.XLS.WorkBook bk) {
        this.wkbook = bk;
    }

    public void setWrapText(boolean wrapit) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setWrapText(wrapit);
        this.updateXf(xf);
    }

    public boolean getWrapText() {
        return this.myxf.getWrapText();
    }

    public void setCellRotation(int align) {
        Xf xf = this.cloneXf(this.myxf);
        xf.setRotation(align);
        this.updateXf(xf);
    }

    public int getCellRotation() {
        return this.myxf.getRotation();
    }

    public String getJSON(int XFNum) {
        return this.getJSONObject(XFNum).toString();
    }

    public JSONObject getJSONObject(int XFNum) {
        Font myf = this.getFont();
        JSONObject theStyle = new JSONObject();
        try {
            theStyle.put("style", XFNum);
            JSONObject theFont = new JSONObject();
            theFont.put("name", (Object)myf.getFontName());
            long sz = Math.round((double)myf.getFontHeight() / 22.0);
            theFont.put("size", sz);
            theFont.put("color", (Object)FormatHandle.colorToHexString(myf.getColorAsColor()));
            theFont.put("weight", myf.getFontWeight());
            if (this.getIsBold()) {
                theFont.put("bold", (Object)"1");
            }
            if (this.getUnderlined()) {
                theFont.put("underline", (Object)"1");
            } else {
                theFont.put("underline", (Object)"0");
            }
            if (this.getItalic()) {
                theFont.put("italic", (Object)"1");
            }
            theStyle.put("font", (Object)theFont);
            JSONObject border = new JSONObject();
            if (this.getRightBorderLineStyle() != 0) {
                JSONObject rBorder = new JSONObject();
                rBorder.put("style", (Object)BORDER_STYLES_JSON[this.getRightBorderLineStyle()]);
                rBorder.put("color", (Object)FormatHandle.colorToHexString(this.getBorderRightColor()));
                border.put("right", (Object)rBorder);
            }
            if (this.getBottomBorderLineStyle() != 0) {
                JSONObject bBorder = new JSONObject();
                bBorder.put("style", (Object)BORDER_STYLES_JSON[this.getBottomBorderLineStyle()]);
                bBorder.put("color", (Object)FormatHandle.colorToHexString(this.getBorderBottomColor()));
                border.put("bottom", (Object)bBorder);
            }
            if (this.getLeftBorderLineStyle() != 0) {
                JSONObject lBorder = new JSONObject();
                lBorder.put("style", (Object)BORDER_STYLES_JSON[this.getLeftBorderLineStyle()]);
                lBorder.put("color", (Object)FormatHandle.colorToHexString(this.getBorderLeftColor()));
                border.put("left", (Object)lBorder);
            }
            if (this.getTopBorderLineStyle() != 0) {
                JSONObject tBorder = new JSONObject();
                tBorder.put("style", (Object)BORDER_STYLES_JSON[this.getTopBorderLineStyle()]);
                tBorder.put("color", (Object)FormatHandle.colorToHexString(this.getBorderTopColor()));
                border.put("top", (Object)tBorder);
            }
            theStyle.put("borders", (Object)border);
            JSONObject alignment = new JSONObject();
            alignment.put("horizontal", (Object)HORIZONTAL_ALIGNMENTS[this.getHorizontalAlignment()]);
            alignment.put("vertical", (Object)VERTICAL_ALIGNMENTS[this.getVerticalAlignment()]);
            if (this.getWrapText()) {
                alignment.put("wrap", (Object)"1");
            }
            theStyle.put("alignment", (Object)alignment);
            if (this.getIndent() != 0) {
                theStyle.put("indent", this.getIndent());
            }
            if (this.getFillPattern() >= 0) {
                JSONObject interior = new JSONObject();
                if (this.myxf.getForegroundColor() == 65) {
                    interior.put("color", (Object)"#FFFFFF");
                } else {
                    interior.put("color", (Object)this.myxf.getForegroundColorHEX());
                }
                interior.put("pattern", this.myxf.getFillPattern());
                interior.put("fg", (int)this.myxf.getForegroundColor());
                interior.put("patterncolor", (Object)this.myxf.getBackgroundColorHEX());
                interior.put("bg", (int)this.myxf.getBackgroundColor());
                theStyle.put("interior", (Object)interior);
            }
            if (this.myxf.getIfmt() != 0) {
                JSONObject nFormat = new JSONObject();
                String fmtpat = this.getFormatPattern();
                try {
                    if (!fmtpat.equals("General")) {
                        nFormat.put("format", (Object)fmtpat);
                        nFormat.put("formatid", (int)this.myxf.getIfmt());
                        if (this.isDate()) {
                            nFormat.put("isdate", (Object)"1");
                        }
                        if (this.isCurrency()) {
                            nFormat.put("iscurrency", (Object)"1");
                        }
                        if (this.isRedWhenNegative()) {
                            nFormat.put("isrednegative", (Object)"1");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                theStyle.put("numberformat", (Object)nFormat);
            }
            JSONObject protection = new JSONObject();
            try {
                if (this.myxf.isLocked()) {
                    protection.put("Protected", true);
                }
                if (this.myxf.isFormulaHidden()) {
                    protection.put("HideFormula", true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            theStyle.put("protection", (Object)protection);
        }
        catch (JSONException e) {
            Logger.logErr("Error getting cellRange JSON: " + (Object)((Object)e));
        }
        return theStyle;
    }

    public String getXML(int XFNum) {
        return this.getXML(XFNum, false);
    }

    public String getXML(int XFNum, boolean convertToUnicodeFont) {
        StringBuffer sb;
        block25: {
            block23: {
                Font myf = this.getFont();
                sb = new StringBuffer("<Style");
                sb.append(" ID=\"s" + XFNum + "\"");
                sb.append(">");
                sb.append("<Font " + myf.getXML(convertToUnicodeFont) + "/>");
                sb.append("<Borders>");
                if (this.getRightBorderLineStyle() != 0) {
                    sb.append("\t\t<Border");
                    sb.append(" Position=\"right\"");
                    sb.append(" LineStyle=\"" + BORDER_NAMES[this.getRightBorderLineStyle()] + "\"");
                    sb.append(" Color=\"" + FormatHandle.colorToHexString(this.getBorderRightColor()) + "\"");
                    sb.append(" Weight=\"" + BORDER_SIZES_HTML[this.getRightBorderLineStyle()] + "\"");
                    sb.append("/>");
                }
                if (this.getBottomBorderLineStyle() != 0) {
                    sb.append("<Border");
                    sb.append(" Position=\"bottom\"");
                    sb.append(" LineStyle=\"" + BORDER_NAMES[this.getBottomBorderLineStyle()] + "\"");
                    sb.append(" Color=\"" + FormatHandle.colorToHexString(this.getBorderBottomColor()) + "\"");
                    sb.append(" Weight=\"" + BORDER_SIZES_HTML[this.getBottomBorderLineStyle()] + "\"");
                    sb.append("/>");
                }
                if (this.getLeftBorderLineStyle() != 0) {
                    sb.append("<Border");
                    sb.append(" Position=\"left\"");
                    sb.append(" LineStyle=\"" + BORDER_NAMES[this.getLeftBorderLineStyle()] + "\"");
                    sb.append(" Color=\"" + FormatHandle.colorToHexString(this.getBorderLeftColor()) + "\"");
                    sb.append(" Weight=\"" + BORDER_SIZES_HTML[this.getLeftBorderLineStyle()] + "\"");
                    sb.append("/>");
                }
                if (this.getTopBorderLineStyle() != 0) {
                    sb.append("<Border");
                    sb.append(" Position=\"top\"");
                    sb.append(" LineStyle=\"" + BORDER_NAMES[this.getTopBorderLineStyle()] + "\"");
                    sb.append(" Color=\"" + FormatHandle.colorToHexString(this.getBorderTopColor()) + "\"");
                    sb.append(" Weight=\"" + BORDER_SIZES_HTML[this.getTopBorderLineStyle()] + "\"");
                    sb.append("/>");
                }
                sb.append("</Borders>");
                sb.append("<Alignment");
                sb.append(" Horizontal=\"" + HORIZONTAL_ALIGNMENTS[this.getHorizontalAlignment()] + "\"");
                sb.append(" Vertical=\"" + VERTICAL_ALIGNMENTS[this.getVerticalAlignment()] + "\"");
                if (this.getWrapText()) {
                    sb.append(" Wrap=\"1\"");
                }
                if (this.myxf.getIndent() > 0) {
                    sb.append(" Indent=\"" + this.myxf.getIndent() * 10 + "px\"");
                }
                sb.append(" />");
                sb.append("<Interior");
                if (this.getFillPattern() > 0) {
                    short fg = this.myxf.getForegroundColor();
                    if (this.myxf.getFillPattern() != 1 || !this.getWorkBook().getColorTable()[fg].equals(Color.WHITE)) {
                        sb.append(" Color=\"" + FormatHandle.colorToHexString(this.getWorkBook().getColorTable()[fg]) + "\"" + " Fg=\"" + fg + "\"");
                    }
                    sb.append(" PatternColor=\"" + FormatHandle.colorToHexString(this.getWorkBook().getColorTable()[this.myxf.getBackgroundColor()]) + "\"" + " Bg=\"" + this.myxf.getBackgroundColor() + "\"");
                    sb.append(" Pattern=\"" + this.myxf.getFillPattern() + "\"");
                }
                sb.append(" />");
                if (this.myxf.getIfmt() != 0) {
                    String fmtpat = this.getFormatPattern();
                    try {
                        try {
                            sb.append("<NumberFormat");
                            if (!fmtpat.equals("General")) {
                                sb.append(" Format=\"" + StringTool.convertXMLChars(fmtpat) + "\"");
                                sb.append(" FormatId=\"" + this.myxf.getIfmt() + "\"");
                                if (this.isDate()) {
                                    sb.append(" IsDate=\"1\"");
                                }
                                if (this.isCurrency()) {
                                    sb.append(" IsCurrency=\"1\"");
                                }
                            }
                        }
                        catch (Exception exception) {
                            sb.append(" />");
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        sb.append(" />");
                        throw throwable;
                    }
                    sb.append(" />");
                }
            }
            boolean locked = this.myxf.isLocked();
            int lck = 0;
            if (locked) {
                lck = 1;
            }
            boolean formulahidden = this.myxf.isFormulaHidden();
            int fmlz = 0;
            if (formulahidden) {
                fmlz = 1;
            }
            try {
                try {
                    sb.append("<Protection");
                    sb.append(" Protected=\"" + lck + "\"");
                    sb.append(" HideFormula=\"" + fmlz + "\"");
                }
                catch (Exception e) {
                    Logger.logWarn("FormatHandle.getXML problem with protection setting: " + e.toString());
                    sb.append(" />");
                    break block25;
                }
            }
            catch (Throwable throwable) {
                sb.append(" />");
                throw throwable;
            }
            sb.append(" />");
        }
        sb.append("</Style>");
        return sb.toString();
    }

    public int getFormatPatternId() {
        return this.myxf.getIfmt();
    }

    public void setFormatPatternId(int fmt) {
        this.myxf.setFormat((short)fmt);
    }

    public static String colorToHexString(Color c) {
        String bh;
        String gh;
        int r2 = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        String rh = Integer.toHexString(r2);
        if (rh.length() < 2) {
            rh = "0" + rh;
        }
        if ((gh = Integer.toHexString(g)).length() < 2) {
            gh = "0" + gh;
        }
        if ((bh = Integer.toHexString(b)).length() < 2) {
            bh = "0" + bh;
        }
        return ("#" + rh + gh + bh).toUpperCase();
    }

    public static int HexStringToColorInt(String s, short colorType) {
        if (s.length() > 7) {
            s = "#" + s.substring(s.length() - 6);
        }
        if (s.indexOf("#") == -1) {
            s = "#" + s;
        }
        if (s.length() == 7) {
            String rs = s.substring(1, 3);
            int r2 = Integer.parseInt(rs, 16);
            String gs = s.substring(3, 5);
            int g = Integer.parseInt(gs, 16);
            String bs = s.substring(5, 7);
            int b = Integer.parseInt(bs, 16);
            if (r2 == 255 && r2 == g && r2 == b && colorType == colorFONT) {
                return 9;
            }
            Color c = new Color(r2, g, b);
            return FormatHandle.getColorInt(c);
        }
        return 0;
    }

    public static int HexStringToColorIntExact(String s, short colorType) {
        if (s.length() > 7) {
            s = "#" + s.substring(s.length() - 6);
        }
        if (s.indexOf("#") == -1) {
            s = "#" + s;
        }
        if (s.length() == 7) {
            String rs = s.substring(1, 3);
            int r2 = Integer.parseInt(rs, 16);
            String gs = s.substring(3, 5);
            int g = Integer.parseInt(gs, 16);
            String bs = s.substring(5, 7);
            int b = Integer.parseInt(bs, 16);
            if (r2 == 255 && r2 == g && r2 == b && colorType == colorFONT) {
                return 9;
            }
            Color c = new Color(r2, g, b);
            int i = 0;
            while (i < COLORTABLE.length) {
                if (c.equals(COLORTABLE[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static Color HexStringToColor(String s) {
        if (s.length() > 7) {
            s = "#" + s.substring(s.length() - 6);
        }
        Color c = null;
        if (s.length() == 7) {
            String rs = s.substring(1, 3);
            int r2 = Integer.parseInt(rs, 16);
            String gs = s.substring(3, 5);
            int g = Integer.parseInt(gs, 16);
            String bs = s.substring(5, 7);
            int b = Integer.parseInt(bs, 16);
            c = new Color(r2, g, b);
        } else {
            c = new Color(0, 0, 0);
        }
        return c;
    }

    public static short interpretSpecialColorIndex(int clr) {
        switch (clr) {
            case 65: 
            case 78: 
            case 80: {
                return 1;
            }
            case 64: 
            case 77: 
            case 79: 
            case 81: 
            case 32767: {
                return 0;
            }
        }
        return 1;
    }

    public static int BorderStringToInt(String s) {
        int i = 0;
        while (i < FormatConstants.BORDER_NAMES.length) {
            if (FormatConstants.BORDER_NAMES[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public com.extentech.formats.XLS.WorkBook getWorkBook() {
        return this.wkbook;
    }

    public boolean isStyleXf() {
        return this.myxf.isStyleXf();
    }

    private Font createNewFont(Font f) {
        f.setIdx(-1);
        this.wkbook.insertFont(f);
        f.setWorkBook(this.wkbook);
        return f;
    }

    private Font cloneFont(Font src) {
        Font f = new Font();
        f.setOpcode((short)49);
        f.setData(src.getBytes());
        f.setIdx(-2);
        f.setWorkBook(this.getWorkBook());
        f.init();
        return f;
    }

    private void updateFont(Font f) {
        int idx = this.wkbook.getFontIdx(f);
        if ((f = idx == -1 ? this.createNewFont(f) : this.wkbook.getFont(idx)).getIdx() != this.myxf.getIfnt()) {
            Xf xf = this.cloneXf(this.myxf);
            xf.setFont(f.getIdx());
            this.updateXf(xf);
        }
    }

    private Xf duplicateXf(Xf xf) {
        int fidx = 0;
        if (xf != null) {
            fidx = xf.getFont().getIdx();
        }
        xf = Xf.updateXf(xf, fidx, this.wkbook);
        this.xfe = xf.getIdx();
        return xf;
    }

    public int addXf(Xf sourceXf) {
        int fidx = this.addFontIfNecessary(sourceXf.getFont());
        Xf localXf = FormatHandle.cloneXf(sourceXf, this.wkbook.getFont(fidx), this.wkbook);
        String fmt = sourceXf.getFormatPattern();
        if (fmt != null) {
            localXf.setFormatPattern(fmt);
        }
        this.updateXf(localXf);
        return this.xfe;
    }

    private void updateXf(Xf xf) {
        if (!this.myxf.toString().equals(xf.toString())) {
            if (this.myxf.getUseCount() <= 1 && this.xfe > 15) {
                if (this.writeImmediate || this.wkbook.getFormatCache().get(xf.toString()) == null) {
                    byte[] xfbytes = xf.getBytes();
                    this.myxf.setData(xfbytes);
                    if (xf.fill != null) {
                        this.myxf.fill = (Fill)xf.fill.cloneElement();
                    }
                    this.myxf.init();
                    this.myxf.setFont(this.myxf.getIfnt());
                    this.wkbook.updateFormatCache(this.myxf);
                } else {
                    if (this.myxf.getUseCount() > 0) {
                        this.myxf.decUseCoount();
                    }
                    this.myxf = (Xf)this.wkbook.getFormatCache().get(xf.toString());
                    this.xfe = this.myxf.getIdx();
                    if (this.xfe == -1) {
                        this.myxf = this.duplicateXf(xf);
                    } else {
                        this.myxf.incUseCount();
                    }
                }
            } else {
                if (this.myxf.getUseCount() > 0) {
                    this.myxf.decUseCoount();
                }
                if (this.wkbook.getFormatCache().get(xf.toString()) == null) {
                    this.myxf = this.duplicateXf(xf);
                } else {
                    this.myxf = (Xf)this.wkbook.getFormatCache().get(xf.toString());
                    this.xfe = this.myxf.getIdx();
                    if (this.xfe == -1) {
                        this.myxf = this.duplicateXf(xf);
                    } else {
                        this.myxf.incUseCount();
                    }
                }
            }
            int i = 0;
            while (i < this.mycells.size()) {
                ((BiffRec)this.mycells.get(i)).setXFRecord(this.xfe);
                ++i;
            }
            if (this.mycol != null) {
                this.mycol.setFormatId(this.xfe);
            }
            if (this.myrow != null) {
                this.myrow.setFormatId(this.xfe);
            }
        }
    }

    private Xf cloneXf(Xf xf) {
        Xf clone = new Xf(xf.getFont().getIdx(), this.wkbook);
        byte[] data = xf.getBytesAt(0, xf.getLength() - 4);
        clone.setData(data);
        if (xf.fill != null) {
            clone.fill = (Fill)xf.fill.cloneElement();
        }
        clone.init();
        return clone;
    }

    public static Xf cloneXf(Xf xf, com.extentech.formats.XLS.WorkBook wkbook) {
        Xf clone = new Xf(xf.getFont().getIdx(), wkbook);
        byte[] data = xf.getBytesAt(0, xf.getLength() - 4);
        clone.setData(data);
        clone.init();
        return clone;
    }

    public static Xf cloneXf(Xf xf, Font f, com.extentech.formats.XLS.WorkBook wkbook) {
        Xf clone = new Xf(f, wkbook);
        byte[] data = xf.getBytesAt(0, xf.getLength() - 4);
        clone.setData(data);
        clone.setFont(f.getIdx());
        clone.init();
        return clone;
    }

    public void setFormatId(int x) {
        this.xfe = x;
    }

    public void close() {
        this.mycells.clear();
        this.mycells = new CompatibleVector();
        this.myxf = null;
        this.mycol = null;
        this.myrow = null;
        this.wkbook = null;
        this.wbh = null;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    protected Xf getXf() {
        return this.myxf;
    }
}

