/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.ExtenXLS.GetInfo;
import com.extentech.naming.InitialContextImpl;
import com.extentech.toolkit.ExtenClassLoader;
import com.extentech.toolkit.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.naming.Context;

public class ResourceLoader
extends InitialContextImpl
implements Serializable,
Context {
    private static final long serialVersionUID = 12345245254L;
    private String resloc = "";
    private File propsfile = null;
    public static boolean DEBUG = false;
    private Properties resources = new Properties();
    private boolean snagged = false;
    private static URLDecoder decodr = new URLDecoder();

    public String toString() {
        return "Extentech ResourceLoader v." + ResourceLoader.getVersion();
    }

    public static String getVersion() {
        return GetInfo.getVersion();
    }

    public Enumeration getKeys() {
        if (!this.snagged) {
            return this.resources.keys();
        }
        return this.env.keys();
    }

    public Object getObject(String key) {
        if (!this.snagged) {
            return this.resources.get(key);
        }
        return this.env.get(key);
    }

    private void snagVals() {
        this.snagged = true;
        Enumeration<Object> a = this.resources.keys();
        while (a.hasMoreElements()) {
            String mystr = (String)a.nextElement();
            this.env.put(mystr, this.resources.get(mystr));
        }
    }

    public ResourceLoader(String s) {
        if (s.indexOf("resources/") == -1) {
            s = "resources/" + s;
        }
        Logger.logInfo("ResourceLoader INIT: " + s);
        this.resloc = s;
        try {
            try {
                this.propsfile = new File(String.valueOf(s) + ".properties");
                FileInputStream fis = new FileInputStream(this.propsfile);
                this.resources.load(fis);
            }
            catch (Exception e) {
                try {
                    this.propsfile.createNewFile();
                    FileInputStream fis = new FileInputStream(this.propsfile);
                    this.resources.load(fis);
                }
                catch (Exception ex) {
                    Logger.logWarn("Could not init Resourceloader from: " + this.propsfile.getAbsolutePath());
                }
            }
            boolean hidevals = false;
            try {
                if (this.resources.get("public") != null && this.resources.get("visibility").equals("private")) {
                    hidevals = true;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (!hidevals) {
                this.snagVals();
            }
        }
        catch (MissingResourceException mre) {
            Logger.logErr("ResourceLoader getting resources failed: " + mre.toString());
        }
    }

    public ResourceLoader() {
    }

    public String getResourceString(String nm) {
        String str;
        try {
            str = this.resources.get(nm).toString();
        }
        catch (Exception mre) {
            str = "";
        }
        return str;
    }

    public void setResourceString(String nm, String v) {
        try {
            this.resources.setProperty(nm, v);
            FileOutputStream fos = new FileOutputStream(this.propsfile);
            this.resources.store(fos, null);
            fos.flush();
            fos.close();
        }
        catch (Exception mre) {
            Logger.logWarn("Resource string: " + nm + " could not be set to " + v + " in:" + this.resloc);
        }
    }

    public Object[] getObjects(String propname) {
        String objnames = this.getResourceString(propname);
        if (objnames != null) {
            Object[] obj = new Object[]{ResourceLoader.loadClass(objnames)};
            return obj;
        }
        return null;
    }

    public static Object loadClass(String className) {
        ExtenClassLoader cl = new ExtenClassLoader();
        Object obj = null;
        try {
            Class c = cl.loadClass(className, true);
            obj = c.newInstance();
            return obj;
        }
        catch (ClassFormatError t) {
            Logger.logErr(t.toString());
            return null;
        }
        catch (ClassNotFoundException t) {
            Logger.logErr(t);
            return null;
        }
        catch (ClassCastException t) {
            Logger.logErr(t);
            return null;
        }
        catch (InstantiationException t) {
            Logger.logErr(t);
            return null;
        }
        catch (IllegalAccessException t) {
            Logger.logErr(t);
            return null;
        }
    }

    public static byte[] getBytesFromJar(String name) throws IOException {
        InputStream source = ResourceLoader.class.getResourceAsStream(name);
        if (source == null) {
            return null;
        }
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        while (count != -1) {
            sink.write(buffer, 0, count);
            count = source.read(buffer);
        }
        source.close();
        return sink.toByteArray();
    }

    public static String getFilePathForResource(String resource) {
        int i;
        URL u = new ResourceLoader().getClass().getResource(resource);
        if (u == null) {
            Logger.logErr("ResourceLoader.getFilePathForResource: " + resource + " not found.");
            return null;
        }
        if (DEBUG) {
            Logger.logInfo("ResourceLoader.getFilePathForResource() got:" + u.toString());
        }
        String s = u.getFile();
        if (DEBUG) {
            Logger.logInfo("ResourceLoader.getFilePathForResource Decoding:" + s);
        }
        s = ResourceLoader.Decode(s);
        if (DEBUG) {
            Logger.logInfo("ResourceLoader.getFilePathForResource Decoded:" + s);
        }
        if ((i = s.indexOf("!")) > -1) {
            String zipstring = s.substring(0, i);
            int begin = zipstring.indexOf(":");
            if ((zipstring = zipstring.substring(++begin)).indexOf(":") != -1 && zipstring.indexOf("/") == 0) {
                zipstring = zipstring.substring(1);
            }
            if (DEBUG) {
                Logger.logInfo("Resourceloader.getFilePathForResource(): Successfully obtained " + zipstring);
            }
            return zipstring;
        }
        if (DEBUG) {
            Logger.logErr("ResourceLoader.getFilePathForResource(): File is not in jar:" + s);
        }
        return s;
    }

    public static void addFileToJar(String jarandResource, String f) {
        String[] tmp = ResourceLoader.extractJarAndResourceName(jarandResource);
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tmp[0]));
            ZipInputStream fin = new ZipInputStream(new FileInputStream(f));
            out.putNextEntry(new ZipEntry(tmp[1]));
            byte[] buf = new byte[fin.available()];
            fin.read(buf);
            out.write(buf);
            out.flush();
            out.closeEntry();
            out.close();
        }
        catch (Exception e) {
            Logger.logErr("addFileToJar: Jar: " + tmp[0] + " File: " + tmp[1] + " : " + e.toString());
        }
    }

    public static boolean isJarFile(String f) {
        int i = (f = f.toLowerCase()).indexOf(".war");
        if (i < 0) {
            i = f.indexOf(".jar");
        }
        if (i < 0) {
            i = f.indexOf(".rar");
        }
        if (i < 0) {
            i = f.indexOf(".zip");
        }
        return i > -1;
    }

    public static String[] extractJarAndResourceName(String jarAndResource) {
        int i = (jarAndResource = jarAndResource.toLowerCase()).indexOf(".war");
        if (i < 0) {
            i = jarAndResource.indexOf(".jar");
        }
        if (i < 0) {
            i = jarAndResource.indexOf(".rar");
        }
        if (i < 0) {
            i = jarAndResource.indexOf(".zip");
        }
        return new String[]{jarAndResource.substring(0, i + 4), jarAndResource.substring(i + 5)};
    }

    public static String getWorkingDirectoryFromJar(String resource) {
        int i;
        String s;
        if (System.getProperty("com.extentech.extenxls.jarloc") != null) {
            s = String.valueOf(System.getProperty("com.extentech.extenxls.jarloc")) + "!";
        } else {
            URL u = ResourceLoader.class.getResource(resource);
            s = u.getFile();
        }
        if (DEBUG) {
            Logger.logInfo("Resource: " + resource + " found in: " + s);
        }
        int begin = -1;
        begin = s.indexOf("file:");
        if (begin < 0) {
            begin = s.indexOf(":");
            ++begin;
        } else {
            begin += 5;
        }
        s = s.substring(begin);
        if (s.indexOf(":") != -1 && s.indexOf("/") == 0) {
            s = s.substring(1);
        }
        if (DEBUG) {
            Logger.logInfo("ResourceLoader() after stripping:" + s);
        }
        if ((i = s.indexOf("!")) > -1) {
            String zipstring = s.substring(0, i);
            if ((i = zipstring.lastIndexOf("/")) == -1) {
                i = zipstring.lastIndexOf("\\");
            }
            zipstring = zipstring.substring(0, i);
            if (DEBUG) {
                Logger.logInfo("ResourceLoader() returning zipstring Final Working Directory Setting: " + zipstring);
            }
            return zipstring;
        }
        if (DEBUG) {
            Logger.logInfo("ResourceLoader() returning Final Working Directory Setting: " + s);
        }
        return s;
    }

    public static String Decode(String s) {
        Object[] tmpstr = new String[]{s, "ISO-8859-1"};
        String ret = s;
        ret = (String)ResourceLoader.executeIfSupported(decodr, tmpstr, "decode");
        if (ret == null) {
            try {
                ret = URLDecoder.decode(s, "ISO-8859-1");
            }
            catch (Exception e) {
                Logger.logErr("ResourceLoader.Decode resource failed: " + e.toString());
            }
        }
        return ret;
    }

    public static String Decode(String s, String encoding) {
        Object[] tmpstr = new String[]{s, "Encoding"};
        String ret = s;
        ret = (String)ResourceLoader.executeIfSupported(decodr, tmpstr, "decode");
        if (ret == null) {
            try {
                ret = URLDecoder.decode(s);
            }
            catch (Exception e) {
                Logger.logErr("ResourceLoader.Decode resource failed: " + e.toString());
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object executeIfSupported(Object ob, Object[] args, String methname) {
        try {
            Object retob = null;
            Method[] mt = ob.getClass().getMethods();
            int t = 0;
            while (true) {
                String nm;
                if (t >= mt.length) {
                    return retob;
                }
                int numparms = 0;
                int numargs = 0;
                if (args != null) {
                    numargs = args.length;
                }
                if (mt[t].getParameterTypes() != null) {
                    numparms = mt[t].getParameterTypes().length;
                }
                if ((nm = mt[t].getName()).equals(methname) && numparms == numargs) {
                    try {
                        Method mx = mt[t];
                        return mx.invoke(ob, args);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                ++t;
            }
        }
        catch (NoSuchMethodError e) {
            return null;
        }
    }

    public static Object execute(Object ob, Object[] args, String methname) throws Exception {
        Class[] pc = new Class[args.length];
        int r2 = 0;
        while (r2 < args.length) {
            pc[r2] = args[r2].getClass();
            ++r2;
        }
        Method mt = null;
        try {
            mt = ob.getClass().getMethod(methname, pc);
        }
        catch (NoSuchMethodException e) {
            return ResourceLoader.executeIfSupported(ob, args, methname);
        }
        try {
            return mt.invoke(ob, args);
        }
        catch (Exception e) {
            Logger.logErr("ResourceLoader.execute " + methname + " on " + ob.getClass().getName() + " failed: " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public void setDebug(boolean b) {
        DEBUG = b;
    }
}

