/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import java.net.URI;

public class BrowserLauncher {
    public static final String[] browsers = new String[]{"google-chrome", "firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla"};
    private static String browser = null;

    public static void open(String url) throws Exception {
        try {
            Class<?> desktop = Class.forName("java.awt.Desktop");
            desktop.getDeclaredMethod("browse", URI.class).invoke(desktop.getDeclaredMethod("getDesktop", null).invoke(null, null), URI.create(url));
            return;
        }
        catch (ClassNotFoundException desktop) {
        }
        catch (NoSuchMethodException desktop) {
        }
        catch (Exception e) {
            throw new Exception("failed to launch browser", e);
        }
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                if (browser == null) {
                    int idx = 0;
                    while (idx < browsers.length) {
                        if (Runtime.getRuntime().exec(new String[]{"which", browsers[idx]}).waitFor() == 0) {
                            browser = browsers[idx];
                        }
                        ++idx;
                    }
                    if (browser == null) {
                        throw new Exception("no browser found");
                    }
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            throw new Exception("failed to launch browser", e);
        }
    }
}

