/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.escher;

import com.extentech.formats.escher.EscherRecord;
import com.extentech.toolkit.ByteTools;

public class MsofbtSplitMenuColors
extends EscherRecord {
    private static final long serialVersionUID = 5888748984363726576L;
    int fillColor = 0x800000D;
    int lineColor = 0x800000C;
    int shadowColor = 134217751;
    int _3dColor = 268435703;

    public MsofbtSplitMenuColors(int fbt, int inst, int version) {
        super(fbt, inst, version);
    }

    @Override
    protected byte[] getData() {
        byte[] fillColorBytes = ByteTools.cLongToLEBytes(this.fillColor);
        byte[] lineColorBytes = ByteTools.cLongToLEBytes(this.lineColor);
        byte[] shadowColorBytes = ByteTools.cLongToLEBytes(this.shadowColor);
        byte[] _3dColorBytes = ByteTools.cLongToLEBytes(this._3dColor);
        byte[] totalBytes = new byte[16];
        System.arraycopy(fillColorBytes, 0, totalBytes, 0, 4);
        System.arraycopy(lineColorBytes, 0, totalBytes, 4, 4);
        System.arraycopy(shadowColorBytes, 0, totalBytes, 8, 4);
        System.arraycopy(_3dColorBytes, 0, totalBytes, 12, 4);
        this.setLength(16);
        this.setInst(4);
        return totalBytes;
    }

    public int get3dColor() {
        return this._3dColor;
    }

    public void set3dColor(int color) {
        this._3dColor = color;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(int lineColor) {
        this.lineColor = lineColor;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.shadowColor = shadowColor;
    }
}

