/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.cellformat;

import com.extentech.ExtenXLS.Cell;
import com.extentech.formats.cellformat.CellFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class NumberCellFormat
extends NumberFormat
implements CellFormat {
    private static final long serialVersionUID = -7191923168789058338L;
    private final String positive;
    private final String negative;
    private final String zero;
    private final String string;

    NumberCellFormat(String positive, String negative, String zero, String string) {
        this.positive = positive;
        this.negative = negative;
        this.zero = zero;
        this.string = string;
    }

    @Override
    public StringBuffer format(Object input, StringBuffer buffer, FieldPosition pos) {
        if (input instanceof String) {
            if ("%s".equals(this.positive)) {
                return buffer.append(String.valueOf(input));
            }
            try {
                Double d = new Double(input.toString());
                input = d;
            }
            catch (NumberFormatException e) {
                return buffer.append(String.format(this.string, (String)input));
            }
        }
        if (input instanceof Number) {
            String format;
            double value = ((Number)input).doubleValue();
            if (value > 0.0) {
                format = this.positive;
            } else if (value < 0.0) {
                format = this.negative;
                value = Math.abs(value);
            } else {
                format = this.zero;
            }
            if (format.contains("%%")) {
                value *= 100.0;
            }
            if ("%s".equals(format)) {
                return buffer.append(String.valueOf(input));
            }
            return buffer.append(String.format(format, value));
        }
        throw new IllegalArgumentException("unsupported input type");
    }

    @Override
    public StringBuffer format(double number, StringBuffer buffer, FieldPosition pos) {
        return buffer.append(this.format((Object)number));
    }

    @Override
    public StringBuffer format(long number, StringBuffer buffer, FieldPosition pos) {
        return buffer.append(this.format((Object)number));
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String format(Cell cell) {
        return this.format(cell.getVal());
    }
}

