/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.toolkit.ByteTools;

public class PtgRefErr3d
extends PtgRef3d
implements Ptg {
    private static final long serialVersionUID = 8691902605148033701L;

    @Override
    public boolean getIsRefErr() {
        return true;
    }

    public PtgRefErr3d() {
        this.record = new byte[7];
        this.record[0] = 60;
    }

    @Override
    public String getString() {
        if (this.sheetname == null) {
            return "#REF!";
        }
        return String.valueOf(this.sheetname) + "!#REF!";
    }

    @Override
    public int getLength() {
        return 7;
    }

    @Override
    public void populateVals() {
        this.ixti = ByteTools.readShort(this.record[1], this.record[2]);
        if (this.ixti > 0) {
            this.sheetname = GenericPtg.qualifySheetname(this.getSheetName());
        }
    }

    @Override
    public int[] getRowCol() {
        return new int[]{-1, -1};
    }

    @Override
    public Object getValue() {
        if (this.sheetname == null) {
            return "#REF!";
        }
        return String.valueOf(this.sheetname) + "!#REF!";
    }

    @Override
    public String getLocation() {
        if (this.sheetname == null) {
            return "#REF!";
        }
        return String.valueOf(this.sheetname) + "!#REF!";
    }

    @Override
    public void setLocation(String[] s) {
        this.sheetname = GenericPtg.qualifySheetname(s[0]);
    }
}

