/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgMemFunc;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.formats.XLS.formulas.PtgRefErr;
import com.extentech.formats.XLS.formulas.PtgRefErr3d;
import com.extentech.formats.cellformat.CellFormatFactory;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;

public class PtgRef
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -7776520933300730470L;
    protected int rw;
    protected boolean fRwRel = true;
    protected boolean fColRel = true;
    protected int col;
    protected boolean is3dRef = false;
    private String cachedLocation = null;
    protected int formulaRow;
    protected int formulaCol;
    BiffRec[] refCell = new BiffRec[1];
    protected String sheetname = null;
    protected int externalLink1 = 0;
    protected int externalLink2 = 0;
    protected boolean useReferenceTracker = true;
    String locax = null;
    public long hashcode = -1L;
    public boolean wholeRow = false;
    public boolean wholeCol = false;

    public boolean equals(Object ob) {
        return ob.hashCode() == this.hashCode();
    }

    public boolean getIsWholeRow() {
        return this.wholeRow;
    }

    public void setIsWholeRow(boolean b) {
        this.wholeRow = b;
    }

    public boolean getIsWholeCol() {
        return this.wholeCol;
    }

    public void setIsWholeCol(boolean b) {
        this.wholeCol = b;
    }

    public boolean getIsRefErr() {
        return false;
    }

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public boolean getIsReference() {
        return true;
    }

    public PtgRef(int[] rowcol, XLSRecord x, boolean useRefTracker) {
        this();
        this.setParentRec(x);
        this.useReferenceTracker = useRefTracker;
        this.setLocation(rowcol);
        this.updateRecord();
    }

    public PtgRef(String location, XLSRecord x, boolean utilizeRefTracker) {
        this.setUseReferenceTracker(utilizeRefTracker);
        this.ptgId = (byte)68;
        this.record = new byte[5];
        this.record[0] = this.ptgId;
        this.setParentRec(x);
        this.setLocation(location);
        this.setIsWholeRowCol();
        if (this.useReferenceTracker) {
            this.addToRefTracker();
        }
    }

    public void setPtgType(short type) {
        switch (type) {
            case 0: {
                this.ptgId = (byte)68;
                break;
            }
            case 1: {
                this.ptgId = (byte)36;
                break;
            }
            case 2: {
                this.ptgId = (byte)100;
            }
        }
        this.record[0] = this.ptgId;
    }

    public PtgRef(byte[] bin, XLSRecord x, boolean utilizeRefTracker) {
        this();
        this.setUseReferenceTracker(utilizeRefTracker);
        this.setParentRec(x);
        this.init(bin);
        if (this.useReferenceTracker) {
            this.addToRefTracker();
        }
    }

    public PtgRef() {
        this.ptgId = (byte)68;
        this.record = new byte[5];
        this.record[0] = this.ptgId;
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    public void setUseReferenceTracker(boolean b) {
        this.useReferenceTracker = b;
    }

    public boolean getUseReferenceTracker() {
        return this.useReferenceTracker;
    }

    protected void populateVals() {
        this.rw = this.readRow(this.record[1], this.record[2]);
        short column = ByteTools.readShort(this.record[3], this.record[4]);
        this.fRwRel = (column & 0x8000) == 32768;
        this.fColRel = (column & 0x4000) == 16384;
        this.col = (short)(column & 0x3FFF);
        this.setRelativeRowCol();
        this.setIsWholeRowCol();
        this.hashcode = this.getHashCode();
    }

    public boolean is3dRef() {
        return this.is3dRef;
    }

    @Override
    public String getString() {
        return this.getLocation();
    }

    public String getLocationWithSheet() {
        String ret = this.getString();
        if (ret == null && this.parent_rec.getOpcode() == 4177) {
            return this.parent_rec.toString();
        }
        if (ret == null) {
            return "";
        }
        if (ret.indexOf("!") > -1) {
            return ret;
        }
        ret = String.valueOf(this.sheetname) + "!" + ret;
        return ret;
    }

    public String toString() {
        return this.getString();
    }

    public int[] getRowCol() {
        int[] ret = new int[]{this.rw, this.col};
        if (this.rw < 0) {
            ret[0] = 65536;
            this.wholeCol = true;
        }
        return ret;
    }

    public void setSheetName(String sheetname) {
        this.sheetname = sheetname;
    }

    @Override
    public String getLocation() {
        String s;
        if (this.locax != null) {
            return this.locax;
        }
        int[] adjusted = this.getIntLocation();
        if (this.wholeCol) {
            s = String.valueOf(this.fColRel ? "" : "$") + ExcelTools.getAlphaVal(adjusted[1]);
        } else if (this.wholeRow) {
            s = String.valueOf(this.fRwRel ? "" : "$") + String.valueOf(adjusted[0] + 1);
        } else {
            if (this.rw < 0 || this.col < 0) {
                return new PtgRefErr().toString();
            }
            s = String.valueOf(this.fColRel ? "" : "$") + ExcelTools.getAlphaVal(adjusted[1]) + (this.fRwRel ? "" : "$") + String.valueOf(adjusted[0] + 1);
        }
        this.locax = s;
        return this.locax;
    }

    @Override
    public int[] getIntLocation() {
        this.setIsWholeRowCol();
        int rowNew = this.rw;
        int colNew = this.col;
        try {
            boolean isExcel2007 = this.parent_rec.getWorkBook().getIsExcel2007();
            if (this.fRwRel) {
                rowNew += this.formulaRow;
            }
            if (this.fColRel) {
                colNew += this.formulaCol;
            }
            if (this.wholeRow) {
                colNew = !isExcel2007 ? 256 : 16384;
            }
            if (this.wholeCol) {
                rowNew = isExcel2007 ? 1048575 : 65535;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new int[]{rowNew, colNew};
    }

    public int[] getRealIntLocation() {
        int rowNew = this.rw;
        int colNew = this.col;
        if (this.fRwRel) {
            rowNew += this.formulaRow;
        }
        if (this.fColRel) {
            colNew += this.formulaCol;
        }
        if (this.wholeCol || rowNew < 0) {
            try {
                if (rowNew < 0) {
                    this.wholeCol = true;
                }
                rowNew = this.getParentRec().getSheet().getMaxRow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.wholeRow || colNew >= 16384) {
            try {
                colNew = this.getParentRec().getSheet().getMaxCol();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int[] ret = new int[]{rowNew, colNew};
        return ret;
    }

    public String getSheetName() throws WorkSheetNotFoundException {
        if (this.locax != null && this.locax.indexOf("!") > -1) {
            this.sheetname = this.locax.substring(0, this.locax.indexOf("!"));
        }
        if (this.sheetname == null && this.parent_rec != null && this.parent_rec.getSheet() != null) {
            this.sheetname = this.parent_rec.getSheet().getSheetName();
        }
        if (this.sheetname == null) {
            return "";
        }
        if (this.externalLink1 > 0) {
            if (this.sheetname.charAt(0) == '\'') {
                this.sheetname = this.sheetname.substring(1, this.sheetname.length() - 1);
            }
            this.sheetname = "[" + this.externalLink1 + "]" + this.sheetname;
        }
        this.sheetname = PtgRef.qualifySheetname(this.sheetname);
        return this.sheetname;
    }

    @Override
    public void setLocation(String address) {
        this.locax = null;
        this.refCell = null;
        if (this.record != null) {
            String[] s = ExcelTools.stripSheetNameFromRange(address);
            this.setLocation(s);
            this.locax = s[1];
        } else {
            Logger.logWarn("PtgRef.setLocation() failed: NO record data: " + address);
        }
    }

    public void clearLocationCache() {
        this.locax = null;
    }

    private boolean referencesEntireRow() {
        boolean isExcel2007 = this.parent_rec.getWorkBook().getIsExcel2007();
        int colNew = this.col;
        if (this.fColRel) {
            colNew += this.formulaRow;
        }
        if (colNew < 0) {
            return true;
        }
        if (colNew >= 255 && !isExcel2007) {
            return true;
        }
        if (this.cachedLocation != null && isExcel2007) {
            return this.locationStringReferencesEntireRow();
        }
        return colNew == 255 && isExcel2007;
    }

    private boolean locationStringReferencesEntireRow() {
        int[] res;
        return this.cachedLocation != null && (res = ExcelTools.getRowColFromString(this.cachedLocation))[1] < 0;
    }

    private boolean referencesEntireCol() {
        int rowNew = this.rw;
        boolean isExcel2007 = this.parent_rec.getWorkBook().getIsExcel2007();
        if (this.fRwRel) {
            rowNew += this.formulaRow;
        }
        if (rowNew < 0) {
            return true;
        }
        if (rowNew >= 65535 && !isExcel2007) {
            rowNew = -1;
            return true;
        }
        return false;
    }

    protected void setIsWholeRowCol() {
        this.wholeCol = this.referencesEntireCol();
        this.wholeRow = this.referencesEntireRow();
    }

    public void setLocation(String[] loc) {
        String addr;
        if (this.useReferenceTracker) {
            this.removeFromRefTracker();
        }
        this.locax = null;
        this.sheetname = loc[0];
        this.cachedLocation = addr = loc[1];
        this.fRwRel = true;
        this.fColRel = true;
        if (addr.indexOf("$") == -1) {
            if (!addr.equals("#REF!") && !addr.equals("")) {
                int[] res = ExcelTools.getRowColFromString(addr);
                this.col = res[1];
                this.rw = res[0];
            } else {
                this.col = -1;
                this.rw = -1;
            }
        } else {
            if (addr.substring(0, 1).equalsIgnoreCase("$")) {
                this.fColRel = false;
                addr = addr.substring(1, addr.length());
            }
            if (addr.indexOf("$") != -1) {
                this.fRwRel = false;
                addr = StringTool.strip(addr, "$");
            }
            int[] res = null;
            try {
                res = ExcelTools.getRowColFromString(addr);
                this.col = res[1];
                this.rw = res[0];
                if (this.col == -1 || this.rw == -1) {
                    this.fColRel = false;
                    this.fRwRel = false;
                }
            }
            catch (IllegalArgumentException ie) {
                if (Character.isDigit(addr.charAt(0))) {
                    this.col = 255;
                    this.rw = Integer.valueOf(addr) - 1;
                    this.fColRel = false;
                    this.fRwRel = false;
                }
                this.rw = -1;
                this.col = ExcelTools.getIntVal(addr);
                this.fColRel = false;
                this.fRwRel = false;
            }
        }
        if (this.col == -1) {
            this.wholeRow = true;
        }
        if (this.rw == -1) {
            this.wholeCol = true;
        }
        this.setIsWholeRowCol();
        this.updateRecord();
        this.hashcode = this.getHashCode();
        if (loc[3] != null) {
            this.externalLink1 = Integer.valueOf(loc[3].substring(1, loc[3].length() - 1));
        }
        if (loc[4] != null) {
            this.externalLink2 = Integer.valueOf(loc[4].substring(1, loc[4].length() - 1));
        }
        if (this.useReferenceTracker && !this.getIsRefErr() && !this.getIsWholeCol() && !this.getIsWholeRow()) {
            this.addToRefTracker();
        }
    }

    public void setLocation(int[] rowcol) {
        this.locax = null;
        this.cachedLocation = null;
        if (this.record != null) {
            if (this.useReferenceTracker) {
                this.removeFromRefTracker();
            }
            this.rw = rowcol[0];
            this.col = rowcol[1];
            this.fRwRel = true;
            this.fColRel = true;
            this.updateRecord();
            this.hashcode = this.getHashCode();
            if (this.useReferenceTracker) {
                this.addToRefTracker();
            }
        } else {
            Logger.logWarn("PtgRef.setLocation() failed: NO record data: " + rowcol.toString());
        }
    }

    public static Ptg createPtgRefFromString(String address, XLSRecord parent) {
        try {
            GenericPtg ptg;
            String[] s = ExcelTools.stripSheetNameFromRange(address);
            String sh1 = s[0];
            String range = s[1];
            if (range == null || range.equals("#REF!") || sh1 != null && sh1.equals("#REF")) {
                if (sh1 != null) {
                    PtgRefErr3d pe3 = new PtgRefErr3d();
                    pe3.setParentRec(parent);
                    pe3.setLocation(s);
                    return pe3;
                }
                PtgRefErr pe = new PtgRefErr();
                pe.setParentRec(parent);
                pe.setLocation(s);
                return pe;
            }
            WorkBook bk = parent.getWorkBook();
            String sht = "((?:\\\\?+.)*?!)?+";
            String rangeMatch = "(.*(:).*){2,}?";
            String opMatch = "(.*([ ,]).*)+";
            String m = String.valueOf(sht) + "((" + opMatch + ")|(" + rangeMatch + "))";
            if (address.matches(m) || range.indexOf("(") > -1) {
                PtgMemFunc pmf = new PtgMemFunc();
                pmf.setParentRec(parent);
                pmf.setLocation(address);
                ptg = pmf;
            } else if (range.indexOf(":") > 0) {
                String[] ops = StringTool.getTokensUsingDelim(range, ":");
                if (bk.getName(ops[0]) != null || bk.getName(ops[1]) != null) {
                    PtgMemFunc pmf = new PtgMemFunc();
                    pmf.setParentRec(parent);
                    pmf.setLocation(address);
                    ptg = pmf;
                } else if (sh1 != null) {
                    int[] rc = ExcelTools.getRowColFromString(ops[0]);
                    if (!ops[0].equals(ops[1]) || rc[0] == -1 || rc[1] == -1) {
                        PtgArea3d pta = new PtgArea3d();
                        pta.setParentRec(parent);
                        pta.setLocation(s);
                        ptg = pta;
                    } else {
                        ptg = new PtgRef3d();
                        ((PtgRef3d)ptg).setPtgType((short)1);
                        ptg.setParentRec(parent);
                        ((PtgRef)ptg).setUseReferenceTracker(false);
                        ((PtgRef3d)ptg).setLocation(s);
                        ((PtgRef)ptg).setUseReferenceTracker(true);
                        ((PtgRef3d)ptg).addToRefTracker();
                    }
                } else {
                    PtgArea pa = new PtgArea();
                    pa.setParentRec(parent);
                    pa.setUseReferenceTracker(false);
                    pa.setLocation(s);
                    pa.setUseReferenceTracker(true);
                    pa.addToRefTracker();
                    ptg = pa;
                }
            } else if (sh1 != null) {
                ptg = new PtgRef3d();
                ((PtgRef3d)ptg).setPtgType((short)1);
                ptg.setParentRec(parent);
                ((PtgRef)ptg).setUseReferenceTracker(false);
                ((PtgRef3d)ptg).setLocation(s);
                ((PtgRef)ptg).setUseReferenceTracker(true);
                ((PtgRef3d)ptg).addToRefTracker();
            } else {
                PtgRef pr = new PtgRef();
                pr.setParentRec(parent);
                pr.setUseReferenceTracker(false);
                pr.setLocation(s);
                pr.setUseReferenceTracker(true);
                pr.addToRefTracker();
                ptg = pr;
            }
            return ptg;
        }
        catch (Exception e) {
            PtgRefErr3d pe3 = new PtgRefErr3d();
            pe3.setParentRec(parent);
            return pe3;
        }
    }

    public void setLocation(int[] rowcol, boolean bRowRel, boolean bColRel) {
        this.locax = null;
        this.cachedLocation = null;
        if (this.record != null) {
            if (this.useReferenceTracker) {
                this.removeFromRefTracker();
            }
            this.rw = rowcol[0];
            this.col = rowcol[1];
            this.fRwRel = bRowRel;
            this.fColRel = bColRel;
            this.updateRecord();
            if (this.useReferenceTracker) {
                this.addToRefTracker();
            }
        } else {
            Logger.logWarn("PtgRef.setLocation() failed: NO record data: " + rowcol.toString());
        }
    }

    @Override
    public void updateRecord() {
        byte[] tmp = new byte[5];
        tmp[0] = this.record[0];
        byte[] brow = ByteTools.cLongToLEBytes(this.rw);
        System.arraycopy(brow, 0, tmp, 1, 2);
        if (this.fRwRel) {
            this.col = (short)(0x8000 | this.col);
        }
        if (this.fColRel) {
            this.col = (short)(0x4000 | this.col);
        }
        byte[] bcol = ByteTools.cLongToLEBytes(this.col);
        if (this.col == -1) {
            bcol[1] = 0;
        }
        System.arraycopy(bcol, 0, tmp, 3, 2);
        this.record = tmp;
        if (this.parent_rec != null) {
            if (this.parent_rec instanceof Formula) {
                ((Formula)this.parent_rec).updateRecord();
            } else if (this.parent_rec instanceof Name) {
                ((Name)this.parent_rec).updatePtgs();
            }
        }
        this.col = (short)this.col & 0x3FFF;
    }

    @Override
    public int getLength() {
        return 5;
    }

    @Override
    public boolean isBlank() {
        this.getRefCells();
        return this.refCell[0] == null || ((XLSRecord)this.refCell[0]).isBlank;
    }

    @Override
    public Object getValue() {
        this.getRefCells();
        Object retValue = null;
        if (this.refCell[0] != null) {
            if (this.refCell[0].getFormulaRec() != null) {
                Formula f = this.refCell[0].getFormulaRec();
                retValue = f.calculateFormula();
                return retValue;
            }
            if (this.refCell[0].getDataType().equals("Float")) {
                retValue = new Double(this.refCell[0].getDblVal());
                return retValue;
            }
            retValue = this.refCell[0].getInternalVal();
            return retValue;
        }
        try {
            if (!this.parent_rec.getSheet().getWindow2().getShowZeroValues()) {
                return null;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public String getFormattedValue() {
        this.getRefCells();
        Object retValue = null;
        BiffRec cell = this.refCell[0];
        if (cell != null) {
            if (cell.getFormulaRec() != null) {
                Formula f = cell.getFormulaRec();
                retValue = f.calculateFormula();
            } else {
                retValue = cell.getDataType().equals("Float") ? new Double(cell.getDblVal()) : cell.getInternalVal();
            }
            return CellFormatFactory.fromPatternString(cell.getXfRec().getFormatPattern()).format(retValue);
        }
        try {
            if (!this.parent_rec.getSheet().getWindow2().getShowZeroValues()) {
                return "";
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "0";
    }

    public BiffRec[] getRefCells() {
        this.refCell = new BiffRec[1];
        try {
            Boundsheet bs = null;
            if (this.sheetname != null && this.parent_rec != null) {
                bs = this.parent_rec.getWorkBook().getWorkSheetByName(this.sheetname);
            } else if (this.parent_rec != null) {
                bs = this.parent_rec.getSheet();
            }
            this.refCell[0] = bs.getCell(this.rw, this.col);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.refCell;
    }

    public boolean changeLocation(String newLoc, Formula f) {
        this.locax = null;
        Ptg ptg = null;
        int z = -1;
        try {
            z = ExpressionParser.getExpressionLocByPtg(this, f.getExpression());
            ptg = (Ptg)f.getExpression().get(z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String unstripped = newLoc;
        if (newLoc.indexOf("!") > -1) {
            newLoc = newLoc.substring(newLoc.indexOf("!") + 1);
        }
        if (unstripped.indexOf(":") > 0) {
            if (unstripped.indexOf("!") > unstripped.indexOf(":")) {
                if (unstripped.indexOf(":") != unstripped.lastIndexOf(":")) {
                    PtgArea3d pta3 = new PtgArea3d();
                    pta3.setLocation(unstripped);
                    ptg = pta3;
                } else {
                    PtgRef3d prd = new PtgRef3d();
                    prd.setParentRec(f);
                    prd.setLocation(unstripped);
                    ptg = prd;
                }
            } else {
                PtgArea pta = new PtgArea();
                pta.setParentRec(f);
                pta.setLocation(unstripped);
                ptg = pta;
            }
        } else if (ptg != null) {
            if (!unstripped.equals("")) {
                ptg.setParentRec(f);
                ptg.setLocation(unstripped);
            } else {
                ptg = new PtgRef3d();
                ptg.setParentRec(f);
            }
        } else {
            ptg = new PtgRef();
            ptg.setParentRec(f);
            ptg.setLocation(unstripped);
        }
        if (z != -1) {
            f.getExpression().set(z, ptg);
        } else {
            f.getExpression().add(ptg);
        }
        return true;
    }

    @Override
    public void setParentRec(XLSRecord f) {
        this.parent_rec = f;
        this.setRelativeRowCol();
    }

    public void removeFromRefTracker() {
        try {
            if (this.parent_rec != null) {
                this.parent_rec.getWorkBook().getRefTracker().removeCellRange(this);
                if (this.parent_rec.getOpcode() == 6) {
                    ((Formula)this.parent_rec).setCachedValue(null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addToRefTracker() {
        try {
            if (this.parent_rec != null) {
                this.parent_rec.getWorkBook().getRefTracker().addCellRange(this);
            }
        }
        catch (Exception ex) {
            Logger.logErr("PtgRef.addToRefTracker() failed.", ex);
        }
    }

    public void updateInRefTracker(XLSRecord parent) {
        try {
            if (parent != null) {
                parent.getWorkBook().getRefTracker().updateInRefTracker(this, parent);
            }
        }
        catch (Exception ex) {
            Logger.logErr("updateInRefTracker() failed.", ex);
        }
    }

    public void setRelativeRowCol() {
        if (this.fRwRel || this.fColRel) {
            int opc = 0;
            if (this.parent_rec != null) {
                opc = this.parent_rec.getOpcode();
            }
            if (opc == 1212 || opc == 434) {
                this.formulaRow = this.parent_rec.getRowNumber();
                this.formulaCol = this.parent_rec.getColNumber();
            }
        }
    }

    public void setExternalReference(String externalWorkbook) {
        if (this instanceof PtgArea3d) {
            PtgArea3d ptg = (PtgArea3d)this;
            WorkBook b = this.parent_rec.getWorkBook();
            if (b == null) {
                b = this.parent_rec.getSheet().getWorkBook();
            }
            short ixti = b.getExternSheet().addExternalSheetRef(externalWorkbook, ptg.getSheetName());
            ptg.setIxti(ixti);
            if (ptg.firstPtg != null) {
                ptg.firstPtg.updateRecord();
                ptg.lastPtg.updateRecord();
            }
            ptg.updateRecord();
        } else if (this instanceof PtgRef3d) {
            WorkBook b = this.parent_rec.getWorkBook();
            PtgRef3d pr = (PtgRef3d)this;
            if (b == null) {
                b = this.parent_rec.getSheet().getWorkBook();
            }
            short ixti = b.getExternSheet().addExternalSheetRef(externalWorkbook, pr.getSheetName());
            pr.setIxti(ixti);
        } else {
            Logger.logWarn("PtgRef.setExternalReference: unable to convert ref");
        }
    }

    public boolean isRowRel() {
        return this.fRwRel;
    }

    public boolean isColRel() {
        return this.fColRel;
    }

    public void setColRel(boolean relative) {
        if (this.fColRel != relative) {
            this.locax = null;
            this.fColRel = relative;
            this.updateRecord();
        }
    }

    public void setRowRel(boolean relative) {
        if (this.fRwRel != relative) {
            this.locax = null;
            this.fRwRel = relative;
            this.updateRecord();
        }
    }

    public void setArrayTypeRef() {
        byte b;
        this.record[0] = b = (byte)(this.record[0] | 0x60);
    }

    protected long getHashCode() {
        if (this.rw >= 0) {
            return this.col + (this.rw + 1) * 16384;
        }
        return this.col + (0x100000 - this.rw + 1) * 16384;
    }

    public static long getHashCode(int row, int col) {
        return col + (row + 1) * 16384;
    }

    @Override
    public void close() {
        if (this.useReferenceTracker) {
            this.removeFromRefTracker();
        }
        this.useReferenceTracker = false;
        super.close();
        if (this.refCell != null && this.refCell.length > 0 && this.refCell[0] != null) {
            ((XLSRecord)this.refCell[0]).close();
        }
        this.refCell = null;
    }
}

