/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.formulas.IxtiListener;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.toolkit.ByteTools;

public class PtgNameX
extends PtgName
implements Ptg,
IxtiListener {
    private static final long serialVersionUID = 1240996941619495505L;
    short ixti;
    int ilbl;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public Name getName() {
        WorkBook b = this.getParentRec().getSheet().getWorkBook();
        Name n = null;
        try {
            n = b.getName(this.ilbl);
            n.setSheet(this.getParentRec().getSheet());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void addListener() {
        try {
            this.getParentRec().getWorkBook().getExternSheet().addPtgListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    private void populateVals() {
        this.ixti = ByteTools.readShort(this.record[1], this.record[2]);
        this.ilbl = ByteTools.readShort(this.record[3], this.record[4]);
    }

    @Override
    public int getVal() {
        return this.ilbl;
    }

    @Override
    public Object getValue() {
        WorkBook b = this.getParentRec().getSheet().getWorkBook();
        String externalname = null;
        try {
            externalname = b.getExternalName(this.ilbl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (externalname != null) {
            return externalname;
        }
        Name n = this.getName();
        return n.getCalculatedValue();
    }

    @Override
    public String toString() {
        if (this.parent_rec.getSheet() != null) {
            return (String)this.getValue();
        }
        return "Uninitialized PtgNameX";
    }

    @Override
    public String getTextString() {
        Object o = this.getValue();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public int getLength() {
        return 7;
    }

    @Override
    public short getIxti() {
        return this.ixti;
    }

    @Override
    public void setIxti(short ixti) {
        this.ixti = ixti;
    }

    @Override
    public void setName(String name) {
        this.ptgId = (byte)57;
        this.record = new byte[7];
        this.record[0] = this.ptgId;
        WorkBook b = this.getParentRec().getSheet().getWorkBook();
        this.ilbl = b.getExtenalNameNumber(name);
        this.ixti = (short)b.getExternSheet().getVirtualReference();
        byte[] bb = ByteTools.shortToLEBytes(this.ixti);
        this.record[1] = bb[0];
        this.record[2] = bb[1];
        byte[] bbb = ByteTools.cLongToLEBytes(this.ilbl);
        this.record[3] = bbb[0];
        this.record[4] = bbb[1];
    }
}

