/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.toolkit.Logger;
import java.lang.reflect.Array;

public class PtgLT
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -2568203115024599915L;

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    @Override
    public boolean getIsBinaryOperator() {
        return true;
    }

    public PtgLT() {
        this.ptgId = (byte)9;
        this.record = new byte[1];
        this.record[0] = 9;
    }

    @Override
    public String getString() {
        return "<";
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Ptg calculatePtg(Ptg[] form) {
        try {
            Object[] o = GenericPtg.getValuesFromPtgs(form);
            if (o == null) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            if (!o[0].getClass().isArray()) {
                boolean res;
                if (o.length != 2) {
                    Logger.logWarn("calculating formula failed, wrong number of values in PtgLT");
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                boolean isDouble = false;
                int i = 0;
                while (i < 2 && !isDouble) {
                    if (!form[i].isBlank()) {
                        isDouble = o[i] instanceof Double;
                    }
                    ++i;
                }
                i = 0;
                while (i < 2) {
                    if (form[i].isBlank()) {
                        o[i] = isDouble ? new Double(0.0) : "";
                    }
                    ++i;
                }
                if (o[0] instanceof Double && o[1] instanceof Double) {
                    res = (Double)o[0] < (Double)o[1];
                } else {
                    if (Formula.isErrorValue(o[0].toString())) {
                        return new PtgErr(PtgErr.convertStringToLookupByte(o[0].toString()));
                    }
                    if (Formula.isErrorValue(o[1].toString())) {
                        return new PtgErr(PtgErr.convertStringToLookupByte(o[1].toString()));
                    }
                    res = o[0].toString().compareTo(o[1].toString()) < 0;
                }
                PtgBool pboo = new PtgBool(res);
                return pboo;
            }
            boolean res = false;
            String retArry = "";
            int nArrays = Array.getLength(o);
            if (nArrays != 2) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            int nVals = Array.getLength(o[0]);
            int i = 0;
            while (i < nArrays - 1) {
                res = false;
                Object secondOp = null;
                boolean comparitorIsArray = o[i + 1].getClass().isArray();
                if (!comparitorIsArray) {
                    secondOp = o[i + 1];
                }
                int j = 0;
                while (j < nVals) {
                    Object firstOp = Array.get(o[i], j);
                    if (comparitorIsArray) {
                        secondOp = Array.get(o[i + 1], j);
                    }
                    if (firstOp instanceof Double && secondOp instanceof Double) {
                        res = ((Double)firstOp).compareTo((Double)secondOp) < 0;
                    } else {
                        if (Formula.isErrorValue(o[0].toString())) {
                            return new PtgErr(PtgErr.convertStringToLookupByte(o[0].toString()));
                        }
                        if (Formula.isErrorValue(o[1].toString())) {
                            return new PtgErr(PtgErr.convertStringToLookupByte(o[1].toString()));
                        }
                        res = o[0].toString().compareTo(o[1].toString()) < 0;
                    }
                    retArry = String.valueOf(retArry) + res + ",";
                    ++j;
                }
                i += 2;
            }
            retArry = "{" + retArry.substring(0, retArry.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(retArry);
            return pa;
        }
        catch (Exception ex) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }
}

