/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.FunctionConstants;
import com.extentech.formats.XLS.formulas.FunctionHandler;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgNameX;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import java.util.Locale;

public class PtgFuncVar
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = 1478629759437556620L;
    public static int LENGTH = 3;
    byte ptgId;
    String loc;
    byte cargs;
    boolean fprompt;
    short iftab;
    boolean fCE;

    public PtgFuncVar(int funcType, int numArgs, XLSRecord parentRec) {
        this(funcType, numArgs);
        this.setParentRec(parentRec);
    }

    public PtgFuncVar(int funcType, int numArgs) {
        byte[] recbyte = new byte[4];
        switch (funcType) {
            case 8: 
            case 9: 
            case 29: 
            case 102: 
            case 228: {
                recbyte[0] = 66;
                break;
            }
            default: {
                recbyte[0] = 34;
            }
        }
        byte[] b = ByteTools.shortToLEBytes((short)funcType);
        recbyte[1] = (byte)numArgs;
        recbyte[2] = b[0];
        recbyte[3] = b[1];
        this.init(recbyte);
    }

    public PtgFuncVar() {
    }

    @Override
    public boolean getIsFunction() {
        return true;
    }

    @Override
    public int getNumParams() {
        return this.cargs;
    }

    public void setNumParams(byte nParams) {
        this.record[1] = nParams;
        this.populateVals();
    }

    @Override
    public byte getOpcode() {
        return this.ptgId;
    }

    @Override
    public String getString() {
        if (this.iftab != 255) {
            String f = null;
            if (Locale.JAPAN.equals(Locale.getDefault())) {
                f = FunctionConstants.getJFunctionString(this.iftab);
            }
            if (f == null) {
                f = FunctionConstants.getFunctionString(this.iftab);
            }
            return f;
        }
        return this.getAddInFunctionString();
    }

    private String getAddInFunctionString() {
        if (this.vars != null && this.vars[0] instanceof PtgNameX) {
            return String.valueOf(((PtgNameX)this.vars[0]).toString()) + "(";
        }
        return "(";
    }

    @Override
    public String getString2() {
        return ")";
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = (byte)34;
        this.record = b;
        this.fprompt = false;
        this.fCE = false;
        this.populateVals();
    }

    public short getFunctionId() {
        return this.iftab;
    }

    private void populateVals() {
        this.cargs = this.record[1];
        if ((this.cargs & 0x80) == 128) {
            this.fprompt = true;
        }
        this.cargs = (byte)(this.cargs & 0x7F);
        this.iftab = ByteTools.readShort(this.record[2], this.record[3]);
        if ((this.iftab & 0x8000) == 32768) {
            this.fCE = true;
        }
        this.iftab = (short)(this.iftab & Short.MAX_VALUE);
    }

    public int getVal() {
        return this.iftab;
    }

    @Override
    public byte[] getRecord() {
        return this.record;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public Ptg calculatePtg(Ptg[] pthings) throws FunctionNotSupportedException, CalculationException {
        Ptg[] ptgarr = new Ptg[pthings.length + 1];
        ptgarr[0] = this;
        System.arraycopy(pthings, 0, ptgarr, 1, pthings.length);
        Ptg resPtg = FunctionHandler.calculateFunction(ptgarr);
        return resPtg;
    }

    public String toString() {
        return "FUNCVAR " + this.iftab;
    }

    public void adjustParameterIds() {
        if (this.vars == null) {
            return;
        }
        switch (this.iftab) {
            case 102: {
                this.setParameterType(0, (short)0);
                this.setParameterType(1, (short)1);
                this.setParameterType(2, (short)0);
                this.setParameterType(3, (short)0);
                break;
            }
            case 8: 
            case 9: {
                this.setParameterType(0, (short)1);
                break;
            }
            case 29: {
                this.setParameterType(0, (short)1);
                this.setParameterType(1, (short)0);
                break;
            }
            case 345: {
                this.setParameterType(0, (short)1);
                break;
            }
            case 228: {
                this.setParameterType(0, (short)2);
                this.setParameterType(1, (short)2);
                break;
            }
        }
    }

    private void setParameterType(int n, short type) {
        if (this.vars.length > n) {
            if (this.vars[n] instanceof PtgArea) {
                ((PtgArea)this.vars[n]).setPtgType(type);
            } else if (this.vars[n] instanceof PtgRef) {
                ((PtgRef)this.vars[n]).setPtgType(type);
            } else if (this.vars[n] instanceof PtgName) {
                ((PtgName)this.vars[n]).setPtgType(type);
            }
        }
    }
}

