/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Array;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.StringRec;
import com.extentech.formats.XLS.formulas.FormulaCalculator;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.ByteTools;
import java.util.Stack;

public class PtgExp
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -2150560716287810448L;
    int rwFirst;
    int colFirst;

    @Override
    public boolean getIsControl() {
        return true;
    }

    @Override
    public boolean getIsStandAloneOperator() {
        return true;
    }

    @Override
    public int getLength() {
        return 5;
    }

    public int getRwFirst() {
        return this.rwFirst;
    }

    public int getColFirst() {
        return this.colFirst;
    }

    public void init(int row, int col) {
        byte[] r2 = ByteTools.shortToLEBytes((short)row);
        byte[] c = ByteTools.shortToLEBytes((short)col);
        this.record = new byte[]{1, r2[0], r2[1], c[0], c[1]};
        this.ptgId = this.record[0];
        this.populateVals();
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    private void populateVals() {
        this.rwFirst = this.readRow(this.record[1], this.record[2]);
        this.colFirst = ByteTools.readShort(this.record[3], this.record[4]);
    }

    public String getReferent() {
        return ExcelTools.formatLocation(new int[]{this.rwFirst, this.colFirst});
    }

    public Ptg[] getConvertedExpression() {
        Formula f = (Formula)this.getParentRec();
        if (f.isSharedFormula()) {
            Stack expression = f.shared.instantiate(f);
            Ptg[] retPtg = new Ptg[expression.size()];
            int i = 0;
            while (i < expression.size()) {
                Ptg p;
                retPtg[i] = p = (Ptg)expression.get(i);
                ++i;
            }
            return retPtg;
        }
        Array a = (Array)f.getInternalRecords().get(0);
        Stack calcStack = a.getExpression();
        Ptg[] retPtg = new Ptg[calcStack.size()];
        int i = 0;
        while (i < calcStack.size()) {
            Ptg p;
            retPtg[i] = p = (Ptg)calcStack.get(i);
            ++i;
        }
        return retPtg;
    }

    @Override
    public Object getValue() {
        Object o = null;
        Formula f = (Formula)this.getParentRec();
        if (f.isSharedFormula()) {
            o = FormulaCalculator.calculateFormula(f.shared.instantiate(f));
        } else {
            Array r2 = null;
            r2 = f.getInternalRecords().size() > 0 ? (Array)f.getInternalRecords().get(0) : this.getParentRec().getSheet().getArrayFormula(this.getReferent());
            if (r2 instanceof Array) {
                Array arr = r2;
                o = arr.getValue(this);
            } else if (r2 instanceof StringRec) {
                o = ((StringRec)((Object)r2)).getStringVal();
            }
        }
        return o;
    }

    @Override
    public Ptg calculatePtg(Ptg[] parsething) {
        Object o = null;
        Formula f = (Formula)this.getParentRec();
        if (f.isSharedFormula()) {
            o = FormulaCalculator.calculateFormula(f.shared.instantiate(f));
        } else {
            Array r2 = null;
            r2 = f.getInternalRecords().size() > 0 ? (Array)f.getInternalRecords().get(0) : this.getParentRec().getSheet().getArrayFormula(this.getReferent());
            if (r2 instanceof Array) {
                Array arr = r2;
                o = arr.getValue(this);
            } else if (r2 instanceof StringRec) {
                o = ((StringRec)((Object)r2)).getStringVal();
            } else {
                throw new UnsupportedOperationException("Expected records parsing Formula were not present");
            }
        }
        GenericPtg p = null;
        if (o instanceof Integer) {
            return new PtgInt((Integer)o);
        }
        if (o instanceof Double) {
            return new PtgNumber((Double)o);
        }
        p = o.toString().equalsIgnoreCase("true") || o.toString().equalsIgnoreCase("false") ? new PtgBool(o.toString().equalsIgnoreCase("true")) : new PtgStr(o.toString());
        return p;
    }

    @Override
    public String getLocation() throws FormulaNotFoundException {
        String s = "";
        try {
            s = this.getParentRec().getCellAddress();
            s = String.valueOf(this.getParentRec().getSheet().getSheetName()) + "!" + s;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    @Override
    public String getString() {
        try {
            try {
                Boundsheet sht = this.getParentRec().getSheet();
                Formula f = (Formula)this.getParentRec();
                if (f.isSharedFormula()) {
                    String o = FormulaParser.getExpressionString(f.shared.instantiate(f));
                    if (o != null && o.toString().startsWith("=")) {
                        return o.toString().substring(1);
                    }
                    return o.toString();
                }
                Formula pr = (Formula)sht.getCell(this.getReferent());
                Object o = pr.getInternalRecords().get(0);
                if (o instanceof Array) {
                    Array a = (Array)o;
                    return a.getFormulaString();
                }
                if (o instanceof StringRec) {
                    if (((Formula)this.getParentRec()).isSharedFormula()) {
                        throw new IndexOutOfBoundsException("parse it");
                    }
                    StringRec s = (StringRec)o;
                    return s.getStringVal();
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new UnsupportedOperationException("Shared formulas must be instantiated for calculation");
            }
        }
        catch (Exception e) {
            return "Array-Entered or Shared Formula";
        }
        return "Array-Entered or Shared Formula";
    }

    @Override
    public void updateRecord() {
        System.arraycopy(ByteTools.shortToLEBytes((short)this.rwFirst), 0, this.record, 1, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.colFirst), 0, this.record, 3, 2);
    }

    @Override
    public void setLocation(String s) {
        int[] rc = ExcelTools.getRowColFromString(s);
        this.rwFirst = rc[0];
        this.colFirst = rc[1];
        this.updateRecord();
    }

    public void setColFirst(int c) {
        this.colFirst = c;
    }

    public void setRowFirst(int r2) {
        this.rwFirst = r2;
    }

    public String toString() {
        return "PtgExp: Parent Formula at [" + this.rwFirst + "," + this.colFirst + "]";
    }
}

