/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;

public class PtgErr
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -5201871987022621869L;
    public static byte ERROR_NULL = 0;
    public static byte ERROR_DIV_ZERO = (byte)7;
    public static byte ERROR_VALUE = (byte)15;
    public static byte ERROR_REF = (byte)23;
    public static byte ERROR_NAME = (byte)29;
    public static byte ERROR_NUM = (byte)36;
    public static byte ERROR_NA = (byte)42;
    private boolean isCircularError = false;
    private String errorValue = null;

    public boolean isCircularError() {
        return this.isCircularError;
    }

    public void setCircularError(boolean isCircularError) {
        this.isCircularError = isCircularError;
    }

    @Override
    public boolean getIsOperand() {
        return true;
    }

    public PtgErr() {
    }

    public PtgErr(byte errorV) {
        this.record = new byte[2];
        this.record[0] = 28;
        this.record[1] = errorV;
    }

    public byte getErrorType() {
        return this.record[1];
    }

    @Override
    public Object getValue() {
        return this.toString();
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
    }

    public String toString() {
        if (this.isCircularError()) {
            return "#CIR_ERR!";
        }
        byte b = this.record[1];
        if (b == ERROR_NULL) {
            this.errorValue = "#ERROR!";
        } else if (b == ERROR_DIV_ZERO) {
            this.errorValue = "#DIV/0!";
        } else if (b == ERROR_VALUE) {
            this.errorValue = "#VALUE!";
        } else if (b == ERROR_REF) {
            this.errorValue = "#REF!";
        } else if (b == ERROR_NAME) {
            this.errorValue = "#NAME?";
        } else if (b == ERROR_NUM) {
            this.errorValue = "#NUM!";
        } else if (b == ERROR_NA) {
            this.errorValue = "#N/A";
        }
        return this.errorValue;
    }

    public static byte convertStringToLookupByte(String errorString) {
        if (errorString.equals("#ERROR!")) {
            return ERROR_NULL;
        }
        if (errorString.equals("#DIV/0!")) {
            return ERROR_DIV_ZERO;
        }
        if (errorString.equals("#REF!")) {
            return ERROR_VALUE;
        }
        if (errorString.equals("#ERROR!")) {
            return ERROR_REF;
        }
        if (errorString.equals("#NAME?")) {
            return ERROR_NAME;
        }
        if (errorString.equals("#NUM!")) {
            return ERROR_NUM;
        }
        if (errorString.equals("#N/A")) {
            return ERROR_NA;
        }
        return ERROR_NULL;
    }

    @Override
    public int getLength() {
        return 2;
    }
}

