/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.InformationCalculator;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgMissArg;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgStr;

public class LogicalCalculator {
    protected static Ptg calcAnd(Ptg[] operands) {
        boolean b = true;
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        int i = 0;
        while (i < alloperands.length) {
            String s;
            PtgBool bo;
            Boolean bool;
            if (alloperands[i] instanceof PtgBool ? (bool = (Boolean)(bo = (PtgBool)alloperands[i]).getValue()) == false : (s = String.valueOf(alloperands[i].getValue())).equalsIgnoreCase("false")) {
                return new PtgBool(false);
            }
            ++i;
        }
        return new PtgBool(true);
    }

    protected static Ptg calcIf(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg determine = operands[0];
        if (operands.length <= 1) {
            if (operands[0] instanceof PtgStr) {
                return operands[0];
            }
            return new PtgInt(0);
        }
        Ptg iftrue = operands[1];
        Ptg iffalse = operands.length > 2 ? operands[2] : new PtgMissArg();
        if (iftrue instanceof PtgMissArg) {
            iftrue = new PtgNumber(0.0);
        }
        if (iffalse instanceof PtgMissArg) {
            iffalse = new PtgNumber(0.0);
        }
        if (!(determine instanceof PtgArray)) {
            String strval = null;
            if (!(determine instanceof PtgRef)) {
                strval = determine.toString();
            } else {
                try {
                    strval = determine.getValue().toString();
                }
                catch (Exception e) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
            }
            if (strval.equalsIgnoreCase("true")) {
                return iftrue;
            }
            return iffalse;
        }
        try {
            String retArry = "";
            Ptg[] p = ((PtgArray)determine).getComponents();
            boolean res = true;
            boolean trueValueIsArray = iftrue instanceof PtgArray;
            boolean falseValueIsArray = iffalse instanceof PtgArray;
            int i = 0;
            while (i < p.length) {
                res = p[i].toString().equalsIgnoreCase("true");
                retArry = res ? (trueValueIsArray ? String.valueOf(retArry) + ((PtgArray)iftrue).arrVals.get(i).toString() + "," : String.valueOf(retArry) + iftrue + ",") : (falseValueIsArray ? String.valueOf(retArry) + ((PtgArray)iffalse).arrVals.get(i).toString() + "," : String.valueOf(retArry) + iffalse + ",");
                ++i;
            }
            retArry = "{" + retArry.substring(0, retArry.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(retArry);
            return pa;
        }
        catch (Exception e) {
            return iffalse;
        }
    }

    protected static Ptg calcFalse(Ptg[] operands) {
        return new PtgBool(false);
    }

    protected static Ptg calcTrue(Ptg[] operands) {
        return new PtgBool(true);
    }

    protected static Ptg calcNot(Ptg[] operands) {
        if (String.valueOf(operands[0].getValue()).equalsIgnoreCase("false")) {
            return new PtgBool(true);
        }
        return new PtgBool(false);
    }

    protected static Ptg calcOr(Ptg[] operands) {
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        int i = 0;
        while (i < alloperands.length) {
            if (String.valueOf(alloperands[i].getValue()).equalsIgnoreCase("true")) {
                return new PtgBool(true);
            }
            ++i;
        }
        return new PtgBool(false);
    }

    protected static Ptg calcIferror(Ptg[] operands) {
        if (operands == null || operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        if (!(operands[0] instanceof PtgArray)) {
            PtgBool ret = (PtgBool)InformationCalculator.calcIserror(operands);
            if (ret.getBooleanValue()) {
                return operands[1];
            }
            return operands[0];
        }
        Ptg[] components = operands[0].getComponents();
        String retArray = "";
        int i = 0;
        while (i < components.length) {
            Ptg[] test = new Ptg[]{components[i]};
            PtgBool ret = (PtgBool)InformationCalculator.calcIserror(test);
            retArray = ret.getBooleanValue() ? String.valueOf(retArray) + operands[1] + "," : String.valueOf(retArray) + test[0] + ",";
            ++i;
        }
        retArray = "{" + retArray.substring(0, retArray.length() - 1) + "}";
        PtgArray pa = new PtgArray();
        pa.setVal(retArray);
        return pa;
    }
}

