/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.DatabaseCalculator;
import com.extentech.formats.XLS.formulas.DateTimeCalculator;
import com.extentech.formats.XLS.formulas.EngineeringCalculator;
import com.extentech.formats.XLS.formulas.FinancialCalculator;
import com.extentech.formats.XLS.formulas.FunctionConstants;
import com.extentech.formats.XLS.formulas.InformationCalculator;
import com.extentech.formats.XLS.formulas.LogicalCalculator;
import com.extentech.formats.XLS.formulas.LookupReferenceCalculator;
import com.extentech.formats.XLS.formulas.MathFunctionCalculator;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgFunc;
import com.extentech.formats.XLS.formulas.PtgFuncVar;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgNameX;
import com.extentech.formats.XLS.formulas.StatisticalCalculator;
import com.extentech.formats.XLS.formulas.TextCalculator;
import java.util.Locale;

public class FunctionHandler {
    public static final Ptg calculateFunction(Ptg[] ptgs) throws FunctionNotSupportedException, CalculationException {
        int funkId = 0;
        Ptg funk = ptgs[0];
        XLSRecord bpar = funk.getParentRec();
        if (bpar != null) {
            int t = 0;
            while (t < ptgs.length) {
                if (ptgs[t].getParentRec() == null) {
                    ptgs[t].setParentRec(bpar);
                }
                ++t;
            }
        }
        int oplen = ptgs.length - 1;
        Ptg[] operands = new Ptg[oplen];
        System.arraycopy(ptgs, 1, operands, 0, oplen);
        if (funk.getOpcode() == 33 || funk.getOpcode() == 65 || funk.getOpcode() == 97) {
            return FunctionHandler.calculatePtgFunc(funk, funkId, operands);
        }
        if (funk.getOpcode() == 34 || funk.getOpcode() == 66 || funk.getOpcode() == 98) {
            return FunctionHandler.calculatePtgFuncVar(funk, funkId, operands);
        }
        return null;
    }

    public static final Ptg calculatePtgFunc(Ptg funk, int funkId, Ptg[] operands) throws FunctionNotSupportedException, CalculationException {
        PtgFunc pf = (PtgFunc)funk;
        funkId = pf.getVal();
        return FunctionHandler.parse_n_calc(funk, funkId, operands);
    }

    public static final Ptg calculatePtgFuncVar(Ptg funk, int funkId, Ptg[] operands) throws FunctionNotSupportedException, CalculationException {
        PtgFuncVar pf = (PtgFuncVar)funk;
        funkId = pf.getVal();
        if (funkId == 255) {
            int y;
            String s = "";
            boolean foundit = false;
            if (operands[0] instanceof PtgNameX) {
                int index = ((PtgNameX)operands[0]).getVal();
                s = pf.getParentRec().getSheet().getWorkBook().getExternalName(index);
            } else if (operands[0] instanceof PtgName) {
                s = ((PtgName)operands[0]).getStoredName();
            }
            if (s.startsWith("_xlfn.")) {
                s = s.substring(6);
            }
            if (Locale.JAPAN.equals(Locale.getDefault())) {
                y = 0;
                while (y < FunctionConstants.jRecArr.length) {
                    if (s.equalsIgnoreCase(FunctionConstants.jRecArr[y][0])) {
                        funkId = Integer.valueOf(FunctionConstants.jRecArr[y][1]);
                        y = FunctionConstants.jRecArr.length;
                        foundit = true;
                    }
                    ++y;
                }
            }
            if (!foundit) {
                y = 0;
                while (y < FunctionConstants.recArr.length) {
                    if (s.equalsIgnoreCase(FunctionConstants.recArr[y][0])) {
                        funkId = Integer.valueOf(FunctionConstants.recArr[y][1]);
                        y = FunctionConstants.recArr.length;
                    }
                    ++y;
                }
            }
            if (funkId == 255) {
                throw new FunctionNotSupportedException(s);
            }
            Ptg[] ops = new Ptg[operands.length - 1];
            System.arraycopy(operands, 1, ops, 0, operands.length - 1);
            operands = new Ptg[ops.length];
            System.arraycopy(ops, 0, operands, 0, ops.length);
        }
        return FunctionHandler.parse_n_calc(funk, funkId, operands);
    }

    public static final Ptg parse_n_calc(Ptg function, int functionId, Ptg[] operands) throws FunctionNotSupportedException, CalculationException {
        Ptg resultPtg = null;
        Object resultArrPtg = null;
        switch (functionId) {
            case 42: {
                resultPtg = DatabaseCalculator.calcDAverage(operands);
                break;
            }
            case 40: {
                resultPtg = DatabaseCalculator.calcDCount(operands);
                break;
            }
            case 199: {
                resultPtg = DatabaseCalculator.calcDCountA(operands);
                break;
            }
            case 235: {
                resultPtg = DatabaseCalculator.calcDGet(operands);
                break;
            }
            case 44: {
                resultPtg = DatabaseCalculator.calcDMax(operands);
                break;
            }
            case 43: {
                resultPtg = DatabaseCalculator.calcDMin(operands);
                break;
            }
            case 189: {
                resultPtg = DatabaseCalculator.calcDProduct(operands);
                break;
            }
            case 45: {
                resultPtg = DatabaseCalculator.calcDStdDev(operands);
                break;
            }
            case 195: {
                resultPtg = DatabaseCalculator.calcDStdDevP(operands);
                break;
            }
            case 41: {
                resultPtg = DatabaseCalculator.calcDSum(operands);
                break;
            }
            case 47: {
                resultPtg = DatabaseCalculator.calcDVar(operands);
                break;
            }
            case 196: {
                resultPtg = DatabaseCalculator.calcDVarP(operands);
                break;
            }
            case 65: {
                resultPtg = DateTimeCalculator.calcDate(operands);
                break;
            }
            case 67: {
                resultPtg = DateTimeCalculator.calcDay(operands);
                break;
            }
            case 220: {
                resultPtg = DateTimeCalculator.calcDays360(operands);
                break;
            }
            case 71: {
                resultPtg = DateTimeCalculator.calcHour(operands);
                break;
            }
            case 72: {
                resultPtg = DateTimeCalculator.calcMinute(operands);
                break;
            }
            case 68: {
                resultPtg = DateTimeCalculator.calcMonth(operands);
                break;
            }
            case 69: {
                resultPtg = DateTimeCalculator.calcYear(operands);
                break;
            }
            case 73: {
                resultPtg = DateTimeCalculator.calcSecond(operands);
                break;
            }
            case 141: {
                resultPtg = DateTimeCalculator.calcTimevalue(operands);
                break;
            }
            case 70: {
                resultPtg = DateTimeCalculator.calcWeekday(operands);
                break;
            }
            case 452: {
                resultPtg = DateTimeCalculator.calcWeeknum(operands);
                break;
            }
            case 453: {
                resultPtg = DateTimeCalculator.calcWorkday(operands);
                break;
            }
            case 459: {
                resultPtg = DateTimeCalculator.calcYearFrac(operands);
                break;
            }
            case 74: {
                resultPtg = DateTimeCalculator.calcNow(operands);
                break;
            }
            case 66: {
                resultPtg = DateTimeCalculator.calcTime(operands);
                break;
            }
            case 221: {
                resultPtg = DateTimeCalculator.calcToday(operands);
                break;
            }
            case 140: {
                resultPtg = DateTimeCalculator.calcDateValue(operands);
                break;
            }
            case 450: {
                resultPtg = DateTimeCalculator.calcEdate(operands);
                break;
            }
            case 451: {
                resultPtg = DateTimeCalculator.calcEOMonth(operands);
                break;
            }
            case 449: {
                resultPtg = DateTimeCalculator.calcNetWorkdays(operands);
                break;
            }
            case 405: {
                resultPtg = EngineeringCalculator.calcBin2Dec(operands);
                break;
            }
            case 406: {
                resultPtg = EngineeringCalculator.calcBin2Hex(operands);
                break;
            }
            case 407: {
                resultPtg = EngineeringCalculator.calcBin2Oct(operands);
                break;
            }
            case 408: {
                resultPtg = EngineeringCalculator.calcDec2Bin(operands);
                break;
            }
            case 409: {
                resultPtg = EngineeringCalculator.calcDec2Hex(operands);
                break;
            }
            case 410: {
                resultPtg = EngineeringCalculator.calcDec2Oct(operands);
                break;
            }
            case 411: {
                resultPtg = EngineeringCalculator.calcHex2Bin(operands);
                break;
            }
            case 412: {
                resultPtg = EngineeringCalculator.calcHex2Dec(operands);
                break;
            }
            case 413: {
                resultPtg = EngineeringCalculator.calcHex2Oct(operands);
                break;
            }
            case 414: {
                resultPtg = EngineeringCalculator.calcOct2Bin(operands);
                break;
            }
            case 415: {
                resultPtg = EngineeringCalculator.calcOct2Dec(operands);
                break;
            }
            case 416: {
                resultPtg = EngineeringCalculator.calcOct2Hex(operands);
                break;
            }
            case 417: {
                resultPtg = EngineeringCalculator.calcComplex(operands);
                break;
            }
            case 418: {
                resultPtg = EngineeringCalculator.calcGEStep(operands);
                break;
            }
            case 419: {
                resultPtg = EngineeringCalculator.calcDelta(operands);
                break;
            }
            case 420: {
                resultPtg = EngineeringCalculator.calcImaginary(operands);
                break;
            }
            case 426: {
                resultPtg = EngineeringCalculator.calcImReal(operands);
                break;
            }
            case 436: {
                resultPtg = EngineeringCalculator.calcImArgument(operands);
                break;
            }
            case 421: {
                resultPtg = EngineeringCalculator.calcImAbs(operands);
                break;
            }
            case 422: {
                resultPtg = EngineeringCalculator.calcImDiv(operands);
                break;
            }
            case 423: {
                resultPtg = EngineeringCalculator.calcImConjugate(operands);
                break;
            }
            case 424: {
                resultPtg = EngineeringCalculator.calcImCos(operands);
                break;
            }
            case 425: {
                resultPtg = EngineeringCalculator.calcImSin(operands);
                break;
            }
            case 427: {
                resultPtg = EngineeringCalculator.calcImExp(operands);
                break;
            }
            case 428: {
                resultPtg = EngineeringCalculator.calcImSub(operands);
                break;
            }
            case 429: {
                resultPtg = EngineeringCalculator.calcImSum(operands);
                break;
            }
            case 430: {
                resultPtg = EngineeringCalculator.calcImProduct(operands);
                break;
            }
            case 431: {
                resultPtg = EngineeringCalculator.calcImLn(operands);
                break;
            }
            case 432: {
                resultPtg = EngineeringCalculator.calcImLog10(operands);
                break;
            }
            case 433: {
                resultPtg = EngineeringCalculator.calcImLog2(operands);
                break;
            }
            case 434: {
                resultPtg = EngineeringCalculator.calcImPower(operands);
                break;
            }
            case 435: {
                resultPtg = EngineeringCalculator.calcImSqrt(operands);
                break;
            }
            case 437: {
                resultPtg = EngineeringCalculator.calcConvert(operands);
                break;
            }
            case 460: {
                resultPtg = EngineeringCalculator.calcErf(operands);
                break;
            }
            case 247: {
                resultPtg = FinancialCalculator.calcDB(operands);
                break;
            }
            case 144: {
                resultPtg = FinancialCalculator.calcDDB(operands);
                break;
            }
            case 59: {
                resultPtg = FinancialCalculator.calcPmt(operands);
                break;
            }
            case 368: {
                resultPtg = FinancialCalculator.calcAccrintm(operands);
                break;
            }
            case 369: {
                resultPtg = FinancialCalculator.calcAccrint(operands);
                break;
            }
            case 370: {
                resultPtg = FinancialCalculator.calcCoupDayBS(operands);
                break;
            }
            case 371: {
                resultPtg = FinancialCalculator.calcCoupDays(operands);
                break;
            }
            case 11: {
                resultPtg = FinancialCalculator.calcNPV(operands);
                break;
            }
            case 56: {
                resultPtg = FinancialCalculator.calcPV(operands);
                break;
            }
            case 57: {
                resultPtg = FinancialCalculator.calcFV(operands);
                break;
            }
            case 167: {
                resultPtg = FinancialCalculator.calcIPMT(operands);
                break;
            }
            case 372: {
                resultPtg = FinancialCalculator.calcCumIPmt(operands);
                break;
            }
            case 373: {
                resultPtg = FinancialCalculator.calcCumPrinc(operands);
                break;
            }
            case 374: {
                resultPtg = FinancialCalculator.calcCoupNCD(operands);
                break;
            }
            case 375: {
                resultPtg = FinancialCalculator.calcCoupDaysNC(operands);
                break;
            }
            case 376: {
                resultPtg = FinancialCalculator.calcCoupPCD(operands);
                break;
            }
            case 377: {
                resultPtg = FinancialCalculator.calcCoupNum(operands);
                break;
            }
            case 378: {
                resultPtg = FinancialCalculator.calcDollarDE(operands);
                break;
            }
            case 379: {
                resultPtg = FinancialCalculator.calcDollarFR(operands);
                break;
            }
            case 380: {
                resultPtg = FinancialCalculator.calcEffect(operands);
                break;
            }
            case 404: {
                resultPtg = FinancialCalculator.calcReceived(operands);
                break;
            }
            case 381: {
                resultPtg = FinancialCalculator.calcINTRATE(operands);
                break;
            }
            case 62: {
                resultPtg = FinancialCalculator.calcIRR(operands);
                break;
            }
            case 61: {
                resultPtg = FinancialCalculator.calcMIRR(operands);
                break;
            }
            case 382: {
                resultPtg = FinancialCalculator.calcXIRR(operands);
                break;
            }
            case 383: {
                resultPtg = FinancialCalculator.calcXNPV(operands);
                break;
            }
            case 60: {
                resultPtg = FinancialCalculator.calcRate(operands);
                break;
            }
            case 384: {
                resultPtg = FinancialCalculator.calcYIELD(operands);
                break;
            }
            case 385: {
                resultPtg = FinancialCalculator.calcPRICE(operands);
                break;
            }
            case 386: {
                resultPtg = FinancialCalculator.calcPRICEDISC(operands);
                break;
            }
            case 387: {
                resultPtg = FinancialCalculator.calcPRICEMAT(operands);
                break;
            }
            case 403: {
                resultPtg = FinancialCalculator.calcDISC(operands);
                break;
            }
            case 58: {
                resultPtg = FinancialCalculator.calcNPER(operands);
                break;
            }
            case 142: {
                resultPtg = FinancialCalculator.calcSLN(operands);
                break;
            }
            case 143: {
                resultPtg = FinancialCalculator.calcSYD(operands);
                break;
            }
            case 388: {
                resultPtg = FinancialCalculator.calcDURATION(operands);
                break;
            }
            case 389: {
                resultPtg = FinancialCalculator.calcMDURATION(operands);
                break;
            }
            case 390: {
                resultPtg = FinancialCalculator.calcTBillEq(operands);
                break;
            }
            case 391: {
                resultPtg = FinancialCalculator.calcTBillPrice(operands);
                break;
            }
            case 392: {
                resultPtg = FinancialCalculator.calcTBillYield(operands);
                break;
            }
            case 393: {
                resultPtg = FinancialCalculator.calcYieldDisc(operands);
                break;
            }
            case 394: {
                resultPtg = FinancialCalculator.calcYieldMat(operands);
                break;
            }
            case 168: {
                resultPtg = FinancialCalculator.calcPPMT(operands);
                break;
            }
            case 395: {
                resultPtg = FinancialCalculator.calcFVSCHEDULE(operands);
                break;
            }
            case 350: {
                resultPtg = FinancialCalculator.calcISPMT(operands);
                break;
            }
            case 396: {
                resultPtg = FinancialCalculator.calcAmorlinc(operands);
                break;
            }
            case 397: {
                resultPtg = FinancialCalculator.calcAmordegrc(operands);
                break;
            }
            case 398: {
                resultPtg = FinancialCalculator.calcODDFPRICE(operands);
                break;
            }
            case 400: {
                resultPtg = FinancialCalculator.calcODDFYIELD(operands);
                break;
            }
            case 399: {
                resultPtg = FinancialCalculator.calcODDLPRICE(operands);
                break;
            }
            case 401: {
                resultPtg = FinancialCalculator.calcODDLYIELD(operands);
                break;
            }
            case 402: {
                resultPtg = FinancialCalculator.calcNominal(operands);
                break;
            }
            case 222: {
                resultPtg = FinancialCalculator.calcVDB(operands);
                break;
            }
            case 125: {
                resultPtg = InformationCalculator.calcCell(operands);
                break;
            }
            case 244: {
                resultPtg = InformationCalculator.calcInfo(operands);
                break;
            }
            case 2: {
                resultPtg = InformationCalculator.calcIsna(operands);
                break;
            }
            case 3: {
                resultPtg = InformationCalculator.calcIserror(operands);
                break;
            }
            case 126: {
                resultPtg = InformationCalculator.calcIserr(operands);
                break;
            }
            case 261: {
                resultPtg = InformationCalculator.calcErrorType(operands);
                break;
            }
            case 10: {
                resultPtg = InformationCalculator.calcNa(operands);
                break;
            }
            case 129: {
                resultPtg = InformationCalculator.calcIsBlank(operands);
                break;
            }
            case 198: {
                resultPtg = InformationCalculator.calcIsLogical(operands);
                break;
            }
            case 190: {
                resultPtg = InformationCalculator.calcIsNonText(operands);
                break;
            }
            case 127: {
                resultPtg = InformationCalculator.calcIsText(operands);
                break;
            }
            case 105: {
                resultPtg = InformationCalculator.calcIsRef(operands);
                break;
            }
            case 131: {
                resultPtg = InformationCalculator.calcN(operands);
                break;
            }
            case 128: {
                resultPtg = InformationCalculator.calcIsNumber(operands);
                break;
            }
            case 447: {
                resultPtg = InformationCalculator.calcIsEven(operands);
                break;
            }
            case 448: {
                resultPtg = InformationCalculator.calcIsOdd(operands);
                break;
            }
            case 86: {
                resultPtg = InformationCalculator.calcType(operands);
                break;
            }
            case 36: {
                resultPtg = LogicalCalculator.calcAnd(operands);
                break;
            }
            case 35: {
                resultPtg = LogicalCalculator.calcFalse(operands);
                break;
            }
            case 34: {
                resultPtg = LogicalCalculator.calcTrue(operands);
                break;
            }
            case 1: {
                resultPtg = LogicalCalculator.calcIf(operands);
                break;
            }
            case 38: {
                resultPtg = LogicalCalculator.calcNot(operands);
                break;
            }
            case 37: {
                resultPtg = LogicalCalculator.calcOr(operands);
                break;
            }
            case 455: {
                resultPtg = LogicalCalculator.calcIferror(operands);
                break;
            }
            case 219: {
                resultPtg = LookupReferenceCalculator.calcAddress(operands);
                break;
            }
            case 75: {
                resultPtg = LookupReferenceCalculator.calcAreas(operands);
                break;
            }
            case 100: {
                resultPtg = LookupReferenceCalculator.calcChoose(operands);
                break;
            }
            case 9: {
                if (operands.length == 0) {
                    operands = new Ptg[]{function};
                }
                resultPtg = LookupReferenceCalculator.calcColumn(operands);
                break;
            }
            case 77: {
                resultPtg = LookupReferenceCalculator.calcColumns(operands);
                break;
            }
            case 359: {
                resultPtg = LookupReferenceCalculator.calcHyperlink(operands);
                break;
            }
            case 29: {
                resultPtg = LookupReferenceCalculator.calcIndex(operands);
                break;
            }
            case 148: {
                resultPtg = LookupReferenceCalculator.calcIndirect(operands);
                break;
            }
            case 8: {
                if (operands.length == 0) {
                    operands = new Ptg[]{function};
                }
                resultPtg = LookupReferenceCalculator.calcRow(operands);
                break;
            }
            case 76: {
                resultPtg = LookupReferenceCalculator.calcRows(operands);
                break;
            }
            case 83: {
                resultPtg = LookupReferenceCalculator.calcTranspose(operands);
                break;
            }
            case 28: {
                resultPtg = LookupReferenceCalculator.calcLookup(operands);
                break;
            }
            case 101: {
                resultPtg = LookupReferenceCalculator.calcHlookup(operands);
                break;
            }
            case 102: {
                resultPtg = LookupReferenceCalculator.calcVlookup(operands);
                break;
            }
            case 64: {
                resultPtg = LookupReferenceCalculator.calcMatch(operands);
                break;
            }
            case 78: {
                resultPtg = LookupReferenceCalculator.calcOffset(operands);
                break;
            }
            case 4: {
                resultPtg = MathFunctionCalculator.calcSum(operands);
                break;
            }
            case 345: {
                resultPtg = MathFunctionCalculator.calcSumif(operands);
                break;
            }
            case 456: {
                resultPtg = MathFunctionCalculator.calcSumIfS(operands);
                break;
            }
            case 228: {
                resultPtg = MathFunctionCalculator.calcSumproduct(operands);
                break;
            }
            case 21: {
                resultPtg = MathFunctionCalculator.calcExp(operands);
                break;
            }
            case 24: {
                resultPtg = MathFunctionCalculator.calcAbs(operands);
                break;
            }
            case 99: {
                resultPtg = MathFunctionCalculator.calcAcos(operands);
                break;
            }
            case 233: {
                resultPtg = MathFunctionCalculator.calcAcosh(operands);
                break;
            }
            case 98: {
                resultPtg = MathFunctionCalculator.calcAsin(operands);
                break;
            }
            case 232: {
                resultPtg = MathFunctionCalculator.calcAsinh(operands);
                break;
            }
            case 18: {
                resultPtg = MathFunctionCalculator.calcAtan(operands);
                break;
            }
            case 97: {
                resultPtg = MathFunctionCalculator.calcAtan2(operands);
                break;
            }
            case 234: {
                resultPtg = MathFunctionCalculator.calcAtanh(operands);
                break;
            }
            case 288: {
                resultPtg = MathFunctionCalculator.calcCeiling(operands);
                break;
            }
            case 276: {
                resultPtg = MathFunctionCalculator.calcCombin(operands);
                break;
            }
            case 16: {
                resultPtg = MathFunctionCalculator.calcCos(operands);
                break;
            }
            case 230: {
                resultPtg = MathFunctionCalculator.calcCosh(operands);
                break;
            }
            case 343: {
                resultPtg = MathFunctionCalculator.calcDegrees(operands);
                break;
            }
            case 279: {
                resultPtg = MathFunctionCalculator.calcEven(operands);
                break;
            }
            case 184: {
                resultPtg = MathFunctionCalculator.calcFact(operands);
                break;
            }
            case 438: {
                resultPtg = MathFunctionCalculator.calcFactDouble(operands);
                break;
            }
            case 285: {
                resultPtg = MathFunctionCalculator.calcFloor(operands);
                break;
            }
            case 439: {
                resultPtg = MathFunctionCalculator.calcGCD(operands);
                break;
            }
            case 25: {
                resultPtg = MathFunctionCalculator.calcInt(operands);
                break;
            }
            case 440: {
                resultPtg = MathFunctionCalculator.calcLCM(operands);
                break;
            }
            case 441: {
                resultPtg = MathFunctionCalculator.calcMRound(operands);
                break;
            }
            case 165: {
                resultPtg = MathFunctionCalculator.calcMMult(operands);
                break;
            }
            case 442: {
                resultPtg = MathFunctionCalculator.calcMultinomial(operands);
                break;
            }
            case 22: {
                resultPtg = MathFunctionCalculator.calcLn(operands);
                break;
            }
            case 109: {
                resultPtg = MathFunctionCalculator.calcLog(operands);
                break;
            }
            case 23: {
                resultPtg = MathFunctionCalculator.calcLog10(operands);
                break;
            }
            case 39: {
                resultPtg = MathFunctionCalculator.calcMod(operands);
                break;
            }
            case 298: {
                resultPtg = MathFunctionCalculator.calcOdd(operands);
                break;
            }
            case 19: {
                resultPtg = MathFunctionCalculator.calcPi(operands);
                break;
            }
            case 337: {
                resultPtg = MathFunctionCalculator.calcPower(operands);
                break;
            }
            case 183: {
                resultPtg = MathFunctionCalculator.calcProduct(operands);
                break;
            }
            case 443: {
                resultPtg = MathFunctionCalculator.calcQuotient(operands);
                break;
            }
            case 342: {
                resultPtg = MathFunctionCalculator.calcRadians(operands);
                break;
            }
            case 63: {
                resultPtg = MathFunctionCalculator.calcRand(operands);
                break;
            }
            case 444: {
                resultPtg = MathFunctionCalculator.calcRandBetween(operands);
                break;
            }
            case 354: {
                resultPtg = MathFunctionCalculator.calcRoman(operands);
                break;
            }
            case 27: {
                resultPtg = MathFunctionCalculator.calcRound(operands);
                break;
            }
            case 213: {
                resultPtg = MathFunctionCalculator.calcRoundDown(operands);
                break;
            }
            case 212: {
                resultPtg = MathFunctionCalculator.calcRoundUp(operands);
                break;
            }
            case 26: {
                resultPtg = MathFunctionCalculator.calcSign(operands);
                break;
            }
            case 15: {
                resultPtg = MathFunctionCalculator.calcSin(operands);
                break;
            }
            case 229: {
                resultPtg = MathFunctionCalculator.calcSinh(operands);
                break;
            }
            case 20: {
                resultPtg = MathFunctionCalculator.calcSqrt(operands);
                break;
            }
            case 446: {
                resultPtg = MathFunctionCalculator.calcSqrtPi(operands);
                break;
            }
            case 17: {
                resultPtg = MathFunctionCalculator.calcTan(operands);
                break;
            }
            case 231: {
                resultPtg = MathFunctionCalculator.calcTanh(operands);
                break;
            }
            case 197: {
                resultPtg = MathFunctionCalculator.calcTrunc(operands);
                break;
            }
            case 0: {
                resultPtg = StatisticalCalculator.calcCount(operands);
                break;
            }
            case 169: {
                resultPtg = StatisticalCalculator.calcCountA(operands);
                break;
            }
            case 347: {
                resultPtg = StatisticalCalculator.calcCountBlank(operands);
                break;
            }
            case 346: {
                resultPtg = StatisticalCalculator.calcCountif(operands);
                break;
            }
            case 458: {
                resultPtg = StatisticalCalculator.calcCountIfS(operands);
                break;
            }
            case 6: {
                resultPtg = StatisticalCalculator.calcMin(operands);
                break;
            }
            case 363: {
                resultPtg = StatisticalCalculator.calcMinA(operands);
                break;
            }
            case 7: {
                resultPtg = StatisticalCalculator.calcMax(operands);
                break;
            }
            case 362: {
                resultPtg = StatisticalCalculator.calcMaxA(operands);
                break;
            }
            case 293: {
                resultPtg = StatisticalCalculator.calcNormdist(operands);
                break;
            }
            case 294: {
                resultPtg = StatisticalCalculator.calcNormsdist(operands);
                break;
            }
            case 296: {
                resultPtg = StatisticalCalculator.calcNormsInv(operands);
                break;
            }
            case 295: {
                resultPtg = StatisticalCalculator.calcNormInv(operands);
                break;
            }
            case 5: {
                resultPtg = StatisticalCalculator.calcAverage(operands);
                break;
            }
            case 454: {
                resultPtg = StatisticalCalculator.calcAverageIf(operands);
                break;
            }
            case 457: {
                resultPtg = StatisticalCalculator.calcAverageIfS(operands);
                break;
            }
            case 269: {
                resultPtg = StatisticalCalculator.calcAveDev(operands);
                break;
            }
            case 361: {
                resultPtg = StatisticalCalculator.calcAverageA(operands);
                break;
            }
            case 227: {
                resultPtg = StatisticalCalculator.calcMedian(operands);
                break;
            }
            case 330: {
                resultPtg = StatisticalCalculator.calcMode(operands);
                break;
            }
            case 327: {
                resultPtg = StatisticalCalculator.calcQuartile(operands);
                break;
            }
            case 216: {
                resultPtg = StatisticalCalculator.calcRank(operands);
                break;
            }
            case 12: {
                resultPtg = StatisticalCalculator.calcStdev(operands);
                break;
            }
            case 46: {
                resultPtg = StatisticalCalculator.calcVar(operands);
                break;
            }
            case 194: {
                resultPtg = StatisticalCalculator.calcVarp(operands);
                break;
            }
            case 308: {
                resultPtg = StatisticalCalculator.calcCovar(operands);
                break;
            }
            case 307: {
                resultPtg = StatisticalCalculator.calcCorrel(operands);
                break;
            }
            case 252: {
                resultPtg = StatisticalCalculator.calcFrequency(operands);
                break;
            }
            case 49: {
                resultPtg = StatisticalCalculator.calcLineSt(operands);
                break;
            }
            case 315: {
                resultPtg = StatisticalCalculator.calcSlope(operands);
                break;
            }
            case 311: {
                resultPtg = StatisticalCalculator.calcIntercept(operands);
                break;
            }
            case 312: {
                resultPtg = StatisticalCalculator.calcPearson(operands);
                break;
            }
            case 313: {
                resultPtg = StatisticalCalculator.calcRsq(operands);
                break;
            }
            case 314: {
                resultPtg = StatisticalCalculator.calcSteyx(operands);
                break;
            }
            case 309: {
                resultPtg = StatisticalCalculator.calcForecast(operands);
                break;
            }
            case 50: {
                resultPtg = StatisticalCalculator.calcTrend(operands);
                break;
            }
            case 325: {
                resultPtg = StatisticalCalculator.calcLarge(operands);
                break;
            }
            case 326: {
                resultPtg = StatisticalCalculator.calcSmall(operands);
                break;
            }
            case 111: {
                resultPtg = TextCalculator.calcChar(operands);
                break;
            }
            case 162: {
                resultPtg = TextCalculator.calcClean(operands);
                break;
            }
            case 121: {
                resultPtg = TextCalculator.calcCode(operands);
                break;
            }
            case 336: {
                resultPtg = TextCalculator.calcConcatenate(operands);
                break;
            }
            case 13: {
                resultPtg = TextCalculator.calcDollar(operands);
                break;
            }
            case 117: {
                resultPtg = TextCalculator.calcExact(operands);
                break;
            }
            case 124: {
                resultPtg = TextCalculator.calcFind(operands);
                break;
            }
            case 205: {
                resultPtg = TextCalculator.calcFindB(operands);
                break;
            }
            case 14: {
                resultPtg = TextCalculator.calcFixed(operands);
                break;
            }
            case 115: {
                resultPtg = TextCalculator.calcLeft(operands);
                break;
            }
            case 208: {
                resultPtg = TextCalculator.calcLeftB(operands);
                break;
            }
            case 32: {
                resultPtg = TextCalculator.calcLen(operands);
                break;
            }
            case 211: {
                resultPtg = TextCalculator.calcLenB(operands);
                break;
            }
            case 112: {
                resultPtg = TextCalculator.calcLower(operands);
                break;
            }
            case 113: {
                resultPtg = TextCalculator.calcUpper(operands);
                break;
            }
            case 31: {
                resultPtg = TextCalculator.calcMid(operands);
                break;
            }
            case 114: {
                resultPtg = TextCalculator.calcProper(operands);
                break;
            }
            case 119: {
                resultPtg = TextCalculator.calcReplace(operands);
                break;
            }
            case 30: {
                resultPtg = TextCalculator.calcRept(operands);
                break;
            }
            case 116: {
                resultPtg = TextCalculator.calcRight(operands);
                break;
            }
            case 82: {
                resultPtg = TextCalculator.calcSearch(operands);
                break;
            }
            case 206: {
                resultPtg = TextCalculator.calcSearchB(operands);
                break;
            }
            case 120: {
                resultPtg = TextCalculator.calcSubstitute(operands);
                break;
            }
            case 130: {
                resultPtg = TextCalculator.calcT(operands);
                break;
            }
            case 118: {
                resultPtg = TextCalculator.calcTrim(operands);
                break;
            }
            case 48: {
                resultPtg = TextCalculator.calcText(operands);
                break;
            }
            case 33: {
                resultPtg = TextCalculator.calcValue(operands);
                break;
            }
            default: {
                String s = FunctionConstants.getFunctionString((short)functionId);
                s = s != null && !s.equals("") ? s.substring(0, s.length() - 1) : new String(Integer.toHexString(functionId));
                throw new FunctionNotSupportedException(s);
            }
        }
        return resultPtg;
    }
}

