/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.OOXMLChart;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class ThreeD
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -7501630910970731901L;
    private short anRot = 0;
    private short anElev = (short)15;
    private short pcDist = (short)30;
    private short pcHeight = (short)100;
    private short pcDepth = (short)100;
    private short pcGap = (short)150;
    private short grbit = 0;
    private boolean fPerspective;
    private boolean fCluster;
    private boolean f3dScaling;
    private boolean f2DWalls;
    private byte[] PROTOTYPE_BYTES;

    public ThreeD() {
        byte[] byArray = new byte[14];
        byArray[4] = 30;
        byArray[6] = 100;
        byArray[8] = 100;
        byArray[10] = -106;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.anRot = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.anElev = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.pcDist = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.pcHeight = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.pcDepth = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.pcGap = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        this.grbit = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        this.fPerspective = (this.grbit & 1) == 1;
        this.fCluster = (this.grbit & 2) == 2;
        this.f3dScaling = (this.grbit & 4) == 4;
        this.f2DWalls = (this.grbit & 0x10) == 16;
    }

    public static XLSRecord getPrototype() {
        ThreeD td = new ThreeD();
        td.setOpcode((short)4154);
        td.setData(td.PROTOTYPE_BYTES);
        td.init();
        return td;
    }

    private void updateRecord() {
        byte[] b = ByteTools.shortToLEBytes(this.anRot);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
        b = ByteTools.shortToLEBytes(this.anElev);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
        b = ByteTools.shortToLEBytes(this.pcDist);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
        b = ByteTools.shortToLEBytes(this.pcHeight);
        this.getData()[6] = b[0];
        this.getData()[7] = b[1];
        b = ByteTools.shortToLEBytes(this.pcDepth);
        this.getData()[8] = b[0];
        this.getData()[9] = b[1];
        b = ByteTools.shortToLEBytes(this.pcGap);
        this.getData()[10] = b[0];
        this.getData()[11] = b[1];
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[12] = b[0];
        this.getData()[13] = b[1];
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("AnRot")) {
            this.anRot = Short.parseShort(val);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("AnElev")) {
            this.anElev = Short.parseShort(val);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("PcDist")) {
            this.pcDist = Short.parseShort(val);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("PcHeight")) {
            this.pcHeight = Short.parseShort(val);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("PcDepth")) {
            this.pcDepth = Short.parseShort(val);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("PcGap")) {
            this.pcGap = Short.parseShort(val);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("Perspective")) {
            this.fPerspective = Boolean.valueOf(val);
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fPerspective, 0);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("Cluster")) {
            this.fCluster = Boolean.valueOf(val);
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fCluster, 1);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("ThreeDScaling")) {
            this.f3dScaling = Boolean.valueOf(val);
            this.grbit = ByteTools.updateGrBit(this.grbit, this.f3dScaling, 2);
            bHandled = true;
        }
        if (op.equalsIgnoreCase("TwoDWalls")) {
            this.f2DWalls = Boolean.valueOf(val);
            this.grbit = ByteTools.updateGrBit(this.grbit, this.f2DWalls, 4);
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }

    @Override
    public String getChartOption(String op) {
        if (op.equalsIgnoreCase("AnRot")) {
            return String.valueOf(this.anRot);
        }
        if (op.equalsIgnoreCase("AnElev")) {
            return String.valueOf(this.anElev);
        }
        if (op.equalsIgnoreCase("PcDist")) {
            return String.valueOf(this.pcDist);
        }
        if (op.equalsIgnoreCase("PcHeight")) {
            return String.valueOf(this.pcHeight);
        }
        if (op.equalsIgnoreCase("PcDepth")) {
            return String.valueOf(this.pcDepth);
        }
        if (op.equalsIgnoreCase("PcGap")) {
            return String.valueOf(this.pcGap);
        }
        if (op.equalsIgnoreCase("Perspective")) {
            return this.fPerspective ? "1" : "0";
        }
        if (op.equalsIgnoreCase("Cluster")) {
            return this.fCluster ? "1" : "0";
        }
        if (op.equalsIgnoreCase("ThreeDScaling")) {
            return this.f3dScaling ? "1" : "0";
        }
        if (op.equalsIgnoreCase("TwoDWalls")) {
            return this.f2DWalls ? "1" : "0";
        }
        return "";
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.anRot != 0) {
            sb.append(" AnRot=\"" + this.anRot + "\"");
        }
        if (this.anElev != 15) {
            sb.append(" AnElev=\"" + this.anElev + "\"");
        }
        if (this.pcDist != 30) {
            sb.append(" pcDist=\"" + this.pcDist + "\"");
        }
        if (this.pcHeight != 100) {
            sb.append(" pcHeight=\"" + this.pcHeight + "\"");
        }
        if (this.pcDepth != 100) {
            sb.append(" pcDepth=\"" + this.pcDepth + "\"");
        }
        if (this.pcGap != 150) {
            sb.append(" pcGap=\"" + this.pcGap + "\"");
        }
        if (this.fPerspective) {
            sb.append(" Perspective=\"true\"");
        }
        if (this.f3dScaling) {
            sb.append(" ThreeDScaling=\"true\"");
        }
        if (this.f2DWalls) {
            sb.append(" TwoDWalls=\"true\"");
        }
        sb.append(" Cluster=\"" + this.fCluster + "\"");
        return sb.toString();
    }

    public boolean isClustered() {
        return this.fCluster;
    }

    public void setIsClustered(boolean bIsClustered) {
        this.fCluster = bIsClustered;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fCluster, 1);
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[12] = b[0];
        this.getData()[13] = b[1];
    }

    public void setIsPie(boolean isPieChart) {
        this.grbit = isPieChart ? (short)(this.grbit & 8) : (short)(this.grbit | 0x17);
        this.updateRecord();
    }

    public void setAnRot(int rot) {
        this.anRot = (short)rot;
        byte[] b = ByteTools.shortToLEBytes(this.anRot);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public void setAnElev(int elev) {
        this.anElev = (short)elev;
        byte[] b = ByteTools.shortToLEBytes(this.anElev);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
    }

    public void setPcDist(int dist) {
        this.pcDist = (short)dist;
        byte[] b = ByteTools.shortToLEBytes(this.pcDist);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public void setPcHeight(int dist) {
        this.pcHeight = (short)dist;
        byte[] b = ByteTools.shortToLEBytes(this.pcHeight);
        this.getData()[6] = b[0];
        this.getData()[7] = b[1];
    }

    public void setPcDepth(int depth) {
        this.pcDepth = (short)depth;
        byte[] b = ByteTools.shortToLEBytes(this.pcDepth);
        this.getData()[8] = b[0];
        this.getData()[9] = b[1];
    }

    public void setPcGap(int gap) {
        this.pcGap = (short)gap;
        byte[] b = ByteTools.shortToLEBytes(this.pcGap);
        this.getData()[10] = b[0];
        this.getData()[11] = b[1];
    }

    public int getPcGap() {
        return this.pcGap;
    }

    public StringBuffer getOOXML() {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:view3D>");
        cooxml.append("\r\n");
        if (this.anElev != 0) {
            cooxml.append("<c:rotX val=\"" + this.anElev + "\"/>");
        }
        if (this.anRot != 0 || this.anElev != 0) {
            cooxml.append("<c:rotY val=\"" + this.anRot + "\"/>");
        }
        if (this.pcDepth != 100) {
            cooxml.append("<c:depthPercent val=\"" + this.pcDepth + "\"/>");
        }
        if (this.fPerspective) {
            cooxml.append("<c:rAngAx val=\"1\"/>");
        }
        if (this.pcDist != 30) {
            cooxml.append("<c:perspective val=\"" + this.pcDist + "\"/>");
        }
        cooxml.append("</c:view3D>");
        cooxml.append("\r\n");
        return cooxml;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, OOXMLChart cht) {
        ThreeD td = cht.getChartObject().getThreeDRec(true);
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    String v = null;
                    try {
                        v = xpp.getAttributeValue(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (v != null) {
                        if (tnm.equals("rotX")) {
                            td.setAnElev(Integer.valueOf(v));
                        } else if (tnm.equals("rotY")) {
                            td.setAnRot(Integer.valueOf(v));
                        } else if (tnm.equals("perspective")) {
                            td.setPcDist(Integer.valueOf(v));
                        } else if (tnm.equals("depthPercent")) {
                            td.setPcDepth(Integer.valueOf(v));
                        } else {
                            tnm.equals("rAngAx");
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("view3D")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("ThreeD.parseOOXML: " + e.toString());
        }
        return null;
    }
}

