/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;
import org.json.JSONException;
import org.json.JSONObject;

public class Surface
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -3243029185139320374L;
    private short grbit = 0;
    private boolean fFillSurface = true;
    private boolean f3DPhoneShade = false;
    private boolean is3d = false;
    private byte[] PROTOTYPE_BYTES = new byte[2];

    @Override
    public void init() {
        super.init();
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.fFillSurface = (this.grbit & 1) == 1;
        this.f3DPhoneShade = (this.grbit & 2) == 2;
        this.chartType = 7;
    }

    private void updateRecord() {
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public static XLSRecord getPrototype() {
        Surface b = new Surface();
        b.setOpcode((short)4159);
        b.setData(b.PROTOTYPE_BYTES);
        b.init();
        return b;
    }

    public boolean isWireframe() {
        return !this.fFillSurface;
    }

    public void setIsWireframe(boolean wireframe) {
        this.fFillSurface = !wireframe;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fFillSurface, 0);
    }

    public boolean getIs3d() {
        return this.is3d;
    }

    public void setIs3d(boolean is3d) {
        this.is3d = is3d;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.fFillSurface) {
            sb.append(" ColorFill=\"true\"");
        }
        if (this.f3DPhoneShade) {
            sb.append(" Shading=\"true\"");
        }
        return sb.toString();
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("ColorFill")) {
            this.fFillSurface = val.equals("true");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fFillSurface, 0);
            bHandled = true;
        } else if (op.equalsIgnoreCase("Shading")) {
            this.f3DPhoneShade = val.equals("true");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.f3DPhoneShade, 1);
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }

    public JSONObject getTypeJSON() throws JSONException {
        JSONObject typeJSON = new JSONObject();
        String dojoType = !this.isStacked() ? "Areas" : "StackedAreas";
        typeJSON.put("type", (Object)dojoType);
        return typeJSON;
    }
}

