/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.DLbls;
import com.extentech.formats.OOXML.DPt;
import com.extentech.formats.OOXML.Marker;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Format;
import com.extentech.formats.XLS.FormatConstantsImpl;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.Ai;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.DataFormat;
import com.extentech.formats.XLS.charts.DataLabExtContents;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Legend;
import com.extentech.formats.XLS.charts.SerToCrt;
import com.extentech.formats.XLS.charts.SeriesText;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Vector;

public final class Series
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 7290108485347063887L;
    public static int SERIES_TYPE_NUMERIC = 1;
    public static int SERIES_TYPE_STRING = 3;
    protected int sdtX = -1;
    protected int sdtY = -1;
    protected int cValx = -1;
    protected int cValy = -1;
    protected int sdtBSz = -1;
    protected int sdtValBSz = -1;
    private SpPr shapeProps = null;
    private Marker m = null;
    private DLbls d = null;
    private ArrayList dPts = null;
    private byte[] PROTOTYPE_BYTES;
    public static int[] automaticSeriesColors = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62};

    @Override
    public void init() {
        super.init();
        this.sdtX = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.sdtY = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.cValx = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.cValy = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.sdtBSz = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.sdtValBSz = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        if (this.DEBUGLEVEL > 10) {
            Logger.logInfo(this.toString());
        }
    }

    public Series() {
        byte[] byArray = new byte[12];
        byArray[0] = 3;
        byArray[2] = 1;
        byArray[4] = 3;
        byArray[6] = 3;
        byArray[8] = 1;
        this.PROTOTYPE_BYTES = byArray;
    }

    public void update() {
        byte[] rkdata = this.getData();
        byte[] b = ByteTools.shortToLEBytes((short)this.sdtX);
        rkdata[0] = b[0];
        rkdata[1] = b[1];
        b = ByteTools.shortToLEBytes((short)this.sdtY);
        rkdata[2] = b[0];
        rkdata[3] = b[1];
        b = ByteTools.shortToLEBytes((short)this.cValx);
        rkdata[4] = b[0];
        rkdata[5] = b[1];
        b = ByteTools.shortToLEBytes((short)this.cValy);
        rkdata[6] = b[0];
        rkdata[7] = b[1];
        b = ByteTools.shortToLEBytes((short)this.sdtBSz);
        rkdata[8] = b[0];
        rkdata[9] = b[1];
        b = ByteTools.shortToLEBytes((short)this.sdtValBSz);
        rkdata[10] = b[0];
        rkdata[11] = b[1];
        this.setData(rkdata);
    }

    public Ai getSeriesValueAi() {
        int i = 0;
        while (i < this.chartArr.size()) {
            Ai thisAi;
            BiffRec br = (BiffRec)this.chartArr.get(i);
            if (br.getOpcode() == 4177 && (thisAi = (Ai)br).getType() == 1) {
                return thisAi;
            }
            ++i;
        }
        return null;
    }

    private int getSeriesNumberFormat() {
        Ai ai = this.getSeriesValueAi();
        int i = 0;
        if (ai != null) {
            i = ai.getIfmt();
            if (i != 0) {
                return i;
            }
            try {
                PtgRef p = (PtgRef)ai.getCellRangePtgs()[0].getComponents()[0];
                i = ai.getWorkBook().getXf(p.getRefCells()[0].getIxfe()).getIfmt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return i;
    }

    public String getSeriesFormatPattern() {
        int ifmt = this.getSeriesNumberFormat();
        String[][] fmts = FormatConstantsImpl.getBuiltinFormats();
        int x = 0;
        while (x < fmts.length) {
            if (ifmt == Integer.parseInt(fmts[x][1], 16)) {
                return fmts[x][0];
            }
            ++x;
        }
        try {
            Format fmt = this.getWorkBook().getFormat(ifmt);
            return fmt.getFormat();
        }
        catch (Exception exception) {
            return "General";
        }
    }

    private int getCategoryNumberFormat() {
        Ai ai = this.getCategoryValueAi();
        if (ai != null) {
            return ai.getIfmt();
        }
        return 0;
    }

    public String getCategoryFormatPattern() {
        int ifmt = this.getCategoryNumberFormat();
        String[][] fmts = FormatConstantsImpl.getBuiltinFormats();
        int x = 0;
        while (x < fmts.length) {
            if (ifmt == Integer.parseInt(fmts[x][1], 16)) {
                return fmts[x][0];
            }
            ++x;
        }
        try {
            Format fmt = this.getWorkBook().getFormat(ifmt);
            return fmt.getFormat();
        }
        catch (Exception exception) {
            return "General";
        }
    }

    public void setLegend(String newLegend, WorkBookHandle wbh) {
        this.getLegendAi().setLegend(newLegend);
        Chart parent = this.getParentChart();
        parent.getChartSeries().legends = null;
        parent.getLegend().adjustWidth(parent.getMetrics(wbh), parent.getChartType(), parent.getChartSeries().getLegends());
    }

    public void setLegendRef(String newLegendCell) {
        Ai ai = this.getLegendAi();
        ai.changeAiLocation(ai.toString(), newLegendCell);
        SeriesText st = this.getLegendSeriesText();
        ai.setRt(2);
        String legendText = "";
        try {
            BiffRec r2 = ai.getWorkBook().getCell(newLegendCell);
            legendText = r2.getStringVal();
        }
        catch (Exception e) {
            Logger.logErr("Series.setLegendRef: Error setting Legend Reference to '" + newLegendCell + "': " + e.toString());
        }
        st.setText(legendText);
    }

    public String getLegendText() {
        int i = 0;
        while (i < this.chartArr.size()) {
            Ai thisAi;
            BiffRec br = (BiffRec)this.chartArr.get(i);
            if (br.getOpcode() == 4177 && (thisAi = (Ai)br).getType() == 0) {
                try {
                    Ptg[] p = thisAi.getCellRangePtgs();
                    return ((PtgRef)p[0]).getFormattedValue();
                }
                catch (Exception p) {
                    try {
                        SeriesText st;
                        if (this.chartArr.size() > i + 1 && (st = (SeriesText)this.chartArr.get(i + 1)) != null) {
                            return st.toString();
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return "";
    }

    public String getLegendRef() {
        Ai ai = this.getLegendAi();
        if (ai != null) {
            return ai.getDefinition();
        }
        return null;
    }

    protected SeriesText getLegendSeriesText() {
        int i = 0;
        while (i < this.chartArr.size()) {
            Ai thisAi;
            BiffRec br = (BiffRec)this.chartArr.get(i);
            if (br.getOpcode() == 4177 && (thisAi = (Ai)br).getType() == 0 && this.chartArr.size() > i + 1) {
                try {
                    SeriesText st = (SeriesText)this.chartArr.get(i + 1);
                    return st;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public Ai getLegendAi() {
        int i = 0;
        while (i < this.chartArr.size()) {
            Ai thisAi;
            BiffRec br = (BiffRec)this.chartArr.get(i);
            if (br.getOpcode() == 4177 && (thisAi = (Ai)br).getType() == 0) {
                return thisAi;
            }
            ++i;
        }
        return null;
    }

    public Ai getBubbleValueAi() {
        int i = 0;
        while (i < this.chartArr.size()) {
            Ai thisAi;
            BiffRec br = (BiffRec)this.chartArr.get(i);
            if (br.getOpcode() == 4177 && (thisAi = (Ai)br).getType() == 3) {
                return thisAi;
            }
            ++i;
        }
        return null;
    }

    protected static Series getPrototype(String seriesRange, String categoryRange, String bubbleRange, String legendRange, String legendText, ChartType chartobj) {
        Ai ai;
        Series series = (Series)Series.getPrototype();
        Chart parentChart = chartobj.getParentChart();
        WorkBook book = parentChart.getWorkBook();
        if (legendRange != null) {
            ai = (Ai)Ai.getPrototype(Ai.AI_TYPE_LEGEND);
            ai.setWorkBook(book);
            ai.setSheet(parentChart.getSheet());
            try {
                ai.changeAiLocation("", legendRange);
            }
            catch (Exception exception) {
                // empty catch block
            }
            series.addChartRecord(ai);
            SeriesText st = SeriesText.getPrototype(legendText);
            ai.setSeriesText(st);
            series.addChartRecord(st);
            Legend l = chartobj.getDataLegend();
            if (l != null) {
                l.setAutoPosition(true);
                l.incrementHeight(parentChart.getCoords()[3]);
            }
        } else {
            ai = (Ai)Ai.getPrototype(Ai.AI_TYPE_NULL_LEGEND);
            ai.setWorkBook(book);
            ai.setSheet(parentChart.getSheet());
            series.addChartRecord(ai);
        }
        ai = (Ai)Ai.getPrototype(Ai.AI_TYPE_SERIES);
        ai.setParentChart(parentChart);
        ai.setWorkBook(book);
        ai.setSheet(parentChart.getSheet());
        try {
            ai.changeAiLocation(ai.toString(), seriesRange);
        }
        catch (Exception st) {
            // empty catch block
        }
        series.addChartRecord(ai);
        ai = (Ai)Ai.getPrototype(Ai.AI_TYPE_CATEGORY);
        ai.setWorkBook(book);
        ai.setSheet(parentChart.getSheet());
        try {
            ai.changeAiLocation(ai.toString(), categoryRange);
        }
        catch (Exception st) {
            // empty catch block
        }
        series.addChartRecord(ai);
        ai = (Ai)Ai.getPrototype(Ai.AI_TYPE_BUBBLE);
        ai.setWorkBook(book);
        ai.setSheet(parentChart.getSheet());
        if (!bubbleRange.equals("")) {
            try {
                ai.changeAiLocation(ai.toString(), bubbleRange);
            }
            catch (Exception st) {
                // empty catch block
            }
            ai.setRt(2);
        }
        series.addChartRecord(ai);
        DataFormat df = null;
        df = (DataFormat)DataFormat.getPrototype();
        Vector ser = parentChart.getAllSeries();
        int yi = -1;
        int iss = -1;
        int i = 0;
        while (i < ser.size()) {
            Series srs = (Series)ser.get(i);
            int newYi = srs.getSeriesIndex();
            int newIss = srs.getSeriesNumber();
            if (newYi > yi) {
                yi = newYi;
            }
            if (newIss > iss) {
                iss = newIss;
            }
            ++i;
        }
        df.setSeriesIndex(++yi);
        df.setSeriesNumber(++iss);
        if (chartobj.getBarShape() != 0) {
            df.setShape(chartobj.getBarShape());
        }
        series.addChartRecord(df);
        SerToCrt stc = (SerToCrt)SerToCrt.getPrototype();
        int vCount = 0;
        int cCount = 0;
        int bCount = 0;
        if (ser.size() > 0) {
            Series s = (Series)ser.get(0);
            ArrayList cr = s.getChartRecords();
            int i2 = 0;
            while (i2 < cr.size()) {
                BiffRec b = (BiffRec)cr.get(i2);
                if (b.getOpcode() == 4165) {
                    SerToCrt stcc = (SerToCrt)b;
                    stc.setData(stcc.getData());
                }
                ++i2;
            }
            vCount = s.getValueCount();
            cCount = s.getCategoryCount();
            bCount = s.getBubbleCount();
        }
        series.init();
        try {
            if (seriesRange.indexOf(":") != -1) {
                int[] coords = ExcelTools.getRangeCoords(seriesRange);
                vCount = coords[4];
            } else {
                vCount = 1;
            }
            series.setValueCount(vCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cCount = ExcelTools.getRangeCoords(categoryRange)[4];
            series.setCategoryCount(cCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bubbleRange.equals("")) {
            try {
                bCount = ExcelTools.getRangeCoords(bubbleRange)[4];
                series.setBubbleCount(bCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        series.addChartRecord(stc);
        return series;
    }

    public static XLSRecord getPrototype() {
        Series s = new Series();
        s.setOpcode((short)4099);
        s.setData(s.PROTOTYPE_BYTES);
        s.init();
        return s;
    }

    public Ai getCategoryValueAi() {
        int i = 0;
        while (i < this.chartArr.size()) {
            Ai thisAi;
            BiffRec br = (BiffRec)this.chartArr.get(i);
            if (br.getOpcode() == 4177 && (thisAi = (Ai)br).getType() == 2) {
                return thisAi;
            }
            ++i;
        }
        return null;
    }

    protected int getSeriesIndex() {
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            return df.getSeriesIndex();
        }
        return -1;
    }

    protected int getSeriesNumber() {
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            return df.getSeriesNumber();
        }
        return -1;
    }

    protected int getCategoryCount() {
        return this.cValx;
    }

    protected int getValueCount() {
        return this.cValy;
    }

    public void setCategoryCount(int i) {
        this.cValx = i;
        this.update();
    }

    protected int getBubbleCount() {
        return this.sdtValBSz;
    }

    public void setBubbleCount(int i) {
        this.sdtValBSz = i;
        this.update();
    }

    public void setValueCount(int i) {
        this.cValy = i;
        this.update();
    }

    public int getCategoryDataType() {
        return this.sdtX;
    }

    public int getValueDataType() {
        return this.sdtY;
    }

    public void setCategoryDataType(int i) {
        this.sdtX = i;
        this.update();
    }

    public void setValueDataType(int i) {
        this.sdtY = i;
        this.update();
    }

    public boolean hasBubbleSizes() {
        return this.sdtValBSz > 0;
    }

    private DataFormat getDataFormatRec(boolean bCreate) {
        DataFormat df = (DataFormat)Chart.findRec(this.chartArr, DataFormat.class);
        if (df == null && bCreate) {
            df = (DataFormat)DataFormat.getPrototypeWithFormatRecs(this.getParentChart());
            this.addChartRecord(df);
        }
        return df;
    }

    private DataFormat getDataFormatRecSlice(int slice, boolean bCreate) {
        DataFormat df = this.getDataFormatRec(false);
        if (df == null) {
            Logger.logErr("Series.getDataFormatRecSlice: cannot find data format record");
            return null;
        }
        short seriesNumber = df.getSeriesNumber();
        Series s = seriesNumber == 0 ? this : (Series)this.getParentChart().getAllSeries().get(seriesNumber);
        int i = Chart.findRecPosition(s.chartArr, DataFormat.class);
        ++i;
        int lastSlice = 0;
        while (i < s.chartArr.size()) {
            if (s.chartArr.get(i) instanceof DataFormat) {
                df = (DataFormat)s.chartArr.get(i);
                lastSlice = df.getPointNumber();
                if (df.getPointNumber() == slice) {
                    return df;
                }
            }
            ++i;
        }
        if (bCreate) {
            --i;
            while (lastSlice <= slice) {
                df = (DataFormat)DataFormat.getPrototypeWithFormatRecs(this.getParentChart());
                df.setPointNumber(lastSlice++);
                df.setParentChart(this.getParentChart());
                s.chartArr.add(i++, df);
            }
            return df;
        }
        return null;
    }

    public int getShape() {
        int ret = 0;
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            ret = df.getShape();
        }
        return ret;
    }

    public void setShape(int shape) {
        DataFormat df = this.getDataFormatRec(true);
        df.setShape(shape);
    }

    public boolean getHasSmoothedLines() {
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            return df.getSmoothedLines();
        }
        return false;
    }

    public void setHasSmoothLines(boolean smooth) {
        DataFormat df = this.getDataFormatRec(true);
        df.setSmoothLines(smooth);
    }

    public void setHasLines(int lineStyle) {
        DataFormat df = this.getDataFormatRec(true);
        df.setHasLines(lineStyle);
    }

    public void setColor(String clr) {
        int type = this.getParentChart().getChartType();
        if (type == 3) {
            this.setPieSliceColor(clr, this.getSeriesIndex());
            return;
        }
        DataFormat df = this.getDataFormatRec(true);
        df.setSeriesColor(clr);
    }

    private int ensureCorrectColorInt(int clr) {
        if (clr == 2) {
            clr = 10;
        }
        if (clr == 4) {
            clr = 39;
        }
        if (clr == 5) {
            clr = 13;
        }
        if (clr == 58) {
            clr = 17;
        }
        if (clr == 19) {
            clr = 13;
        }
        if (clr == 59) {
            clr = 19;
        }
        if (clr == 1) {
            clr = 9;
        }
        return clr;
    }

    public void setColor(int clr) {
        clr = this.ensureCorrectColorInt(clr);
        int type = this.getParentChart().getChartType();
        if (type == 3) {
            this.setPieSliceColor(clr, this.getSeriesIndex());
            return;
        }
        DataFormat df = this.getDataFormatRec(true);
        df.setSeriesColor(clr);
    }

    public void setPieSliceColor(int clr, int slice) {
        clr = this.ensureCorrectColorInt(clr);
        int type = this.getParentChart().getChartType();
        if (type != 3) {
            return;
        }
        DataFormat df = this.getDataFormatRecSlice(slice, true);
        if (df != null) {
            df.setPieSliceColor(clr, slice);
        } else {
            Logger.logErr("Series.setPieSliceColor: unable to fnd pie slice record");
        }
    }

    public void setPieSliceColor(String clr, int slice) {
        int type = this.getParentChart().getChartType();
        if (type != 3) {
            return;
        }
        DataFormat df = this.getDataFormatRecSlice(slice, true);
        if (df != null) {
            df.setPieSliceColor(clr, slice);
        } else {
            Logger.logErr("Series.setPieSliceColor: unable to fnd pie slice record");
        }
    }

    public String getSeriesColor() {
        DataFormat df = this.getDataFormatRec(false);
        int type = this.getParentChart().getChartType();
        short seriesNumber = df.getSeriesNumber();
        if (type == 3) {
            return FormatHandle.colorToHexString(FormatHandle.COLORTABLE[automaticSeriesColors[seriesNumber]]);
        }
        String bg = df.getBgColor();
        if (bg != null) {
            return bg;
        }
        return FormatHandle.colorToHexString(FormatHandle.COLORTABLE[automaticSeriesColors[seriesNumber]]);
    }

    public String getPieSliceColor(int slice) {
        String bg;
        int type = this.getParentChart().getChartType();
        if (type != 3) {
            return null;
        }
        DataFormat df = this.getDataFormatRecSlice(slice, false);
        if (df != null && (bg = df.getBgColor()) != null) {
            return bg;
        }
        return FormatHandle.colorToHexString(FormatHandle.COLORTABLE[automaticSeriesColors[slice]]);
    }

    public int getMarkerFormat() {
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            return df.getMarkerFormat();
        }
        return 0;
    }

    public int getDataLabel() {
        DataFormat df;
        int datalabels = 0;
        DataLabExtContents dl = (DataLabExtContents)Chart.findRec(this.chartArr, DataLabExtContents.class);
        if (dl != null) {
            datalabels = dl.getTypeInt();
        }
        if ((df = this.getDataFormatRec(false)) != null) {
            datalabels |= df.getDataLabelTypeInt();
        }
        return datalabels;
    }

    public int[] getDataLabelsPIE(int defaultdl) {
        int datalabels = 0;
        DataFormat df = this.getDataFormatRec(false);
        if (df != null) {
            datalabels |= df.getDataLabelTypeInt();
        }
        return null;
    }

    public SpPr getSpPr() {
        return this.shapeProps;
    }

    public void setSpPr(SpPr sp) {
        this.shapeProps = sp;
    }

    public Marker getMarker() {
        return this.m;
    }

    public void setMarker(Marker m) {
        this.m = m;
    }

    public DLbls getDLbls() {
        return this.d;
    }

    public void setDLbls(DLbls d) {
        this.d = d;
    }

    public DPt[] getDPt() {
        if (this.dPts != null) {
            return this.dPts.toArray(new DPt[0]);
        }
        return null;
    }

    public void addDpt(DPt d) {
        if (this.dPts == null) {
            this.dPts = new ArrayList();
        }
        this.dPts.add(d);
    }

    public StringBuffer getValOOXML(String valstr) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<c:" + valstr + ">");
        ooxml.append("\r\n");
        Ai seriesAi = null;
        int i = 0;
        while (i < this.chartArr.size()) {
            Ai thisAi;
            BiffRec br = (BiffRec)this.chartArr.get(i);
            if (br.getOpcode() == 4177 && (thisAi = (Ai)br).getType() == 1) {
                seriesAi = thisAi;
                break;
            }
            ++i;
        }
        ooxml.append("<c:numRef>");
        ooxml.append("\r\n");
        ooxml.append("<c:f>" + OOXMLAdapter.stripNonAscii(seriesAi.toString()) + "</c:f>");
        ooxml.append("\r\n");
        ooxml.append("<c:numCache>");
        ooxml.append("\r\n");
        ooxml.append("<c:formatCode>" + this.getSeriesFormatPattern() + "</c:formatCode>");
        CellRange cr = new CellRange(seriesAi.toString(), this.parentChart.wbh, false);
        CellHandle[] ch = cr.getCells();
        ooxml.append(Series.getValueRangeOOXML(ch));
        ooxml.append("</c:numCache>");
        ooxml.append("\r\n");
        ooxml.append("</c:numRef>");
        ooxml.append("\r\n");
        ooxml.append("</c:" + valstr + ">");
        ooxml.append("\r\n");
        return ooxml;
    }

    public StringBuffer getCatOOXML(String cat, String catstr) {
        StringBuffer ooxml = new StringBuffer();
        if (!"".equals(cat)) {
            ooxml.append("<c:" + catstr + ">");
            ooxml.append("\r\n");
            if (catstr.equals("cat")) {
                ooxml.append("<c:strRef>");
            } else {
                ooxml.append("<c:numRef>");
            }
            ooxml.append("\r\n");
            ooxml.append("<c:f>" + OOXMLAdapter.stripNonAscii(cat) + "</c:f>");
            ooxml.append("\r\n");
            if (catstr.equals("cat")) {
                ooxml.append("</c:strRef>");
            } else {
                ooxml.append("</c:numRef>");
            }
            ooxml.append("\r\n");
            ooxml.append("</c:" + catstr + ">");
            ooxml.append("\r\n");
        }
        return ooxml;
    }

    public StringBuffer getBubbleOOXML(boolean isBubble3d) {
        StringBuffer ooxml = new StringBuffer();
        Ai bubbleAi = null;
        int i = 0;
        while (i < this.chartArr.size()) {
            Ai thisAi;
            BiffRec br = (BiffRec)this.chartArr.get(i);
            if (br.getOpcode() == 4177 && (thisAi = (Ai)br).getType() == 3) {
                bubbleAi = thisAi;
                break;
            }
            ++i;
        }
        ooxml.append("<c:bubbleSize>");
        ooxml.append("\r\n");
        ooxml.append("<c:numRef>");
        ooxml.append("\r\n");
        ooxml.append("<c:f>" + bubbleAi.toString() + "</c:f>");
        ooxml.append("\r\n");
        ooxml.append("<c:numCache>");
        ooxml.append("\r\n");
        try {
            CellHandle[] cells = CellRange.getCells(bubbleAi.toString(), this.parentChart.wbh);
            ooxml.append(Series.getValueRangeOOXML(cells));
            ooxml.append("\r\n");
        }
        catch (NumberFormatException e) {
            Logger.logErr("geteriesOOXML: Number format exception for Bubble Range: " + bubbleAi.toString());
        }
        ooxml.append("</c:numCache>");
        ooxml.append("\r\n");
        ooxml.append("</c:numRef>");
        ooxml.append("\r\n");
        ooxml.append("</c:bubbleSize>");
        ooxml.append("\r\n");
        if (isBubble3d) {
            ooxml.append("<c:bubble3D val=\"1\"/>");
        }
        ooxml.append("\r\n");
        return ooxml;
    }

    public StringBuffer getLegendOOXML(boolean from2003) {
        StringBuffer ooxml = new StringBuffer();
        String txt = this.getLegendText();
        Ai ai = this.getLegendAi();
        ooxml.append("<c:tx>");
        ooxml.append("\r\n");
        ooxml.append("<c:strRef>");
        ooxml.append("\r\n");
        if (ai != null) {
            ooxml.append("<c:f>" + OOXMLAdapter.stripNonAscii(ai.getDefinition()) + "</c:f>");
            ooxml.append("\r\n");
            ooxml.append("<c:strCache>");
            ooxml.append("\r\n");
            ooxml.append("<c:ptCount val=\"1\"/>");
            ooxml.append("\r\n");
            ooxml.append("<c:pt idx=\"0\">");
            ooxml.append("\r\n");
            ooxml.append("<c:v>" + OOXMLAdapter.stripNonAscii(txt) + "</c:v>");
            ooxml.append("</c:pt>");
            ooxml.append("\r\n");
            ooxml.append("</c:strCache>");
            ooxml.append("\r\n");
            ooxml.append("</c:strRef>");
            ooxml.append("\r\n");
            ooxml.append("</c:tx>");
            ooxml.append("\r\n");
            if (this.getSpPr() != null) {
                ooxml.append(this.getSpPr().getOOXML());
            } else if (from2003) {
                SpPr ss = this.parentChart.getChartType() != 6 ? new SpPr("c", this.getSeriesColor().substring(1), 12700, "000000") : new SpPr("c", null, 25400, this.getSeriesColor().substring(1));
                ooxml.append(ss.getOOXML());
            }
        }
        return ooxml;
    }

    private static String getValueRangeOOXML(CellHandle[] cells) {
        StringBuffer ooxml = new StringBuffer();
        if (cells == null) {
            return "<c:ptCount val=\"0\"/>";
        }
        ooxml.append("<c:ptCount val=\"" + cells.length + "\"/>");
        ooxml.append("\r\n");
        int j = 0;
        while (j < cells.length) {
            ooxml.append("<c:pt idx=\"" + j + "\">");
            ooxml.append("\r\n");
            if (!cells[j].getStringVal().equals("NaN")) {
                ooxml.append("<c:v>" + cells[j].getStringVal() + "</c:v>");
                ooxml.append("\r\n");
            } else {
                ooxml.append("<c:v>0</c:v>");
                ooxml.append("\r\n");
            }
            ooxml.append("</c:pt>");
            ooxml.append("\r\n");
            ++j;
        }
        return ooxml.toString();
    }
}

