/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartSeriesHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.MarkerFormat;
import com.extentech.formats.XLS.charts.Scatter;
import com.extentech.formats.XLS.charts.ValueRange;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ScatterChart
extends ChartType {
    private Scatter scatter = null;

    public ScatterChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.scatter = (Scatter)charttype;
    }

    public JSONObject getJSON(ChartSeriesHandle[] series, WorkBookHandle wbh, Double[] minMax) throws JSONException {
        JSONObject chartObjectJSON = new JSONObject();
        chartObjectJSON.put("type", (Object)this.getTypeJSON());
        double yMax = 0.0;
        double yMin = 0.0;
        int nSeries = 0;
        JSONArray seriesJSON = new JSONArray();
        JSONArray seriesCOLORS = new JSONArray();
        boolean bHasBubbles = false;
        try {
            int i = 0;
            while (i < series.length) {
                JSONArray seriesvals = CellRange.getValuesAsJSON(series[i].getSeriesRange(), wbh);
                nSeries = Math.max(nSeries, seriesvals.length());
                int j = 0;
                while (j < seriesvals.length()) {
                    try {
                        yMax = Math.max(yMax, seriesvals.getDouble(j));
                        yMin = Math.min(yMin, seriesvals.getDouble(j));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++j;
                }
                if (!series[i].hasBubbleSizes()) {
                    seriesJSON.put((Object)seriesvals);
                } else {
                    bHasBubbles = true;
                }
                seriesCOLORS.put((Object)FormatConstants.SVGCOLORSTRINGS[series[i].getSeriesColor()]);
                ++i;
            }
            if (bHasBubbles) {
                i = 0;
                while (i < series.length) {
                    JSONArray bubbles = new JSONArray();
                    JSONArray seriesvals = CellRange.getValuesAsJSON(series[i].getSeriesRange(), wbh);
                    JSONArray catvals = CellRange.getValuesAsJSON(series[i].getCategoryRange(), wbh);
                    JSONArray bubblesizes = CellRange.getValuesAsJSON(series[i].getBubbleSizes(), wbh);
                    int j = 0;
                    while (j < catvals.length()) {
                        JSONObject jo = new JSONObject();
                        try {
                            jo.put("x", catvals.getDouble(j));
                        }
                        catch (Exception e) {
                            jo.put("x", j + 1);
                        }
                        jo.put("y", seriesvals.getDouble(j));
                        jo.put("size", Math.round(bubblesizes.getDouble(j) / ((yMax - yMin) / (double)nSeries)));
                        bubbles.put((Object)jo);
                        ++j;
                    }
                    seriesJSON.put((Object)bubbles);
                    ++i;
                }
            }
            chartObjectJSON.put("Series", (Object)seriesJSON);
            chartObjectJSON.put("SeriesFills", (Object)seriesCOLORS);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        minMax[0] = new Double(yMin);
        minMax[1] = new Double(yMax);
        minMax[2] = new Double(nSeries);
        return chartObjectJSON;
    }

    @Override
    public JSONObject getTypeJSON() throws JSONException {
        JSONObject typeJSON = new JSONObject();
        return typeJSON;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        StringBuffer svg = new StringBuffer();
        if (series.size() == 0) {
            Logger.logErr("Scatter.getSVG: error in series");
            return "";
        }
        boolean threeD = this.cf.isThreeD(5);
        int[] dls = this.getDataLabelInts();
        int n = series.size();
        boolean hasLines = this.cf.getHasLines();
        int[] markers = this.getMarkerFormats();
        if (!hasLines && markers[0] == 0) {
            int[] defaultmarkers = new int[]{2, 3, 1, 4, 8, 9, 5, 6, 7};
            int i = 0;
            while (i < n) {
                markers[i] = defaultmarkers[i];
                ++i;
            }
        }
        double[] seriesx = null;
        double xfactor = 0.0;
        double yfactor = 0.0;
        boolean TEXTUALXAXIS = true;
        double xmin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        seriesx = new double[categories.length];
        int j = 0;
        while (j < categories.length) {
            try {
                seriesx[j] = new Double(categories[j].toString());
                xmax = Math.max(xmax, seriesx[j]);
                xmin = Math.min(xmin, seriesx[j]);
                TEXTUALXAXIS = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++j;
        }
        if (!TEXTUALXAXIS) {
            double[] d = ValueRange.calcMaxMin(xmax, xmin, w);
            xfactor = w / d[2];
        } else {
            xfactor = w / (double)(categories.length + 1);
        }
        if (max != 0.0) {
            yfactor = h / max;
        }
        svg.append("<g>\r\n");
        svg.append(MarkerFormat.getMarkerSVGDefs());
        int i = 0;
        while (i < n) {
            String points = "";
            String labels = "";
            double[] seriesy = (double[])series.get(i);
            int j2 = 0;
            while (j2 < seriesy.length) {
                double xval = 0.0;
                xval = TEXTUALXAXIS ? (double)(j2 + 1) : seriesx[j2];
                points = String.valueOf(points) + (x + xval * xfactor) + "," + (y + h - seriesy[j2] * yfactor);
                points = String.valueOf(points) + " ";
                String l = this.getSVGDataLabels(dls, axisMetrics, seriesy[j2], 0.0, i, legends, categories[j2].toString());
                if (l != null) {
                    labels = String.valueOf(labels) + "<text x='" + (12.0 + x + xval * xfactor) + "' y='" + (y + h - seriesy[j2] * yfactor) + "' " + ScatterChart.getDataLabelFontSVG() + ">" + l + "</text>\r\n";
                }
                ++j2;
            }
            if (hasLines) {
                svg.append(this.getLineSVG(points, seriescolors[i]));
            }
            if (markers[i] > 0) {
                String[] markerpoints = points.split(" ");
                int j3 = 0;
                while (j3 < markerpoints.length) {
                    String markerpoint = markerpoints[j3];
                    String[] xy = markerpoint.split(",");
                    double xx = Double.valueOf(xy[0]);
                    double yy = Double.valueOf(xy[1]);
                    svg.append(String.valueOf(MarkerFormat.getMarkerSVG(xx, yy, seriescolors[i], markers[i])) + "\r\n");
                    ++j3;
                }
            }
            svg.append(labels);
            ++i;
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }

    private String getLineSVG(String points, String clr) {
        String s = "";
        s = "<polyline fill='none' fill-opacity='0' " + ScatterChart.getStrokeSVG(1.0f, ScatterChart.getDarkColor()) + " points='" + points + "'" + "/>\r\n";
        s = String.valueOf(s) + "<polyline fill='none' fill-opacity='0' " + ScatterChart.getStrokeSVG(2.0f, clr) + " points='" + points + "'" + "/>\r\n";
        return s;
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:scatterChart>");
        cooxml.append("\r\n");
        int[] markers = this.getMarkerFormats();
        String style = null;
        int[] nArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            int m = nArray[n2];
            if (m != 0) {
                if (this.getHasSmoothLines()) {
                    style = "smoothMarker";
                    break;
                }
                if (this.getHasLines()) {
                    style = "lineMarker";
                    break;
                }
                style = "marker";
                break;
            }
            ++n2;
        }
        if (style == null && this.getHasLines()) {
            style = "line";
        }
        if (style == null && this.getHasSmoothLines()) {
            style = "smooth";
        }
        if (style == null) {
            style = "none";
        }
        cooxml.append("<c:scatterStyle val=\"" + style + "\"/>");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:scatterChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

