/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartLine;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Line;
import com.extentech.formats.XLS.charts.MarkerFormat;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class LineChart
extends ChartType {
    Line line = null;

    public LineChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.line = (Line)charttype;
    }

    @Override
    public JSONObject getTypeJSON() throws JSONException {
        JSONObject typeJSON = new JSONObject();
        return typeJSON;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        if (series.size() == 0) {
            Logger.logErr("Line.getSVG: error in series");
            return "";
        }
        StringBuffer svg = new StringBuffer();
        int n = series.size();
        int[] dls = this.getDataLabelInts();
        int[] markers = this.getMarkerFormats();
        double xfactor = 0.0;
        double yfactor = 0.0;
        xfactor = categories.length != 0 ? w / (double)categories.length : w;
        if (max != 0.0) {
            yfactor = h / max;
        }
        svg.append("<g>\r\n");
        svg.append(MarkerFormat.getMarkerSVGDefs());
        int i = 0;
        while (i < n) {
            String points = "";
            String labels = "";
            double[] curseries = (double[])series.get(i);
            String[] curranges = (String[])s.getSeriesRanges().get(i);
            int j = 0;
            while (j < curseries.length) {
                points = String.valueOf(points) + (x + ((double)j + 0.5) * xfactor) + "," + (y + h - curseries[j] * yfactor);
                points = String.valueOf(points) + " ";
                String l = this.getSVGDataLabels(dls, axisMetrics, curseries[j], 0.0, i, legends, categories[j].toString());
                if (l != null) {
                    double xx = 2.0 + x + ((double)j + 0.5) * xfactor;
                    if (markers[i] > 0) {
                        xx += 10.0;
                    }
                    labels = String.valueOf(labels) + "<text x='" + xx + "' y='" + (y + h - curseries[j] * yfactor) + "' " + LineChart.getDataLabelFontSVG() + ">" + l + "</text>\r\n";
                }
                ++j;
            }
            svg.append("<polyline " + LineChart.getScript("") + " fill='none' fill-opacity='0' " + LineChart.getStrokeSVG(4.0f, LineChart.getDarkColor()) + " points='" + points + "'" + "/>\r\n");
            svg.append("<polyline " + LineChart.getScript("") + "  id='series_" + (i + 1) + "' fill='none' fill-opacity='0' stroke='" + seriescolors[i] + "' stroke-opacity='1' stroke-width='3' stroke-linecap='butt' stroke-linejoin='miter' stroke-miterlimit='4'" + " points='" + points + "'" + "/>\r\n");
            if (markers[i] > 0) {
                String[] markerpoints = points.split(" ");
                int j2 = 0;
                while (j2 < markerpoints.length) {
                    String markerpoint = markerpoints[j2];
                    String[] xy = markerpoint.split(",");
                    double xx = Double.valueOf(xy[0]);
                    double yy = Double.valueOf(xy[1]);
                    svg.append(String.valueOf(MarkerFormat.getMarkerSVG(xx, yy, seriescolors[i], markers[i])) + "\r\n");
                    ++j2;
                }
            }
            svg.append(labels);
            ++i;
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:lineChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:grouping val=\"");
        if (this.is100PercentStacked()) {
            cooxml.append("percentStacked");
        } else if (this.isStacked()) {
            cooxml.append("stacked");
        } else {
            cooxml.append("standard");
        }
        cooxml.append("\"/>");
        cooxml.append("\r\n");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        ChartLine cl = this.cf.getChartLinesRec(ChartLine.TYPE_DROPLINE);
        if (cl != null) {
            cooxml.append(cl.getOOXML());
        }
        if ((cl = this.cf.getChartLinesRec(ChartLine.TYPE_HILOWLINE)) != null) {
            cooxml.append(cl.getOOXML());
        }
        cooxml.append(this.cf.getUpDownBarOOXML());
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:lineChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

