/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartSeriesHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Pie;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DoughnutChart
extends ChartType {
    private Pie doughnut = null;

    public DoughnutChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.doughnut = (Pie)charttype;
    }

    public JSONObject getJSON(ChartSeriesHandle[] series, WorkBookHandle wbh, Double[] minMax) throws JSONException {
        JSONObject chartObjectJSON = new JSONObject();
        chartObjectJSON.put("type", (Object)this.getTypeJSON());
        double yMax = 0.0;
        double yMin = 0.0;
        double len = 0.0;
        JSONArray pieSeries = new JSONArray();
        try {
            String range = series[0].getCategoryRange();
            JSONArray cats = CellRange.getValuesAsJSON(range, wbh);
            JSONArray seriesvals = CellRange.getValuesAsJSON(series[0].getSeriesRange(), wbh);
            double piesum = 0.0;
            int k = 0;
            while (k < seriesvals.length()) {
                piesum += seriesvals.getDouble(k);
                yMax = Math.max(yMax, seriesvals.getDouble(k));
                yMin = Math.min(yMin, seriesvals.getDouble(k));
                ++k;
            }
            double percent = 100.0 / piesum;
            int k2 = 0;
            while (k2 < seriesvals.length()) {
                JSONObject piepoint = new JSONObject();
                piepoint.put("y", seriesvals.getDouble(k2));
                piepoint.put("text", (Object)(String.valueOf(cats.getString(k2)) + "\n" + Math.round(percent * seriesvals.getDouble(k2)) + "%"));
                piepoint.put("color", (Object)FormatConstants.SVGCOLORSTRINGS[series[k2].getPieChartSliceColor(k2)]);
                piepoint.put("stroke", (Object)DoughnutChart.getDarkColor());
                pieSeries.put((Object)piepoint);
                ++k2;
            }
            len = seriesvals.length();
        }
        catch (Exception exception) {
            // empty catch block
        }
        minMax[0] = new Double(yMin);
        minMax[1] = new Double(yMax);
        minMax[2] = new Double(len);
        chartObjectJSON.put("Series", (Object)pieSeries);
        chartObjectJSON.put("SeriesFills", (Object)"");
        return chartObjectJSON;
    }

    @Override
    public JSONObject getTypeJSON() throws JSONException {
        JSONObject typeJSON = new JSONObject();
        typeJSON.put("labelOffset", -25);
        typeJSON.put("precision", 0);
        typeJSON.put("type", (Object)"Pie");
        return typeJSON;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        StringBuffer svg = new StringBuffer();
        if (series.size() == 0) {
            Logger.logErr("DoughnutChart.getSVG: error in series");
            return "";
        }
        int[] dls = this.getDataLabelInts();
        boolean threeD = this.isThreeD();
        int LABELOFFSET = 15;
        int n = series.size();
        double centerx = 0.0;
        double centery = 0.0;
        double radius = 0.0;
        double radiusy = 0.0;
        centerx = w / 2.0 + chartMetrics.get("x");
        centery = h / 2.0 + chartMetrics.get("y");
        if (threeD) {
            svg.append("<defs>\r\n");
            svg.append("<filter id=\"multiply\">\r\n");
            svg.append("<feBlend mode=\"multiply\" in2=\"\"/>\r\n");
            svg.append("</filter>\r\n");
            svg.append("</defs>\r\n");
        }
        svg.append("<g>\r\n");
        radius = Math.min(w, h) / 1.9;
        double r0 = radius / 2.0 / (double)n;
        double r2 = radius;
        int i = n - 1;
        while (i >= 0) {
            double[] curseries = (double[])series.get(i);
            double total = 0.0;
            int j = 0;
            while (j < curseries.length) {
                total += curseries[j];
                ++j;
            }
            if (dls.length == 1) {
                int dl = dls[0];
                dls = new int[curseries.length];
                int z = 0;
                while (z < dls.length) {
                    dls[z] = dl;
                    ++z;
                }
            }
            svg.append("<circle " + DoughnutChart.getScript("") + " cx='" + centerx + "' cy='" + centery + "' r='" + r2 + "' " + DoughnutChart.getStrokeSVG(2.0f, DoughnutChart.getDarkColor()) + " fill='none'/>\r\n");
            double x = centerx + r2;
            double y = centery;
            String path = "";
            double percentage = 0.0;
            double lasta = 0.0;
            int largearcflag = 0;
            int sweepflag = 0;
            int j2 = 0;
            while (j2 < curseries.length) {
                percentage = curseries[j2] / total;
                double angle = percentage * 360.0 + lasta;
                double x1 = centerx + r2 * Math.cos(Math.toRadians(angle));
                double y1 = centery - r2 * Math.sin(Math.toRadians(angle));
                if (percentage * 360.0 > 180.0) {
                    sweepflag = 0;
                    largearcflag = 1;
                } else {
                    largearcflag = 0;
                }
                path = "M" + centerx + " " + centery + " L" + x + " " + y + " A" + r2 + " " + r2 + " 0 " + largearcflag + " " + sweepflag + " " + x1 + " " + y1 + " L" + centerx + " " + centery + "Z";
                svg.append("<path  " + DoughnutChart.getScript("") + "  fill='" + seriescolors[j2] + "'   id='series_" + (j2 + 1) + "' fill-opacity='" + DoughnutChart.getFillOpacity() + "' " + DoughnutChart.getStrokeSVG() + " path='' d='" + path + "' fill-rule='evenodd'/>\r\n");
                String l = this.getSVGDataLabels(dls, axisMetrics, curseries[j2], percentage, j2, legends, categories[j2].toString());
                if (l != null) {
                    double halfa = percentage / 2.0 * 360.0 + lasta;
                    double x2 = centerx + (r2 - r0 / 2.0) * Math.cos(Math.toRadians(halfa));
                    double y2 = centery - (r2 - r0 / 2.0) * Math.sin(Math.toRadians(halfa));
                    svg.append("<text x='" + x2 + "' y='" + y2 + "' vertical-align='bottom' " + DoughnutChart.getDataLabelFontSVG() + " style='text-anchor: middle;'>" + l + "</text>\r\n");
                }
                lasta = angle;
                x = x1;
                y = y1;
                ++j2;
            }
            r2 -= r0;
            --i;
        }
        svg.append("<circle " + DoughnutChart.getScript("") + " cx='" + centerx + "' cy='" + centery + "' r='" + r2 + "' " + DoughnutChart.getStrokeSVG(2.0f, DoughnutChart.getDarkColor()) + " fill='white'/>\r\n");
        svg.append("</g>\r\n");
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:doughnutChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:varyColors val=\"1\"/>");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        cooxml.append("<c:firstSliceAng val=\"0\"/>");
        cooxml.append("<c:holeSize val=\"" + this.getChartOption("donutSize") + "\"/>");
        cooxml.append("</c:doughnutChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

